/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/modules/libpr0n/public/imgILoader.idl
 */

package org.mozilla.xpcom;

/**
 * imgILoader interface
 *
 * @author Stuart Parmenter <pavlov@netscape.com>
 * @version 0.3
 * @see imagelib2
 */
public interface imgILoader extends nsISupports {

  String IMGILOADER_IID =
    "{a32826ff-9e56-4425-a811-97a8dba64ff5}";

  /**
   * Start the load and decode of an image.
   * @param aURI the URI to load
   * @param aInitialDocumentURI the URI that 'initiated' the load -- used for 3rd party cookie blocking
   * @param aReferrerURI the 'referring' URI
   * @param aLoadGroup Loadgroup to put the image load into
   * @param aObserver the observer
   * @param aCX some random data
   * @param aLoadFlags Load flags for the request
   * @param aCacheKey cache key to use for a load if the original
   *                  image came from a request that had post data
   * @param aRequest A newly created, unused imgIRequest object or NULL for one to
                     be created for you.


   * libpr0n does NOT keep a strong ref to the observer; this prevents
   * reference cycles.  This means that callers of loadImage should
   * make sure to Cancel() the resulting request before the observer
   * goes away.
   */
  imgIRequest loadImage(nsIURI aURI, nsIURI aInitialDocumentURL, nsIURI aReferrerURI, nsILoadGroup aLoadGroup, imgIDecoderObserver aObserver, nsISupports aCX, long aLoadFlags, nsISupports cacheKey, imgIRequest aRequest);

  /**
   * Start the load and decode of an image.
   * @param aChannel the channel to load the image from.  This must
   *                 already be opened before ths method is called, and there
   *                 must have been no OnDataAvailable calls for it yet.   
   * @param aObserver the observer
   * @param cx some random data
   * @param aListener [out]
   *        A listener that should receive the data. Can be null, in which
   *        case imagelib has found a cached image and is not interested in
   *        the data. The caller needs not cancel the channel in this case.
   *
   * libpr0n does NOT keep a strong ref to the observer; this prevents
   * reference cycles.  This means that callers of loadImageWithChannel should
   * make sure to Cancel() the resulting request before the observer goes away.
   */
  imgIRequest loadImageWithChannel(nsIChannel aChannel, imgIDecoderObserver aObserver, nsISupports cx, nsIStreamListener[] aListener);

  /**
   * Checks if a decoder for the an image with the given mime type is available
   * @param mimeType The type to find a decoder for
   * @return true if a decoder is available, false otherwise
   */
  boolean supportImageWithMimeType(String mimeType);

}