/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/components/places/public/nsINavBookmarksService.idl
 */

package org.mozilla.xpcom;

/**
 * The BookmarksService interface provides methods for managing bookmarked
 * history items.  Bookmarks consist of a set of user-customizable
 * folders.  A URI in history can be contained in one or more such folders.
 */
public interface nsINavBookmarksService extends nsISupports {

  String NS_INAVBOOKMARKSSERVICE_IID =
    "{860d786d-9bba-4011-a396-486a87af8f07}";

  /**
   * The folder ID of the Places root.
   */
  long getPlacesRoot();

  /**
   * The folder ID of the bookmarks root.
   */
  long getBookmarksRoot();

  /**
   * The folder ID of the personal toolbar root.
   */
  long getToolbarRoot();

  /**
   * The folder ID of the top-level folders that contain the tag "folders".
   *
   * NOTE: This isn't wired up yet, so don't try to use it for anything until
   *       bug 329961 is marked resolved.
   */
  long getTagRoot();

  /**
   * Inserts a child item into the given folder. If this item already exists in
   * the given folder, it will be moved to the new position.
   *  @param folder     The id of the parent folder
   *  @param item       The URI to insert
   *  @param index      The index to insert at, or -1 to append
   */
  void insertItem(long folder, nsIURI item, int index);

  /**
   * Removes a child item from the given folder.
   *  @param folder     The folder to remove the child from
   *  @param item       The child item to remove
   */
  void removeItem(long folder, nsIURI child);

  /**
   * Replace an item with a different item.
   *  @param folder     The folder which contains the item to replace
   *  @param item       The item which should be replaced
   *  @param newItem    The new item
   */
  void replaceItem(long folder, nsIURI item, nsIURI newItem);

  /**
   * Creates a new child folder and inserts it under the given parent.
   *  @param parent     The id of the parent folder
   *  @param name       The name of the new folder
   *  @param index      The index to insert at, or -1 to append
   *  @returns the ID of the newly-inserted folder
   */
  long createFolder(long parent, String name, int index);

  /**
   * Wrapper for container services.  Creates a folder under the given
   * parent and sets the container type.
   *  @param parent     The id of the parent folder
   *  @param name       The name of the new folder
   *  @param type       The type of container to insert
   *  @param index      The index to insert at, or -1 to append
   *  @returns the ID of the newly-inserted folder
   */
  long createContainer(long parent, String name, String type, int index);

  /**
   * Removes a folder from the bookmarks tree.
   *  @param folder     The id of the folder to remove.
   */
  void removeFolder(long folder);

  /**
   * Gets an undo-able transaction for removing a folder from the bookmarks
   * tree. 
   *  @param folder     The id of the folder to remove.
   *  @returns An object implementing nsITransaction that can be used to undo 
   *           or redo the action. 
   *
   * This method exists because complex delete->undo operations rely on 
   * recreated folders to have the same ID they had before they were deleted, 
   * so that any other items deleted in different transactions can be 
   * re-inserted correctly. This provides a safe encapsulation of this 
   * functionality without exposing the ability to recreate folders with 
   * specific IDs (potentially dangerous if abused by other code!) in the
   * public API.
   */
  nsITransaction getRemoveFolderTransaction(long folder);

  /**
   * Convenience function for container services.  Removes
   * all children of the given folder.
   *  @param folder     The id of the folder to remove children from.
   */
  void removeFolderChildren(long folder);

  /**
   * Moves a folder to a different container, preserving its contents.
   *  @param folder      The folder to move
   *  @param newParent   The id of the folder's new parent
   *  @param index       The folder's index under newParent, or -1 to append
   */
  void moveFolder(long folder, long newParent, int index);

  /**
   * Returns the ID of a child folder with the given name. This does not
   * recurse, you have to give it an immediate sibling of the given folder.
   * If the given subfolder doesn't exist, it will return 0.
   *  @param folder    Parent folder whose children we will search
   *  @param subFolder Name of the folder to search for in folder
   */
  long getChildFolder(long folder, String subFolder);

  /**
   * Inserts a bookmark separator into the given folder at the given index.
   * The separator can be removed using removeChildAt().
   *  @param folder    Parent folder of the separator
   *  @param index     The separator's index under folder, or -1 to append
   */
  void insertSeparator(long folder, int index);

  /**
   * Removes any type of child (item, folder, or separator) at the given index.
   *  @param folder    The folder to remove a child from
   *  @param index     The index of the child to remove
   */
  void removeChildAt(long folder, int index);

  /**
   * Set the history/bookmark title for a URI.  The new title will be used
   * anywhere the URI is shown in bookmarks or history.
   *  @param uri   The URI whose name should be set
   *  @param title The new title for the URI
   */
  void setItemTitle(nsIURI uri, String title);

  /**
   * Get the history/bookmark title for the URI.
   *
   * If no item title is available (for instance, if the URI doesn't appear 
   * in the bookmarks or history), it will return a void string (null in JS).
   *
   *  @param uri   The URI whose title should be retrieved
   *  @returns     The title for the URI.
   */
  String getItemTitle(nsIURI uri);

  /**
   * Set the title for a bookmark folder.
   *  @param folder     The folder whose title should be set
   *  @param title      The new title for the folder
   */
  void setFolderTitle(long folder, String title);

  /**
   * Get the title for a bookmark folder.  Throws an invalid argument
   * exception if it can't find a folder with the given ID.
   *
   *  @param folder     The folder whose title should be retrieved
   *  @returns          The title for the folder
   */
  String getFolderTitle(long folder);

  /**
   * Get the place: url for a bookmark folder. You can use this value to
   * get/set the icon for a folder or to associate other data with it using
   * the annotation service. Its important that you use this function instead
   * of just serializing the query/options for a given folder because you
   * may have different options or query parameters. This function will give
   * the canonical value.
   * @param folder      The folder whose URI should be retrieved
   * @returns           The URI for the folder
   */
  nsIURI getFolderURI(long folder);

  /**
   * Checks whether a folder has read-only children.  This property is
   * defined by the nsIBookmarsContainer for the folder, if one exists.
   * If this is set to true, UI should not allow the user to add, remove,
   * or reorder children in this folder.  The default for all folders is false.
   */
  boolean getFolderReadonly(long folder);

  /**
   * Returns true if the given URI is in any bookmark folder. If you want the
   * results to be redirect-aware, use getBookmarkedURIFor()
   */
  boolean isBookmarked(nsIURI uri);

  /**
   * Used to see if the given URI is bookmarked, or any page that redirected to
   * it is bookmarked. For example, if I bookmark "mozilla.org" by manually
   * typing it in, and follow the bookmark, I will get redirected to
   * "www.mozilla.org". Logically, this new page is also bookmarked. This
   * function, if given "www.mozilla.org", will return the URI of the bookmark,
   * in this case "mozilla.org".
   *
   * If there is no bookmarked page found, it will return NULL.
   */
  nsIURI getBookmarkedURIFor(nsIURI uri);

  /**
   * "Changes" the URI of a bookmark.  Since URIs are the unique
   * identifiers of bookmarks in this system, what this really means is
   * that all the metadata attached to oldURI will be copied onto newURI,
   * and oldURI will be deleted from the bookmark system.  If newURI
   * is already bookmarked, the metadata from oldURI will overwrite
   * the corresponding metadata on newURI.  Any annotations on oldURI
   * will be copied to newURI (a copy will remain on oldURI).
   */
  void changeBookmarkURI(nsIURI oldURI, nsIURI newURI);

  /**
   * Returns the list of folder ids that contain the given URI.
   */
  long[] getBookmarkFolders(nsIURI uri, long[] count);

  /**
   * Returns the index of the given item in the given folder.
   * Returns -1 if the item is not present in the folder.
   */
  int indexOfItem(long folder, nsIURI uri);

  /**
   * Returns the index of the given subfolder in its parent.
   * Returns -1 if the subfolder is not present in the parent folder.
   */
  int indexOfFolder(long parent, long folder);

  /**
   * Associates the given keyword with the given URI.
   *
   * Use an empty keyword to clear the keyword associated with the URI. Use an
   * empty URI to clear the URI associated with that keyword. In both of these
   * cases, succeeds but does nothing if the URL/keyword is not found.
   *
   * When setting a keyword (both URI and keyword are specified), the URI must
   * be bookmarked for the keyword to be persistent.
   */
  void setKeywordForURI(nsIURI uri, String keyword);

  /**
   * Retrieves the keyword for the given URI. Will be void string
   * (null in JS) if no such keyword is found.
   */
  String getKeywordForURI(nsIURI uri);

  /**
   * Returns the URI associated with the given keyword. Empty if no such
   * keyword is found.
   */
  nsIURI getURIForKeyword(String keyword);

  /**
   * Adds a bookmark observer. If ownsWeak is false, the bookmark service will
   * keep an owning reference to the observer.  If ownsWeak is true, then
   * aObserver must implement nsISupportsWeakReference, and the bookmark
   * service will keep a weak reference to the observer.
   */
  void addObserver(nsINavBookmarkObserver observer, boolean ownsWeak);

  /**
   * Removes a bookmark observer.
   */
  void removeObserver(nsINavBookmarkObserver observer);

  /**
   * Causes observers to be notified of a beginUpdateBatch when a lot of things
   * are about to change. Calls can be nested, observers will only be
   * notified when all batches begin/end.
   *
   * It is EXTREMELY IMPORTANT that you call EndUpdateBatch for each call to
   * beginUpdateBatch. If you don't do this, certain parts of the UI will not
   * get updated and any changes to bookmarks will not get written to disk.
   * From C++ code inside the places component, use nsBookmarksUpdateBatcher
   * defined in nsNavBookmarks.h to scope batches. For JS or from other
   * components, just please be very careful to close the batch, especially
   * when encountering an error and returning early.
   */
  void beginUpdateBatch();

  /**
   * Causes observers to be notified of an endUpdateBatch when a batch is
   * done changing. Should match beginUpdateBatch or bad things will happen.
   */
  void endUpdateBatch();

  /**
   * Loads the given bookmarks.html file and merges it with the current
   * bookmarks hierarchy.
   */
  void importBookmarksHTML(nsIURI url);

  /**
   * Loads the given bookmarks.html file and puts it in the given folder
   */
  void importBookmarksHTMLToFolder(nsIURI url, long folder);

  /**
   * Saves the current bookmarks hierarchy to a bookmarks.html file.
   */
  void exportBookmarksHTML(nsIFile file);

}