/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/components/downloads/public/nsIDownloadManager.idl
 */

package org.mozilla.interfaces;

public interface nsIDownloadManager extends nsISupports {

  String NS_IDOWNLOADMANAGER_IID =
    "{1f280341-30f4-4009-bb0d-a78f2936d1fb}";

  short DOWNLOAD_NOTSTARTED = -1;

  short DOWNLOAD_DOWNLOADING = 0;

  short DOWNLOAD_FINISHED = 1;

  short DOWNLOAD_FAILED = 2;

  short DOWNLOAD_CANCELED = 3;

  short DOWNLOAD_PAUSED = 4;

  short DOWNLOAD_TYPE_DOWNLOAD = 0;

  /**
   * Creates an nsIDownload and adds it to be managed by the download manager.
   *
   * @param aSource The source URI of the transfer. Must not be null.
   *
   * @param aTarget The target URI of the transfer. Must not be null.
   *
   * @param aDisplayName The user-readable description of the transfer.
   *                     Can be empty.
   *
   * @param aMIMEInfo The MIME info associated with the target,
   *                  including MIME type and helper app when appropriate.
   *                  This parameter is optional.
   *
   * @param startTime Time when the download started
   *
   * @param aTempFile The location of a temporary file; i.e. a file in which
   *                  the received data will be stored, but which is not
   *                  equal to the target file. (will be moved to the real
   *                  target by the caller, when the download is finished)
   *                  May be null.
   *
   * @param aCancelable An object that can be used to abort the download.
   *                    Must not be null.
   *
   * @return The newly created download item with the passed-in properties.
   */
  nsIDownload addDownload(short aDownloadType, nsIURI aSource, nsIURI aTarget, String aDisplayName, String aIconURL, nsIMIMEInfo aMIMEInfo, double aStartTime, nsILocalFile aTempFile, nsICancelable aCancelable);

  /**
   *  Retrieves an in-progress download managed by the download manager.
   *
   *  @param aPersistentDescriptor The unique identifier used to describe a
   *                               a download, and an attribute of nsILocalFile.
   *                               On Windows and Linux, this is just the path
   *                               of the target, but on Mac this is guaranteed
   *                               to be unique.
   *
   *  @return The download with the specified persistent descriptor.
   */
  nsIDownload getDownload(String aPersistentDescriptor);

  /**
   * Cancels the download with the specified persistent descriptor if it's
   * currently in progress. This calls cancel(NS_BINDING_ABORTED) on the
   * nsICancelable provided for the download.
   *
   * @param aPersistentDescriptor The persistent descriptor of the download to
   *                              be cancelled.
   */
  void cancelDownload(String aPersistentDescriptor);

  /**
   * Removes the download with the specified persistent descriptor if it's not
   * currently in progress.  Whereas cancelDownload simply cancels the transfer
   * but retains information about it, removeDownload removes all knowledge of it.
   *
   * @param aPersistentDescriptor The persistent descriptor of the download to
   *                              be removed.
   */
  void removeDownload(String aPersistentDescriptor);

  /**
   * Pause the specified download.
   */
  void pauseDownload(String aPersistentDescriptor);

  /**
   * Resume the specified download.
   */
  void resumeDownload(String aPersistentDescriptor);

  /** 
   * Opens the Download Manager front end.
   * 
   * @param aParent   The parent, or opener, of the front end (optional).
   * @param aDownload A download to pass to the manager widnow. Useful if,
   *                  for example, you want the window to select a certain
   *                  download (optional).
   */
  void open(nsIDOMWindow aParent, String aPersistentDescriptor);

  /** 
   * The Download Manager's progress listener.
   */
  nsIDownloadProgressListener getListener();

  /** 
   * The Download Manager's progress listener.
   */
  void setListener(nsIDownloadProgressListener aListener);

  /**
  * Indicate that a batch update (e.g. mass removal) is about to start.
  */
  void startBatchUpdate();

  /**
  * Indicate that a batch update is ending.
  */
  void endBatchUpdate();

  /** 
   * Whether or not there are downloads that can be cleaned up (removed)
   * i.e. downloads that have completed, have failed or have been canceled. 
   */
  boolean getCanCleanUp();

  /** 
   * Removes completed, failed, and canceled downloads from the list. 
   */
  void cleanUp();

  /** 
   * The number of files currently being downloaded.
   */
  int getActiveDownloadCount();

  /**
   * An enumeration of active downloads.
   */
  nsISupportsArray getActiveDownloads();

  /** 
   * Update the download datasource. 
   */
  void saveState();

  /** 
   * Flush the download datasource to disk.
   */
  void flush();

  nsIRDFDataSource getDatasource();

}