/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/components/places/public/nsIAnnotationService.idl
 */

package org.mozilla.interfaces;

public interface nsIAnnotationService extends nsISupports {

  String NS_IANNOTATIONSERVICE_IID =
    "{15999472-f158-11db-8314-0800200c9a66}";

  /**
     * Valid values for aExpiration, which sets the expiration policy for your
     * annotation. These times are measured since the last visit date of the
     * page in question. This means that if you set an annotation with anything
     * but session expiration, it will not expire so long as the user keeps
     * visiting the page from time to time.
     */
  int EXPIRE_SESSION = 0;

  int EXPIRE_DAYS = 1;

  int EXPIRE_WEEKS = 2;

  int EXPIRE_MONTHS = 3;

  int EXPIRE_NEVER = 4;

  int TYPE_INT32 = 1;

  int TYPE_DOUBLE = 2;

  int TYPE_STRING = 3;

  int TYPE_BINARY = 4;

  int TYPE_INT64 = 5;

  /**
     * Sets an annotation, overwriting any previous annotation with the same
     * URL/name. IT IS YOUR JOB TO NAMESPACE YOUR ANNOTATION NAMES.
     * Use the form "namespace/value", so your name would be like
     * "bills_extension/page_state" or "history/thumbnail".
     *
     * Do not use characters that are not valid in URLs such as spaces, ":",
     * commas, or most other symbols. You should stick to ASCII letters and
     * numbers plus "_", "-", and "/".
     *
     * aExpiration is one of EXPIRE_* above. aFlags should be 0 for now, some
     * flags will be defined in the future.
     *
     * NOTE: ALL ANNOTATIONS WILL GET DELETED WHEN THE PAGE IS REMOVED FROM
     * HISTORY, regardless of expiration date. This means that if you create an
     * annotation on a random unvisited URI, it will get deleted when the
     * browser shuts down.  Otherwise, things can exist in history as
     * annotations but the user has no way of knowing it, potentially violating
     * their privacy expectations about actions such as "Clear history." If
     * there is an important annotation that the user wants to keep, you should
     * make sure that URL is bookmarked. This will ensure the item is never
     * completely deleted from the history database.
     *
     * The annotation "favicon" is special. favicons are stored in the favicon
     * service, but are special cased in the protocol handler so they look like
     * annotations. Do not set favicons using this service, it will not work.
     */
  void setAnnotationString(nsIURI aURI, String aName, String aValue, int aFlags, int aExpiration);

  /**
     * Sets an annotation just like setAnnotationString, but takes an Int32 as
     * input.
     */
  void setAnnotationInt32(nsIURI aURI, String aName, int aValue, int aFlags, int aExpiration);

  /**
     * Sets an annotation just like setAnnotationString, but takes an Int64 as
     * input.
     */
  void setAnnotationInt64(nsIURI aURI, String aName, long aValue, int aFlags, int aExpiration);

  /**
     * Sets an annotation just like setAnnotationString, but takes a double as
     * input.
     */
  void setAnnotationDouble(nsIURI aURI, String aName, double aValue, int aFlags, int aExpiration);

  void setAnnotationBinary(nsIURI aURI, String aName, byte[] aData, long aDataLen, String aMimeType, int aFlags, int aExpiration);

  /**
     * Retrieves the string value of a given annotation. Throws an error if the
     * annotation does not exist. If the annotation was set as a different
     * type than you are retrieving it as, the value will be converted as best
     * as we can. You aren't always guaranteed a good conversion, however,
     * and errors will not be thrown in this case. (For example, doubles will
     * lose precision when stringified.)
     */
  String getAnnotationString(nsIURI aURI, String aName);

  /**
     * Same as getAnnotationString but for ints. If the value doesn't look like
     * an int, returns 0. (this is current sqlite behavior when asking for an
     * int when there is not one, it will possibly change in the future if we
     * start caching stuff).
     */
  int getAnnotationInt32(nsIURI aURI, String aName);

  /**
     * Same as getAnnotationString for Int64s. If the value doesn't look like
     * an int, returns 0. (this is current sqlite behavior when asking for an
     * int when there is not one, it will possibly change in the future if we
     * start caching stuff).
     */
  long getAnnotationInt64(nsIURI aURI, String aName);

  /**
     * Same as getAnnotationString but returns a double-precision float. If the
     * value doesn't look like an float, returns 0. (this is current sqlite
     * behavior when asking for an number when there is not one, it will
     * possibly change in the future if we start caching stuff).
     */
  double getAnnotationDouble(nsIURI aURI, String aName);

  /**
     * Same as getAnnotationString but for binary data. This also returns the
     * MIME type.
     */
  void getAnnotationBinary(nsIURI aURI, String aName, byte[][] aData, long[] aDataLen, String[] aMimeType);

  /**
     * Retrieves info about an existing annotation. aMimeType will be empty
     * if the value was not binary data.
     *
     * aType will be one of TYPE_* constansts above
     *
     * example JS:
     *   var flags = {}, exp = {}, mimeType = {};
     *   annotator.getAnnotationInfo(myURI, "foo", flags, exp, mimeType);
     *   // now you can use 'exp.value' and 'flags.value'
     */
  void getAnnotationInfo(nsIURI aURI, String aName, int[] aFlags, int[] aExpiration, String[] aMimeType, int[] aType);

  /**
     * Retrieves the type of an existing annotation
     * Use getAnnotationInfo if you need this along with the mime-type etc.
     *
     * @param aURI
     *        the uri on which the annotation is set
     * @param aName
     *        the annotation name
     * @return one of the TYPE_* constants above
     * @throws if the annotation is not set
     */
  int getAnnotationType(nsIURI aURI, String aName);

  /**
     * Returns a list of all URIs having a given annotation.
     */
  nsIURI[] getPagesWithAnnotation(String name, long[] resultCount);

  /**
     * Get the names of all annotations for this URI.
     *
     * example JS:
     *   var annotations = annotator.getPageAnnotations(myURI, {});
     * You probably don't want to use this from C++, use
     * GetPageAnnotationsTArray instead.
     */
  nsIVariant[] getPageAnnotationNames(nsIURI aURI, long[] count);

  /**
     * Test for annotation existance.
     */
  boolean hasAnnotation(nsIURI aURI, String aName);

  /**
     * Removes a specific annotation. Succeeds even if the annotation is
     * not found.
     */
  void removeAnnotation(nsIURI aURI, String aName);

  /**
     * Removes all annotations for the given page.
     * We may want some other similar functions to get annotations with given
     * flags (once we have flags defined).
     */
  void removePageAnnotations(nsIURI aURI);

  /**
     * Copies all annotations from the source to the destination URI. If the
     * destination already has an annotation with the same name as one on the
     * source, it will be overwritten if aOverwriteDest is set. Otherwise,
     * the destination URIs will be preferred.
     *
     * All the source annotations will stay as-is. If you don't want them
     * any more, use removePageAnnotations on that URI.
     */
  void copyAnnotations(nsIURI aSourceURI, nsIURI aDestURI, boolean aOverwriteDest);

  /**
     * Adds an annotation observer. The annotation service will keep an owning
     * reference to the observer object.
     */
  void addObserver(nsIAnnotationObserver aObserver);

  /**
     * Removes an annotaton observer previously registered by addObserver.
     */
  void removeObserver(nsIAnnotationObserver aObserver);

  /**
     * Returns a URI that can be used to access the given binary annotation.
     * This function does NOT check that the annotation exists. Also, note that
     * you can only load URIs for annotations that have have a valid MIME type
     * set by setAnnotationBinary. No non-URI valid chars in name, especially
     * colon, which will mess up parsing.
     */
  nsIURI getAnnotationURI(nsIURI aURI, String aName);

}