/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsINavBookmarksService.idl
 */

package org.mozilla.interfaces;

/**
 * Observer for bookmark changes.
 */
public interface nsINavBookmarkObserver extends nsISupports {

  String NS_INAVBOOKMARKOBSERVER_IID =
    "{7a553ba3-5381-4a66-95d9-c7ba3895603c}";

  /**
   * Notify this observer that a batch transaction has started.
   * Other notifications will be sent during the batch change,
   * but the observer is guaranteed that onEndUpdateBatch() will be called
   * at the completion of changes.
   */
  void onBeginUpdateBatch();

  /**
   * Notify this observer that a batch transaction has ended.
   */
  void onEndUpdateBatch();

  /**
   * Notify this observer that an item was added.  Called after the actual
   * add took place. The items following the index will be shifted down, but
   * no additional notifications will be sent.
   *
   * @param aItemId
   *        The id of the bookmark that was added.
   * @param aFolder
   *        The folder that the item was added to.
   * @param aIndex
   *        The item's index in the folder.
   */
  void onItemAdded(long aItemId, long aFolder, int aIndex);

  /**
   * Notify this observer that an item was removed.  Called after the actual
   * remove took place. The items following the index will be shifted up, but
   * no additional notifications will be sent.
   *
   * @param aItemId
   *        The id of the bookmark that was removed.
   * @param aFolder
   *        The folder that the item was removed from.
   * @param aIndex
   *        The bookmark's index in the folder.
   */
  void onItemRemoved(long aItemId, long aFolder, int aIndex);

  /**
   * Notify this observer that a bookmark's information has changed.  This
   * will be called whenever any attributes like "title" are changed.
   * 
   * @param aBookmarkId
   *        The id of the bookmark that was changed.
   * @param aProperty
   *        The property which changed.
   * @param aIsAnnotationProperty
   *        Is aProperty the name of an item annotation
   *
   * property = "cleartime": (history was deleted, there is no last visit date):
   *                         value = none
   * property = "title": value = new title
   * property = "favicon": value = new "moz-anno" URL of favicon image
   * property = "uri": value = new uri spec
   * aIsAnnotationProperty = true: value = empty string
   */
  void onItemChanged(long aBookmarkId, String aProperty, boolean aIsAnnotationProperty, String aValue);

  /**
   * Notify that the item was visited. Normally in bookmarks we use the last
   * visit date, and normally the time will be a new visit that will be more
   * recent, but this is not guaranteed. You should check to see if it's
   * actually more recent before using this new time.
   *
   * @param aBookmarkId
   *        The id of the bookmark that was visited.
   * @see onItemChanged property = "cleartime" for when all visit dates are
   * deleted for the URI.
   */
  void onItemVisited(long aBookmarkId, long aVisitID, double time);

  /**
   * Notify this observer that a bookmark folder has been moved.
   *  @param aFolder
   *         The id of the folder that was moved.
   *  @param aOldParent
   *         The id of the folder's old parent.
   *  @param aOldIndex
   *         The folder's old index inside oldParent.
   *  @param aNewParent
   *         The id of the folder's new parent.
   *  @param aNewIndex
   *         The folder's index inside newParent.
   */
  void onFolderMoved(long aFolder, long aOldParent, int aOldIndex, long aNewParent, int aNewIndex);

  /**
   * Notify this observer that a bookmark folder's information has changed.
   * This will be called whenever any attributes like "title" are changed.
   *  @param aFolder
   *         The id of the folder that was changed.
   *  @param aProperty
   *         The property that was changed.
   */
  void onFolderChanged(long aFolder, String aProperty);

}