/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/accessible/public/nsIAccessible.idl
 */

package org.mozilla.interfaces;

/**
 * A cross-platform interface that supports platform-specific 
 * accessibility APIs like MSAA and ATK. Contains the sum of what's needed
 * to support IAccessible as well as ATK's generic accessibility objects.
 * Can also be used by in-process accessibility clients to get information
 * about objects in the accessible tree. The accessible tree is a subset of 
 * nodes in the DOM tree -- such as documents, focusable elements and text.
 * Mozilla creates the implementations of nsIAccessible on demand.
 * See http://www.mozilla.org/projects/ui/accessibility for more information.
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessible extends nsISupports {

  String NS_IACCESSIBLE_IID =
    "{b3674866-49a9-4cf2-bfea-c00be2d4a695}";

  /**
   * Parent node in accessible tree.
   */
  nsIAccessible getParent();

  /**
   * Next sibling in accessible tree
   */
  nsIAccessible getNextSibling();

  /**
   * Previous sibling in accessible tree
   */
  nsIAccessible getPreviousSibling();

  /**
   * First child in accessible tree
   */
  nsIAccessible getFirstChild();

  /**
   * Last child in accessible tree
   */
  nsIAccessible getLastChild();

  /**
   * Array of all this element's children.
   */
  nsIArray getChildren();

  /**
   * Number of accessible children
   */
  int getChildCount();

  /**
   * The 0-based index of this accessible in its parent's list of children,
   * or -1 if this accessible does not have a parent.
   */
  int getIndexInParent();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  String getName();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  void setName(String aName);

  /**
   * Accessible value -- a number or a secondary text equivalent for this node
   * Widgets that use role attribute can force a value using the valuenow attribute
   */
  String getValue();

  /**
   * Accessible description -- long text associated with this node
   */
  String getDescription();

  /**
   * Provides localized string of accesskey name, such as Alt+D.
   * The modifier may be affected by user and platform preferences.
   * Usually alt+letter, or just the letter alone for menu items. 
   */
  String getKeyboardShortcut();

  /**
   * Provides localized string of global keyboard accelerator for default
   * action, such as Ctrl+O for Open file
   */
  String getDefaultKeyBinding();

  /**
   * Provides array of localized string of global keyboard accelerator for
   * the given action index supported by accessible.
   *
   * @param aActionIndex - index of the given action
   */
  nsIDOMDOMStringList getKeyBindings(short aActionIndex);

  /**
   * Natural enumerated accessible role for the associated element.
   * The values depend on platform because of variations.
   * See the ROLE_* constants defined in nsIAccessibleRole.
   * This does not take into account role attribute as the finalRole does.
   */
  long getRole();

  /**
   * Enumerated accessible role. The values depend on platform because of variations.
   * See the ROLE_* constants defined in nsIAccessibleRole.
   * Widgets can use role attribute to force the final role
   */
  long getFinalRole();

  /**
   * Accessible states -- bit fields which describe boolean properties of node.
   * Many states are only valid given a certain role attribute that supports
   * them.
   *
   * @param aState - the first bit field (see nsIAccessibleStates::STATE_*
   *                 constants)
   * @param aExtraState - the second bit field
   *                      (see nsIAccessibleStates::EXT_STATE_* constants)
   */
  void getFinalState(long[] aState, long[] aExtraState);

  /**
   * Help text associated with node
   */
  String getHelp();

  /**
   * Focused accessible child of node
   */
  nsIAccessible getFocusedChild();

  /**
   * Attributes of accessible
   */
  nsIPersistentProperties getAttributes();

  /**
   * Returns grouping information. Used for tree items, list items, tab panel
   * labels, radio buttons, etc. Also used for collectons of non-text objects.
   *
   * @param groupLevel - 1-based, similar to ARIA 'level' property
   * @param similarItemsInGroup - 1-based, similar to ARIA 'setsize' property
   * @param positionInGroup - 1-based, similar to ARIA 'posinset' property
   */
  void groupPosition(int[] aGroupLevel, int[] aSimilarItemsInGroup, int[] aPositionInGroup);

  /**
   * Accessible child which contains the coordinate at (x, y) in screen pixels.
   */
  nsIAccessible getChildAtPoint(int x, int y);

  /**
   * Nth accessible child using zero-based index or last child if index less than zero
   */
  nsIAccessible getChildAt(int aChildIndex);

  /**
   * Accessible node geometrically to the right of this one
   */
  nsIAccessible getAccessibleToRight();

  /**
   * Accessible node geometrically to the left of this one
   */
  nsIAccessible getAccessibleToLeft();

  /**
   * Accessible node geometrically above this one
   */
  nsIAccessible getAccessibleAbove();

  /**
   * Accessible node geometrically below this one
   */
  nsIAccessible getAccessibleBelow();

  /**
   * Accessible node related to this one 
   */
  nsIAccessible getAccessibleRelated(long aRelationType);

  /**
   * Return accessible's x and y coordinates relative to the screen and
   * accessible's width and height.
   */
  void getBounds(int[] x, int[] y, int[] width, int[] height);

  /**
   * Add or remove this accessible to the current selection
   */
  void setSelected(boolean isSelected);

  /**
   * Extend the current selection from its current accessible anchor node
   * to this accessible
   */
  void extendSelection();

  /**
   * Select this accessible node only
   */
  void takeSelection();

  /**
   * Focus this accessible node,
   * The state STATE_FOCUSABLE indicates whether this node is normally focusable.
   * It is the callers responsibility to determine whether this node is focusable.
   * accTakeFocus on a node that is not normally focusable (such as a table),
   * will still set focus on that node, although normally that will not be visually 
   * indicated in most style sheets.
   */
  void takeFocus();

  /**
   * The number of accessible actions associated with this accessible
   */
  short getNumActions();

  /**
   * The name of the accessible action at the given zero-based index
   */
  String getActionName(short index);

  /**
   * The description of the accessible action at the given zero-based index
   */
  String getActionDescription(short aIndex);

  /**
   * Perform the accessible action at the given zero-based index
   * Action number 0 is the default action
   */
  void doAction(short index);

  /**
   * API states we map from opposite states
   *   VISIBLE -- mapped as the opposite of INVISIBLE
   *   SHOWING -- mapped as the opposite of OFFSCREEN
   *
   * ATK states we don't have in nsIAccessible:
   *   ARMED -- no clear use case, used briefly when button is activated
   *   HAS_TOOLTIP -- no known use case
   *   ICONIFIED -- Mozilla does not have elements which are collapsable into icons
   *   TRUNCATED -- need use case. Indicates that an object's onscreen content is truncated, e.g. a text value in a spreadsheet cell. No IA2 state.
   */
/**
 * Relation Types -- most of these come from ATK's atkrelationtype.h
 * When adding support for relations, make sure to add them to appropriate
 * places in nsAccessibleWrap implementations
 * RELATION_NULL:
 * RELATION_CONTROLLED_BY:    Controlled by one or more target objects.
 * RELATION_CONTROLLER_FOR:   Controller for one or more target objects.
 * RELATION_LABEL_FOR:        Label for one or more target objects.
 * RELATION_LABELLED_BY:      Labelled by one or more target objects.
 * RELATION_MEMBER_OF:        Member of a group of one or more target objects.
 * RELATION_NODE_CHILD_OF:    Cell in a treetable which is displayed because a
 *                            cell in the same col is expanded & identifies it.
 * RELATION_FLOWS_TO:         Has content that flows logically to another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_FLOWS_FROM:       Has content that flows logically from another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_SUBWINDOW_OF:     Subwindow attached to a component but otherwise 
 *                            not connected in the UI hierarchy to that component.
 * RELATION_EMBEDS:           Visually embeds another object's content, i.e.
 *                            this object's content flows around another's content.
 * RELATION_EMBEDDED_BY:      Inverse of RELATION_EMBEDS; this object's content
 *                            is visually embedded in another object.
 * RELATION_POPUP_FOR:        Popup for another object.
 * RELATION_PARENT_WINDOW_OF: Parent window of another object.
 * RELATION_DEFAULT_BUTTON:   Part of a form/dialog with a related default button.
 * RELATION_DESCRIBED_BY:     Described by one or more target objects.
 * RELATION_DESCRIPTION_FOR:  Description for one or more target objects.
 */
  long RELATION_NUL = 0L;

  long RELATION_CONTROLLED_BY = 1L;

  long RELATION_CONTROLLER_FOR = 2L;

  long RELATION_LABEL_FOR = 3L;

  long RELATION_LABELLED_BY = 4L;

  long RELATION_MEMBER_OF = 5L;

  long RELATION_NODE_CHILD_OF = 6L;

  long RELATION_FLOWS_TO = 7L;

  long RELATION_FLOWS_FROM = 8L;

  long RELATION_SUBWINDOW_OF = 9L;

  long RELATION_EMBEDS = 10L;

  long RELATION_EMBEDDED_BY = 11L;

  long RELATION_POPUP_FOR = 12L;

  long RELATION_PARENT_WINDOW_OF = 13L;

  long RELATION_DESCRIBED_BY = 14L;

  long RELATION_DESCRIPTION_FOR = 15L;

  long RELATION_DEFAULT_BUTTON = 16384L;

  long NAVRELATION_CONTROLLED_BY = 4096L;

  long NAVRELATION_CONTROLLER_FOR = 4097L;

  long NAVRELATION_LABEL_FOR = 4098L;

  long NAVRELATION_LABELLED_BY = 4099L;

  long NAVRELATION_MEMBER_OF = 4100L;

  long NAVRELATION_NODE_CHILD_OF = 4101L;

  long NAVRELATION_FLOWS_TO = 4102L;

  long NAVRELATION_FLOWS_FROM = 4103L;

  long NAVRELATION_SUBWINDOW_OF = 4104L;

  long NAVRELATION_EMBEDS = 4105L;

  long NAVRELATION_EMBEDDED_BY = 4106L;

  long NAVRELATION_POPUP_FOR = 4107L;

  long NAVRELATION_PARENT_WINDOW_OF = 4108L;

  long NAVRELATION_DEFAULT_BUTTON = 4109L;

  long NAVRELATION_DESCRIBED_BY = 4110L;

  long NAVRELATION_DESCRIPTION_FOR = 4111L;

}