//@line 38 "/builds/tinderbox/XR-Trunk/Linux_2.4.21-32.0.1.ELsmp_Depend/mozilla/toolkit/mozapps/downloads/content/downloadProperties.js"

function Startup()
{
  const dlmgrContractID = "@mozilla.org/download-manager;1";
  const dlmgrIID = Components.interfaces.nsIDownloadManager;
  var dm = Components.classes[dlmgrContractID].getService(dlmgrIID);
  var db = dm.DBConnection;
  
  const dateTimeContractID = "@mozilla.org/intl/scriptabledateformat;1";
  const dateTimeIID = Components.interfaces.nsIScriptableDateFormat;
  var dts = Components.classes[dateTimeContractID].getService(dateTimeIID);  

  var dateStartedField = document.getElementById("dateStarted");
  var dateEndedField = document.getElementById("dateEnded");
  var pathField = document.getElementById("path");
  var sourceField = document.getElementById("source");

  var dlid = window.arguments[0].replace(/^dl([0-9]+)$/, "$1");

  var stmt = db.createStatement("SELECT startTime, endTime, target, source " +
                                "FROM moz_downloads " +
                                "WHERE id = ?1");
  stmt.bindInt64Parameter(0, dlid);
  stmt.executeStep();

  var dateStarted = new Date(stmt.getInt64(0) / 1000);
  dateStarted = dts.FormatDateTime("", dts.dateFormatShort,
                                   dts.timeFormatSeconds,
                                   dateStarted.getFullYear(),
                                   dateStarted.getMonth() + 1,
                                   dateStarted.getDate(),
                                   dateStarted.getHours(),
                                   dateStarted.getMinutes(),
                                   dateStarted.getSeconds());
  dateStartedField.setAttribute("value", dateStarted);
  
  var dateEnded = new Date(stmt.getInt64(1) / 1000);
  dateEnded = dts.FormatDateTime("", dts.dateFormatShort,
                                 dts.timeFormatSeconds,
                                 dateEnded.getFullYear(),
                                 dateEnded.getMonth() + 1,
                                 dateEnded.getDate(),
                                 dateEnded.getHours(),
                                 dateEnded.getMinutes(),
                                 dateEnded.getSeconds());
  dateEndedField.setAttribute("value", dateEnded);
  
  pathField.value = stmt.getUTF8String(2);
  sourceField.value = stmt.getUTF8String(3);
  stmt.reset();

  var dl = dm.getDownload(dlid);
  if (dl.state == dlmgrIID.DOWNLOAD_DOWNLOADING ||
      dl.state == dlmgrIID.DOWNLOAD_PAUSED ||
      dl.state == dlmgrIID.DOWNLOAD_NOTSTARTED) {
    document.getElementById("dateEndedRow").hidden = true;
    document.getElementById("dateEndedSeparator").hidden = true;
  }
  
  document.documentElement.getButton("accept").label = document.documentElement.getAttribute("acceptbuttontext");
  
  document.documentElement.getButton("accept").focus();
}
  