/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/uriloader/exthandler/nsIExternalProtocolService.idl
 */

package org.mozilla.interfaces;

/**
 * The external protocol service is used for finding and launching
 * web handlers (a la registerProtocolHandler in the HTML5 draft) or 
 * platform-specific applications for handling particular protocols.
 *
 * You can ask the external protocol service if it has an external
 * handler for a given protocol scheme. And you can ask it to load 
 * the url using the default handler.
 */
public interface nsIExternalProtocolService extends nsISupports {

  String NS_IEXTERNALPROTOCOLSERVICE_IID =
    "{01e9ce6e-1c81-4f1a-b128-2f2526ec40e3}";

  /**
   * Check whether a handler for a specific protocol exists.
   * @param aProtocolScheme The scheme from a url: http, ftp, mailto, etc.
   * @return true if we have a handler and false otherwise.
   */
  boolean externalProtocolHandlerExists(String aProtocolScheme);

  /**
   * Check whether a handler for a specific protocol is "exposed" as a visible
   * feature of the current application.
   *
   * An exposed protocol handler is one that can be used in all contexts.  A
   * non-exposed protocol handler is one that can only be used internally by the
   * application.  For example, a non-exposed protocol would not be loaded by the
   * application in response to a link click or a X-remote openURL command.
   * Instead, it would be deferred to the system's external protocol handler.
   */
  boolean isExposedProtocol(String aProtocolScheme);

  /**
   * Used to load a url via an external protocol handler (if one exists)
   *
   * @param aURL The url to load
   * @deprecated Use LoadURI instead (See Bug 389565 for removal)
   */
  void loadUrl(nsIURI aURL);

  /**
   * Used to load a URI via an external application. Might prompt the user for
   * permission to load the external application.
   *
   * @param aURI           The URI to load
   * @param aWindowContext The parent window to open the dialog with.
   */
  void loadURI(nsIURI aURI, nsIInterfaceRequestor aWindowContext);

  /**
   * Gets a human-readable description for the application responsible for
   * handling a specific protocol.
   *
   * @param aScheme The scheme to look up. For example, "mms".
   *
   * @throw NS_ERROR_NOT_IMPLEMENTED
   *        If getting descriptions for protocol helpers is not supported
   * @throw NS_ERROR_NOT_AVAILABLE
   *        If no protocol helper exists for this scheme, or if it is not
   *        possible to get a description for it.
   */
  String getApplicationDescription(String aScheme);

}