/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/netwerk/base/public/nsIScriptableIO.idl
 */

#ifndef __gen_nsIScriptableIO_h__
#define __gen_nsIScriptableIO_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIVariant; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIUnicharInputStream; /* forward declaration */

class nsIUnicharOutputStream; /* forward declaration */

class nsIURI; /* forward declaration */


/* starting interface:    nsIScriptableIO */
#define NS_ISCRIPTABLEIO_IID_STR "e54798d5-7693-43f9-9bb6-f21e434dd3fc"

#define NS_ISCRIPTABLEIO_IID \
  {0xe54798d5, 0x7693, 0x43f9, \
    { 0x9b, 0xb6, 0xf2, 0x1e, 0x43, 0x4d, 0xd3, 0xfc }}

/**
 * A singleton object which contains a number of methods for creating files,
 * streams and uris.
 *
 * This interface is intended to be used only from script.
 */
class NS_NO_VTABLE nsIScriptableIO : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ISCRIPTABLEIO_IID)

  /**
   * Retrieves a reference to a file or directory on disk, which may or may
   * not exist. If the file exists, it may be opened for reading by passing
   * the file as the base to newInputStream. If it doesn't exist, it may be
   * created by opening an output stream and writing to it.
   *
   * Files are identified by the filename argument. The file is found relative
   * to a well known directory identified by the location argument. This
   * location is a string key which identifies common directories typically
   * found on a system. For instance, using the location key 'Desk' will
   * retrieve files in the desktop folder, and the location key 'TmpD' will
   * retrieve files in the system's temporary directory.
   *
   * A complete list of location keys may be found at
   *   http://developer.mozilla.org/en/docs/IO_Guide/Directory_Keys
   *
   * The filename is always a file within the directory identified by the
   * location key and this does not include a path. To retrieve
   * subdirectories, retrieve a file and then use the file's append method
   * to navigate into further subdirectories. This allows platform independent
   * paths to be constructed.
   *
   * The filename may be a null string to retrieve a reference to the
   * location directory itself.
   *
   * @param aLocation location key of well-known directory
   * @param aFileName filename to locate within this directory, may be null
   * @returns a file object
   * @throws NS_ERROR_INVALID_ARG when aLocation is null
   */
  /* nsIFile getFile (in AString aLocation, in AString aFileName); */
  NS_IMETHOD GetFile(const nsAString & aLocation, const nsAString & aFileName, nsIFile **_retval) = 0;

  /**
   * Retrieves a reference to a file given a absolute file path.
   *
   * Use this method only when absolutely necessary. In most cases, getFile
   * should be used instead, as file paths are not portable across different
   * platforms and systems so this method should be avoided if possible.
   * Instead, the getFile method should be used and a path constructed from
   * it.
   *
   * The filepath should be an absolute path or the value of the
   * persistentDescriptor of a file.
   *
   * @param aFilePath path to the file
   * @returns a file object
   * @throws NS_ERROR_INVALID_ARG when aFilePath is null
   */
  /* nsIFile getFileWithPath (in AString aFilePath); */
  NS_IMETHOD GetFileWithPath(const nsAString & aFilePath, nsIFile **_retval) = 0;

  /**
   * Creates a URI object which implements nsIURI. The url argument may either
   * be a string or a file.
   *
   * @param aUri the url to create
   * @returns a new nsIURI object
   * @throws NS_ERROR_INVALID_ARG when aUri is null
   */
  /* nsIURI newURI (in nsIVariant aUri); */
  NS_IMETHOD NewURI(nsIVariant *aUri, nsIURI **_retval) = 0;

  /**
   * Retrieves a stream which may be read from.
   *
   * The base argument may be one of a number of different types of objects
   * which may be read from:
   *   nsIFile - an object returned from the getFile or getFileWithPath
   *             methods, or any object which implements the nsIFile
   *             interface.
   *   nsITransport - a transport object such as a socket.
   *   nsIInputStream - a stream returned by a previous call to this method or
   *                    any other object which implements the nsIInputStream
   *                    interface.
   *   string - a string
   *
   * The mode may be any number of space separated strings which control
   * the manner is which the stream is created. If no strings apply, use
   * a null string. Possible values are:
   *   text - read unicode converted text. The default character set is UTF-8.
   *          To read text in a different character set, set the aCharSet
   *          argument to the desired character set.
   *   buffered - a stream which uses a buffer to hold a block of the next
   *              part of the data to read. This mode would normally be used
   *              as a wrapper for other streams. The size of the buffer
   *              defaults to 1024 bytes, however the size may be changed by
   *              specifying the aBufferSize argument. If the text mode is
   *              used, the stream is always buffered.
   *   block - when reading from a transport such as a socket, an attempt to
   *           read from the stream while there is no data available will wait
   *           until data is available before returning. Without this mode,
   *           the stream will throw an exception if there is no data
   *           available.
   *   deleteonclose - the file is automatically deleted when the stream is
   *                   closed. This might be used for temporary files.
   *   closeoneof - the file is automatically closed when the end of the file
   *                is reached.
   *   reopenonrewind - used in conjuction with the seek mode, the file will
   *                    be reopened when a seek to the beginning of the file
   *                    is done.
   *   multi - a stream which is used to concatenate the input from multiple
   *           streams together as if it was one long continuous stream. The
   *           returned stream implements the nsIMultiplexInputStream
   *           interface. This mode may only be used if the text or buffered
   *           modes are not used.
   *
   * If the mode is a null string, then no special type of reading is
   * performed. In this case, the data from the stream is not interpreted in
   * any way.
   *
   * @param aBase the base object to read from
   * @param aMode flags controlling the reading
   * @param aCharSet the character set to use when parsing text streams
   * @param aReplaceChar the replacement character for unknown characters
   * @param aBufferSize the size of buffer to use for buffered streams
   * @returns a new input stream
   * @throws NS_ERROR_INVALID_ARG when aBase is null
   */
  /* nsISupports newInputStream (in nsIVariant aBase, in AString aMode, [optional] in AString aCharSet, [optional] in AString aReplaceChar, [optional] in unsigned long aBufferSize); */
  NS_IMETHOD NewInputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, nsISupports **_retval) = 0;

  /**
   * Retrieves a stream which may be written to.
   *
   * The base argument may be one of a number of different types of objects
   * which may be written to:
   *   nsIFile - an object returned from the getFile or getFileWithPath
   *             methods, or any object which implements the nsIFile
   *             interface.
   *   nsITransport - a transport object such as a socket.
   *   nsIOutputStream - a stream returned by a previous call to this method
   *                     or any other object which implements the
   *                     nsIOutputStream interface.
   *   string - a string
   *
   * The mode may be any number of space separated strings which control
   * the manner is which the stream is created. If no strings apply, use
   * a null string. Possible values are:
   *   text - write unicode converted text. The default character set is
   *          UTF-8. To write text in a different character set, set the
   *          aCharSet argument to the desired character set.
   *   buffered - a stream which buffers the data being written, which would
   *              normally be used as a wrapper for other streams. The size of
   *              the buffer defaults to 1024 bytes, however the size may be
   *              changed by specifying the aBufferSize argument. If the text
   *              mode is used, the stream is always buffered.
   *   append - when writing to files, append to the end of the file instead
   *            of overwriting. If used in conjuction with the create mode, an
   *            existing file may be opened for appending, or a new file
   *            created.
   *   nocreate - when writing to files, and the file does not yet exist,
   *              don't create a new file. If this mode is not used, a
   *              new file will be created if it doesn't exist.
   *   notruncate - when writing to an existing file, overwrite the existing
   *                content. If this mode is not used, the file will be
   *                truncated to 0 length.
   *   syncsave - if used, then writing methods do not return until the
   *              data is properly saved.
   *   block - when writing to a transport such as a socket, an attempt
   *           to write to the stream will not return until all of the
   *           data has been written. This may cause a delay if the
   *           socket's underlying buffer is full. If this mode is not used,
   *           then an exception will be thrown if the buffer is full.
   *
   * If the mode is a null string, then no special type of writing is
   * performed. In this case, the data being written to the stream is not
   * interpreted in any way.
   *
   * The permissions may be set if a file is created. Typically, an octal
   * value is used, for example: 0775. The default value when calling
   * newOutputStream is 0664.
   *
   * @param aBase the base object to write to
   * @param aMode flags controlling the writing
   * @param aCharSet the character set to use when writing text streams
   * @param aReplaceChar the replacement character for unknown characters
   * @param aBufferSize the size of buffer to use for buffered streams
   * @param aPermissions permissions of a file if one is created.
   * @returns a new output stream
   * @throws NS_ERROR_INVALID_ARG when aBase is null
   */
  /* nsISupports newOutputStream (in nsIVariant aBase, in AString aMode, [optional] in AString aCharSet, [optional] in AString aReplaceChar, [optional] in unsigned long aBufferSize, [optional] in unsigned long aPermissions); */
  NS_IMETHOD NewOutputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, PRUint32 aPermissions, nsISupports **_retval) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIScriptableIO, NS_ISCRIPTABLEIO_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISCRIPTABLEIO \
  NS_IMETHOD GetFile(const nsAString & aLocation, const nsAString & aFileName, nsIFile **_retval); \
  NS_IMETHOD GetFileWithPath(const nsAString & aFilePath, nsIFile **_retval); \
  NS_IMETHOD NewURI(nsIVariant *aUri, nsIURI **_retval); \
  NS_IMETHOD NewInputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, nsISupports **_retval); \
  NS_IMETHOD NewOutputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, PRUint32 aPermissions, nsISupports **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISCRIPTABLEIO(_to) \
  NS_IMETHOD GetFile(const nsAString & aLocation, const nsAString & aFileName, nsIFile **_retval) { return _to GetFile(aLocation, aFileName, _retval); } \
  NS_IMETHOD GetFileWithPath(const nsAString & aFilePath, nsIFile **_retval) { return _to GetFileWithPath(aFilePath, _retval); } \
  NS_IMETHOD NewURI(nsIVariant *aUri, nsIURI **_retval) { return _to NewURI(aUri, _retval); } \
  NS_IMETHOD NewInputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, nsISupports **_retval) { return _to NewInputStream(aBase, aMode, aCharSet, aReplaceChar, aBufferSize, _retval); } \
  NS_IMETHOD NewOutputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, PRUint32 aPermissions, nsISupports **_retval) { return _to NewOutputStream(aBase, aMode, aCharSet, aReplaceChar, aBufferSize, aPermissions, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISCRIPTABLEIO(_to) \
  NS_IMETHOD GetFile(const nsAString & aLocation, const nsAString & aFileName, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFile(aLocation, aFileName, _retval); } \
  NS_IMETHOD GetFileWithPath(const nsAString & aFilePath, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFileWithPath(aFilePath, _retval); } \
  NS_IMETHOD NewURI(nsIVariant *aUri, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewURI(aUri, _retval); } \
  NS_IMETHOD NewInputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, nsISupports **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewInputStream(aBase, aMode, aCharSet, aReplaceChar, aBufferSize, _retval); } \
  NS_IMETHOD NewOutputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, PRUint32 aPermissions, nsISupports **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewOutputStream(aBase, aMode, aCharSet, aReplaceChar, aBufferSize, aPermissions, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsScriptableIO : public nsIScriptableIO
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISCRIPTABLEIO

  nsScriptableIO();

private:
  ~nsScriptableIO();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsScriptableIO, nsIScriptableIO)

nsScriptableIO::nsScriptableIO()
{
  /* member initializers and constructor code */
}

nsScriptableIO::~nsScriptableIO()
{
  /* destructor code */
}

/* nsIFile getFile (in AString aLocation, in AString aFileName); */
NS_IMETHODIMP nsScriptableIO::GetFile(const nsAString & aLocation, const nsAString & aFileName, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile getFileWithPath (in AString aFilePath); */
NS_IMETHODIMP nsScriptableIO::GetFileWithPath(const nsAString & aFilePath, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI newURI (in nsIVariant aUri); */
NS_IMETHODIMP nsScriptableIO::NewURI(nsIVariant *aUri, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports newInputStream (in nsIVariant aBase, in AString aMode, [optional] in AString aCharSet, [optional] in AString aReplaceChar, [optional] in unsigned long aBufferSize); */
NS_IMETHODIMP nsScriptableIO::NewInputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, nsISupports **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports newOutputStream (in nsIVariant aBase, in AString aMode, [optional] in AString aCharSet, [optional] in AString aReplaceChar, [optional] in unsigned long aBufferSize, [optional] in unsigned long aPermissions); */
NS_IMETHODIMP nsScriptableIO::NewOutputStream(nsIVariant *aBase, const nsAString & aMode, const nsAString & aCharSet, const nsAString & aReplaceChar, PRUint32 aBufferSize, PRUint32 aPermissions, nsISupports **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIScriptableIO_h__ */
