/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Linux_2.6.18-8.el5_Depend/mozilla/netwerk/mime/public/nsIMIMEInfo.idl
 */

package org.mozilla.interfaces;

/**
 * nsIMIMEInfo extends nsIHandlerInfo with a bunch of information specific to
 * MIME content-types. There is a one-to-many relationship between MIME types
 * and file extensions. This means that a MIMEInfo object may have multiple
 * file extensions associated with it.  However, the reverse is not true.
 *
 * MIMEInfo objects are generally retrieved from the MIME Service
 * @see nsIMIMEService
 */
public interface nsIMIMEInfo extends nsIHandlerInfo {

  String NS_IMIMEINFO_IID =
    "{ba01eb13-c2fd-4652-94f8-b33c61e6d77e}";

  /**
     * Gives you an array of file types associated with this type.
     *
     * @return Number of elements in the array.
     * @return Array of extensions.
     */
  nsIUTF8StringEnumerator getFileExtensions();

  /**
     * Set File Extensions. Input is a comma delimited list of extensions.
     */
  void setFileExtensions(String aExtensions);

  /**
     * Returns whether or not the given extension is
     * associated with this MIME info.
     *
     * @return TRUE if the association exists. 
     */
  boolean extensionExists(String aExtension);

  /**
     * Append a given extension to the set of extensions
     */
  void appendExtension(String aExtension);

  /**
     * Returns the first extension association in
     * the internal set of extensions.
     *
     * @return The first extension.
     */
  String getPrimaryExtension();

  /**
     * Returns the first extension association in
     * the internal set of extensions.
     *
     * @return The first extension.
     */
  void setPrimaryExtension(String aPrimaryExtension);

  /**
     * The MIME type of this MIMEInfo.
     * 
     * @return String representing the MIME type.
     * 
     * @deprecated  use nsIHandlerInfo::type instead.
     */
  String getMIMEType();

  /**
     * Mac Type and creator types
     */
  long getMacType();

  /**
     * Mac Type and creator types
     */
  void setMacType(long aMacType);

  long getMacCreator();

  void setMacCreator(long aMacCreator);

  /**
     * Returns whether or not these two nsIMIMEInfos are logically
     * equivalent.
     *
     * @returns PR_TRUE if the two are considered equal
     */
  boolean _equals(nsIMIMEInfo aMIMEInfo);

}