/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/uriloader/prefetch/nsIOfflineCacheUpdate.idl
 */

package org.mozilla.interfaces;

/**
 * An nsIOfflineCacheUpdate is used to update a domain's offline resources.
 * It can be used to perform partial or complete updates.
 *
 * Each update object maintains a list of nsIDOMLoadStatus items for the
 * resources it is updating.  The list of these items will be available
 * after the object is scheduled.
 *
 * One update object will be updating at a time.  The active object will
 * load its items one by one, sending itemCompleted() to any registered
 * observers.
 */
public interface nsIOfflineCacheUpdate extends nsISupports {

  String NS_IOFFLINECACHEUPDATE_IID =
    "{7dc06ede-1098-4384-b95e-65525ab254c9}";

  /**
   * The domain being updated, and the domain that will own any URIs added
   * with this update.
   */
  String getUpdateDomain();

  /**
   * The URI that will own any URIs added by this update
   */
  String getOwnerURI();

  /**
   * Initialize the update.
   *
   * @param aPartialUpdate
   *        TRUE if the update should just update the URIs given to it,
   *        FALSE if all URLs for the owner domain should be added.
   * @param aUpdateDomain
   *        The domain which is being updated, and which will own any
   *        URIs added.
   * @param aOwnerURI
   *        The owner URI for any URIs added.
   * @param aReferrerURI
   *        The page that is requesting the update.
   */
  void init(boolean aPartialUpdate, String aUpdateDomain, String aOwnerURI, nsIURI aReferrerURI);

  /**
   * Add a URI to the offline cache as part of the update.
   *
   * @param aURI
   *        The URI to add.
   * @param aSource
   *        The DOM node (<link> tag) associated with this node (for
   *        implementing nsIDOMLoadStatus).
   */
  void addURI(nsIURI aURI, nsIDOMNode aSource);

  /**
   * Add the update to the offline update queue.  An offline-cache-update-added
   * event will be sent to the observer service.
   */
  void schedule();

  /**
   * Request that the update be scheduled when a document finishes loading.
   *
   * @param aDocument
   *        When this document finishes loading, the update will be scheduled.
   */
  void scheduleOnDocumentStop(nsIDOMDocument aDocument);

  /**
   * Access to the list of items in the update.
   */
  long getCount();

  nsIDOMLoadStatus item(long index);

  /**
   * Observe loads that are added to the update.
   *
   * @param aObserver
   *        object that notifications will be sent to.
   * @param aHoldWeak
   *        TRUE if you want the update to hold a weak reference to the
   *        observer, FALSE for a strong reference.
   */
  void addObserver(nsIOfflineCacheUpdateObserver aObserver, boolean aHoldWeak);

  /**
   * Remove an observer from the update.
   *
   * @param aObserver
   *        the observer to remove.
   */
  void removeObserver(nsIOfflineCacheUpdateObserver aObserver);

}