/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/xpcom/io/nsIScriptableStreams.idl
 */

package org.mozilla.interfaces;

/**
 * Streams used with scriptable IO, which is itself located within netwerk.
 */
public interface nsIScriptableIOInputStream extends nsISupports {

  String NS_ISCRIPTABLEIOINPUTSTREAM_IID =
    "{9245740d-d22e-4065-a1a0-72f0ae45e6df}";

  /**
   * Called to initialize the stream.
   */
  void initWithStreams(nsIInputStream aStream, nsIUnicharInputStream aCharStream);

  /**
   * Read string of aCount characters from the stream. If the stream is
   * text, then the characters are read in the expected character set.
   * If the stream is non-text aCount bytes are read and returned as a
   * string. If the end of the stream, or the end of the available data
   * is reached, the returned string may be shorter than the desired
   * length.
   *
   * @param aCount the number of characters to read
   * @returns the string read from the stream 
   */
  String readString(long aCount);

  /**
   * Read from the stream until an end of line is reached and return a string
   * containing all characters up until that point. An end of line is
   * indicated by a 0x0A, 0x0D, a sequence of 0x0A 0x0D or a sequence of
   * 0x0D 0x0A. These characters are not returned as part of the string.
   *
   * @returns the next line from the stream
   */
  String readLine();

  /**
   * Read a single byte from a stream and return false if the byte is zero and
   * true if the byte is non-zero.
   *
   * @param a boolean value for the next byte in the stream
   */
  boolean readBoolean();

  /**
   * Read a single byte from a stream.
   *
   * @returns the next byte in the stream
   */
  short read8();

  /**
   * Read and interpret the next two bytes in the stream as an unsigned
   * big endian integer.
   *
   * @returns the next 16-bit integer in the stream
   */
  int read16();

  /**
   * Read and interpret the next four bytes in the stream as an unsigned
   * big endian integer.
   *
   * @returns the next 32-bit integer in the stream
   */
  long read32();

  /**
   * Read and interpret the next four bytes in the stream as a floating point
   * value.
   *
   * @returns the next float in the stream
   */
  float readFloat();

  /**
   * Read and interpret the next eight bytes in the stream as a double
   * floating point value.
   *
   * @returns the next double in the stream
   */
  double readDouble();

  /**
   * Read aCount bytes from the stream and fill the aBytes array with
   * the bytes.
   *
   * @param aCount the number of bytes to read
   * @param aBytes [out] set to the array of read bytes
   */
  byte[] readByteArray(long aCount);

}