/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/tinderbox/XR-Trunk/Darwin_8.8.4_Depend/mozilla/toolkit/mozapps/extensions/public/nsIExtensionManager.idl
 */

#ifndef __gen_nsIExtensionManager_h__
#define __gen_nsIExtensionManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFile; /* forward declaration */

class nsIRDFDataSource; /* forward declaration */

class nsIUpdateItem; /* forward declaration */

class nsIAddonUpdateListener; /* forward declaration */

class nsIAddonUpdateCheckListener; /* forward declaration */

class nsICommandLine; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */

class nsIDirectoryEnumerator; /* forward declaration */


/* starting interface:    nsIInstallLocation */
#define NS_IINSTALLLOCATION_IID_STR "32a74707-ec7c-af19-f4d8-d0cd8cb6a948"

#define NS_IINSTALLLOCATION_IID \
  {0x32a74707, 0xec7c, 0xaf19, \
    { 0xf4, 0xd8, 0xd0, 0xcd, 0x8c, 0xb6, 0xa9, 0x48 }}

/**
 * Interface representing a location where extensions, themes etc are
 * installed.
 */
class NS_NO_VTABLE nsIInstallLocation : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IINSTALLLOCATION_IID)

  /**
   * The string identifier of this Install Location
   */
  /* readonly attribute AString name; */
  NS_IMETHOD GetName(nsAString & aName) = 0;

  /**
   * An enumeration of nsIFiles for:
   * - locations that contain items
   * - potential dropped-in XPIs
   * Note: This enumeration resolves Text Links to the directories they
   *       refer to.
   */
  /* readonly attribute nsIDirectoryEnumerator itemLocations; */
  NS_IMETHOD GetItemLocations(nsIDirectoryEnumerator * *aItemLocations) = 0;

  /**
   * The file system location where items live. Items can be dropped in
   * at this location. Can be null for Install Locations that don't have
   * a file system presence.
   * Note: This is a clone of the actual location which the caller can
   *       modify freely.
   */
  /* readonly attribute nsIFile location; */
  NS_IMETHOD GetLocation(nsIFile * *aLocation) = 0;

  /**
   * Whether or not this Install Location is on an area of the file system
   * that could be restricted on a restricted-access account, regardless
   * of whether or not the location is restricted with the current user
   * privileges.
   */
  /* readonly attribute boolean restricted; */
  NS_IMETHOD GetRestricted(PRBool *aRestricted) = 0;

  /**
   * Whether or not the user can write to the Install Location with the
   * current access privileges. This is different from restricted because
   * it's not whether or not the location *might* be restricted, it's
   * whether or not it actually *is* restricted right now.
   */
  /* readonly attribute boolean canAccess; */
  NS_IMETHOD GetCanAccess(PRBool *aCanAccess) = 0;

  /**
   * Constants representing priority of some default Install Locations.
   * XXXben - priority ranking of user-level items vs. global-level items
   *          here is debatable. Should app-system-global trump
   *          xre-system-user?
   * You should not use the exact values here, you should offset from
   * these values each time you create a new Install Location. Offsetting
   * can be brittle but you should know what Install Locations are being
   * defined for your own application.
   */
  enum { PRIORITY_APP_PROFILE = 0U };

  enum { PRIORITY_APP_SYSTEM_USER = 10U };

  enum { PRIORITY_XRE_SYSTEM_USER = 100U };

  enum { PRIORITY_APP_SYSTEM_GLOBAL = 1000U };

  enum { PRIORITY_XRE_SYSTEM_GLOBAL = 10000U };

  /**
   * The priority level of this Install Location in loading.
   */
  /* readonly attribute long priority; */
  NS_IMETHOD GetPriority(PRInt32 *aPriority) = 0;

  /**
   * Gets the directory that contains an item.
   * @param   id
   *          The GUID of the item.
   * @returns The location of the item.
   */
  /* nsIFile getItemLocation (in AString id); */
  NS_IMETHOD GetItemLocation(const nsAString & id, nsIFile **_retval) = 0;

  /**
   * Retrieves the GUID for an item at the specified location.
   * @param   file
   *          The location where an item might live.
   * @returns The ID for an item that might live at the location specified.
   *
   * N.B. This function makes no promises about whether or not this path is
   *      actually maintained by this Install Location.
   */
  /* AString getIDForLocation (in nsIFile file); */
  NS_IMETHOD GetIDForLocation(nsIFile *file, nsAString & _retval) = 0;

  /**
   * Gets a nsIFile object for a file within an item's directory structure.
   * @param   id
   *          The GUID of the item.
   * @param   path
   *          The path to the file beneath an Extension's directory
   * @returns A file object at the requested location. The file does not
   *          necessarily have to exist.
   */
  /* nsIFile getItemFile (in AString id, in AString path); */
  NS_IMETHOD GetItemFile(const nsAString & id, const nsAString & path, nsIFile **_retval) = 0;

  /**
   * Determines whether or not an item's resources are managed by the Extension
   * System or by some other user or process. For example, items linked to by
   * text links are managed by the user, and items linked to from Registry
   * Install Locations are usually managed by other applications or installers.
   *
   * @param   id
   *          The GUID of the item.
   * @returns true if the item's resources are managed independently of the
   *          Extension System, false otherwise.
   */
  /* boolean itemIsManagedIndependently (in AString id); */
  NS_IMETHOD ItemIsManagedIndependently(const nsAString & id, PRBool *_retval) = 0;

  /**
   * Stages the specified file by copying it to some location from where it
   * can be retrieved later to complete installation.
   *
   * @param   file
   *          The file to stage
   * @param   id
   *          The GUID of the item the file represents
   * @returns The staged file
   */
  /* nsIFile stageFile (in nsIFile file, in AString id); */
  NS_IMETHOD StageFile(nsIFile *file, const nsAString & id, nsIFile **_retval) = 0;

  /**
   * Returns the most recently staged package (e.g. the last XPI or JAR in a
   * directory) for an item and removes items that do not qualify.
   *
   * @param   id
   *          The ID of the staged package
   * @returns an nsIFile if the package exists otherwise null.
   */
  /* nsIFile getStageFile (in AString id); */
  NS_IMETHOD GetStageFile(const nsAString & id, nsIFile **_retval) = 0;

  /**
   * Removes a file from the stage. This cleans up the stage if there is nothing
   * else left after the remove operation.
   *
   * @param   file
   *          The file to remove.
   */
  /* void removeFile (in nsIFile file); */
  NS_IMETHOD RemoveFile(nsIFile *file) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIInstallLocation, NS_IINSTALLLOCATION_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIINSTALLLOCATION \
  NS_IMETHOD GetName(nsAString & aName); \
  NS_IMETHOD GetItemLocations(nsIDirectoryEnumerator * *aItemLocations); \
  NS_IMETHOD GetLocation(nsIFile * *aLocation); \
  NS_IMETHOD GetRestricted(PRBool *aRestricted); \
  NS_IMETHOD GetCanAccess(PRBool *aCanAccess); \
  NS_IMETHOD GetPriority(PRInt32 *aPriority); \
  NS_IMETHOD GetItemLocation(const nsAString & id, nsIFile **_retval); \
  NS_IMETHOD GetIDForLocation(nsIFile *file, nsAString & _retval); \
  NS_IMETHOD GetItemFile(const nsAString & id, const nsAString & path, nsIFile **_retval); \
  NS_IMETHOD ItemIsManagedIndependently(const nsAString & id, PRBool *_retval); \
  NS_IMETHOD StageFile(nsIFile *file, const nsAString & id, nsIFile **_retval); \
  NS_IMETHOD GetStageFile(const nsAString & id, nsIFile **_retval); \
  NS_IMETHOD RemoveFile(nsIFile *file); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIINSTALLLOCATION(_to) \
  NS_IMETHOD GetName(nsAString & aName) { return _to GetName(aName); } \
  NS_IMETHOD GetItemLocations(nsIDirectoryEnumerator * *aItemLocations) { return _to GetItemLocations(aItemLocations); } \
  NS_IMETHOD GetLocation(nsIFile * *aLocation) { return _to GetLocation(aLocation); } \
  NS_IMETHOD GetRestricted(PRBool *aRestricted) { return _to GetRestricted(aRestricted); } \
  NS_IMETHOD GetCanAccess(PRBool *aCanAccess) { return _to GetCanAccess(aCanAccess); } \
  NS_IMETHOD GetPriority(PRInt32 *aPriority) { return _to GetPriority(aPriority); } \
  NS_IMETHOD GetItemLocation(const nsAString & id, nsIFile **_retval) { return _to GetItemLocation(id, _retval); } \
  NS_IMETHOD GetIDForLocation(nsIFile *file, nsAString & _retval) { return _to GetIDForLocation(file, _retval); } \
  NS_IMETHOD GetItemFile(const nsAString & id, const nsAString & path, nsIFile **_retval) { return _to GetItemFile(id, path, _retval); } \
  NS_IMETHOD ItemIsManagedIndependently(const nsAString & id, PRBool *_retval) { return _to ItemIsManagedIndependently(id, _retval); } \
  NS_IMETHOD StageFile(nsIFile *file, const nsAString & id, nsIFile **_retval) { return _to StageFile(file, id, _retval); } \
  NS_IMETHOD GetStageFile(const nsAString & id, nsIFile **_retval) { return _to GetStageFile(id, _retval); } \
  NS_IMETHOD RemoveFile(nsIFile *file) { return _to RemoveFile(file); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIINSTALLLOCATION(_to) \
  NS_IMETHOD GetName(nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD GetItemLocations(nsIDirectoryEnumerator * *aItemLocations) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItemLocations(aItemLocations); } \
  NS_IMETHOD GetLocation(nsIFile * *aLocation) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocation(aLocation); } \
  NS_IMETHOD GetRestricted(PRBool *aRestricted) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRestricted(aRestricted); } \
  NS_IMETHOD GetCanAccess(PRBool *aCanAccess) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanAccess(aCanAccess); } \
  NS_IMETHOD GetPriority(PRInt32 *aPriority) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPriority(aPriority); } \
  NS_IMETHOD GetItemLocation(const nsAString & id, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItemLocation(id, _retval); } \
  NS_IMETHOD GetIDForLocation(nsIFile *file, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIDForLocation(file, _retval); } \
  NS_IMETHOD GetItemFile(const nsAString & id, const nsAString & path, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItemFile(id, path, _retval); } \
  NS_IMETHOD ItemIsManagedIndependently(const nsAString & id, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ItemIsManagedIndependently(id, _retval); } \
  NS_IMETHOD StageFile(nsIFile *file, const nsAString & id, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->StageFile(file, id, _retval); } \
  NS_IMETHOD GetStageFile(const nsAString & id, nsIFile **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStageFile(id, _retval); } \
  NS_IMETHOD RemoveFile(nsIFile *file) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveFile(file); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsInstallLocation : public nsIInstallLocation
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIINSTALLLOCATION

  nsInstallLocation();

private:
  ~nsInstallLocation();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsInstallLocation, nsIInstallLocation)

nsInstallLocation::nsInstallLocation()
{
  /* member initializers and constructor code */
}

nsInstallLocation::~nsInstallLocation()
{
  /* destructor code */
}

/* readonly attribute AString name; */
NS_IMETHODIMP nsInstallLocation::GetName(nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDirectoryEnumerator itemLocations; */
NS_IMETHODIMP nsInstallLocation::GetItemLocations(nsIDirectoryEnumerator * *aItemLocations)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIFile location; */
NS_IMETHODIMP nsInstallLocation::GetLocation(nsIFile * *aLocation)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean restricted; */
NS_IMETHODIMP nsInstallLocation::GetRestricted(PRBool *aRestricted)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canAccess; */
NS_IMETHODIMP nsInstallLocation::GetCanAccess(PRBool *aCanAccess)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long priority; */
NS_IMETHODIMP nsInstallLocation::GetPriority(PRInt32 *aPriority)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile getItemLocation (in AString id); */
NS_IMETHODIMP nsInstallLocation::GetItemLocation(const nsAString & id, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getIDForLocation (in nsIFile file); */
NS_IMETHODIMP nsInstallLocation::GetIDForLocation(nsIFile *file, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile getItemFile (in AString id, in AString path); */
NS_IMETHODIMP nsInstallLocation::GetItemFile(const nsAString & id, const nsAString & path, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean itemIsManagedIndependently (in AString id); */
NS_IMETHODIMP nsInstallLocation::ItemIsManagedIndependently(const nsAString & id, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile stageFile (in nsIFile file, in AString id); */
NS_IMETHODIMP nsInstallLocation::StageFile(nsIFile *file, const nsAString & id, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile getStageFile (in AString id); */
NS_IMETHODIMP nsInstallLocation::GetStageFile(const nsAString & id, nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeFile (in nsIFile file); */
NS_IMETHODIMP nsInstallLocation::RemoveFile(nsIFile *file)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIExtensionManager */
#define NS_IEXTENSIONMANAGER_IID_STR "feccf1ac-df58-43c1-bef0-b86dc768b906"

#define NS_IEXTENSIONMANAGER_IID \
  {0xfeccf1ac, 0xdf58, 0x43c1, \
    { 0xbe, 0xf0, 0xb8, 0x6d, 0xc7, 0x68, 0xb9, 0x06 }}

/**
 * Interface representing a system for the installation and management of
 * Extensions, Themes etc.
 *
 * XXXben - Some of this stuff should go into a management-ey interface,
 *          some into an app-startup-ey interface.
 */
class NS_NO_VTABLE nsIExtensionManager : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IEXTENSIONMANAGER_IID)

  /**
   * Constants representing types of update checks.
   */
  enum { UPDATE_CHECK_NEWVERSION = 0U };

  enum { UPDATE_CHECK_COMPATIBILITY = 1U };

  enum { UPDATE_SYNC_COMPATIBILITY = 2U };

  /**
   * Starts the Extension Manager, checking for item changes, additions and
   * removals, and finishing pending operations.
   * @param   commandLine
   *          The command line the application was started with.
   * @returns true if the application has rewritten the extensions.ini file
   *          and needs to restart to register components/chrome etc,
   *          false otherwise
   */
  /* boolean start (in nsICommandLine commandLine); */
  NS_IMETHOD Start(nsICommandLine *commandLine, PRBool *_retval) = 0;

  /**
   * Determines if there are incompatible items installed (and offers to
   * upgrade them to newer versions if available, via a UI).
   * @returns true if there were incompatible items that were disabled
   *          and the application needs to restart to re-register components,
   *          chrome etc, false otherwise.
   */
  /* boolean checkForMismatches (); */
  NS_IMETHOD CheckForMismatches(PRBool *_retval) = 0;

  /**
   * Handle command line flags, e.g. -install-global-[extension|theme]
   * @param   cmdLine
   *          the command line the application was started with
   * XXXben - move this off this API - currently it is only used for
   *          global installation, and the apprunner can do this directly
   *          with |installItemFromFile|
   */
  /* void handleCommandLineArgs (in nsICommandLine cmdline); */
  NS_IMETHOD HandleCommandLineArgs(nsICommandLine *cmdline) = 0;

  /**
   * Gets the Install Location for an item
   * @param   id
   *          The GUID of the item
   * @returns The Install Location where the item is installed.
   */
  /* nsIInstallLocation getInstallLocation (in AString id); */
  NS_IMETHOD GetInstallLocation(const nsAString & id, nsIInstallLocation **_retval) = 0;

  /**
   * An enumeration of all registered Install Items
   */
  /* readonly attribute nsISimpleEnumerator installLocations; */
  NS_IMETHOD GetInstallLocations(nsISimpleEnumerator * *aInstallLocations) = 0;

  /**
   * Installs an item from a XPI/JAR file into the location specified.
   * @param   xpiFile
   *          The source file to install from. This function stages a copy
   *          of this file for persistence across potential application
   *          restarts, you are responsible for removing the file you pass
   *          in.
   * @param   installLocationKey
   *          The name identifier of an Install Location to install into.
   */
  /* void installItemFromFile (in nsIFile xpiFile, in AString installLocationKey); */
  NS_IMETHOD InstallItemFromFile(nsIFile *xpiFile, const nsAString & installLocationKey) = 0;

  /**
   * Uninstalls an item
   * @param   id
   *          The GUID of the item.
   */
  /* void uninstallItem (in AString id); */
  NS_IMETHOD UninstallItem(const nsAString & id) = 0;

  /**
   * Enables a disabled item
   * @param   id
   *          The GUID of the item.
   */
  /* void enableItem (in AString id); */
  NS_IMETHOD EnableItem(const nsAString & id) = 0;

  /**
   * Disables an enabled item
   * @param   id
   *          The GUID of the item.
   */
  /* void disableItem (in AString id); */
  NS_IMETHOD DisableItem(const nsAString & id) = 0;

  /**
   * Checks for updates to a list of items.
   * @param   items
   *          An array of nsIUpdateItems to check for updates for.
   * @param   itemCount
   *          The length of |items|
   * @param   updateCheckType
   *          UPDATE_CHECK_NEWVERSION if this check should find the newest
   *          versions available,
   *          UPDATE_CHECK_COMPATIBILITY if it should only find newer target
   *          application compatibility information for the currently
   *          installed version.
   *          UPDATE_SYNC_COMPATIBILITY if this check should only find target
   *          application compatibility information for the currently
   *          installed version and synchronize the values.
   * @param   listener
   *          An nsIAddonUpdateCheckListener object which will be notified during
   *          the update check process.
   *
   * @throws  NS_ERROR_ILLEGAL_VALUE if any item is invalid, or if itemCount == 0.
   */
  /* void update ([array, size_is (itemCount)] in nsIUpdateItem items, in unsigned long itemCount, in unsigned long updateCheckType, in nsIAddonUpdateCheckListener listener); */
  NS_IMETHOD Update(nsIUpdateItem **items, PRUint32 itemCount, PRUint32 updateCheckType, nsIAddonUpdateCheckListener *listener) = 0;

  /**
   * Gets a nsIUpdateItem for the item with the specified id.
   * @param   id
   *          The GUID of the item to construct a nsIUpdateItem for.
   * @returns The nsIUpdateItem representing the item or null if the item does
   *          not exist.
   */
  /* nsIUpdateItem getItemForID (in AString id); */
  NS_IMETHOD GetItemForID(const nsAString & id, nsIUpdateItem **_retval) = 0;

  /**
   * Retrieves a list of visible nsIUpdateItems of items matching the
   * specified type.
   * @param   type
   *          The type of item to return.
   * @param   countRef
   *          The XPCJS reference to the number of items returned.
   * @returns An array of nsIUpdateItems matching the id/type filter.
   *
   * XXXben - it would be good if this function took an optional
   *          install location.
   */
  /* void getItemList (in unsigned long type, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
  NS_IMETHOD GetItemList(PRUint32 type, PRUint32 *itemCount, nsIUpdateItem ***items) = 0;

  /**
   * Retrieves a list of nsIUpdateItems of items that are incompatible
   * with the supplied parameters.
   * @param   id
   *          The id of the application to check compatibility against
   * @param   appVersion
   *          The version of the application to check compatibility against
   * @param   platformVersion
   *          The version of the toolkit to check compatibility against
   * @param   type
   *          The type of item to return
   * @param   includeDisabled
   *          true if disabled items should be included in the result set,
   *          false otherwise
   * @param   countRef
   *          The XPCJS reference to the number of items returned.
   * @returns An array of incompatible nsIUpdateItems.
   */
  /* void getIncompatibleItemList (in AString id, in AString appVersion, in AString platformVersion, in unsigned long type, in boolean includeDisabled, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
  NS_IMETHOD GetIncompatibleItemList(const nsAString & id, const nsAString & appVersion, const nsAString & platformVersion, PRUint32 type, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) = 0;

  /**
   * The Extensions Datasource
   * XXXben - the datasource should be registered with the RDF system, so it
   *          can be accessed via rdf:extensions, and not exposed through the API
   *          like this.
   */
  /* readonly attribute nsIRDFDataSource datasource; */
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) = 0;

  /**
   * Adds active download entries to the UI
   * @param   items
   *          A list of nsIUpdateItems to entries to add
   * @param   itemCount
   *          The length of |items|
   * @param   fromChrome
   *          true when called from chrome
   *          false when not called from chrome (e.g. web page)
   *
   * @throws  NS_ERROR_ILLEGAL_VALUE if any item is invalid, or if itemCount == 0.
   */
  /* void addDownloads ([array, size_is (itemCount)] in nsIUpdateItem items, in unsigned long itemCount, in boolean fromChrome); */
  NS_IMETHOD AddDownloads(nsIUpdateItem **items, PRUint32 itemCount, PRBool fromChrome) = 0;

  /**
   * Removes an active download from the UI
   * @param   url
   *          The URL of the active download to remove
   */
  /* void removeDownload (in AString url); */
  NS_IMETHOD RemoveDownload(const nsAString & url) = 0;

  /**
   * Adds a download progress listener so the front end can listen to download
   * and install progress.
   * @param   listener
   *          The listener to add
   * @returns the index of the added listen in the listener list.
   */
  /* long addUpdateListener (in nsIAddonUpdateListener listener); */
  NS_IMETHOD AddUpdateListener(nsIAddonUpdateListener *listener, PRInt32 *_retval) = 0;

  /**
   * Removes a download progress listener.
   * @param   index
   *          The index of the listener to remove.
   */
  /* void removeUpdateListenerAt (in long index); */
  NS_IMETHOD RemoveUpdateListenerAt(PRInt32 index) = 0;

  /**
   * Move an Item to the index of another item in its container.
   * @param   movingID
   *          The ID of an item to be moved.
   * @param   destinationID
   *          The ID of an item to move an item to.
   */
  /* void moveToIndexOf (in AString movingID, in AString destinationID); */
  NS_IMETHOD MoveToIndexOf(const nsAString & movingID, const nsAString & destinationID) = 0;

  /**
   * Cancels a pending install or upgrade of an item. If the item does
   * not have a pending install or upgrade then this will do nothing.
   * @param   id
   *          The ID of the item.
   */
  /* void cancelInstallItem (in AString id); */
  NS_IMETHOD CancelInstallItem(const nsAString & id) = 0;

  /**
   * Cancels a pending uninstall of an item
   * @param   id
   *          The ID of the item.
   */
  /* void cancelUninstallItem (in AString id); */
  NS_IMETHOD CancelUninstallItem(const nsAString & id) = 0;

  /**
   * Retrieves a list of installed nsIUpdateItems of items that are dependent
   * on another item.
   * @param   id
   *          The ID of the item that other items depend on.
   * @param   includeDisabled
   *          Whether to include disabled items in the set returned.
   * @param   countRef
   *          The XPCJS reference to the number of items returned.
   * @returns An array of installed nsIUpdateItems that depend on the item
   *          specified by the id parameter.
   */
  /* void getDependentItemListForID (in AString id, in boolean includeDisabled, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
  NS_IMETHOD GetDependentItemListForID(const nsAString & id, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) = 0;

  /**
   * Checks for changes to the blocklist using the local blocklist file,
   * application disables / enables items that have been added / removed from
   * the blocklist, and if there are additions to the blocklist this will
   * inform the user by displaying a list of the items added.
   *
   * XXXrstrong - this method is not terribly useful and was added so we can
   * trigger this check from the additional timer used by blocklisting.
   */
  /* void checkForBlocklistChanges (); */
  NS_IMETHOD CheckForBlocklistChanges(void) = 0;

  /**
   * Sorts addons of the specified type by the specified property in the
   * Extensions Datasource container starting from the top of their container.
   * If the addons are already sorted then no action is performed.
   * @param   type
   *          The nsIUpdateItem type of the items to sort.
   * @param   propertyName
   *          The RDF property name used for sorting.
   * @param   isAscending
   *          true to sort ascending and false to sort descending
   */
  /* void sortTypeByProperty (in unsigned long type, in AString propertyName, in boolean isAscending); */
  NS_IMETHOD SortTypeByProperty(PRUint32 type, const nsAString & propertyName, PRBool isAscending) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIExtensionManager, NS_IEXTENSIONMANAGER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEXTENSIONMANAGER \
  NS_IMETHOD Start(nsICommandLine *commandLine, PRBool *_retval); \
  NS_IMETHOD CheckForMismatches(PRBool *_retval); \
  NS_IMETHOD HandleCommandLineArgs(nsICommandLine *cmdline); \
  NS_IMETHOD GetInstallLocation(const nsAString & id, nsIInstallLocation **_retval); \
  NS_IMETHOD GetInstallLocations(nsISimpleEnumerator * *aInstallLocations); \
  NS_IMETHOD InstallItemFromFile(nsIFile *xpiFile, const nsAString & installLocationKey); \
  NS_IMETHOD UninstallItem(const nsAString & id); \
  NS_IMETHOD EnableItem(const nsAString & id); \
  NS_IMETHOD DisableItem(const nsAString & id); \
  NS_IMETHOD Update(nsIUpdateItem **items, PRUint32 itemCount, PRUint32 updateCheckType, nsIAddonUpdateCheckListener *listener); \
  NS_IMETHOD GetItemForID(const nsAString & id, nsIUpdateItem **_retval); \
  NS_IMETHOD GetItemList(PRUint32 type, PRUint32 *itemCount, nsIUpdateItem ***items); \
  NS_IMETHOD GetIncompatibleItemList(const nsAString & id, const nsAString & appVersion, const nsAString & platformVersion, PRUint32 type, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items); \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource); \
  NS_IMETHOD AddDownloads(nsIUpdateItem **items, PRUint32 itemCount, PRBool fromChrome); \
  NS_IMETHOD RemoveDownload(const nsAString & url); \
  NS_IMETHOD AddUpdateListener(nsIAddonUpdateListener *listener, PRInt32 *_retval); \
  NS_IMETHOD RemoveUpdateListenerAt(PRInt32 index); \
  NS_IMETHOD MoveToIndexOf(const nsAString & movingID, const nsAString & destinationID); \
  NS_IMETHOD CancelInstallItem(const nsAString & id); \
  NS_IMETHOD CancelUninstallItem(const nsAString & id); \
  NS_IMETHOD GetDependentItemListForID(const nsAString & id, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items); \
  NS_IMETHOD CheckForBlocklistChanges(void); \
  NS_IMETHOD SortTypeByProperty(PRUint32 type, const nsAString & propertyName, PRBool isAscending); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEXTENSIONMANAGER(_to) \
  NS_IMETHOD Start(nsICommandLine *commandLine, PRBool *_retval) { return _to Start(commandLine, _retval); } \
  NS_IMETHOD CheckForMismatches(PRBool *_retval) { return _to CheckForMismatches(_retval); } \
  NS_IMETHOD HandleCommandLineArgs(nsICommandLine *cmdline) { return _to HandleCommandLineArgs(cmdline); } \
  NS_IMETHOD GetInstallLocation(const nsAString & id, nsIInstallLocation **_retval) { return _to GetInstallLocation(id, _retval); } \
  NS_IMETHOD GetInstallLocations(nsISimpleEnumerator * *aInstallLocations) { return _to GetInstallLocations(aInstallLocations); } \
  NS_IMETHOD InstallItemFromFile(nsIFile *xpiFile, const nsAString & installLocationKey) { return _to InstallItemFromFile(xpiFile, installLocationKey); } \
  NS_IMETHOD UninstallItem(const nsAString & id) { return _to UninstallItem(id); } \
  NS_IMETHOD EnableItem(const nsAString & id) { return _to EnableItem(id); } \
  NS_IMETHOD DisableItem(const nsAString & id) { return _to DisableItem(id); } \
  NS_IMETHOD Update(nsIUpdateItem **items, PRUint32 itemCount, PRUint32 updateCheckType, nsIAddonUpdateCheckListener *listener) { return _to Update(items, itemCount, updateCheckType, listener); } \
  NS_IMETHOD GetItemForID(const nsAString & id, nsIUpdateItem **_retval) { return _to GetItemForID(id, _retval); } \
  NS_IMETHOD GetItemList(PRUint32 type, PRUint32 *itemCount, nsIUpdateItem ***items) { return _to GetItemList(type, itemCount, items); } \
  NS_IMETHOD GetIncompatibleItemList(const nsAString & id, const nsAString & appVersion, const nsAString & platformVersion, PRUint32 type, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) { return _to GetIncompatibleItemList(id, appVersion, platformVersion, type, includeDisabled, itemCount, items); } \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) { return _to GetDatasource(aDatasource); } \
  NS_IMETHOD AddDownloads(nsIUpdateItem **items, PRUint32 itemCount, PRBool fromChrome) { return _to AddDownloads(items, itemCount, fromChrome); } \
  NS_IMETHOD RemoveDownload(const nsAString & url) { return _to RemoveDownload(url); } \
  NS_IMETHOD AddUpdateListener(nsIAddonUpdateListener *listener, PRInt32 *_retval) { return _to AddUpdateListener(listener, _retval); } \
  NS_IMETHOD RemoveUpdateListenerAt(PRInt32 index) { return _to RemoveUpdateListenerAt(index); } \
  NS_IMETHOD MoveToIndexOf(const nsAString & movingID, const nsAString & destinationID) { return _to MoveToIndexOf(movingID, destinationID); } \
  NS_IMETHOD CancelInstallItem(const nsAString & id) { return _to CancelInstallItem(id); } \
  NS_IMETHOD CancelUninstallItem(const nsAString & id) { return _to CancelUninstallItem(id); } \
  NS_IMETHOD GetDependentItemListForID(const nsAString & id, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) { return _to GetDependentItemListForID(id, includeDisabled, itemCount, items); } \
  NS_IMETHOD CheckForBlocklistChanges(void) { return _to CheckForBlocklistChanges(); } \
  NS_IMETHOD SortTypeByProperty(PRUint32 type, const nsAString & propertyName, PRBool isAscending) { return _to SortTypeByProperty(type, propertyName, isAscending); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEXTENSIONMANAGER(_to) \
  NS_IMETHOD Start(nsICommandLine *commandLine, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->Start(commandLine, _retval); } \
  NS_IMETHOD CheckForMismatches(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckForMismatches(_retval); } \
  NS_IMETHOD HandleCommandLineArgs(nsICommandLine *cmdline) { return !_to ? NS_ERROR_NULL_POINTER : _to->HandleCommandLineArgs(cmdline); } \
  NS_IMETHOD GetInstallLocation(const nsAString & id, nsIInstallLocation **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInstallLocation(id, _retval); } \
  NS_IMETHOD GetInstallLocations(nsISimpleEnumerator * *aInstallLocations) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInstallLocations(aInstallLocations); } \
  NS_IMETHOD InstallItemFromFile(nsIFile *xpiFile, const nsAString & installLocationKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallItemFromFile(xpiFile, installLocationKey); } \
  NS_IMETHOD UninstallItem(const nsAString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallItem(id); } \
  NS_IMETHOD EnableItem(const nsAString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnableItem(id); } \
  NS_IMETHOD DisableItem(const nsAString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->DisableItem(id); } \
  NS_IMETHOD Update(nsIUpdateItem **items, PRUint32 itemCount, PRUint32 updateCheckType, nsIAddonUpdateCheckListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->Update(items, itemCount, updateCheckType, listener); } \
  NS_IMETHOD GetItemForID(const nsAString & id, nsIUpdateItem **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItemForID(id, _retval); } \
  NS_IMETHOD GetItemList(PRUint32 type, PRUint32 *itemCount, nsIUpdateItem ***items) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItemList(type, itemCount, items); } \
  NS_IMETHOD GetIncompatibleItemList(const nsAString & id, const nsAString & appVersion, const nsAString & platformVersion, PRUint32 type, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIncompatibleItemList(id, appVersion, platformVersion, type, includeDisabled, itemCount, items); } \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDatasource(aDatasource); } \
  NS_IMETHOD AddDownloads(nsIUpdateItem **items, PRUint32 itemCount, PRBool fromChrome) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDownloads(items, itemCount, fromChrome); } \
  NS_IMETHOD RemoveDownload(const nsAString & url) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveDownload(url); } \
  NS_IMETHOD AddUpdateListener(nsIAddonUpdateListener *listener, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddUpdateListener(listener, _retval); } \
  NS_IMETHOD RemoveUpdateListenerAt(PRInt32 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveUpdateListenerAt(index); } \
  NS_IMETHOD MoveToIndexOf(const nsAString & movingID, const nsAString & destinationID) { return !_to ? NS_ERROR_NULL_POINTER : _to->MoveToIndexOf(movingID, destinationID); } \
  NS_IMETHOD CancelInstallItem(const nsAString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelInstallItem(id); } \
  NS_IMETHOD CancelUninstallItem(const nsAString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelUninstallItem(id); } \
  NS_IMETHOD GetDependentItemListForID(const nsAString & id, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDependentItemListForID(id, includeDisabled, itemCount, items); } \
  NS_IMETHOD CheckForBlocklistChanges(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckForBlocklistChanges(); } \
  NS_IMETHOD SortTypeByProperty(PRUint32 type, const nsAString & propertyName, PRBool isAscending) { return !_to ? NS_ERROR_NULL_POINTER : _to->SortTypeByProperty(type, propertyName, isAscending); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsExtensionManager : public nsIExtensionManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIEXTENSIONMANAGER

  nsExtensionManager();

private:
  ~nsExtensionManager();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsExtensionManager, nsIExtensionManager)

nsExtensionManager::nsExtensionManager()
{
  /* member initializers and constructor code */
}

nsExtensionManager::~nsExtensionManager()
{
  /* destructor code */
}

/* boolean start (in nsICommandLine commandLine); */
NS_IMETHODIMP nsExtensionManager::Start(nsICommandLine *commandLine, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean checkForMismatches (); */
NS_IMETHODIMP nsExtensionManager::CheckForMismatches(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void handleCommandLineArgs (in nsICommandLine cmdline); */
NS_IMETHODIMP nsExtensionManager::HandleCommandLineArgs(nsICommandLine *cmdline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIInstallLocation getInstallLocation (in AString id); */
NS_IMETHODIMP nsExtensionManager::GetInstallLocation(const nsAString & id, nsIInstallLocation **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator installLocations; */
NS_IMETHODIMP nsExtensionManager::GetInstallLocations(nsISimpleEnumerator * *aInstallLocations)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installItemFromFile (in nsIFile xpiFile, in AString installLocationKey); */
NS_IMETHODIMP nsExtensionManager::InstallItemFromFile(nsIFile *xpiFile, const nsAString & installLocationKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallItem (in AString id); */
NS_IMETHODIMP nsExtensionManager::UninstallItem(const nsAString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void enableItem (in AString id); */
NS_IMETHODIMP nsExtensionManager::EnableItem(const nsAString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void disableItem (in AString id); */
NS_IMETHODIMP nsExtensionManager::DisableItem(const nsAString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void update ([array, size_is (itemCount)] in nsIUpdateItem items, in unsigned long itemCount, in unsigned long updateCheckType, in nsIAddonUpdateCheckListener listener); */
NS_IMETHODIMP nsExtensionManager::Update(nsIUpdateItem **items, PRUint32 itemCount, PRUint32 updateCheckType, nsIAddonUpdateCheckListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIUpdateItem getItemForID (in AString id); */
NS_IMETHODIMP nsExtensionManager::GetItemForID(const nsAString & id, nsIUpdateItem **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getItemList (in unsigned long type, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
NS_IMETHODIMP nsExtensionManager::GetItemList(PRUint32 type, PRUint32 *itemCount, nsIUpdateItem ***items)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getIncompatibleItemList (in AString id, in AString appVersion, in AString platformVersion, in unsigned long type, in boolean includeDisabled, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
NS_IMETHODIMP nsExtensionManager::GetIncompatibleItemList(const nsAString & id, const nsAString & appVersion, const nsAString & platformVersion, PRUint32 type, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIRDFDataSource datasource; */
NS_IMETHODIMP nsExtensionManager::GetDatasource(nsIRDFDataSource * *aDatasource)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addDownloads ([array, size_is (itemCount)] in nsIUpdateItem items, in unsigned long itemCount, in boolean fromChrome); */
NS_IMETHODIMP nsExtensionManager::AddDownloads(nsIUpdateItem **items, PRUint32 itemCount, PRBool fromChrome)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeDownload (in AString url); */
NS_IMETHODIMP nsExtensionManager::RemoveDownload(const nsAString & url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long addUpdateListener (in nsIAddonUpdateListener listener); */
NS_IMETHODIMP nsExtensionManager::AddUpdateListener(nsIAddonUpdateListener *listener, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeUpdateListenerAt (in long index); */
NS_IMETHODIMP nsExtensionManager::RemoveUpdateListenerAt(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void moveToIndexOf (in AString movingID, in AString destinationID); */
NS_IMETHODIMP nsExtensionManager::MoveToIndexOf(const nsAString & movingID, const nsAString & destinationID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelInstallItem (in AString id); */
NS_IMETHODIMP nsExtensionManager::CancelInstallItem(const nsAString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelUninstallItem (in AString id); */
NS_IMETHODIMP nsExtensionManager::CancelUninstallItem(const nsAString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getDependentItemListForID (in AString id, in boolean includeDisabled, out unsigned long itemCount, [array, size_is (itemCount), retval] out nsIUpdateItem items); */
NS_IMETHODIMP nsExtensionManager::GetDependentItemListForID(const nsAString & id, PRBool includeDisabled, PRUint32 *itemCount, nsIUpdateItem ***items)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void checkForBlocklistChanges (); */
NS_IMETHODIMP nsExtensionManager::CheckForBlocklistChanges()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void sortTypeByProperty (in unsigned long type, in AString propertyName, in boolean isAscending); */
NS_IMETHODIMP nsExtensionManager::SortTypeByProperty(PRUint32 type, const nsAString & propertyName, PRBool isAscending)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIUpdateItem */
#define NS_IUPDATEITEM_IID_STR "a15390e0-2ad6-422c-9596-94f95286c16f"

#define NS_IUPDATEITEM_IID \
  {0xa15390e0, 0x2ad6, 0x422c, \
    { 0x95, 0x96, 0x94, 0xf9, 0x52, 0x86, 0xc1, 0x6f }}

class NS_NO_VTABLE nsIUpdateItem : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IUPDATEITEM_IID)

  /**
 * An item managed by the Extension System. Contains metadata that describes
 * the item.
 * XXXben work in progress, the name of this interface will change after the
 *        update system is complete, probably to nsIAddon
 */
/**
   * The GUID of the item.
   */
  /* readonly attribute AString id; */
  NS_IMETHOD GetId(nsAString & aId) = 0;

  /**
   * The Version of the item, in FVF format.
   */
  /* readonly attribute AString version; */
  NS_IMETHOD GetVersion(nsAString & aVersion) = 0;

  /**
   * The minimum version of the application that this item works with,
   * in FVF format.
   */
  /* readonly attribute AString minAppVersion; */
  NS_IMETHOD GetMinAppVersion(nsAString & aMinAppVersion) = 0;

  /**
   * The maximum version of the application that this item works with,
   * in FVF format.
   */
  /* readonly attribute AString maxAppVersion; */
  NS_IMETHOD GetMaxAppVersion(nsAString & aMaxAppVersion) = 0;

  /**
   * The name of the Install Location where this item is installed.
   */
  /* readonly attribute AString installLocationKey; */
  NS_IMETHOD GetInstallLocationKey(nsAString & aInstallLocationKey) = 0;

  /**
   * The name of this item.
   */
  /* readonly attribute AString name; */
  NS_IMETHOD GetName(nsAString & aName) = 0;

  /**
   * The URL of the XPI where this item can be downloaded.
   */
  /* readonly attribute AString xpiURL; */
  NS_IMETHOD GetXpiURL(nsAString & aXpiURL) = 0;

  /**
   * The string Hash for the XPI file. Can be null and if supplied must be in
   * the format of "type:hash" (see the types in nsICryptoHash and
   * nsIXPInstallManager::initManagerWithHashes).
   */
  /* readonly attribute AString xpiHash; */
  NS_IMETHOD GetXpiHash(nsAString & aXpiHash) = 0;

  /**
   * The URL of the icon that can be shown for this item.
   */
  /* readonly attribute AString iconURL; */
  NS_IMETHOD GetIconURL(nsAString & aIconURL) = 0;

  /**
   * The URL of the update RDF file for this item.
   */
  /* readonly attribute AString updateRDF; */
  NS_IMETHOD GetUpdateRDF(nsAString & aUpdateRDF) = 0;

  enum { TYPE_APP = 1U };

  enum { TYPE_EXTENSION = 2U };

  enum { TYPE_THEME = 4U };

  enum { TYPE_LOCALE = 8U };

  enum { TYPE_MULTI_XPI = 32U };

  enum { TYPE_ADDON = 14U };

  enum { TYPE_ANY = 15U };

  /**
   * The type of this item.
   */
  /* readonly attribute long type; */
  NS_IMETHOD GetType(PRInt32 *aType) = 0;

  /**
   * The target application ID used for checking compatibility for this item.
   *
   * @note Add-ons can specify a targetApplication id of toolkit@mozilla.org in
   *       their install manifest for compatibility with all apps using a
   *       specific release of the toolkit.
   */
  /* readonly attribute AString targetAppID; */
  NS_IMETHOD GetTargetAppID(nsAString & aTargetAppID) = 0;

  /**
   * Initializes this Item object.
   */
  /* void init (in AString id, in AString version, in AString installLocationKey, in AString minAppVersion, in AString maxAppVersion, in AString name, in AString downloadURL, in AString xpiHash, in AString iconURL, in AString updateURL, in long type, in AString targetAppID); */
  NS_IMETHOD Init(const nsAString & id, const nsAString & version, const nsAString & installLocationKey, const nsAString & minAppVersion, const nsAString & maxAppVersion, const nsAString & name, const nsAString & downloadURL, const nsAString & xpiHash, const nsAString & iconURL, const nsAString & updateURL, PRInt32 type, const nsAString & targetAppID) = 0;

  /**
   * Returns a JS Object source representing an nsIUpdateItem.
   */
  /* readonly attribute AString objectSource; */
  NS_IMETHOD GetObjectSource(nsAString & aObjectSource) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIUpdateItem, NS_IUPDATEITEM_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIUPDATEITEM \
  NS_IMETHOD GetId(nsAString & aId); \
  NS_IMETHOD GetVersion(nsAString & aVersion); \
  NS_IMETHOD GetMinAppVersion(nsAString & aMinAppVersion); \
  NS_IMETHOD GetMaxAppVersion(nsAString & aMaxAppVersion); \
  NS_IMETHOD GetInstallLocationKey(nsAString & aInstallLocationKey); \
  NS_IMETHOD GetName(nsAString & aName); \
  NS_IMETHOD GetXpiURL(nsAString & aXpiURL); \
  NS_IMETHOD GetXpiHash(nsAString & aXpiHash); \
  NS_IMETHOD GetIconURL(nsAString & aIconURL); \
  NS_IMETHOD GetUpdateRDF(nsAString & aUpdateRDF); \
  NS_IMETHOD GetType(PRInt32 *aType); \
  NS_IMETHOD GetTargetAppID(nsAString & aTargetAppID); \
  NS_IMETHOD Init(const nsAString & id, const nsAString & version, const nsAString & installLocationKey, const nsAString & minAppVersion, const nsAString & maxAppVersion, const nsAString & name, const nsAString & downloadURL, const nsAString & xpiHash, const nsAString & iconURL, const nsAString & updateURL, PRInt32 type, const nsAString & targetAppID); \
  NS_IMETHOD GetObjectSource(nsAString & aObjectSource); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIUPDATEITEM(_to) \
  NS_IMETHOD GetId(nsAString & aId) { return _to GetId(aId); } \
  NS_IMETHOD GetVersion(nsAString & aVersion) { return _to GetVersion(aVersion); } \
  NS_IMETHOD GetMinAppVersion(nsAString & aMinAppVersion) { return _to GetMinAppVersion(aMinAppVersion); } \
  NS_IMETHOD GetMaxAppVersion(nsAString & aMaxAppVersion) { return _to GetMaxAppVersion(aMaxAppVersion); } \
  NS_IMETHOD GetInstallLocationKey(nsAString & aInstallLocationKey) { return _to GetInstallLocationKey(aInstallLocationKey); } \
  NS_IMETHOD GetName(nsAString & aName) { return _to GetName(aName); } \
  NS_IMETHOD GetXpiURL(nsAString & aXpiURL) { return _to GetXpiURL(aXpiURL); } \
  NS_IMETHOD GetXpiHash(nsAString & aXpiHash) { return _to GetXpiHash(aXpiHash); } \
  NS_IMETHOD GetIconURL(nsAString & aIconURL) { return _to GetIconURL(aIconURL); } \
  NS_IMETHOD GetUpdateRDF(nsAString & aUpdateRDF) { return _to GetUpdateRDF(aUpdateRDF); } \
  NS_IMETHOD GetType(PRInt32 *aType) { return _to GetType(aType); } \
  NS_IMETHOD GetTargetAppID(nsAString & aTargetAppID) { return _to GetTargetAppID(aTargetAppID); } \
  NS_IMETHOD Init(const nsAString & id, const nsAString & version, const nsAString & installLocationKey, const nsAString & minAppVersion, const nsAString & maxAppVersion, const nsAString & name, const nsAString & downloadURL, const nsAString & xpiHash, const nsAString & iconURL, const nsAString & updateURL, PRInt32 type, const nsAString & targetAppID) { return _to Init(id, version, installLocationKey, minAppVersion, maxAppVersion, name, downloadURL, xpiHash, iconURL, updateURL, type, targetAppID); } \
  NS_IMETHOD GetObjectSource(nsAString & aObjectSource) { return _to GetObjectSource(aObjectSource); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIUPDATEITEM(_to) \
  NS_IMETHOD GetId(nsAString & aId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetId(aId); } \
  NS_IMETHOD GetVersion(nsAString & aVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetVersion(aVersion); } \
  NS_IMETHOD GetMinAppVersion(nsAString & aMinAppVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMinAppVersion(aMinAppVersion); } \
  NS_IMETHOD GetMaxAppVersion(nsAString & aMaxAppVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMaxAppVersion(aMaxAppVersion); } \
  NS_IMETHOD GetInstallLocationKey(nsAString & aInstallLocationKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInstallLocationKey(aInstallLocationKey); } \
  NS_IMETHOD GetName(nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD GetXpiURL(nsAString & aXpiURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXpiURL(aXpiURL); } \
  NS_IMETHOD GetXpiHash(nsAString & aXpiHash) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXpiHash(aXpiHash); } \
  NS_IMETHOD GetIconURL(nsAString & aIconURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIconURL(aIconURL); } \
  NS_IMETHOD GetUpdateRDF(nsAString & aUpdateRDF) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUpdateRDF(aUpdateRDF); } \
  NS_IMETHOD GetType(PRInt32 *aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_IMETHOD GetTargetAppID(nsAString & aTargetAppID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTargetAppID(aTargetAppID); } \
  NS_IMETHOD Init(const nsAString & id, const nsAString & version, const nsAString & installLocationKey, const nsAString & minAppVersion, const nsAString & maxAppVersion, const nsAString & name, const nsAString & downloadURL, const nsAString & xpiHash, const nsAString & iconURL, const nsAString & updateURL, PRInt32 type, const nsAString & targetAppID) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(id, version, installLocationKey, minAppVersion, maxAppVersion, name, downloadURL, xpiHash, iconURL, updateURL, type, targetAppID); } \
  NS_IMETHOD GetObjectSource(nsAString & aObjectSource) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetObjectSource(aObjectSource); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsUpdateItem : public nsIUpdateItem
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIUPDATEITEM

  nsUpdateItem();

private:
  ~nsUpdateItem();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsUpdateItem, nsIUpdateItem)

nsUpdateItem::nsUpdateItem()
{
  /* member initializers and constructor code */
}

nsUpdateItem::~nsUpdateItem()
{
  /* destructor code */
}

/* readonly attribute AString id; */
NS_IMETHODIMP nsUpdateItem::GetId(nsAString & aId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString version; */
NS_IMETHODIMP nsUpdateItem::GetVersion(nsAString & aVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString minAppVersion; */
NS_IMETHODIMP nsUpdateItem::GetMinAppVersion(nsAString & aMinAppVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString maxAppVersion; */
NS_IMETHODIMP nsUpdateItem::GetMaxAppVersion(nsAString & aMaxAppVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString installLocationKey; */
NS_IMETHODIMP nsUpdateItem::GetInstallLocationKey(nsAString & aInstallLocationKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString name; */
NS_IMETHODIMP nsUpdateItem::GetName(nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString xpiURL; */
NS_IMETHODIMP nsUpdateItem::GetXpiURL(nsAString & aXpiURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString xpiHash; */
NS_IMETHODIMP nsUpdateItem::GetXpiHash(nsAString & aXpiHash)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString iconURL; */
NS_IMETHODIMP nsUpdateItem::GetIconURL(nsAString & aIconURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString updateRDF; */
NS_IMETHODIMP nsUpdateItem::GetUpdateRDF(nsAString & aUpdateRDF)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long type; */
NS_IMETHODIMP nsUpdateItem::GetType(PRInt32 *aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString targetAppID; */
NS_IMETHODIMP nsUpdateItem::GetTargetAppID(nsAString & aTargetAppID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void init (in AString id, in AString version, in AString installLocationKey, in AString minAppVersion, in AString maxAppVersion, in AString name, in AString downloadURL, in AString xpiHash, in AString iconURL, in AString updateURL, in long type, in AString targetAppID); */
NS_IMETHODIMP nsUpdateItem::Init(const nsAString & id, const nsAString & version, const nsAString & installLocationKey, const nsAString & minAppVersion, const nsAString & maxAppVersion, const nsAString & name, const nsAString & downloadURL, const nsAString & xpiHash, const nsAString & iconURL, const nsAString & updateURL, PRInt32 type, const nsAString & targetAppID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString objectSource; */
NS_IMETHODIMP nsUpdateItem::GetObjectSource(nsAString & aObjectSource)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAddonUpdateListener */
#define NS_IADDONUPDATELISTENER_IID_STR "bb86037c-98c1-4c22-8e03-1e4c9fc89a8e"

#define NS_IADDONUPDATELISTENER_IID \
  {0xbb86037c, 0x98c1, 0x4c22, \
    { 0x8e, 0x03, 0x1e, 0x4c, 0x9f, 0xc8, 0x9a, 0x8e }}

class NS_NO_VTABLE nsIAddonUpdateListener : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IADDONUPDATELISTENER_IID)

  /**
 * Interface for handling download and install progress notifications for
 * addons.
 */
/**
   * Install/Download state has changed
   * @param   addon
   *          The addon that state changed for
   * @param   state
   *          The new state. States are defined in nsIXPIProgressDialog
   * @param   value
   *          Some data about the new state
   */
  /* void onStateChange (in nsIUpdateItem addon, in short state, in long value); */
  NS_IMETHOD OnStateChange(nsIUpdateItem *addon, PRInt16 state, PRInt32 value) = 0;

  /**
   * Progress occurred in the download/install operation
   * @param   addon
   *          The addon that progress occurred for
   * @param   value
   *          The value of the current progress
   * @param   maxValue
   *          The maximum value |value| can reach
   */
  /* void onProgress (in nsIUpdateItem addon, in unsigned long value, in unsigned long maxValue); */
  NS_IMETHOD OnProgress(nsIUpdateItem *addon, PRUint32 value, PRUint32 maxValue) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAddonUpdateListener, NS_IADDONUPDATELISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIADDONUPDATELISTENER \
  NS_IMETHOD OnStateChange(nsIUpdateItem *addon, PRInt16 state, PRInt32 value); \
  NS_IMETHOD OnProgress(nsIUpdateItem *addon, PRUint32 value, PRUint32 maxValue); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIADDONUPDATELISTENER(_to) \
  NS_IMETHOD OnStateChange(nsIUpdateItem *addon, PRInt16 state, PRInt32 value) { return _to OnStateChange(addon, state, value); } \
  NS_IMETHOD OnProgress(nsIUpdateItem *addon, PRUint32 value, PRUint32 maxValue) { return _to OnProgress(addon, value, maxValue); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIADDONUPDATELISTENER(_to) \
  NS_IMETHOD OnStateChange(nsIUpdateItem *addon, PRInt16 state, PRInt32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnStateChange(addon, state, value); } \
  NS_IMETHOD OnProgress(nsIUpdateItem *addon, PRUint32 value, PRUint32 maxValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnProgress(addon, value, maxValue); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAddonUpdateListener : public nsIAddonUpdateListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIADDONUPDATELISTENER

  nsAddonUpdateListener();

private:
  ~nsAddonUpdateListener();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAddonUpdateListener, nsIAddonUpdateListener)

nsAddonUpdateListener::nsAddonUpdateListener()
{
  /* member initializers and constructor code */
}

nsAddonUpdateListener::~nsAddonUpdateListener()
{
  /* destructor code */
}

/* void onStateChange (in nsIUpdateItem addon, in short state, in long value); */
NS_IMETHODIMP nsAddonUpdateListener::OnStateChange(nsIUpdateItem *addon, PRInt16 state, PRInt32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onProgress (in nsIUpdateItem addon, in unsigned long value, in unsigned long maxValue); */
NS_IMETHODIMP nsAddonUpdateListener::OnProgress(nsIUpdateItem *addon, PRUint32 value, PRUint32 maxValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAddonUpdateCheckListener */
#define NS_IADDONUPDATECHECKLISTENER_IID_STR "c946119f-9e7c-41aa-a794-803148045350"

#define NS_IADDONUPDATECHECKLISTENER_IID \
  {0xc946119f, 0x9e7c, 0x41aa, \
    { 0xa7, 0x94, 0x80, 0x31, 0x48, 0x04, 0x53, 0x50 }}

class NS_NO_VTABLE nsIAddonUpdateCheckListener : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IADDONUPDATECHECKLISTENER_IID)

  /**
 * Interface for handling notifications during the addon update check process.
 */
/**
   * Addon update has begun
   */
  /* void onUpdateStarted (); */
  NS_IMETHOD OnUpdateStarted(void) = 0;

  enum { STATUS_NONE = 0U };

  enum { STATUS_UPDATE = 1U };

  enum { STATUS_VERSIONINFO = 2U };

  enum { STATUS_DATA_FOUND = 3U };

  enum { STATUS_FAILURE = 4U };

  enum { STATUS_NO_UPDATE = 8U };

  enum { STATUS_DISABLED = 16U };

  enum { STATUS_APP_MANAGED = 32U };

  enum { STATUS_READ_ONLY = 64U };

  enum { STATUS_PENDING_OP = 128U };

  enum { STATUS_NOT_MANAGED = 256U };

  enum { STATUS_DISALLOWED = 496U };

  /**
   * Addon update has ended
   */
  /* void onUpdateEnded (); */
  NS_IMETHOD OnUpdateEnded(void) = 0;

  /**
   * Update for an individual addon has begun
   * @param   addon
   *          A nsIUpdateItem object representing the addon being updated
   *
   * @throws  NS_ERROR_ILLEGAL_VALUE if the addon is invalid.
   */
  /* void onAddonUpdateStarted (in nsIUpdateItem addon); */
  NS_IMETHOD OnAddonUpdateStarted(nsIUpdateItem *addon) = 0;

  /**
   * Update for an individual addon has ended
   * @param   addon
   *          A nsIUpdateItem object representing the addon being updated
   * @param   status
   *          The success or failure code of the update operation
   *
   * @throws  NS_ERROR_ILLEGAL_VALUE if the addon is invalid.
   */
  /* void onAddonUpdateEnded (in nsIUpdateItem addon, in long status); */
  NS_IMETHOD OnAddonUpdateEnded(nsIUpdateItem *addon, PRInt32 status) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAddonUpdateCheckListener, NS_IADDONUPDATECHECKLISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIADDONUPDATECHECKLISTENER \
  NS_IMETHOD OnUpdateStarted(void); \
  NS_IMETHOD OnUpdateEnded(void); \
  NS_IMETHOD OnAddonUpdateStarted(nsIUpdateItem *addon); \
  NS_IMETHOD OnAddonUpdateEnded(nsIUpdateItem *addon, PRInt32 status); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIADDONUPDATECHECKLISTENER(_to) \
  NS_IMETHOD OnUpdateStarted(void) { return _to OnUpdateStarted(); } \
  NS_IMETHOD OnUpdateEnded(void) { return _to OnUpdateEnded(); } \
  NS_IMETHOD OnAddonUpdateStarted(nsIUpdateItem *addon) { return _to OnAddonUpdateStarted(addon); } \
  NS_IMETHOD OnAddonUpdateEnded(nsIUpdateItem *addon, PRInt32 status) { return _to OnAddonUpdateEnded(addon, status); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIADDONUPDATECHECKLISTENER(_to) \
  NS_IMETHOD OnUpdateStarted(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnUpdateStarted(); } \
  NS_IMETHOD OnUpdateEnded(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnUpdateEnded(); } \
  NS_IMETHOD OnAddonUpdateStarted(nsIUpdateItem *addon) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnAddonUpdateStarted(addon); } \
  NS_IMETHOD OnAddonUpdateEnded(nsIUpdateItem *addon, PRInt32 status) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnAddonUpdateEnded(addon, status); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAddonUpdateCheckListener : public nsIAddonUpdateCheckListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIADDONUPDATECHECKLISTENER

  nsAddonUpdateCheckListener();

private:
  ~nsAddonUpdateCheckListener();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAddonUpdateCheckListener, nsIAddonUpdateCheckListener)

nsAddonUpdateCheckListener::nsAddonUpdateCheckListener()
{
  /* member initializers and constructor code */
}

nsAddonUpdateCheckListener::~nsAddonUpdateCheckListener()
{
  /* destructor code */
}

/* void onUpdateStarted (); */
NS_IMETHODIMP nsAddonUpdateCheckListener::OnUpdateStarted()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onUpdateEnded (); */
NS_IMETHODIMP nsAddonUpdateCheckListener::OnUpdateEnded()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onAddonUpdateStarted (in nsIUpdateItem addon); */
NS_IMETHODIMP nsAddonUpdateCheckListener::OnAddonUpdateStarted(nsIUpdateItem *addon)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onAddonUpdateEnded (in nsIUpdateItem addon, in long status); */
NS_IMETHODIMP nsAddonUpdateCheckListener::OnAddonUpdateEnded(nsIUpdateItem *addon, PRInt32 status)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

/**
 * Install Location Key for Application-Global Items
 */
#define NS_INSTALL_LOCATION_APPGLOBAL NS_LITERAL_STRING("app-global")
/**
 * Install Location Key for Application-Profile Items
 */
#define NS_INSTALL_LOCATION_APPPROFILE NS_LITERAL_STRING("app-profile")
/**
 * The category that contains a list of contract-ids to Install Location
 * services.
 */
#define CATEGORY_INSTALL_LOCATIONS "extension-install-locations"
/**
 * The observer topic to listen to for actions performed on installed
 * items.
 */
#define EM_ACTION_REQUESTED_TOPIC "em-action-requested"
#define EM_ITEM_INSTALLED   "item-installed"
#define EM_ITEM_UPGRADED    "item-upgraded"
#define EM_ITEM_UNINSTALLED "item-uninstalled"
#define EM_ITEM_ENABLED     "item-enabled"
#define EM_ITEM_DISABLED    "item-disabled"
#define EM_ITEM_CANCEL      "item-cancel-action"

#endif /* __gen_nsIExtensionManager_h__ */
