/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Linux_2.6.18-8.el5_Depend/mozilla/toolkit/components/downloads/public/nsIDownload.idl
 */

package org.mozilla.interfaces;

/**
 * Represents a download object.
 *
 * @note This object is no longer updated once it enters a completed state.
 *       Completed states are the following:
 *       nsIDownloadManager::DOWNLOAD_FINISHED
 *       nsIDownloadManager::DOWNLOAD_FAILED
 *       nsIDownloadManager::DOWNLOAD_CANCELED
 */
public interface nsIDownload extends nsITransfer {

  String NS_IDOWNLOAD_IID =
    "{e5900f21-7a8a-4f9f-ac67-5379a65c18b6}";

  /**
     * The target of a download is always a file on the local file system.
     */
  nsILocalFile getTargetFile();

  /**
     * The percentage of transfer completed.
     * If the file size is unknown it'll be -1 here.
     */
  int getPercentComplete();

  /**
     * The amount of bytes downloaded so far.
     */
  double getAmountTransferred();

  /**
     * The size of file in bytes.
     * Unknown size is represented by LL_MAXUINT.
     */
  double getSize();

  /**
     * The source of the transfer.
     */
  nsIURI getSource();

  /**
     * The target of the transfer.
     */
  nsIURI getTarget();

  /**
     * Object that can be used to cancel the download.
     * Will be null after the download is finished.
     */
  nsICancelable getCancelable();

  /**
     * The user-readable description of the transfer.
     */
  String getDisplayName();

  /**
     * The time a transfer was started.
     */
  long getStartTime();

  /**
     * The speed of the transfer in bytes/sec.
     */
  double getSpeed();

  /**
     * Optional. If set, it will contain the target's relevant MIME information.
     * This includes it's MIME Type, helper app, and whether that helper should be
     * executed.
     */
  nsIMIMEInfo getMIMEInfo();

  /**
     * The id of the download that is stored in the database.
     */
  long getId();

  /**
     * The state of the download.
     * @see nsIDownloadManager and nsIXPInstallManagerUI
     */
  short getState();

  /**
     * The referrer uri of the download.  This is only valid for HTTP downloads,
     * and can be null.
     */
  nsIURI getReferrer();

}