/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Netscape security libraries.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1994-2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Sun Microsystems
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * This file is intended to be included after different definitions of
 * PKIX_ERRORENTRY. It is included in pkixt.h to define a number for each error
 * by defining PKIX_ERRORENTRY(x,y) as PKIX_ ## x  and then listing thim within
 * an enum. It is included in pkix_error.c to define an array of error strings
 * by defining PKIX_ERRORENTRY(x,y) #y and then listing thim within an array
 * char *PKIX_ErrorText[]
 */
PKIX_ERRORENTRY(ADDHEADERFUNCTIONNOTSUPPORTED,AddHeader function not supported),
PKIX_ERRORENTRY(ADDTOVERIFYLOGFAILED,pkix_AddToVerifyLog failed),
PKIX_ERRORENTRY(AIAMGRCREATEFAILED,PKIX_PL_AIAMgr_Create failed),
PKIX_ERRORENTRY(AIAMGRFINDLDAPCLIENTFAILED,pkix_pl_AiaMgr_FindLDAPClient failed),
PKIX_ERRORENTRY(AIAMGRGETAIACERTSFAILED,PKIX_PL_AIAMgr_GetAIACerts failed),
PKIX_ERRORENTRY(AIAMGRGETHTTPCERTSFAILED,pkix_pl_AIAMgr_GetHTTPCerts failed),
PKIX_ERRORENTRY(AIAMGRGETLDAPCERTSFAILED,pkix_pl_AIAMgr_GetLDAPCerts failed),
PKIX_ERRORENTRY(ALGORITHMBYTESLENGTH0,Algorithm bytes length is 0),
PKIX_ERRORENTRY(ALLOCATENEWCERTGENERALNAMEFAILED,Allocate new CERTGeneralName failed),
PKIX_ERRORENTRY(ALLOCATESPACEFORCERTNAMECONSTRAINTSFAILED,Allocate space for CERTNameConstraints failed),
PKIX_ERRORENTRY(AMBIGUOUSPARENTAGEOFVERIFYNODE,Ambiguous parentage of VerifyNode),
PKIX_ERRORENTRY(ANCHORDIDNOTCHAINTOCERT,Anchor did not chain to Cert),
PKIX_ERRORENTRY(ANCHORDIDNOTPASSCERTSELECTORCRITERIA,Anchor did not pass CertSelector criteria),
PKIX_ERRORENTRY(APPENDLISTFAILED,pkix_pl_AppendList failed),
PKIX_ERRORENTRY(ARGUMENTNOTSTRING,Argument is not a String),
PKIX_ERRORENTRY(ARGUMENTSNOTBIGINTS,Arguments are not BigInts),
PKIX_ERRORENTRY(ARGUMENTSNOTBYTEARRAYS,Arguments are not Byte Arrays),
PKIX_ERRORENTRY(ARGUMENTSNOTDATES,Arguments are not Dates),
PKIX_ERRORENTRY(ARGUMENTSNOTOIDS,Arguments are not OIDs),
PKIX_ERRORENTRY(ATTEMPTTOADDDUPLICATEKEY,Attempt to add duplicate key),
PKIX_ERRORENTRY(ATTEMPTTODECODEANINCOMPLETERESPONSE,Attempt to decode an incomplete response),
PKIX_ERRORENTRY(ATTEMPTTODECREFALLOCERROR,Attempt to DecRef Alloc Error),
PKIX_ERRORENTRY(ATTEMPTTOINCREFALLOCERROR,Attempt to IncRef Alloc Error),
PKIX_ERRORENTRY(ATTEMPTTOREMOVENONEXISTANTITEM,Attempt to remove non-existant item),
PKIX_ERRORENTRY(BADHTTPRESPONSE,Bad Http Response),
PKIX_ERRORENTRY(BASICCONSTRAINTSCHECKERINITIALIZEFAILED,pkix_BasicConstraintsChecker_Initialize failed),
PKIX_ERRORENTRY(BASICCONSTRAINTSCHECKERSTATECREATEFAILED,PKIX_BasicConstraintsCheckerState_Create failed),
PKIX_ERRORENTRY(BASICCONSTRAINTSGETCAFLAGFAILED,PKIX_PL_BasicConstraints_GetCAFlag failed),
PKIX_ERRORENTRY(BASICCONSTRAINTSGETPATHLENCONSTRAINTFAILED,PKIX_PL_BasicConstraints_GetPathLenConstraint failed),
PKIX_ERRORENTRY(BASICCONSTRAINTSVALIDATIONFAILEDCA,PKIX_BasicConstraints validation failed: CA Flag not set),
PKIX_ERRORENTRY(BASICCONSTRAINTSVALIDATIONFAILEDLN,PKIX_BasicConstraints validation failed: maximum length mismatch),
PKIX_ERRORENTRY(BIGINTCOMPARATORFAILED,pkix_pl_BigInt_Comparator failed),
PKIX_ERRORENTRY(BIGINTCREATEWITHBYTESFAILED,pkix_pl_BigInt_CreateWithBytes failed),
PKIX_ERRORENTRY(BIGINTEQUALSFAILED,PKIX_PL_BigInt_Equals failed),
PKIX_ERRORENTRY(BIGINTLENGTH0INVALID,BigInt length 0 is invalid),
PKIX_ERRORENTRY(BIGINTTOSTRINGFAILED,pkix_pl_BigInt_ToString failed),
PKIX_ERRORENTRY(BIGINTTOSTRINGHELPERFAILED,PKIX_PL_BigInt_ToString_Helper failed),
PKIX_ERRORENTRY(BINDREJECTEDBYSERVER,BIND rejected by server),
PKIX_ERRORENTRY(BUILDBUILDSELECTORANDPARAMSFAILED,pkix_Build_BuildSelectorAndParams failed),
PKIX_ERRORENTRY(BUILDCOMBINEWITHTRUSTFAILED,pkix_Build_CombineWithTrust failed),
PKIX_ERRORENTRY(BUILDFORWARDDEPTHFIRSTSEARCHFAILED,pkix_BuildForwardDepthFirstSearch failed),
PKIX_ERRORENTRY(BUILDGATHERCERTSFAILED,pkix_Build_GatherCerts failed),
PKIX_ERRORENTRY(BUILDGETRESOURCELIMITSFAILED,pkix_Build_GetResourceLimits failed),
PKIX_ERRORENTRY(BUILDINITIATEBUILDCHAINFAILED,pkix_Build_InitiateBuildChain failed),
PKIX_ERRORENTRY(BUILDRESULTCREATEFAILED,pkix_BuildResult_Create failed),
PKIX_ERRORENTRY(BUILDRESULTGETCERTCHAINFAILED,PKIX_BuildResult_GetCertChain failed),
PKIX_ERRORENTRY(BUILDRESULTGETVALIDATERESULTFAILED,PKIX_BuildResult_GetValidateResult failed),
PKIX_ERRORENTRY(BUILDREVCHECKPREPFAILED,pkix_Build_RevCheckPrep failed),
PKIX_ERRORENTRY(BUILDSORTCANDIDATECERTSFAILED,pkix_Build_SortCandidateCerts failed),
PKIX_ERRORENTRY(BUILDSTATECREATEFAILED,pkix_BuildState_Create failed),
PKIX_ERRORENTRY(BUILDTRYSHORTCUTFAILED,pkix_Build_TryShortcut failed),
PKIX_ERRORENTRY(BUILDUPDATEDATEFAILED,pkix_Build_UpdateDate failed),
PKIX_ERRORENTRY(BUILDVALIDATEENTIRECHAINFAILED,pkix_Build_ValidateEntireChain failed),
PKIX_ERRORENTRY(BUILDVALIDATIONCHECKERSFAILED,pkix_Build_ValidationCheckers failed),
PKIX_ERRORENTRY(BUILDVERIFYCERTIFICATEFAILED,pkix_Build_VerifyCertificate failed),
PKIX_ERRORENTRY(BYTEARRAYCOMPARATORFAILED,pkix_pl_ByteArray_Comparator failed),
PKIX_ERRORENTRY(BYTEARRAYCREATEFAILED,PKIX_PL_ByteArray_Create failed),
PKIX_ERRORENTRY(BYTEARRAYEQUALSFAILED,PKIX_PL_ByteArray_Equals failed),
PKIX_ERRORENTRY(BYTEARRAYGETLENGTHFAILED,PKIX_PL_ByteArray_GetLength failed),
PKIX_ERRORENTRY(BYTEARRAYGETPOINTERFAILED,PKIX_PL_ByteArray_GetPointer failed),
PKIX_ERRORENTRY(BYTEARRAYTOHEXSTRINGFAILED,pkix_pl_ByteArray_ToHexString failed),
PKIX_ERRORENTRY(BYTEARRAYTOSTRINGFAILED,PKIX_PL_ByteArray_ToString failed),
PKIX_ERRORENTRY(CACHECERTADDFAILED,pkix_CacheCert_Add failed),
PKIX_ERRORENTRY(CACHECERTCHAINADDFAILED,pkix_CacheCertChain_Add failed),
PKIX_ERRORENTRY(CACHECERTCHAINLOOKUPFAILED,pkix_CacheCertChain_Lookup failed),
PKIX_ERRORENTRY(CACHECERTCHAINREMOVEFAILED,pkix_CacheCertChain_Remove failed),
PKIX_ERRORENTRY(CACHECRLENTRYADDFAILED,pkix_CacheCrlEntry_Add failed),
PKIX_ERRORENTRY(CACHECRLENTRYLOOKUPFAILED,pkix_CacheCrlEntry_Lookup failed),
PKIX_ERRORENTRY(CALLOCFAILED,PKIX_PL_Calloc failed),
PKIX_ERRORENTRY(CANNOTCALLAPPENDITEMONIMMUTABLELIST,Cannot call AppendItem on Immutable List),
PKIX_ERRORENTRY(CANNOTCALLDELETEITEMONIMMUTABLELIST,Cannot call DeleteItem on Immutable List),
PKIX_ERRORENTRY(CANNOTCALLINSERTITEMONIMMUTABLELIST,Cannot call InsertItem on Immutable List),
PKIX_ERRORENTRY(CANNOTCALLSETITEMONIMMUTABLELIST,Cannot call SetItem on Immutable List),
PKIX_ERRORENTRY(CANNOTOPENCOLLECTIONCERTSTORECONTEXTDIRECTORY,Cannot open CollectionCertStoreContext directory),
PKIX_ERRORENTRY(CANTCREATESTRING,Cannot create PKIX_PL_String),
PKIX_ERRORENTRY(CANTDECODEBINDRESPONSEFROMSERVER,Cannot decode BIND response from server),
PKIX_ERRORENTRY(CANTDECODESEARCHRESPONSEFROMSERVER,Cannot decode SEARCH response from server),
PKIX_ERRORENTRY(CANTENABLEREVOCATIONWITHOUTCERTSTORE,Cannot enable Revocation without CertStore),
PKIX_ERRORENTRY(CANTREREGISTERSYSTEMTYPE,Cannot reregister system type),
PKIX_ERRORENTRY(CERTARECERTPOLICIESCRITICALFAILED,PKIX_PL_Cert_AreCertPoliciesCritical failed),
PKIX_ERRORENTRY(CERTBASICCONSTRAINTSCREATEFAILED,pkix_pl_CertBasicConstraints_Create failed),
PKIX_ERRORENTRY(CERTBASICCONSTRAINTSTOSTRINGFAILED,PKIX_PL_CertBasicConstraints_ToString failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERCHECKCALLBACKFAILED,PKIX_CertChainChecker_CheckCallback failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERCHECKFAILED,PKIX_CertChainChecker_Check failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERCREATEFAILED,PKIX_CertChainChecker_Create failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETCERTCHAINCHECKERSTATEFAILED,PKIX_CertChainChecker_GetCertChainCheckerState failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETCHECKCALLBACKFAILED,PKIX_CertChainChecker_GetCheckCallback failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERGETSUPPORTEDEXTENSIONSFAILED,PKIX_CertChainChecker_GetSupportedExtensions failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERISFORWARDCHECKINGSUPPORTEDFAILED,PKIX_CertChainChecker_IsForwardCheckingSupported failed),
PKIX_ERRORENTRY(CERTCHAINCHECKERSETCERTCHAINCHECKERSTATEFAILED,PKIX_CertChainChecker_SetCertChainCheckerState failed),
PKIX_ERRORENTRY(CERTCHAINFAILSCERTIFICATEPOLICYVALIDATION,CertChain fails Certificate Policy validation),
PKIX_ERRORENTRY(CERTCHECKCERTVALIDTIMESFAILED,CERT_CheckCertValidTimes failed),
PKIX_ERRORENTRY(CERTCHECKEXTENDEDKEYUSAGEFAILED,pkix_pl_Cert_CheckExtendedKeyUsage failed),
PKIX_ERRORENTRY(CERTCHECKKEYUSAGEFAILED,CERT_CheckKeyUsage failed),
PKIX_ERRORENTRY(CERTCHECKNAMECONSTRAINTSFAILED,PKIX_PL_Cert_CheckNameConstraints failed),
PKIX_ERRORENTRY(CERTCHECKVALIDITYFAILED,PKIX_PL_Cert_CheckValidity failed),
PKIX_ERRORENTRY(CERTCOMPLETECRLDECODEDENTRIESFAILED,CERT_CompleteCRLDecodedEntries failed),
PKIX_ERRORENTRY(CERTCOPYNAMECONSTRAINTFAILED,CERT_CopyNameConstraint failed),
PKIX_ERRORENTRY(CERTCREATEFAILED,PKIX_PL_Cert_Create failed),
PKIX_ERRORENTRY(CERTCREATEGENERALNAMELISTFAILED,CERT_CreateGeneralNameList failed),
PKIX_ERRORENTRY(CERTCREATETOLISTFAILED,pkix_pl_Cert_CreateToList failed),
PKIX_ERRORENTRY(CERTCREATEWITHNSSCERTFAILED,pkix_pl_Cert_CreateWithNSSCert failed),
PKIX_ERRORENTRY(CERTDECODEALTNAMEEXTENSIONFAILED,CERT_DecodeAltNameExtension failed),
PKIX_ERRORENTRY(CERTDECODECERTIFICATEPOLICIESEXTENSIONFAILED,CERT_DecodeCertificatePoliciesExtension failed),
PKIX_ERRORENTRY(CERTDECODEDERCERTIFICATEFAILED,CERT_DecodeDERCertificate failed),
PKIX_ERRORENTRY(CERTDECODEDERCRLFAILED,CERT_DecodeDERCrl failed),
PKIX_ERRORENTRY(CERTDECODEINHIBITANYEXTENSIONFAILED,CERT_DecodeInhibitAnyExtension failed),
PKIX_ERRORENTRY(CERTDECODEINHIBITANYPOLICYFAILED,pkix_pl_Cert_DecodeInhibitAnyPolicy failed),
PKIX_ERRORENTRY(CERTDECODEOIDSEQUENCEFAILED,CERT_DecodeOidSequence failed),
PKIX_ERRORENTRY(CERTDECODEPOLICYCONSTRAINTSEXTENSIONFAILED,CERT_DecodePolicyConstraintsExtension failed),
PKIX_ERRORENTRY(CERTDECODEPOLICYCONSTRAINTSFAILED,pkix_pl_Cert_DecodePolicyConstraints failed),
PKIX_ERRORENTRY(CERTDECODEPOLICYINFOFAILED,pkix_pl_Cert_DecodePolicyInfo failed),
PKIX_ERRORENTRY(CERTDECODEPOLICYMAPPINGFAILED,pkix_pl_Cert_DecodePolicyMapping failed),
PKIX_ERRORENTRY(CERTDECODEPOLICYMAPPINGSEXTENSIONFAILED,CERT_DecodePolicyMappingsExtension failed),
PKIX_ERRORENTRY(CERTEQUALSFAILED,pkix_pl_Cert_Equals failed),
PKIX_ERRORENTRY(CERTFAILEDNAMECONSTRAINTSCHECKING,Cert failed NameConstraints checking),
PKIX_ERRORENTRY(CERTGETALLSUBJECTNAMESFAILED,PKIX_PL_Cert_GetAllSubjectNames failed),
PKIX_ERRORENTRY(CERTGETAUTHORITYINFOACCESSFAILED,PKIX_PL_Cert_GetAuthorityInfoAccess failed),
PKIX_ERRORENTRY(CERTGETAUTHORITYKEYIDENTIFIERFAILED,PKIX_PL_Cert_GetAuthorityKeyIdentifier failed),
PKIX_ERRORENTRY(CERTGETBASICCONSTRAINTFAILED,PKIX_PL_Cert_GetBasicConstraint failed),
PKIX_ERRORENTRY(CERTGETBASICCONSTRAINTSFAILED,PKIX_PL_Cert_GetBasicConstraints failed),
PKIX_ERRORENTRY(CERTGETCACHEFLAGFAILED,PKIX_Cert_GetCacheFlag failed),
PKIX_ERRORENTRY(CERTGETCERTIFICATENAMESRETURNNULL,CERT_GetCertificateNames return NULL),
PKIX_ERRORENTRY(CERTGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_Cert_GetCriticalExtensionOIDs failed),
PKIX_ERRORENTRY(CERTGETEXTENDEDKEYUSAGEFAILED,PKIX_PL_Cert_GetExtendedKeyUsage failed),
PKIX_ERRORENTRY(CERTGETINHIBITANYPOLICYFAILED,PKIX_PL_Cert_GetInhibitAnyPolicy failed),
PKIX_ERRORENTRY(CERTGETISSUERFAILED,PKIX_PL_Cert_GetIssuer failed),
PKIX_ERRORENTRY(CERTGETNAMECONSTRAINTSFAILED,PKIX_PL_CertGetNameConstraints failed),
PKIX_ERRORENTRY(CERTGETNSSSUBJECTALTNAMESFAILED,pkix_pl_Cert_GetNssSubjectAltNames failed),
PKIX_ERRORENTRY(CERTGETPOLICYINFORMATIONFAILED,PKIX_PL_Cert_GetPolicyInformation failed),
PKIX_ERRORENTRY(CERTGETPOLICYMAPPINGINHIBITEDFAILED,PKIX_PL_Cert_GetPolicyMappingInhibited failed),
PKIX_ERRORENTRY(CERTGETPOLICYMAPPINGSFAILED,PKIX_PL_Cert_GetPolicyMappings failed),
PKIX_ERRORENTRY(CERTGETREQUIREEXPLICITPOLICYFAILED,PKIX_PL_Cert_GetRequireExplicitPolicy failed),
PKIX_ERRORENTRY(CERTGETSERIALNUMBERFAILED,PKIX_PL_Cert_GetSerialNumber failed),
PKIX_ERRORENTRY(CERTGETSUBJALTNAMESFAILED,PKIX_PL_Cert_GetSubjAltNames failed),
PKIX_ERRORENTRY(CERTGETSUBJECTALTNAMESFAILED,PKIX_PL_Cert_GetSubjectAltNames failed),
PKIX_ERRORENTRY(CERTGETSUBJECTFAILED,PKIX_PL_Cert_GetSubject failed),
PKIX_ERRORENTRY(CERTGETSUBJECTINFOACCESSFAILED,PKIX_PL_Cert_GetSubjectInfoAccess failed),
PKIX_ERRORENTRY(CERTGETSUBJECTKEYIDENTIFIERFAILED,PKIX_PL_Cert_GetSubjectKeyIdentifier failed),
PKIX_ERRORENTRY(CERTGETSUBJECTPUBLICKEYALGIDFAILED,PKIX_PL_Cert_GetSubjectPublicKeyAlgId failed),
PKIX_ERRORENTRY(CERTGETSUBJECTPUBLICKEYFAILED,PKIX_PL_Cert_GetSubjectPublicKey failed),
PKIX_ERRORENTRY(CERTGETVALIDITYNOTAFTERFAILED,PKIX_PL_Cert_GetValidityNotAfter failed),
PKIX_ERRORENTRY(CERTGETVERSIONFAILED,PKIX_PL_Cert_GetVersion failed),
PKIX_ERRORENTRY(CERTHASHCODEFAILED,PKIX_PL_Cert_Hashcode failed),
PKIX_ERRORENTRY(CERTIFICATEDOESNTHAVEVALIDCRL,Certificate does not have a valid CRL),
PKIX_ERRORENTRY(CERTIFICATEREVOKEDBYCRL,Certificate is revoked by CRL for key compromise),
PKIX_ERRORENTRY(CERTIMPORTCERTIFICATEFUNCTIONFAILED,CERTImportCertificate function failed),
PKIX_ERRORENTRY(CERTISCERTTRUSTEDFAILED,PKIX_PL_Cert_IsCertTrusted failed),
PKIX_ERRORENTRY(CERTISEXTENSIONCRITICALFAILED,pkix_pl_Cert_IsExtensionCritical failed),
PKIX_ERRORENTRY(CERTMERGENAMECONSTRAINTSFAILED,PKIX_PL_Cert_MergeNameConstraints failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMEINNAMESPACEFAILED,PKIX_PL_CertNameConstraints_CheckNameInNameSpace failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMESINNAMESPACEFAILED,PKIX_PL_CertNameConstraints_CheckNamesInNameSpace failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCHECKNAMESPACENSSNAMESFAILED,pkix_pl_CertNameConstraints_CheckNameSpaceNssNames failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCOPYNSSNAMECONSTRAINTSFAILED,pkix_pl_CertNameConstraints_CopyNssNameConstraints failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEBYMERGEFAILED,pkix_pl_CertNameConstraints_CreateByMerge failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEFAILED,pkix_pl_CertNameConstraints_Create failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSCREATEHELPERFAILED,pkix_pl_CertNameConstraints_Create_Helper failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSGETEXCLUDEDFAILED,pkix_pl_CertNameConstraints_GetExcluded failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSGETPERMITTEDFAILED,pkix_pl_CertNameConstraints_GetPermitted failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSMERGEFAILED,pkix_pl_CertNameConstraints_Merge failed),
PKIX_ERRORENTRY(CERTNAMECONSTRAINTSTOSTRINGHELPERFAILED,pkix_pl_CertNameConstraints_ToString_Helper failed),
PKIX_ERRORENTRY(CERTNAMETOASCIIFAILED,CERT_NameToAscii failed),
PKIX_ERRORENTRY(CERTNOTALLOWEDTOSIGNCERTIFICATES,Cert not allowed to sign certificates),
PKIX_ERRORENTRY(CERTPOLICYINFOCREATEFAILED,pkix_pl_CertPolicyInfo_Create failed),
PKIX_ERRORENTRY(CERTPOLICYINFOGETPOLICYIDFAILED,PKIX_PL_CertPolicyInfo_GetPolicyId failed),
PKIX_ERRORENTRY(CERTPOLICYINFOGETPOLQUALIFIERSFAILED,PKIX_PL_CertPolicyInfo_GetPolQualifiers failed),
PKIX_ERRORENTRY(CERTPOLICYMAPCREATEFAILED,pkix_pl_CertPolicyMap_Create failed),
PKIX_ERRORENTRY(CERTPOLICYMAPGETISSUERDOMAINPOLICYFAILED,PKIX_PL_CertPolicyMap_GetIssuerDomainPolicy failed),
PKIX_ERRORENTRY(CERTPOLICYMAPGETSUBJECTDOMAINPOLICYFAILED,PKIX_PL_CertPolicyMap_GetSubjectDomainPolicy failed),
PKIX_ERRORENTRY(CERTPOLICYQUALIFIERCREATEFAILED,pkix_pl_CertPolicyQualifier_Create failed),
PKIX_ERRORENTRY(CERTREJECTEDBYREVOCATIONCHECKER,Cert rejected by revocation checker),
PKIX_ERRORENTRY(CERTSELECTORCHECKFAILED,Validation failed: CertSelector check failed),
PKIX_ERRORENTRY(CERTSELECTORCREATEFAILED,PKIX_CertSelector_Create failed),
PKIX_ERRORENTRY(CERTSELECTORFAILED,certSelector failed),
PKIX_ERRORENTRY(CERTSELECTORGETCOMCERTSELPARAMSFAILED,PKIX_CertSelector_GetComCertSelParams failed),
PKIX_ERRORENTRY(CERTSELECTORGETCOMMONCERTSELECTORPARAMFAILED,PKIX_CertSelector_GetCommonCertSelectorParam failed),
PKIX_ERRORENTRY(CERTSELECTORGETCOMMONCERTSELECTORPARAMSFAILED,PKIX_CertSelector_GetCommonCertSelectorParams failed),
PKIX_ERRORENTRY(CERTSELECTORGETMATCHCALLBACKFAILED,PKIX_CertSelector_GetMatchCallback failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHAUTHKEYIDFAILED,pkix_CertSelector_Match_AuthKeyId failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHBASICCONSTRAINTFAILED,pkix_CertSelector_Match_BasicConstraint failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHCALLBACKFAILED,PKIX_CertSelector_MatchCallback failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHCERTIFICATEVALIDFAILED,pkix_CertSelector_Match_CertificateValid failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHEXTENDEDKEYUSAGEFAILED,pkix_CertSelector_Match_ExtendedKeyUsage failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHFAILED,certSelectorMatch failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHKEYUSAGEFAILED,pkix_CertSelector_Match_KeyUsage failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHNAMECONSTRAINTSFAILED,pkix_CertSelector_Match_NameConstraints failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHPATHTONAMESFAILED,pkix_CertSelector_Match_PathToNames failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHPOLICIESFAILED,pkix_CertSelector_Match_Policies failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJALTNAMESFAILED,pkix_CertSelector_Match_SubjAltNames failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJKEYIDFAILED,pkix_CertSelector_Match_SubjKeyId failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJPKALGIDFAILED,pkix_CertSelector_Match_SubjPKAlgId failed),
PKIX_ERRORENTRY(CERTSELECTORMATCHSUBJPUBKEYFAILED,pkix_CertSelector_Match_SubjPubKey failed),
PKIX_ERRORENTRY(CERTSELECTORSELECTFAILED,pkix_CertSelector_Select failed),
PKIX_ERRORENTRY(CERTSELECTORSETCOMMONCERTSELECTORPARAMSFAILED,PKIX_CertSelector_SetCommonCertSelectorParams failed),
PKIX_ERRORENTRY(CERTSETCACHEFLAGFAILED,PKIX_PL_Cert_SetCacheFlag failed),
PKIX_ERRORENTRY(CERTSETTRUSTCERTSTOREFAILED,PKIX_PL_Cert_SetTrustCertStore failed),
PKIX_ERRORENTRY(CERTSTORECERTCONTINUEFAILED,PKIX_CertStore_CertContinue failed),
PKIX_ERRORENTRY(CERTSTORECERTCONTINUEFUNCTIONFAILED,PKIX_CertStore_CertContinueFunction failed),
PKIX_ERRORENTRY(CERTSTORECREATEFAILED,PKIX_CertStore_Create failed),
PKIX_ERRORENTRY(CERTSTORECRLCONTINUEFAILED,PKIX_CertStore_CrlContinue failed),
PKIX_ERRORENTRY(CERTSTOREEQUALSFAILED,pkix_CertStore_Equals failed),
PKIX_ERRORENTRY(CERTSTOREGETCERTCALLBACKFAILED,PKIX_CertStore_GetCertCallback failed),
PKIX_ERRORENTRY(CERTSTOREGETCERTSTORECACHEFLAGFAILED,PKIX_CertStore_GetCertStoreCacheFlag failed),
PKIX_ERRORENTRY(CERTSTOREGETCERTSTORECONTEXTFAILED,PKIX_CertStore_GetCertStoreContext failed),
PKIX_ERRORENTRY(CERTSTOREGETCRLCALLBACKFAILED,PKIX_CertStore_GetCRLCallback failed),
PKIX_ERRORENTRY(CERTSTOREGETLOCALFLAGFAILED,PKIX_CertStore_GetLocalFlag failed),
PKIX_ERRORENTRY(CERTSTOREGETTRUSTCALLBACKFAILED,PKIX_CertStore_GetTrustCallback failed),
PKIX_ERRORENTRY(CERTSTOREHASHCODEFAILED,pkix_CertStore_Hashcode failed),
PKIX_ERRORENTRY(CERTTOSTRINGFAILED,PKIX_PL_Cert_ToString failed),
PKIX_ERRORENTRY(CERTTOSTRINGHELPERFAILED,pkix_pl_Cert_ToString_Helper failed),
PKIX_ERRORENTRY(CERTVERIFYKEYUSAGEFAILED,PKIX_PL_Cert_VerifyKeyUsage failed),
PKIX_ERRORENTRY(CERTVERIFYSIGNATUREFAILED,PKIX_PL_Cert_VerifySignature failed),
PKIX_ERRORENTRY(CHAINREJECTEDBYREVOCATIONCHECKER,Chain rejected by Revocation Checker),
PKIX_ERRORENTRY(CHECKCERTAGAINSTANCHORFAILED,pkix_CheckCertAgainstAnchor failed),
PKIX_ERRORENTRY(CHECKCERTFAILED,pkix_CheckCert failed),
PKIX_ERRORENTRY(CHECKCHAINFAILED,pkix_CheckChain failed),
PKIX_ERRORENTRY(CHECKTRUSTCALLBACKFAILED,CheckTrustCallback failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTCREATECERTFAILED,pkix_pl_CollectionCertStoreContext_CreateCert failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTCREATECRLFAILED,pkix_pl_CollectionCertStoreContext_CreateCRL failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTGETSELECTCERTFAILED,pkix_pl_CollectionCertStoreContext_GetSelectCert failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTGETSELECTCRLFAILED,pkix_pl_CollectionCertStoreContext_GetSelectCRL failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTPOPULATECERTFAILED,pkix_pl_CollectionCertStoreContext_PopulateCert failed),
PKIX_ERRORENTRY(COLLECTIONCERTSTORECONTEXTPOPULATECRLFAILED,pkix_pl_CollectionCertStoreContext_PopulateCRL failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSCREATEFAILED,PKIX_ComCertSelParams_Create failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETAUTHORITYKEYIDENTIFIERFAILED,PKIX_ComCertSelParams_GetAuthorityKeyIdentifier failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETBASICCONSTRAINTSFAILED,PKIX_ComCertSelParams_GetBasicConstraints failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETCERTIFICATEFAILED,PKIX_ComCertSelParams_GetCertificate failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETCERTIFICATEVALIDFAILED,PKIX_ComCertSelParams_GetCertificateValid failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETEXTENDEDKEYUSAGEFAILED,PKIX_ComCertSelParams_GetExtendedKeyUsage failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETISSUERFAILED,PKIX_ComCertSelParams_GetIssuer failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETKEYUSAGEFAILED,PKIX_ComCertSelParams_GetKeyUsage failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETMATCHALLSUBJALTNAMESFAILED,PKIX_ComCertSelParams_GetMatchAllSubjAltNames failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETNAMECONSTRAINTSFAILED,PKIX_ComCertSelParams_GetNameConstraints failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETPATHTONAMESFAILED,PKIX_ComCertSelParams_GetPathToNames failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETPOLICYFAILED,PKIX_ComCertSelParams_GetPolicy failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSERIALNUMBERFAILED,PKIX_ComCertSelParams_GetSerialNumber failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJALTNAMESFAILED,PKIX_ComCertSelParams_GetSubjAltNames failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJECTFAILED,PKIX_ComCertSelParams_GetSubject failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJKEYIDENTIFIERFAILED,PKIX_ComCertSelParams_GetSubjKeyIdentifier failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJPKALGIDFAILED,PKIX_ComCertSelParams_GetSubjPKAlgId failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETSUBJPUBKEYFAILED,PKIX_ComCertSelParams_GetSubjPubKey failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSGETVERSIONFAILED,PKIX_ComCertSelParams_GetVersion failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETBASICCONSTRAINTSFAILED,PKIX_ComCertSelParams_SetBasicConstraints failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETCERTIFICATEFAILED,PKIX_ComCertSelParams_SetCertificate failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETCERTIFICATEVALIDFAILED,PKIX_ComCertSelParams_SetCertificateValid failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETPATHTONAMESFAILED,PKIX_ComCertSelParams_SetPathToNames failed),
PKIX_ERRORENTRY(COMCERTSELPARAMSSETSUBJECTFAILED,PKIX_ComCertSelParams_SetSubject failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSADDISSUERNAMEFAILED,PKIX_ComCRLSelParams_AddIssuerName failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSCREATEFAILED,PKIX_ComCRLSelParams_Create failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSEQUALSFAILED,pkix_ComCRLSelParams_Equals failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETDATEANDTIMEFAILED,PKIX_ComCRLSelParams_GetDateAndTime failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETISSUERNAMESFAILED,PKIX_ComCRLSelParams_GetIssuerNames failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETMAXCRLNUMBERFAILED,PKIX_ComCRLSelParams_GetMaxCRLNumber failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSGETMINCRLNUMBERFAILED,PKIX_ComCRLSelParams_GetMinCRLNumber failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSSETDATEANDTIMEFAILED,PKIX_ComCRLSelParams_SetDateAndTime failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSTOSTRINGFAILED,pkix_ComCRLSelParams_ToString failed),
PKIX_ERRORENTRY(COMCRLSELPARAMSTOSTRINGHELPERFAILED,pkix_ComCRLSelParams_ToString_Helper failed),
PKIX_ERRORENTRY(COMPARATORCALLBACKFAILED,comparator callback failed),
PKIX_ERRORENTRY(CONTENTTYPENOTPKCS7MIME,Content type is not application/pkcs7-mime),
PKIX_ERRORENTRY(CONTENTTYPENOTPKIXCRL,Content type is not application/pkix-crl),
PKIX_ERRORENTRY(COULDNOTALLOCATEMEMORY,Could not allocate memory),
PKIX_ERRORENTRY(COULDNOTALLOCATENEWSTRINGOBJECT,Could not allocate new string object),
PKIX_ERRORENTRY(COULDNOTAPPENDCHILDTOPARENTSPOLICYNODELIST,Could not append child to parent PolicyNode list),
PKIX_ERRORENTRY(COULDNOTAPPENDCHILDTOPARENTSVERIFYNODELIST,Could not append child to parent VerifyNode list),
PKIX_ERRORENTRY(COULDNOTCREATEAIAMGROBJECT,Could not create AiaMgr object),
PKIX_ERRORENTRY(COULDNOTCREATEBASICCONSTRAINTSSTATEOBJECT,Could not create basic constraints state object),
PKIX_ERRORENTRY(COULDNOTCREATEBUILDPARAMSOBJECT,Could not create build params object),
PKIX_ERRORENTRY(COULDNOTCREATEBUILDRESULTOBJECT,Could not create build result object),
PKIX_ERRORENTRY(COULDNOTCREATECERTBASICCONSTRAINTSOBJECT,Could not create a CertBasicConstraints object),
PKIX_ERRORENTRY(COULDNOTCREATECERTCHAINCHECKEROBJECT,Could not create cert chain checker object),
PKIX_ERRORENTRY(COULDNOTCREATECERTNAMECONSTRAINTSOBJECT,Could not create CertNameConstraints object),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYINFOOBJECT,Could not create a CertPolicyInfo object),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYMAPOBJECT,Could not create a CertPolicyMap object),
PKIX_ERRORENTRY(COULDNOTCREATECERTPOLICYQUALIFIEROBJECT,Could not create a CertPolicyQualifier object),
PKIX_ERRORENTRY(COULDNOTCREATECERTSELECTOROBJECT,Could not create cert selector object),
PKIX_ERRORENTRY(COULDNOTCREATECERTSTOREOBJECT,Could not create CertStore object),
PKIX_ERRORENTRY(COULDNOTCREATECOLLECTIONCERTSTORECONTEXTOBJECT,Could not create CollectionCertStoreContext object),
PKIX_ERRORENTRY(COULDNOTCREATECOMMONCERTSELPARAMSOBJECT,Could not create common certsel params object),
PKIX_ERRORENTRY(COULDNOTCREATECOMMONCRLSELECTORPARAMSOBJECT,Could not create common crl selector params object),
PKIX_ERRORENTRY(COULDNOTCREATECRLENTRYOBJECT,Could not create CRLENTRY object),
PKIX_ERRORENTRY(COULDNOTCREATECRLOBJECT,Could not create CRL object),
PKIX_ERRORENTRY(COULDNOTCREATECRLSELECTOROBJECT,Could not create CRLSelector object),
PKIX_ERRORENTRY(COULDNOTCREATEDEFAULTCRLCHECKERSTATEOBJECT,Could not create DefaultCRLCheckerState object),
PKIX_ERRORENTRY(COULDNOTCREATEDEFAULTREVOCATIONCHECKEROBJECT,Could not create DefaultRevocationChecker object),
PKIX_ERRORENTRY(COULDNOTCREATEEKUCHECKERSTATEOBJECT,Could not create EkuCheckerState object),
PKIX_ERRORENTRY(COULDNOTCREATEFORWARDBUILDERSTATEOBJECT,Could not create forwardBuilder state object),
PKIX_ERRORENTRY(COULDNOTCREATEHASHTABLEOBJECT,Could not create HashTable object),
PKIX_ERRORENTRY(COULDNOTCREATEHTTPDEFAULTCLIENTOBJECT,Could not create HttpDefaultClient object),
PKIX_ERRORENTRY(COULDNOTCREATEINFOACCESSOBJECT,Could not create InfoAccess object),
PKIX_ERRORENTRY(COULDNOTCREATELDAPDEFAULTCLIENTOBJECT,Could not create LdapDefaultClient object),
PKIX_ERRORENTRY(COULDNOTCREATELOCKOBJECT,Could not create lock object),
PKIX_ERRORENTRY(COULDNOTCREATELOGGEROBJECT,Could not create Logger object),
PKIX_ERRORENTRY(COULDNOTCREATENAMECONSTRAINTSCHECKERSTATEOBJECT,Could not create NameConstraintsCheckerState object),
PKIX_ERRORENTRY(COULDNOTCREATENSSDN,Could not create NSS DN),
PKIX_ERRORENTRY(COULDNOTCREATEOBJECT,Could not create object),
PKIX_ERRORENTRY(COULDNOTCREATEOBJECTSTORAGE,Could not create object storage),
PKIX_ERRORENTRY(COULDNOTCREATEPOLICYCHECKERSTATEOBJECT,Could not create policyChecker state object),
PKIX_ERRORENTRY(COULDNOTCREATEPOLICYNODEOBJECT,Could not create a PolicyNode object),
PKIX_ERRORENTRY(COULDNOTCREATEPROCESSINGPARAMSOBJECT,Could not create processing params object),
PKIX_ERRORENTRY(COULDNOTCREATERESOURCELIMITOBJECT,Could not create ResourceLimit object),
PKIX_ERRORENTRY(COULDNOTCREATESIGNATURECHECKERSTATEOBJECT,Could not create SignatureCheckerState object),
PKIX_ERRORENTRY(COULDNOTCREATESOCKETOBJECT,Could not create Socket object),
PKIX_ERRORENTRY(COULDNOTCREATESTRING,Could not create string),
PKIX_ERRORENTRY(COULDNOTCREATETARGETCERTCHECKERSTATEOBJECT,Could not create target cert checker state object),
PKIX_ERRORENTRY(COULDNOTCREATETRUSTANCHOROBJECT,Could not create trust anchor object),
PKIX_ERRORENTRY(COULDNOTCREATEVALIDATEPARAMSOBJECT,Could not create validate params object),
PKIX_ERRORENTRY(COULDNOTCREATEVALIDATERESULTOBJECT,Could not create validate result object),
PKIX_ERRORENTRY(COULDNOTCREATEVERIFYNODEOBJECT,Could not create a VerifyNode object),
PKIX_ERRORENTRY(COULDNOTCREATEX500NAMEOBJECT,Could not create X500Name object),
PKIX_ERRORENTRY(COULDNOTGETFIRSTOBJECTTYPE,Could not get first object type),
PKIX_ERRORENTRY(COULDNOTGETSECONDOBJECTTYPE,Could not get second object type),
PKIX_ERRORENTRY(COULDNOTGETTYPEOFSECONDARGUMENT,Could not get type of second argument),
PKIX_ERRORENTRY(COULDNOTLOOKUPINHASHTABLE,Could not lookup in hashtable),
PKIX_ERRORENTRY(COULDNOTMALLOCNEWKEY,Could not malloc new key),
PKIX_ERRORENTRY(COULDNOTTESTWHETHERKEYSEQUAL,Could not test whether keys are equal),
PKIX_ERRORENTRY(CREATECERTFAILED,CreateCert failed),
PKIX_ERRORENTRY(CREATECRLSELECTORDUPLICATEOBJECTFAILED,Create CRLSelector Duplicate Object failed),
PKIX_ERRORENTRY(CRLCREATEFAILED,PKIX_PL_CRL_Create failed),
PKIX_ERRORENTRY(CRLCREATETOLISTFAILED,pkix_pl_CRL_CreateToList failed),
PKIX_ERRORENTRY(CRLCREATEWITHSIGNEDCRLFAILED,pkix_pl_CRL_CreateWithSignedCRL failed),
PKIX_ERRORENTRY(CRLCRITICALEXTENSIONOIDSNOTPROCESSED,CRL Critical Extension OIDs not processed),
PKIX_ERRORENTRY(CRLENTRYCREATEFAILED,pkix_pl_CRLEntry_Create failed),
PKIX_ERRORENTRY(CRLENTRYCRITICALEXTENSIONWASNOTPROCESSED,CRLEntry Critical Extension was not processed),
PKIX_ERRORENTRY(CRLENTRYEXTENSIONSEQUALSFAILED,PKIX_PL_CRLEntry_Extensions_Equals failed),
PKIX_ERRORENTRY(CRLENTRYEXTENSIONSHASHCODEFAILED,pkix_pl_CRLEntry_Extensions_Hashcode failed),
PKIX_ERRORENTRY(CRLENTRYGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_CRLEntry_GetCriticalExtensionOIDs failed),
PKIX_ERRORENTRY(CRLENTRYGETCRLENTRYREASONCODEFAILED,PKIX_PL_CRLEntry_GetCRLEntryReasonCode failed),
PKIX_ERRORENTRY(CRLENTRYTOSTRINGHELPERFAILED,pkix_pl_CRLEntry_ToString_Helper failed),
PKIX_ERRORENTRY(CRLGETCRITICALEXTENSIONOIDSFAILED,PKIX_PL_CRL_GetCriticalExtensionOIDs failed),
PKIX_ERRORENTRY(CRLGETCRLENTRIESFAILED,pkix_pl_CRL_GetCRLEntries failed),
PKIX_ERRORENTRY(CRLGETCRLENTRYFORSERIALNUMBERFAILED,PKIX_PL_CRL_GetCRLEntryForSerialNumber failed),
PKIX_ERRORENTRY(CRLGETCRLNUMBERFAILED,PKIX_PL_CRL_GetCRLNumber failed),
PKIX_ERRORENTRY(CRLGETISSUERFAILED,PKIX_PL_CRL_GetIssuer failed),
PKIX_ERRORENTRY(CRLGETSIGNATUREALGIDFAILED,pkix_pl_CRL_GetSignatureAlgId failed),
PKIX_ERRORENTRY(CRLGETVERSIONFAILED,pkix_pl_CRL_GetVersion failed),
PKIX_ERRORENTRY(CRLMAXNUMBERRANGEMATCHFAILED,CRL MaxNumber Range Match Failed),
PKIX_ERRORENTRY(CRLSELECTORCREATEFAILED,PKIX_CRLSelector_Create failed),
PKIX_ERRORENTRY(CRLSELECTORFAILED,crlSelector failed),
PKIX_ERRORENTRY(CRLSELECTORGETCOMCERTSELPARAMSFAILED,PKIX_CRLSelector_GetComCertSelParams failed),
PKIX_ERRORENTRY(CRLSELECTORGETMATCHCALLBACKFAILED,PKIX_CRLSelector_GetMatchCallback failed),
PKIX_ERRORENTRY(CRLSELECTORMATCHCALLBACKFAILED,PKIX_CRLSelector_MatchCallback failed),
PKIX_ERRORENTRY(CRLSELECTORMATCHFAILED,crlSelectorMatch failed),
PKIX_ERRORENTRY(CRLSELECTORSELECTFAILED,pkix_CRLSelector_Select failed),
PKIX_ERRORENTRY(CRLSELECTORSETCOMMONCRLSELECTORPARAMSFAILED,PKIX_CRLSelector_SetCommonCRLSelectorParams failed),
PKIX_ERRORENTRY(CRLSELECTORTOSTRINGHELPERFAILED,pkix_CRLSelector_ToString_Helper failed),
PKIX_ERRORENTRY(CRLTOSTRINGHELPERFAILED,pkix_pl_CRL_ToString_Helper failed),
PKIX_ERRORENTRY(CRLVERIFYUPDATETIMEFAILED,pkix_pl_CRL_VerifyUpdateTime failed),
PKIX_ERRORENTRY(DATECREATECURRENTOFFBYSECONDSFAILED,PKIX_PL_Date_Create_CurrentOffBySeconds failed),
PKIX_ERRORENTRY(DATECREATEFROMPRTIMEFAILED,pkix_pl_Date_CreateFromPRTime failed),
PKIX_ERRORENTRY(DATECREATEUTCTIMEFAILED,PKIX_PL_Date_Create_UTCTime failed),
PKIX_ERRORENTRY(DATEEQUALSFAILED,PKIX_PL_Date_Equals failed),
PKIX_ERRORENTRY(DATEGETPRTIMEFAILED,pkix_pl_Date_GetPRTime failed),
PKIX_ERRORENTRY(DATEHASHCODEFAILED,PKIX_PL_Date_Hashcode failed),
PKIX_ERRORENTRY(DATETOSTRINGFAILED,PKIX_Date_ToString failed),
PKIX_ERRORENTRY(DATETOSTRINGHELPERFAILED,pkix_pl_Date_ToString_Helper failed),
PKIX_ERRORENTRY(DECIPHERONLYKEYUSAGENOTSUPPORTED,decipherOnly key usage not supported),
PKIX_ERRORENTRY(DECODINGCERTNAMECONSTRAINTSFAILED,Decoding Cert NameConstraints failed),
PKIX_ERRORENTRY(DEFAULTCRLCHECKERCHECKHELPERFAILED,pkix_DefaultCRLChecker_Check_Helper failed),
PKIX_ERRORENTRY(DEFAULTCRLCHECKERCHECKSETSELECTORFAILED,pkix_DefaultCRLChecker_Check_SetSelector failed),
PKIX_ERRORENTRY(DEFAULTCRLCHECKERCHECKSTOREFAILED,pkix_DefaultCRLChecker_Check_Store failed),
PKIX_ERRORENTRY(DEFAULTCRLCHECKERINITIALIZEFAILED,pkix_DefaultCRLChecker_Initialize failed),
PKIX_ERRORENTRY(DEFAULTCRLCHECKERSTATECREATEFAILED,pkix_DefaultCRLCheckerState_Create failed),
PKIX_ERRORENTRY(DEFAULTREVCHECKERCREATEFAILED,pkix_DefaultRevChecker_Create failed),
PKIX_ERRORENTRY(DEFAULTREVCHECKERINITIALIZEFAILED,pkix_DefaultRevChecker_Initialize failed),
PKIX_ERRORENTRY(DEPTHWOULDEXCEEDRESOURCELIMITS,Depth would exceed Resource Limits),
PKIX_ERRORENTRY(DERASCIITOTIMEFAILED,DER_AsciiToTime failed),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFAILED,DER_DecodeTimeChoice failed),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFORLASTUPDATEFAILED,DER_DecodeTimeChoice for lastUpdate failed),
PKIX_ERRORENTRY(DERDECODETIMECHOICEFORNEXTUPDATEFAILED,DER_DecodeTimeChoice for nextUpdate failed),
PKIX_ERRORENTRY(DERENCODETIMECHOICEFAILED,DER_EncodeTimeChoice failed),
PKIX_ERRORENTRY(DERGENERALIZEDDAYTOASCIIFAILED,DER_GeneralizedDayToAscii failed),
PKIX_ERRORENTRY(DERTIMETOUTCTIMEFAILED,DER_TimeToUTCTime failed),
PKIX_ERRORENTRY(DERUTCTIMETOASCIIFAILED,DER_UTCTimeToAscii failed),
PKIX_ERRORENTRY(DESTROYSPKIFAILED,pkix_pl_DestroySPKI failed),
PKIX_ERRORENTRY(DIRECTORYNAMECREATEFAILED,pkix_pl_DirectoryName_Create failed),
PKIX_ERRORENTRY(DUPLICATEIMMUTABLEFAILED,pkix_duplicateImmutable failed),
PKIX_ERRORENTRY(EKUCHECKERGETREQUIREDEKUFAILED,pkix_pl_EkuChecker_GetRequiredEku failed),
PKIX_ERRORENTRY(EKUCHECKERSTATECREATEFAILED,pkix_pl_EkuCheckerState_Create failed),
PKIX_ERRORENTRY(ENABLEREVOCATIONWITHOUTCERTSTORE,Enable Revocation without CertStore),
PKIX_ERRORENTRY(ERRORALLOCATINGMONITORLOCK,Error Allocating MonitorLock),
PKIX_ERRORENTRY(ERRORALLOCATINGPRMONITORLOCK,Error Allocating PR_MonitorLock),
PKIX_ERRORENTRY(ERRORALLOCATINGPRRWLOCK,Error Allocating PR_RWLock),
PKIX_ERRORENTRY(ERRORALLOCATINGRWLOCK,Error Allocating RWLock),
PKIX_ERRORENTRY(ERRORCREATINGCHILDSTRING,Error creating child string),
PKIX_ERRORENTRY(ERRORCREATINGFORMATSTRING,Error creating format string),
PKIX_ERRORENTRY(ERRORCREATINGINDENTSTRING,Error creating indent string),
PKIX_ERRORENTRY(ERRORCREATINGITEMSTRING,Error creating item string),
PKIX_ERRORENTRY(ERRORCREATINGLISTITEM,Error Creating List Item),
PKIX_ERRORENTRY(ERRORCREATINGSUBTREESTRING,Error creating subtree string),
PKIX_ERRORENTRY(ERRORCREATINGTABLELOCK,Error creating table lock),
PKIX_ERRORENTRY(ERRORFINDINGORPROCESSINGURI,Error finding or processing URI),
PKIX_ERRORENTRY(ERRORGETTINGCAUSESTRING,Error getting cause string),
PKIX_ERRORENTRY(ERRORGETTINGCLASSTABLEENTRY,Error getting class table entry),
PKIX_ERRORENTRY(ERRORGETTINGHASHCODE,Error getting hashcode),
PKIX_ERRORENTRY(ERRORGETTINGSECONDOBJECTTYPE,Error getting second object type),
PKIX_ERRORENTRY(ERRORINBYTEARRAYHASHCODE,Error in PKIX_PL_ByteArray_Hashcode),
PKIX_ERRORENTRY(ERRORINGETTINGDESTRUCTOR,Error in getting destructor),
PKIX_ERRORENTRY(ERRORINHASH,Error in pkix_hash),
PKIX_ERRORENTRY(ERRORINLISTHASHCODE,Error in PKIX_List_Hashcode),
PKIX_ERRORENTRY(ERRORINOBJECTDEFINEDESTROY,Error in object-defined destroy callback),
PKIX_ERRORENTRY(ERRORINOIDHASHCODE,Error in PKIX_PL_OID_Hashcode),
PKIX_ERRORENTRY(ERRORINRECURSIVEEQUALSCALL,Error in recursive equals call),
PKIX_ERRORENTRY(ERRORINSINGLEPOLICYNODETOSTRING,Error in pkix_SinglePolicyNode_ToString),
PKIX_ERRORENTRY(ERRORINSINGLEVERIFYNODETOSTRING,Error in pkix_SingleVerifyNode_ToString),
PKIX_ERRORENTRY(ERRORINSNPRINTF,Error in snprintf),
PKIX_ERRORENTRY(ERRORINSPRINTF,Error in PKIX_PL_Sprintf),
PKIX_ERRORENTRY(ERRORINSTRINGCREATE,Error in PKIX_PL_String_Create),
PKIX_ERRORENTRY(ERRORLOCKINGOBJECT,Error locking object),
PKIX_ERRORENTRY(ERRORTOSTRINGFAILED,PKIX_Error_ToString failed),
PKIX_ERRORENTRY(ERRORTRAVERSINGBUCKET,Error traversing bucket),
PKIX_ERRORENTRY(ERRORUNLOCKINGMUTEX,Error unlocking mutex),
PKIX_ERRORENTRY(ERRORUNLOCKINGOBJECT,Error unlocking object),
PKIX_ERRORENTRY(ESCASCIITOUTF16FAILED,pkix_EscASCII_to_UTF16 failed),
PKIX_ERRORENTRY(EXPIRATIONCHECKERINITIALIZEFAILED,pkix_ExpirationChecker_Initialize failed),
PKIX_ERRORENTRY(EXTENDEDKEYUSAGECHECKINGFAILED,Extended Key Usage Checking failed),
PKIX_ERRORENTRY(EXTENDEDKEYUSAGEUSEROBJECT,Extended Key Usage User Object),
PKIX_ERRORENTRY(EXTRACTPARAMETERSFAILED,pkix_ExtractParameters failed),
PKIX_ERRORENTRY(FAILEDINENCODINGABANDON,failed in encoding Abandon),
PKIX_ERRORENTRY(FAILEDINENCODINGBINDREQUEST,failed in encoding bindRequest),
PKIX_ERRORENTRY(FAILEDINENCODINGSEARCHREQUEST,failed in encoding searchRequest),
PKIX_ERRORENTRY(FAILEDINENCODINGUNBIND,failed in encoding unbind),
PKIX_ERRORENTRY(FAILUREHASHINGCERT,Failure hashing Cert),
PKIX_ERRORENTRY(FAILUREHASHINGERROR,Failure hashing Error),
PKIX_ERRORENTRY(FAILUREHASHINGLISTEXPECTEDPOLICYSET,Failure hashing PKIX_List expectedPolicySet),
PKIX_ERRORENTRY(FAILUREHASHINGLISTQUALIFIERSET,Failure hashing PKIX_List qualifierSet),
PKIX_ERRORENTRY(FAILUREHASHINGOIDVALIDPOLICY,Failure hashing PKIX_PL_OID validPolicy),
PKIX_ERRORENTRY(FANOUTEXCEEDSRESOURCELIMITS,Fanout exceeds Resource Limits),
PKIX_ERRORENTRY(FETCHINGCACHEDCRLFAILED,Fetching Cached CRLfailed),
PKIX_ERRORENTRY(FIRSTARGUMENTNOTANOID,FirstObject is not an OID),
PKIX_ERRORENTRY(FIRSTARGUMENTNOTBYTEARRAY,FirstObject is not a ByteArray),
PKIX_ERRORENTRY(FIRSTARGUMENTNOTCERTBASICCONSTRAINTSOBJECT,First argument is not a CertBasicConstraints Object),
PKIX_ERRORENTRY(FIRSTDOUBLEHEXMUSTNOTBE00,First DoubleHex MUST NOT be 00),
PKIX_ERRORENTRY(FIRSTFIELDMUSTBEBETWEEN02,First field must be between 0-2),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTANOCSPRESPONSE,FirstObject is not an OcspResponse),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTLDAPREQUEST,FirstObject is not a LdapRequest),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTLDAPRESPONSE,FirstObject is not a LdapResponse),
PKIX_ERRORENTRY(FIRSTOBJARGUMENTNOTOCSPREQUEST,FirstObject is not a OcspRequest),
PKIX_ERRORENTRY(FIRSTOBJECTARGUMENTNOTANX500NAME,FirstObject is not an X500Name),
PKIX_ERRORENTRY(FIRSTOBJECTNOTANERROROBJECT,FirstObject is not an Error object),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBIGINT,FirstObject not a BigInt),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBUILDPARAMS,FirstObject is not a BuildParams),
PKIX_ERRORENTRY(FIRSTOBJECTNOTBUILDRESULT,FirstObject is not a BuildResult),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERT,FirstObject is not a Cert),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTBASICCONSTRAINTS,FirstObject is not a CertBasicConstraints),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTNAMECONSTRAINTS,FirstObject is not a CertNameConstraints),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYINFO,FirstObject is not a CertPolicyInfo),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYMAP,FirstObject is not a CertPolicyMap),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCERTPOLICYQUALIFIER,FirstObject is not a CertPolicyQualifier),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCOMCRLSELPARAMS,FirstObject is not a ComCRLSelParams),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRL,FirstObject is not a CRL),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRLENTRY,FirstObject is not a CRLEntry),
PKIX_ERRORENTRY(FIRSTOBJECTNOTCRLSELECTOR,FirstObject is not a CRLSelector),
PKIX_ERRORENTRY(FIRSTOBJECTNOTDATE,FirstObject is not a Date),
PKIX_ERRORENTRY(FIRSTOBJECTNOTERROR,FirstObject is not an Error),
PKIX_ERRORENTRY(FIRSTOBJECTNOTGENERALNAME,FirstObject is not a GeneralName),
PKIX_ERRORENTRY(FIRSTOBJECTNOTINFOACCESS,FirstObject is not a InfoAccess),
PKIX_ERRORENTRY(FIRSTOBJECTNOTLIST,FirstObject is not a List),
PKIX_ERRORENTRY(FIRSTOBJECTNOTLOGGER,FirstObject is not a Logger),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPOLICYNODE,FirstObject is not a PolicyNode),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPROCESSINGPARAMS,FirstObject is not a ProcessingParams),
PKIX_ERRORENTRY(FIRSTOBJECTNOTPUBLICKEY,FirstObject is not a PublicKey),
PKIX_ERRORENTRY(FIRSTOBJECTNOTRESOURCELIMITS,FirstObject is not a ResourceLimits),
PKIX_ERRORENTRY(FIRSTOBJECTNOTSTRING,FirstObject is not a String),
PKIX_ERRORENTRY(FIRSTOBJECTNOTTRUSTANCHOR,FirstObject is not a TrustAnchor),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVALIDATEPARAMS,FirstObject is not a ValidateParams),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVALIDATERESULT,FirstObject is not a ValidateResult),
PKIX_ERRORENTRY(FIRSTOBJECTNOTVERIFYNODE,FirstObject is not a VerifyNode),
PKIX_ERRORENTRY(FIRSTPUBKEYTYPENULLKEY,firstPubKeyType is nullKey),
PKIX_ERRORENTRY(FORWARDBUILDERSTATEDUMPSTATEFAILED,pkix_ForwardBuilderState_DumpState failed),
PKIX_ERRORENTRY(FORWARDBUILDERSTATEISIOPENDINGFAILED,pkix_ForwardBuilderState_IsIOPending failed),
PKIX_ERRORENTRY(FORWARDBUILDSTATECREATEFAILED,pkix_ForwardBuildState_Create failed),
PKIX_ERRORENTRY(FREEFAILED,PKIX_PL_Free failed),
PKIX_ERRORENTRY(GENERALNAMECREATEFAILED,pkix_pl_GeneralName_Create failed),
PKIX_ERRORENTRY(GENERALNAMEGETNSSGENERALNAMEFAILED,pkix_pl_GeneralName_GetNssGeneralName failed),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGDOUBLESLASH,GeneralName string missing double slash),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGLOCATIONTYPE,GeneralName string missing location type),
PKIX_ERRORENTRY(GENERALNAMESTRINGMISSINGSERVERSITE,GeneralName string missing server-site),
PKIX_ERRORENTRY(GENERALNAMETOSTRINGFAILED,pkix_pl_GeneralName_ToString failed),
PKIX_ERRORENTRY(GENERALNAMETOSTRINGHELPERFAILED,pkix_pl_GeneralName_ToString_Helper failed),
PKIX_ERRORENTRY(GENERICCLIENTNOTANLDAPDEFAULTCLIENT,genericClient is not an LdapDefaultClient),
PKIX_ERRORENTRY(GETATTRIBUTESCALLEDFORNONENTRYMESSAGE,GetAttributes called for non-Entry message),
PKIX_ERRORENTRY(GETCERTSFAILED,getCerts failed),
PKIX_ERRORENTRY(GETCRITICALEXTENSIONOIDSFAILED,pkix_GetCriticalExtensionOIDs failed),
PKIX_ERRORENTRY(GETCRLSFAILED,getCrls failed),
PKIX_ERRORENTRY(GETOIDTOKENFAILED,pkix_pl_getOIDToken failed),
PKIX_ERRORENTRY(GETRESULTCODECALLEDFORNONRESULTMESSAGE,GetResultCode called for non-Result message),
PKIX_ERRORENTRY(HASHFAILED,pkix_hash failed),
PKIX_ERRORENTRY(HASHTABLEADDFAILED,PKIX_PL_HashTable_Add failed),
PKIX_ERRORENTRY(HASHTABLECREATEFAILED,PKIX_PL_HashTable_Create failed),
PKIX_ERRORENTRY(HASHTABLELOOKUPFAILED,PKIX_PL_HashTable_Lookup failed),
PKIX_ERRORENTRY(HASHTABLEREMOVEFAILED,PKIX_PL_HashTable_Remove failed),
PKIX_ERRORENTRY(HELPERBYTES2ASCIIFAILED,pkix_pl_helperBytes2Ascii failed),
PKIX_ERRORENTRY(HELPERBYTES2ASCIINUMTOKENSZERO,pkix_pl_helperBytes2Ascii: numTokens is zero),
PKIX_ERRORENTRY(HTTPCERTSTORECREATEREQUESTSESSIONFAILED,pkix_pl_HttpCertStore_CreateRequestSession failed),
PKIX_ERRORENTRY(HTTPCERTSTORECREATEWITHASCIINAMEFAILED,PKIX_PL_HttpCertStore_CreateWithAsciiName failed),
PKIX_ERRORENTRY(HTTPCERTSTOREDECODECERTPACKAGEFAILED,pkix_pl_HttpCertStore_DecodeCertPackage failed),
PKIX_ERRORENTRY(HTTPCERTSTOREFINDSOCKETCONNECTIONFAILED,pkix_HttpCertStore_FindSocketConnection failed),
PKIX_ERRORENTRY(HTTPCERTSTOREPROCESSCERTRESPONSEFAILED,pkix_pl_HttpCertStore_ProcessCertResponse failed),
PKIX_ERRORENTRY(HTTPCERTSTOREPROCESSCRLRESPONSEFAILED,pkix_pl_HttpCertStore_ProcessCrlResponse failed),
PKIX_ERRORENTRY(HTTPCLIENTCREATESESSIONFAILED,HttpClient->CreateSession failed),
PKIX_ERRORENTRY(HTTPCLIENTININVALIDSTATE,HttpClient in invalid state),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTCONNECTCONTINUEFAILED,pkix_pl_HttpDefaultClient_ConnectContinue failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTCREATEFAILED,pkix_pl_HttpDefaultClient_Create failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTDISPATCHFAILED,pkix_pl_HttpDefaultClient_Dispatch failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTHDRCHECKCOMPLETEFAILED,pkix_pl_HttpDefaultClient_HdrCheckComplete failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTINILLEGALSTATE,HttpDefaultClient in illegal state),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVBODYCONTINUEFAILED,pkix_pl_HttpDefaultClient_RecvBodyContinue failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVBODYFAILED,pkix_pl_HttpDefaultClient_RecvBody failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVHDRCONTINUEFAILED,pkix_pl_HttpDefaultClient_RecvHdrContinue failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTRECVHDRFAILED,pkix_pl_HttpDefaultClient_RecvHdr failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTSENDCONTINUEFAILED,pkix_pl_HttpDefaultClient_SendContinue failed),
PKIX_ERRORENTRY(HTTPDEFAULTCLIENTSENDFAILED,pkix_pl_HttpDefaultClient_Send failed),
PKIX_ERRORENTRY(HTTPSERVERERROR,HTTP Server Error),
PKIX_ERRORENTRY(ILLEGALCHARACTERINESCAPEDASCII,Illegal character in Escaped ASCII String),
PKIX_ERRORENTRY(ILLEGALCHARACTERINOID,Illegal character in OID),
PKIX_ERRORENTRY(ILLEGALDOTINOID,Illegal period in OID),
PKIX_ERRORENTRY(ILLEGALSURROGATEPAIR,Illegal surrogate pair in EscapedASCII),
PKIX_ERRORENTRY(ILLEGALUNICODECHARACTER,Illegal Unicode character in EscapedASCII),
PKIX_ERRORENTRY(ILLEGALUSEOFAMP,Illegal use of ampersand character),
PKIX_ERRORENTRY(IMPOSSIBLECRITERIONFORCRLQUERY,Impossible criterion for Crl Query),
PKIX_ERRORENTRY(INDEXOUTOFBOUNDS,Index out of bounds),
PKIX_ERRORENTRY(INESCAPEDASCII,in EscapedASCII),
PKIX_ERRORENTRY(INFOACCESSCREATEFAILED,pkix_pl_InfoAccess_Create failed),
PKIX_ERRORENTRY(INFOACCESSCREATELISTFAILED,pkix_pl_InfoAccess_CreateList failed),
PKIX_ERRORENTRY(INFOACCESSGETLOCATIONFAILED,PKIX_PL_InfoAccess_GetLocation failed),
PKIX_ERRORENTRY(INFOACCESSGETLOCATIONTYPEFAILED,PKIX_PL_InfoAccess_GetLocationType failed),
PKIX_ERRORENTRY(INFOACCESSPARSELOCATIONFAILED,pkix_pl_InfoAccess_ParseLocation failed),
PKIX_ERRORENTRY(INFOACCESSPARSETOKENSFAILED,pkix_pl_InfoAccess_ParseTokens failed),
PKIX_ERRORENTRY(INITIALIZECHECKERSFAILED,pkix_InitializeCheckers failed),
PKIX_ERRORENTRY(INITIALIZEFAILED,PKIX_PL_Initialize failed),
PKIX_ERRORENTRY(INPUTLISTMUSTBEHEADER,Input List must be header),
PKIX_ERRORENTRY(INPUTLISTSMUSTBELISTHEADERS,Input Lists must be list headers),
PKIX_ERRORENTRY(INSUFFICIENTCRITERIAFORCERTQUERY,Insufficient criteria for Cert query),
PKIX_ERRORENTRY(INSUFFICIENTCRITERIAFORCRLQUERY,Insufficient criteria for Crl Query),
PKIX_ERRORENTRY(INTRUSTEDCERT,in Trusted Cert),
PKIX_ERRORENTRY(INVALIDCHARACTERINBIGINT,Invalid character in BigInt),
PKIX_ERRORENTRY(INVALIDDERENCODINGFOROID,Invalid DER-encoding for OID),
PKIX_ERRORENTRY(INVALIDENCODINGOIDTOKENVALUETOOBIG,Invalid encoding: OID token value too big),
PKIX_ERRORENTRY(INVALIDPOLICYMAPPINGINCLUDESANYPOLICY,Invalid policyMapping includes anyPolicy),
PKIX_ERRORENTRY(INVALIDSIGNINGCERTINOCSPRESPONSE,Invalid signing Cert in OCSP response),
PKIX_ERRORENTRY(INVALIDSTATUS,INVALID STATUS),
PKIX_ERRORENTRY(INVALIDSTORETYPEFORSETTINGCONFIGDIR,Invalid Store type for Setting ConfigDir),
PKIX_ERRORENTRY(IPADDRBYTES2ASCIIDATALENGTHZERO,pkix_pl_ipAddrBytes2Ascii: data length is zero),
PKIX_ERRORENTRY(IPADDRBYTES2ASCIIFAILED,pkix_pl_ipAddrBytes2Ascii failed),
PKIX_ERRORENTRY(ISCERTSELFISSUEDFAILED,pkix_IsCertSelfIssued failed),
PKIX_ERRORENTRY(ISCERTSELFISSUEFAILED,pkix_IsCertSelfIssue failed),
PKIX_ERRORENTRY(KEYUSAGEKEYCERTSIGNBITNOTON,Validation failed: KeyUsage KeyCertSign bit is not on),
PKIX_ERRORENTRY(KEYUSAGEKEYCRLSIGNBITNOTON,Validation failed: KeyUsage CRLSign bit is not on),
PKIX_ERRORENTRY(LDAPCERTSTOREBUILDCERTLISTFAILED,pkix_pl_LdapCertStore_BuildCertList failed),
PKIX_ERRORENTRY(LDAPCERTSTOREBUILDCRLLISTFAILED,pkix_pl_LdapCertStore_BuildCrlList failed),
PKIX_ERRORENTRY(LDAPCERTSTOREDECODECROSSCERTPAIRFAILED,pkix_pl_LdapCertStore_DecodeCrossCertPair failed),
PKIX_ERRORENTRY(LDAPCERTSTOREDESTROYAVALISTFAILED,pkix_pl_LdapCertStore_DestroyAVAList failed),
PKIX_ERRORENTRY(LDAPCERTSTOREINILLEGALSTATE,LDAP CertStore in illegal state),
PKIX_ERRORENTRY(LDAPCERTSTOREMAKENAMEAVALISTFAILED,pkix_pl_LdapCertStore_MakeNameAVAList failed),
PKIX_ERRORENTRY(LDAPCLIENTINITIATEREQUESTFAILED,PKIX_PL_LdapClient_InitiateRequest failed),
PKIX_ERRORENTRY(LDAPCLIENTRESUMEREQUESTFAILED,PKIX_PL_LdapClient_ResumeRequest failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTABANDONCONTINUEFAILED,pkix_pl_LdapDefaultClient_AbandonContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDCONTINUEFAILED,pkix_pl_LdapDefaultClient_BindContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDFAILED,pkix_pl_LdapDefaultClient_Bind failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDRESPONSECONTINUEFAILED,pkix_pl_LdapDefaultClient_BindResponseContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_BindResponse failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCONNECTCONTINUEFAILED,pkix_pl_LdapDefaultClient_ConnectContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCREATEBYNAMEFAILED,PKIX_PL_LdapDefaultClient_CreateByName failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTCREATEHELPERFAILED,pkix_pl_LdapDefaultClient_CreateHelper failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTDECODEBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_DecodeBindResponse failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTDISPATCHFAILED,pkix_pl_LdapDefaultClient_Dispatch failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTINILLEGALSTATE,LDAP DefaultClient in illegal state),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEABANDONFAILED,pkix_pl_LdapDefaultClient_MakeAbandon failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEANDFILTERFAILED,pkix_pl_LdapDefaultClient_MakeAndFilter failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEBINDFAILED,pkix_pl_LdapDefaultClient_MakeBind failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTMAKEUNBINDFAILED,pkix_pl_LdapDefaultClient_MakeUnbind failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVCHECKCOMPLETEFAILED,pkix_pl_LdapDefaultClient_RecvCheckComplete failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVCONTINUEFAILED,pkix_pl_LdapDefaultClient_RecvContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVFAILED,pkix_pl_LdapDefaultClient_Recv failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVINITIALFAILED,pkix_pl_LdapDefaultClient_RecvInitial failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTRECVNONINITIALFAILED,pkix_pl_LdapDefaultClient_RecvNonInitial failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTSENDCONTINUEFAILED,pkix_pl_LdapDefaultClient_SendContinue failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTSENDFAILED,pkix_pl_LdapDefaultClient_Send failed),
PKIX_ERRORENTRY(LDAPDEFAULTCLIENTVERIFYBINDRESPONSEFAILED,pkix_pl_LdapDefaultClient_VerifyBindResponse failed),
PKIX_ERRORENTRY(LDAPREQUESTATTRSTRINGTOBITFAILED,pkix_pl_LdapRequest_AttrStringToBit failed),
PKIX_ERRORENTRY(LDAPREQUESTATTRTYPETOBITFAILED,pkix_pl_LdapRequest_AttrTypeToBit failed),
PKIX_ERRORENTRY(LDAPREQUESTCREATEFAILED,pkix_pl_LdapRequest_Create failed),
PKIX_ERRORENTRY(LDAPREQUESTENCODEATTRSFAILED,pkix_pl_LdapRequest_EncodeAttrs failed),
PKIX_ERRORENTRY(LDAPREQUESTGETENCODEDFAILED,pkix_pl_LdapRequest_GetEncoded failed),
PKIX_ERRORENTRY(LDAPRESPONSEAPPENDFAILED,pkix_pl_LdapResponse_Append failed),
PKIX_ERRORENTRY(LDAPRESPONSECREATEFAILED,pkix_pl_LdapResponseCreate failed),
PKIX_ERRORENTRY(LDAPRESPONSEDECODEFAILED,pkix_pl_LDAPResponse_Decode failed),
PKIX_ERRORENTRY(LDAPRESPONSEGETCAPACITYFAILED,pkix_pl_LdapResponse_GetCapacity failed),
PKIX_ERRORENTRY(LDAPRESPONSEGETMESSAGEFAILED,pkix_pl_LdapResponse_GetMessage failed),
PKIX_ERRORENTRY(LDAPRESPONSEGETMESSAGETYPEFAILED,pkix_pl_LdapResponse_GetMessageType failed),
PKIX_ERRORENTRY(LDAPRESPONSEGETRESULTCODEFAILED,pkix_pl_LdapResponse_GetResultCode failed),
PKIX_ERRORENTRY(LDAPRESPONSEISCOMPLETEFAILED,pkix_pl_LdapResponse_IsComplete failed),
PKIX_ERRORENTRY(LISTAPPENDFAILED,PKIX_List_Append failed),
PKIX_ERRORENTRY(LISTAPPENDITEMFAILED,PKIX_List_AppendItem failed),
PKIX_ERRORENTRY(LISTAPPENDLISTFAILED,pkix_List_AppendList failed),
PKIX_ERRORENTRY(LISTAPPENDUNIQUEFAILED,pkix_List_AppendUnique failed),
PKIX_ERRORENTRY(LISTBUBBLESORTFAILED,pkix_List_BubbleSort failed),
PKIX_ERRORENTRY(LISTCONTAINSFAILED,pkix_List_Contains failed),
PKIX_ERRORENTRY(LISTCREATEFAILED,PKIX_List_Create failed),
PKIX_ERRORENTRY(LISTCREATEINTERNALFAILED,pkix_List_Create_Internal failed),
PKIX_ERRORENTRY(LISTDELETEITEMFAILED,PKIX_List_DeleteItem failed),
PKIX_ERRORENTRY(LISTDUPLICATEFAILED,pkix_List_Duplicate failed),
PKIX_ERRORENTRY(LISTEQUALSFAILED,PKIX_List_Equals failed),
PKIX_ERRORENTRY(LISTGETELEMENTFAILED,pkix_List_GetElement failed),
PKIX_ERRORENTRY(LISTGETITEMFAILED,PKIX_List_GetItem failed),
PKIX_ERRORENTRY(LISTGETLENGTHFAILED,PKIX_List_GetLength failed),
PKIX_ERRORENTRY(LISTHASHCODEFAILED,pkix_List_Hashcode failed),
PKIX_ERRORENTRY(LISTINSERTITEMFAILED,PKIX_List_InsertItem failed),
PKIX_ERRORENTRY(LISTISEMPTYFAILED,PKIX_List_IsEmpty failed),
PKIX_ERRORENTRY(LISTQUICKSORTFAILED,pkix_List_QuickSort failed),
PKIX_ERRORENTRY(LISTREMOVEFAILED,pkix_List_Remove failed),
PKIX_ERRORENTRY(LISTREMOVEITEMSFAILED,pkix_List_RemoveItems failed),
PKIX_ERRORENTRY(LISTREVERSELISTFAILED,PKIX_List_ReverseList failed),
PKIX_ERRORENTRY(LISTSETIMMUTABLEFAILED,PKIX_List_SetImmutable failed),
PKIX_ERRORENTRY(LISTSETITEMFAILED,PKIX_List_SetItem failed),
PKIX_ERRORENTRY(LISTTOSTRINGFAILED,pkix_List_ToString failed),
PKIX_ERRORENTRY(LISTTOSTRINGHELPERFAILED,pkix_List_ToString Helper failed),
PKIX_ERRORENTRY(LOCATIONSTRINGNOTPROPERLYTERMINATED,Location string not properly terminated),
PKIX_ERRORENTRY(LOCKHASNONZEROREADCOUNT,Lock has non-zero read count),
PKIX_ERRORENTRY(LOCKOBJECTFAILED,pkix_LockObject failed),
PKIX_ERRORENTRY(LOGGERDUPLICATEFAILED,pkix_Logger_Duplicate failed),
PKIX_ERRORENTRY(LOGGINGLEVELEXCEEDSMAXIMUM,Logging Level exceeds Maximum),
PKIX_ERRORENTRY(LOOPDISCOVEREDDUPCERTSNOTALLOWED,Loop discovered: duplicate certificates not allowed),
PKIX_ERRORENTRY(MAJORVERSIONSDONTMATCH,Major versions do not match),
PKIX_ERRORENTRY(MALLOCFAILED,PKIX_PL_Malloc failed),
PKIX_ERRORENTRY(MEMCPYFAILED,PKIX_PL_Memcpy failed),
PKIX_ERRORENTRY(MINORVERSIONNOTBETWEENDESIREDMINANDMAX,Minor version does not fall between desired minimum and maximum),
PKIX_ERRORENTRY(MISSINGDSAPARAMETERS,Missing DSA parameters in Trusted Cert),
PKIX_ERRORENTRY(MONITORLOCKCREATEFAILED,PKIX_PL_MonitorLock_Create failed),
PKIX_ERRORENTRY(MONITORLOCKENTERFAILED,PKIX_PL_MonitorLock_Enter failed),
PKIX_ERRORENTRY(MONITORLOCKEXITFAILED,PKIX_PL_MonitorLock_Exit failed),
PKIX_ERRORENTRY(MUTEXLOCKFAILED,PKIX_PL_Mutex_Lock failed),
PKIX_ERRORENTRY(NAMECHAININGCHECKERINITIALIZEFAILED,pkix_NameChainingChecker_Initialize failed),
PKIX_ERRORENTRY(NAMECHAININGCHECKFAILED,Name Chaining Check failed),
PKIX_ERRORENTRY(NAMECOMPONENTWITHNOEQ,Name Component with no equal sign),
PKIX_ERRORENTRY(NAMECONSTRAINTSCHECKERINITIALIZEFAILED,pkix_NameConstraintsChecker_Initialize failed),
PKIX_ERRORENTRY(NAMECONSTRAINTSCHECKERSTATECREATEFAILED,pkix_NameConstraintsCheckerState_Create failed),
PKIX_ERRORENTRY(NAMETYPENOTSUPPORTED,name type not supported),
PKIX_ERRORENTRY(NOCONTENTTYPEINHTTPRESPONSE,No content type in Http Response),
PKIX_ERRORENTRY(NODESMISSINGFROMCHAIN,Nodes missing from chain),
PKIX_ERRORENTRY(NOREGISTEREDHTTPCLIENT,No registered Http Client),
PKIX_ERRORENTRY(NORESPONSEDATAINHTTPRESPONSE,No responseData in Http Response),
PKIX_ERRORENTRY(NOTARGETCERTSUPPLIED,No target cert supplied),
PKIX_ERRORENTRY(NOTDERPACKAGE,Not a DER package),
PKIX_ERRORENTRY(NOTENOUGHNAMECOMPONENTSINGENERALNAME,Not enough name components in GeneralName),
PKIX_ERRORENTRY(NSSCONTEXTCREATEFAILED,PKIX_PL_NssContext_Create failed),
PKIX_ERRORENTRY(NSSCONTEXTGETWINCXFAILED,pkix_pl_NssContext_GetWincx failed),
PKIX_ERRORENTRY(NULLARGUMENT,Null argument),
PKIX_ERRORENTRY(NUMBUCKETSEQUALSZERO,NumBuckets equals zero),
PKIX_ERRORENTRY(OBJECTALLOCFAILED,PKIX_PL_Object_Alloc failed),
PKIX_ERRORENTRY(OBJECTARGUMENTNOTPOLICYMAP,object argument is not a PolicyMap),
PKIX_ERRORENTRY(OBJECTCOMPARATORFAILED,PKIX_PL_Object_Comparator failed),
PKIX_ERRORENTRY(OBJECTDEFINED,object-defined ),
PKIX_ERRORENTRY(OBJECTDUPLICATECERTFAILED,PKIX_PL_Object_Duplicate Cert failed),
PKIX_ERRORENTRY(OBJECTDUPLICATECONTEXTFAILED,PKIX_PL_Object_Duplicate Context failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEDATEFAILED,PKIX_PL_Object_Duplicate Date failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEFAILED,PKIX_PL_Object_Duplicate failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEISSUERNAMESFAILED,PKIX_PL_Object_Duplicate IssuerNames failed),
PKIX_ERRORENTRY(OBJECTDUPLICATELISTFAILED,PKIX_PL_Object_Duplicate List failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEMAXCRLNUMBERFAILED,PKIX_PL_Object_Duplicate maxCRLNumber failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEMINCRLNUMBERFAILED,PKIX_PL_Object_Duplicate minCRLNumber failed),
PKIX_ERRORENTRY(OBJECTDUPLICATEPARAMSFAILED,PKIX_PL_Object_Duplicate Params failed),
PKIX_ERRORENTRY(OBJECTEQUALSFAILED,PKIX_PL_Object_Equals failed),
PKIX_ERRORENTRY(OBJECTEQUALSFAILEDONCHILDREN,PKIX_PL_Object_Equals failed on children),
PKIX_ERRORENTRY(OBJECTEQUALSFAILEDONEXPECTEDPOLICYSETS,PKIX_PL_Object_Equals failed on expectedPolicySets),
PKIX_ERRORENTRY(OBJECTGETTYPEFAILED,PKIX_PL_Object_GetType failed),
PKIX_ERRORENTRY(OBJECTHASHCODEFAILED,PKIX_PL_Object_Hashcode failed),
PKIX_ERRORENTRY(OBJECTINVALIDATECACHEFAILED,PKIX_PL_Object_InvalidateCache failed),
PKIX_ERRORENTRY(OBJECTLOCKFAILED,PKIX_PL_Object_Lock failed),
PKIX_ERRORENTRY(OBJECTNOTAIAMGR,Object is not a AIAMgr),
PKIX_ERRORENTRY(OBJECTNOTANEKUCHECKERSTATE,Object is not an EKU Checker State),
PKIX_ERRORENTRY(OBJECTNOTANERROR,Object is not an Error),
PKIX_ERRORENTRY(OBJECTNOTANHTTPCERTSTORECONTEXT,Object is not an HttpCertStoreContext),
PKIX_ERRORENTRY(OBJECTNOTANHTTPDEFAULTCLIENT,Object is not an HttpDefaultClient),
PKIX_ERRORENTRY(OBJECTNOTANINFOACCESS,Object is not an InfoAccess),
PKIX_ERRORENTRY(OBJECTNOTANLDAPDEFAULTCLIENT,Object is not an LdapDefaultClient),
PKIX_ERRORENTRY(OBJECTNOTANOCSPRESPONSE,Object is not an OcspResponse),
PKIX_ERRORENTRY(OBJECTNOTANOID,Object is not an OID),
PKIX_ERRORENTRY(OBJECTNOTANSOCKET,Object is not an Socket),
PKIX_ERRORENTRY(OBJECTNOTANX500NAME,Object is not an X500Name),
PKIX_ERRORENTRY(OBJECTNOTBASICCONSTRAINTSCHECKERSTATE,Object is not a basic constraints checker state),
PKIX_ERRORENTRY(OBJECTNOTBIGINT,Object is not a BigInt),
PKIX_ERRORENTRY(OBJECTNOTBUILDPARAMS,Object is not a BuildParams),
PKIX_ERRORENTRY(OBJECTNOTBUILDRESULT,Object is not a BuildResult),
PKIX_ERRORENTRY(OBJECTNOTBYTEARRAY,Object is not a bytearray),
PKIX_ERRORENTRY(OBJECTNOTCERT,Object is not a Cert),
PKIX_ERRORENTRY(OBJECTNOTCERTBASICCONSTRAINTS,Object is not a CertBasicConstraints),
PKIX_ERRORENTRY(OBJECTNOTCERTCHAINCHECKER,Object is not a cert chain checker),
PKIX_ERRORENTRY(OBJECTNOTCERTNAMECONSTRAINTS,Object is not a CertNameConstraints),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYINFO,Object is not a CertPolicyInfo),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYMAP,Object is not a CertPolicyMap),
PKIX_ERRORENTRY(OBJECTNOTCERTPOLICYQUALIFIER,Object is not a CertPolicyQualifier),
PKIX_ERRORENTRY(OBJECTNOTCERTSELECTOR,Object is not a cert selector),
PKIX_ERRORENTRY(OBJECTNOTCERTSTORE,Object is not a CertStore),
PKIX_ERRORENTRY(OBJECTNOTCOLLECTIONCERTSTORECONTEXT,Object is not a CollectionCertStoreContext),
PKIX_ERRORENTRY(OBJECTNOTCOMCERTSELPARAMS,Object is not a comCertSelParams),
PKIX_ERRORENTRY(OBJECTNOTCOMCRLSELPARAMS,Object is not a ComCRLSelParams),
PKIX_ERRORENTRY(OBJECTNOTCRL,Object is not a CRL),
PKIX_ERRORENTRY(OBJECTNOTCRLENTRY,Object is not a CRLEntry),
PKIX_ERRORENTRY(OBJECTNOTCRLSELECTOR,Object is not a CRLSelector),
PKIX_ERRORENTRY(OBJECTNOTDATE,Object is not a Date),
PKIX_ERRORENTRY(OBJECTNOTDEFAULTCRLCHECKERSTATE,Object is not a DefaultCRLCheckerState),
PKIX_ERRORENTRY(OBJECTNOTDEFAULTREVOCATIONCHECKER,Object is not a DefaultRevocationChecker),
PKIX_ERRORENTRY(OBJECTNOTFORWARDBUILDERSTATE,Object is not a PKIX_ForwardBuilderState),
PKIX_ERRORENTRY(OBJECTNOTGENERALNAME,Object is not a GeneralName),
PKIX_ERRORENTRY(OBJECTNOTHASHTABLE,Object is not a hashtable),
PKIX_ERRORENTRY(OBJECTNOTINFOACCESS,Object is not a InfoAccess),
PKIX_ERRORENTRY(OBJECTNOTLDAPREQUEST,Object is not a LdapRequest),
PKIX_ERRORENTRY(OBJECTNOTLDAPRESPONSE,Object is not a LdapResponse),
PKIX_ERRORENTRY(OBJECTNOTLIST,Object is not a list),
PKIX_ERRORENTRY(OBJECTNOTLOGGER,Object is not a Logger),
PKIX_ERRORENTRY(OBJECTNOTMONITORLOCK,Object is not a MonitorLock),
PKIX_ERRORENTRY(OBJECTNOTMUTEX,Object is not a Mutex),
PKIX_ERRORENTRY(OBJECTNOTNAMECONSTRAINTSCHECKERSTATE,Object is not a name constraints checker state),
PKIX_ERRORENTRY(OBJECTNOTOCSPCHECKER,Object is not an OCSPChecker),
PKIX_ERRORENTRY(OBJECTNOTOCSPREQUEST,Object is not an OcspRequest),
PKIX_ERRORENTRY(OBJECTNOTPOLICYCHECKERSTATE,Object is not a PKIX_PolicyCheckerState),
PKIX_ERRORENTRY(OBJECTNOTPOLICYNODE,Object is not a PolicyNode),
PKIX_ERRORENTRY(OBJECTNOTPROCESSINGPARAMS,Object is not a ProcessingParams),
PKIX_ERRORENTRY(OBJECTNOTPUBLICKEY,Object is not a PublicKey),
PKIX_ERRORENTRY(OBJECTNOTRESOURCELIMITS,Object is not a ResourceLimits),
PKIX_ERRORENTRY(OBJECTNOTREVOCATIONCHECKER,Object is not a revocation checker),
PKIX_ERRORENTRY(OBJECTNOTRWLOCK,Object is not a RWLock),
PKIX_ERRORENTRY(OBJECTNOTSIGNATURECHECKERSTATE,Object is not a signature checker state),
PKIX_ERRORENTRY(OBJECTNOTSOCKET,Object is not a Socket),
PKIX_ERRORENTRY(OBJECTNOTSTRING,Object is not a string),
PKIX_ERRORENTRY(OBJECTNOTTARGETCERTCHECKERSTATE,Object is not a target cert checker state),
PKIX_ERRORENTRY(OBJECTNOTTRUSTANCHOR,Object is not a trustAnchor),
PKIX_ERRORENTRY(OBJECTNOTVALIDATEPARAMS,Object is not a ValidateParams),
PKIX_ERRORENTRY(OBJECTNOTVALIDATERESULT,Object is not a ValidateResult),
PKIX_ERRORENTRY(OBJECTNOTVERIFYNODE,Object is not a VerifyNode),
PKIX_ERRORENTRY(OBJECTREGISTERTYPEFAILED,PkIX_PL_Object_RegisterType failed),
PKIX_ERRORENTRY(OBJECTRETRIEVEEQUALSCALLBACKFAILED,pkix_pl_Object_RetrieveEqualsCallback failed),
PKIX_ERRORENTRY(OBJECTSPECIFICFUNCTIONFAILED,object-specific function failed),
PKIX_ERRORENTRY(OBJECTSTILLREFERENCED,Object is still referenced),
PKIX_ERRORENTRY(OBJECTTOSTRINGFAILED,PKIX_PL_Object_ToString failed),
PKIX_ERRORENTRY(OBJECTTYPESDONOTMATCH,Object types do not match),
PKIX_ERRORENTRY(OBJECTWITHNONPOSITIVEREFERENCES,Object with non-positive references),
PKIX_ERRORENTRY(OCSPCHECKERCREATEFAILED,PKIX_OcspChecker_Create failed),
PKIX_ERRORENTRY(OCSPREQUESTCREATEFAILED,PKIX_PL_OcspRequest_Create failed),
PKIX_ERRORENTRY(OCSPREQUESTGETCERTIDFAILED,pkix_pl_OcspRequest_GetCertID failed),
PKIX_ERRORENTRY(OCSPREQUESTGETENCODEDFAILED,pkix_pl_OcspRequest_GetEncoded failed),
PKIX_ERRORENTRY(OCSPREQUESTGETLOCATIONFAILED,pkix_pl_OcspRequest_GetLocation failed),
PKIX_ERRORENTRY(OCSPRESPONSECREATEFAILED,pkix_pl_OcspResponse_Create failed),
PKIX_ERRORENTRY(OCSPRESPONSEDECODEFAILED,pkix_pl_OcspResponse_Decode failed),
PKIX_ERRORENTRY(OCSPRESPONSEGETSTATUSFORCERTFAILED,pkix_pl_OcspResponse_GetStatusForCert failed),
PKIX_ERRORENTRY(OCSPRESPONSEGETSTATUSRETURNEDANERROR,pkix_pl_OcspResponse_GetStatus returned an error),
PKIX_ERRORENTRY(OCSPRESPONSESAYSCERTREVOKED,OCSP response says Cert revoked),
PKIX_ERRORENTRY(OCSPRESPONSEVERIFYSIGNATUREFAILED,pkix_pl_OcspResponse_VerifySignature failed),
PKIX_ERRORENTRY(OCSPSERVERERROR,OCSP Server Error),
PKIX_ERRORENTRY(OIDBYTES2ASCIIDATALENGTHZERO,pkix_pl_oidBytes2Ascii: data length is zero),
PKIX_ERRORENTRY(OIDBYTES2ASCIIFAILED,pkix_pl_oidBytes2Ascii failed),
PKIX_ERRORENTRY(OIDBYTESLENGTH0,Oid bytes length is 0),
PKIX_ERRORENTRY(OIDCOMPARATORFAILED,pkix_pl_OID_Comparator failed),
PKIX_ERRORENTRY(OIDCOMPONENTTOOBIG,Overflow error: OID component > 2^32),
PKIX_ERRORENTRY(OIDCREATEFAILED,PKIX_PL_OID_Create failed),
PKIX_ERRORENTRY(OIDEQUALFAILED,PKIX_PL_OID_Equal failed),
PKIX_ERRORENTRY(OIDEQUALSFAILED,PKIX_PL_OID_Equals failed),
PKIX_ERRORENTRY(OIDGETNEXTTOKENFAILED,pkix_pl_OID_GetNextToken failed),
PKIX_ERRORENTRY(OIDHASHCODEFAILED,PKIX_PL_OID_Hashcode failed),
PKIX_ERRORENTRY(OIDLENGTHTOOSHORT,OID length too short),
PKIX_ERRORENTRY(OIDNEEDS2ORMOREFIELDS,OID needs 2 or more fields),
PKIX_ERRORENTRY(OIDTOSTRINGFAILED,PKIX_PL_OID_ToString failed),
PKIX_ERRORENTRY(OTHERNAMECREATEFAILED,pkix_pl_OtherName_Create failed),
PKIX_ERRORENTRY(OUTOFMEMORY,Out of Memory),
PKIX_ERRORENTRY(PK11CERTSTORECERTQUERYFAILED,pkix_pl_Pk11CertStore_CertQuery failed),
PKIX_ERRORENTRY(PK11CERTSTORECREATEFAILED,PKIX_PL_Pk11CertStore_Create failed),
PKIX_ERRORENTRY(PK11CERTSTORECRLQUERYFAILED,pkix_pl_Pk11CertStore_CrlQuery failed),
PKIX_ERRORENTRY(POLICYCHECKERCALCULATEINTERSECTIONFAILED,pkix_PolicyChecker_CalculateIntersection failed),
PKIX_ERRORENTRY(POLICYCHECKERCHECKANYFAILED,pkix_PolicyChecker_CheckAny failed),
PKIX_ERRORENTRY(POLICYCHECKERCHECKPOLICYRECURSIVEFAILED,pkix_PolicyChecker_CheckPolicyRecursive failed),
PKIX_ERRORENTRY(POLICYCHECKERERROR,PolicyChecker Error),
PKIX_ERRORENTRY(POLICYCHECKERINITIALIZEFAILED,pkix_PolicyChecker_Initialize failed),
PKIX_ERRORENTRY(POLICYCHECKERMAKEMUTABLECOPYFAILED,pkix_PolicyChecker_MakeMutableCopy failed),
PKIX_ERRORENTRY(POLICYCHECKERMAKESINGLETONFAILED,pkix_PolicyChecker_MakeSingleton failed),
PKIX_ERRORENTRY(POLICYCHECKERMAPCONTAINSFAILED,pkix_PolicyChecker_MapContains failed),
PKIX_ERRORENTRY(POLICYCHECKERMAPGETMAPPEDPOLICIESFAILED,pkix_PolicyChecker_MapGetMappedPolicies failed),
PKIX_ERRORENTRY(POLICYCHECKERMAPGETSUBJECTDOMAINPOLICIESFAILED,pkix_PolicyChecker_MapGetSubjectDomainPolicies failed),
PKIX_ERRORENTRY(POLICYCHECKERSPAWNFAILED,pkix_PolicyChecker_Spawn failed),
PKIX_ERRORENTRY(POLICYCHECKERSTATECREATEFAILED,PKIX_PolicyCheckerState_Create failed),
PKIX_ERRORENTRY(POLICYNODEADDTOPARENTFAILED,pkix_PolicyNode_AddToParent failed),
PKIX_ERRORENTRY(POLICYNODECREATEFAILED,pkix_PolicyNode_Create failed),
PKIX_ERRORENTRY(POLICYNODEDUPLICATEHELPERFAILED,pkix_PolicyNode_DuplicateHelper failed),
PKIX_ERRORENTRY(POLICYNODEGETCHILDRENMUTABLEFAILED,pkix_PolicyNode_GetChildrenMutable failed),
PKIX_ERRORENTRY(POLICYNODEGETDEPTHFAILED,PKIX_PolicyNode_GetDepth failed),
PKIX_ERRORENTRY(POLICYNODEGETEXPECTEDPOLICIESFAILED,PKIX_PolicyNode_GetExpectedPolicies failed),
PKIX_ERRORENTRY(POLICYNODEGETPARENTFAILED,PKIX_PolicyNode_GetParent failed),
PKIX_ERRORENTRY(POLICYNODEGETPOLICYQUALIFIERSFAILED,PKIX_PolicyNode_GetPolicyQualifiers failed),
PKIX_ERRORENTRY(POLICYNODEGETVALIDPOLICYFAILED,PKIX_PolicyNode_GetValidPolicy failed),
PKIX_ERRORENTRY(POLICYNODEISCRITICALFAILED,PKIX_PolicyNode_IsCritical failed),
PKIX_ERRORENTRY(POLICYNODEPRUNEFAILED,pkix_PolicyNode_Prune failed),
PKIX_ERRORENTRY(PORTARENAZNEWFAILED,PORT_ArenaZNew failed),
PKIX_ERRORENTRY(PORTNEWARENAFAILED,PORT_NewArena failed),
PKIX_ERRORENTRY(PORTUCS2UTF8CONVERSIONFAILED,PORT_UCS2_UTF8Conversion failed.),
PKIX_ERRORENTRY(PORTZALLOCFAILED,PORT_ZAlloc failed),
PKIX_ERRORENTRY(PRACCEPTFAILED,PR_Accept failed),
PKIX_ERRORENTRY(PRBINDFAILED,PR_Bind failed),
PKIX_ERRORENTRY(PRCONNECTCONTINUEFAILED,PR_ConnectContinue failed),
PKIX_ERRORENTRY(PRCONNECTFAILED,PR_Connect failed),
PKIX_ERRORENTRY(PRENUMERATEHOSTENTFAILED,PR_EnumerateHostEnt failed.),
PKIX_ERRORENTRY(PRGETHOSTBYNAMEREJECTSHOSTNAMEARGUMENT,PR_GetHostByName rejects hostname argument.),
PKIX_ERRORENTRY(PRIMHASHTABLEADDFAILED,pkix_pl_PrimHashTable_Add failed),
PKIX_ERRORENTRY(PRIMHASHTABLECREATEFAILED,pkix_pl_PrimHashTable_Create failed),
PKIX_ERRORENTRY(PRIMHASHTABLEDESTROYFAILED,pkix_pl_PrimHashTable_Destroy failed),
PKIX_ERRORENTRY(PRIMHASHTABLEGETBUCKETSIZEFAILED,pkix_pl_PrimHashTable_GetBucketSize failed),
PKIX_ERRORENTRY(PRIMHASHTABLELOOKUPFAILED,pkix_pl_PrimHashTable_Lookup failed),
PKIX_ERRORENTRY(PRIMHASHTABLEREMOVEFAILED,pkix_pl_PrimHashTable_Remove failed),
PKIX_ERRORENTRY(PRLISTENFAILED,PR_Listen failed),
PKIX_ERRORENTRY(PRNEWTCPSOCKETFAILED,PR_NewTCPSocket failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSADDCERTCHAINCHECKERFAILED,PKIX_ProcessingParams_AddCertChainChecker failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSCREATEFAILED,PKIX_ProcessingParams_Create failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETCERTCHAINCHECKERSFAILED,PKIX_ProcessingParams_GetCertChainCheckers failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETCERTSTORESFAILED,PKIX_ProcessingParams_GetCertStores failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETDATEFAILED,PKIX_ProcessingParams_GetDate failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETHINTCERTSFAILED,PKIX_ProcessingParams_GetHintCerts failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETINITIALPOLICIESFAILED,PKIX_ProcessingParams_GetInitialPolicies failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETPOLICYQUALIFIERSREJECTEDFAILED,PKIX_ProcessingParams_GetPolicyQualifiersRejected failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETRESOURCELIMITSFAILED,PKIX_ProcessingParams_GetResourceLimits failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETREVOCATIONCHECKERSFAILED,PKIX_ProcessingParams_GetRevocationCheckers failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETREVOCATIONENABLEDFAILED,PKIX_ProcessingParams_GetRevocationEnabled failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETTARGETCERTCONSTRAINTSFAILED,PKIX_ProcessingParams_GetTargetCertConstraints failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSGETTRUSTANCHORSFAILED,PKIX_ProcessingParams_GetTrustAnchors failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSISANYPOLICYINHIBITEDFAILED,PKIX_ProcessingParams_IsAnyPolicyInhibited failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSISEXPLICITPOLICYREQUIREDFAILED,PKIX_ProcessingParams_IsExplicitPolicyRequired failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSISPOLICYMAPPINGINHIBITEDFAILED,PKIX_ProcessingParams_IsPolicyMappingInhibited failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETCERTSTORESFAILED,PKIX_ProcessingParams_SetCertStores failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETDATEFAILED,PKIX_ProcessingParams_SetDate failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETREVOCATIONENABLEDFAILED,PKIX_ProcessingParams_SetRevocationEnabled failed),
PKIX_ERRORENTRY(PROCESSINGPARAMSSETTARGETCERTCONSTRAINTSFAILED,PKIX_ProcessingParams_SetTargetCertConstraints failed),
PKIX_ERRORENTRY(PRPOLLFAILED,PR_Poll failed),
PKIX_ERRORENTRY(PRRECVFAILED,PR_Recv failed),
PKIX_ERRORENTRY(PRRECVREPORTSNETWORKCONNECTIONCLOSED,PR_Recv reports network connection is closed),
PKIX_ERRORENTRY(PRSENDFAILED,PR_Send failed),
PKIX_ERRORENTRY(PRSHUTDOWNFAILED,PR_Shutdown failed),
PKIX_ERRORENTRY(PRSMPRINTFFAILED,PR_smprintf failed),
PKIX_ERRORENTRY(PRSNPRINTFFAILED,PR_snprintf failed),
PKIX_ERRORENTRY(PUBKEYTYPENULLKEY,pubKeyType is nullKey),
PKIX_ERRORENTRY(PUBLICKEYMAKEINHERITEDDSAPUBLICKEYFAILED,PKIX_PL_PublicKey_MakeInheritedDSAPublicKey failed),
PKIX_ERRORENTRY(PUBLICKEYNEEDSDSAPARAMETERSFAILED,PKIX_PL_PublicKey_NeedsDSAParameters failed),
PKIX_ERRORENTRY(PUBLICKEYTOSTRINGFAILED,PKIX_PL_PublicKey_ToString failed),
PKIX_ERRORENTRY(PUBLICKEYTOSTRINGHELPERFAILED,pkix_pl_PublicKey_ToString_Helper failed),
PKIX_ERRORENTRY(QUALIFIERSINCRITICALCERTIFICATEPOLICYEXTENSION,Qualifiers in critical Certificate Policy extension),
PKIX_ERRORENTRY(REALLOCFAILED,PKIX_PL_Realloc failed),
PKIX_ERRORENTRY(RECEIVEDCORRUPTEDOBJECTARGUMENT,Received corrupted object argument),
PKIX_ERRORENTRY(REQUESTNOTANHTTPDEFAULTCLIENT,request is not an HttpDefaultClient),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXDEPTHFAILED,PKIX_ResourceLimits_GetMaxDepth failed),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXFANOUTFAILED,PKIX_ResourceLimits_GetMaxFanout failed),
PKIX_ERRORENTRY(RESOURCELIMITSGETMAXTIMEFAILED,PKIX_ResourceLimits_GetMaxTime failed),
PKIX_ERRORENTRY(RETRIEVEOUTPUTSFAILED,pkix_RetrieveOutputs failed),
PKIX_ERRORENTRY(REVCHECKCERTFAILED,pkix_RevCheckCert failed),
PKIX_ERRORENTRY(REVCHECKERCHECKFAILED,revCheckerCheck failed),
PKIX_ERRORENTRY(REVOCATIONCHECKERCREATEFAILED,PKIX_RevocationChecker_Create failed),
PKIX_ERRORENTRY(REVOCATIONCHECKERGETREVCALLBACKFAILED,PKIX_RevocationChecker_GetRevCallback failed),
PKIX_ERRORENTRY(REVOCATIONCHECKERGETREVCHECKERCONTEXTFAILED,PKIX_RevocationChecker_GetRevCheckerContext failed),
PKIX_ERRORENTRY(REVOKEDBYUNKNOWNCRLREASONCODE,Revoked by Unknown CRL ReasonCode),
PKIX_ERRORENTRY(SEARCHRESPONSEPACKETOFUNKNOWNTYPE,SearchResponse packet of unknown type),
PKIX_ERRORENTRY(SECASN1ENCODEITEMFAILED,SEC_ASN1EncodeItem failed),
PKIX_ERRORENTRY(SECITEMALLOCITEMFAILED,SECITEM_AllocItem failed),
PKIX_ERRORENTRY(SECITEMALLOCITEMFORCRLDERRETURNNULL,SECITEM_AllocItem for CRL der return NULL),
PKIX_ERRORENTRY(SECITEMCOPYITEMFAILED,SECITEM_CopyItem failed),
PKIX_ERRORENTRY(SECKEYCOPYSUBJECTPUBLICKEYINFOFAILED,SECKEY_CopySubjectPublicKeyInfo failed),
PKIX_ERRORENTRY(SECKEYEXTRACTPUBLICKEYFAILED,SECKEY_ExtractPublicKey failed),
PKIX_ERRORENTRY(SECOIDCOPYALGORITHMIDFAILED,SECOID_CopyAlgorithmID failed),
PKIX_ERRORENTRY(SECOIDFINDOIDTAGDESCRIPTIONFAILED,SECOID_FindOIDTag Description failed),
PKIX_ERRORENTRY(SECONDFIELDMUSTBEBETWEEN039,Second field must be between 0-39),
PKIX_ERRORENTRY(SECONDKEYDSAPUBLICKEY,Second key is a DSA public key but has null parameters),
PKIX_ERRORENTRY(SECONDKEYNOTDSAPUBLICKEY,Second key is not a DSA public key),
PKIX_ERRORENTRY(SECONDPUBKEYTYPENULLKEY,secondPubKeyType is nullKey),
PKIX_ERRORENTRY(SECREADPKCS7CERTSFAILED,SEC_ReadPKCS7Certs failed),
PKIX_ERRORENTRY(SELECTORMATCHFAILED,selectorMatch failed),
PKIX_ERRORENTRY(SESSIONNOTANHTTPDEFAULTCLIENT,session is not an HttpDefaultClient),
PKIX_ERRORENTRY(SHUTDOWNFAILED,PKIX_PL_Shutdown failed),
PKIX_ERRORENTRY(SIGNATURECHECKERINITIALIZEFAILED,pkix_SignatureChecker_Initialize failed),
PKIX_ERRORENTRY(SIGNATURECHECKERSTATECREATEFAILED,pkix_SignatureCheckerState_Create failed),
PKIX_ERRORENTRY(SIGNATUREDIDNOTVERIFYWITHTHEPUBLICKEY,Signature did not verify with the public key),
PKIX_ERRORENTRY(SIGNATUREDIDNOTVERIFYWITHTHISPUBLICKEY,Signature did not verify with this public key),
PKIX_ERRORENTRY(SINGLEPOLICYNODEEQUALSFAILED,PKIX_PL_SinglePolicyNode_Equals failed),
PKIX_ERRORENTRY(SINGLEPOLICYNODEHASHCODEFAILED,pkix_SinglePolicyNode_Hashcode failed),
PKIX_ERRORENTRY(SINGLEPOLICYNODETOSTRINGFAILED,pkix_SinglePolicyNode_ToString failed),
PKIX_ERRORENTRY(SINGLEVERIFYNODEEQUALSFAILED,PKIX_PL_SingleVerifyNode_Equals failed),
PKIX_ERRORENTRY(SINGLEVERIFYNODEHASHCODEFAILED,pkix_SingleVerifyNode_Hashcode failed),
PKIX_ERRORENTRY(SOCKETCONNECTCONTINUEFAILED,pkix_pl_Socket_ConnectContinue failed),
PKIX_ERRORENTRY(SOCKETCONNECTFAILED,pkix_pl_Socket_Connect failed),
PKIX_ERRORENTRY(SOCKETCREATEBYHOSTANDPORTFAILED,pkix_pl_Socket_CreateByHostAndPort failed),
PKIX_ERRORENTRY(SOCKETCREATEBYNAMEFAILED,pkix_pl_Socket_CreateByName failed),
PKIX_ERRORENTRY(SOCKETCREATECLIENTFAILED,pkix_pl_Socket_CreateClient failed),
PKIX_ERRORENTRY(SOCKETCREATEFAILED,pkix_pl_Socket_Create failed),
PKIX_ERRORENTRY(SOCKETCREATESERVERFAILED,pkix_pl_Socket_CreateServer failed),
PKIX_ERRORENTRY(SOCKETEQUALSFAILED,PKIX_PL_Socket_Equals failed),
PKIX_ERRORENTRY(SOCKETGETCALLBACKLISTFAILED,pkix_pl_Socket_GetCallbackList failed),
PKIX_ERRORENTRY(SOCKETGETPRFILEDESCFAILED,pkix_pl_Socket_GetPRFileDesc failed),
PKIX_ERRORENTRY(SOCKETHASHCODEFAILED,PKIX_PL_Socket_Hashcode failed),
PKIX_ERRORENTRY(SOCKETPOLLFAILED,pkix_pl_Socket_Poll failed),
PKIX_ERRORENTRY(SOCKETRECVFAILED,pkix_pl_Socket_Recv failed),
PKIX_ERRORENTRY(SOCKETSENDFAILED,pkix_pl_Socket_Send failed),
PKIX_ERRORENTRY(SOCKETSETNONBLOCKINGFAILED,pkix_pl_Socket_SetNonBlocking failed),
PKIX_ERRORENTRY(SOURCESTRINGHASINVALIDLENGTH,Source string has invalid length),
PKIX_ERRORENTRY(SPRINTFFAILED,PKIX_PL_Sprintf failed),
PKIX_ERRORENTRY(STRINGCOMPARATORFAILED,pkix_pl_String_Comparator failed),
PKIX_ERRORENTRY(STRINGCREATEFAILED,PKIX_PL_String_Create failed),
PKIX_ERRORENTRY(STRINGEQUALSFAILED,pkix_pl_String_Equals failed),
PKIX_ERRORENTRY(STRINGGETENCODEDFAILED,PKIX_PL_String_GetEncoded failed),
PKIX_ERRORENTRY(STRINGHASHCODEFAILED,pkix_pl_String_Hashcode failed),
PKIX_ERRORENTRY(SUBJALTNAMECHECKFAILED,Validation failed: SubjAltNamecheck failed),
PKIX_ERRORENTRY(TARGETCERTCHECKERINITIALIZEFAILED,pkix_TargetCertChecker_Initialize failed),
PKIX_ERRORENTRY(TARGETCERTCHECKERSTATECREATEFAILED,pkix_TargetCertCheckerState_Create failed),
PKIX_ERRORENTRY(TIMECONSUMEDEXCEEDSRESOURCELIMITS,Time consumed exceeds Resource Limits),
PKIX_ERRORENTRY(TOOLITTLEDATAINDERSEQUENCE,Too little data in DER Sequence),
PKIX_ERRORENTRY(TOOMUCHDATAINDERSEQUENCE,Too much data in DER Sequence),
PKIX_ERRORENTRY(TOSTRINGFORTHISGENERALNAMETYPENOTSUPPORTED,ToString for this GeneralName type not supported),
PKIX_ERRORENTRY(TRUNCATEDUNICODEINESCAPEDASCII,Truncated Unicode in EscapedASCII),
PKIX_ERRORENTRY(TRUSTANCHORCREATEWITHCERTFAILED,PKIX_TrustAnchor_CreateWithCert failed),
PKIX_ERRORENTRY(TRUSTANCHORGETCANAMEFAILED,PKIX_TrustAnchor_GetCAName failed),
PKIX_ERRORENTRY(TRUSTANCHORGETCAPUBLICKEYFAILED,PKIX_TrustAnchor_GetCAPublicKey failed),
PKIX_ERRORENTRY(TRUSTANCHORGETNAMECONSTRAINTSFAILED,PKIX_TrustAnchor_GetNameConstraints failed),
PKIX_ERRORENTRY(TRUSTANCHORGETTRUSTEDCERTFAILED,PKIX_TrustAnchor_GetTrustedCert failed),
PKIX_ERRORENTRY(TYPEALREADYREGISTERED,Type is already registered),
PKIX_ERRORENTRY(UNABLETOADDACCEPTABLERESPONSESTOREQUEST,Unable to add acceptableResponses to request),
PKIX_ERRORENTRY(UNABLETOADDCERTTOCERTLIST,Unable to add Cert to CertList),
PKIX_ERRORENTRY(UNABLETOALLOCATESECITEM,Unable to allocate SECItem),
PKIX_ERRORENTRY(UNABLETOBUILDCHAIN,Unable to build chain),
PKIX_ERRORENTRY(UNABLETOCREATECERTOCSPREQUEST,Unable to create a CertOCSPRequest),
PKIX_ERRORENTRY(UNABLETOCREATECRLSTRING,Unable to create crlString),
PKIX_ERRORENTRY(UNABLETOCREATEGENERALNAMEOFTHISTYPE,Unable to create GeneralName of this type),
PKIX_ERRORENTRY(UNABLETOCREATEISSUER,Unable to create Issuer),
PKIX_ERRORENTRY(UNABLETOCREATELIST,Unable to create list),
PKIX_ERRORENTRY(UNABLETOCREATENEWCERTLIST,Unable to create a new CertList),
PKIX_ERRORENTRY(UNABLETOCREATEPSTRING,Unable to create pString),
PKIX_ERRORENTRY(UNABLETOFINDSTATUSINOCSPRESPONSE,Unable to find status in OCSP response),
PKIX_ERRORENTRY(UNABLETOMAKELISTIMMUTABLE,Unable to make list immutable),
PKIX_ERRORENTRY(UNABLETOOPENCERTFILE,Unable to open cert file),
PKIX_ERRORENTRY(UNABLETOOPENCRLFILE,Unable to open crl file),
PKIX_ERRORENTRY(UNABLETOPARSEOCSPRESPONSE,Unable to parse OCSP response),
PKIX_ERRORENTRY(UNABLETOREADDERFROMCERTFILE,Unable to read DER from cert file),
PKIX_ERRORENTRY(UNABLETOREADDERFROMCRLFILE,Unable to read DER from crl file),
PKIX_ERRORENTRY(UNABLETOSETSOCKETTONONBLOCKING,Unable to set socket to non-blocking I/O),
PKIX_ERRORENTRY(UNDEFINEDCALLBACK,Undefined callback),
PKIX_ERRORENTRY(UNDEFINEDCLASSTABLEENTRY,Undefined class table entry),
PKIX_ERRORENTRY(UNDEFINEDCOMPARATOR,Undefined Comparator),
PKIX_ERRORENTRY(UNDEFINEDDUPLICATEFUNCTION,Undefined Duplicate function),
PKIX_ERRORENTRY(UNDEFINEDEQUALSCALLBACK,Undefined equals callback),
PKIX_ERRORENTRY(UNEXPECTEDERRORINESTABLISHINGCONNECTION,Unexpected error in establishing connection),
PKIX_ERRORENTRY(UNEXPECTEDRESULTCODEINRESPONSE,Unexpected result code in Response),
PKIX_ERRORENTRY(UNKNOWNFORMAT,Unknown format),
PKIX_ERRORENTRY(UNKNOWNINFOACCESSTYPE,Unknown InfoAccess type),
PKIX_ERRORENTRY(UNKNOWNOBJECTOID,Unknown object OID),
PKIX_ERRORENTRY(UNKNOWNOBJECTTYPE,Unknown object type),
PKIX_ERRORENTRY(UNKNOWNTYPEARGUMENT,Unknown type argument),
PKIX_ERRORENTRY(UNLOCKOBJECTFAILED,pkix_UnlockObject failed),
PKIX_ERRORENTRY(UNRECOGNIZEDCRITICALEXTENSION,Unrecognized Critical Extension),
PKIX_ERRORENTRY(UNRECOGNIZEDCRLENTRYCRITICALEXTENSION,Unrecognized CRLEntry Critical Extension),
PKIX_ERRORENTRY(UNRECOGNIZEDPROTOCOLREQUESTED,Unrecognized protocol requested),
PKIX_ERRORENTRY(UNRECOGNIZEDREQUESTMETHOD,Unrecognized request method),
PKIX_ERRORENTRY(UNRECOGNIZEDTIMETYPE,Unrecognized time type),
PKIX_ERRORENTRY(UNSUPPORTEDVERSIONOFHTTPCLIENT,Unsupported version of Http Client),
PKIX_ERRORENTRY(URLPARSINGFAILED,URL Parsing failed),
PKIX_ERRORENTRY(USERCHECKERCHECKFAILED,userCheckerCheck failed),
PKIX_ERRORENTRY(UTF16ALIGNMENTERROR,UTF16 Alignment Error),
PKIX_ERRORENTRY(UTF16HIGHZONEALIGNMENTERROR,UTF16 High Zone Alignment Error),
PKIX_ERRORENTRY(UTF16LOWZONEERROR,UTF16 Low Zone Error),
PKIX_ERRORENTRY(UTF16TOESCASCIIFAILED,pkix_UTF16_to_EscASCII failed),
PKIX_ERRORENTRY(UTF16TOUTF8FAILED,pkix_UTF16_to_UTF8 failed),
PKIX_ERRORENTRY(UTF8TOUTF16FAILED,pkix_UTF8_to_UTF16 failed),
PKIX_ERRORENTRY(VALIDATEBUILDUSEROIDSFAILED,pkix_Validate_BuildUserOIDs failed),
PKIX_ERRORENTRY(VALIDATECHAINFAILED,PKIX_ValidateChain failed),
PKIX_ERRORENTRY(VALIDATEPARAMSGETCERTCHAINFAILED,PKIX_ValidateParams_GetCertChain failed),
PKIX_ERRORENTRY(VALIDATEPARAMSGETPROCESSINGPARAMSFAILED,PKIX_ValidateParams_GetProcessingParams failed),
PKIX_ERRORENTRY(VALIDATERESULTCREATEFAILED,pkix_ValidateResult_Create failed),
PKIX_ERRORENTRY(VALIDATERESULTGETPOLICYTREEFAILED,PKIX_ValidateResult_GetPolicyTree failed),
PKIX_ERRORENTRY(VALIDATERESULTGETTRUSTANCHORFAILED,PKIX_ValidateResult_GetTrustAnchor failed),
PKIX_ERRORENTRY(VALIDATIONFAILEDCERTSIGNATURECHECKING,Validation failed: Cert Signature checking),
PKIX_ERRORENTRY(VALIDATIONFAILEDNULLCERTPOINTER,Validation failed: NULL Cert pointer),
PKIX_ERRORENTRY(VALIDATIONFAILEDPATHTONAMECHECKFAILED,Validation failed: PathToName check failed),
PKIX_ERRORENTRY(VALUEINESCAPEDASCII,value in EscapedASCII),
PKIX_ERRORENTRY(VERIFYNODEADDTOCHAINFAILED,pkix_VerifyNode_AddToChain failed),
PKIX_ERRORENTRY(VERIFYNODEADDTOTREEFAILED,pkix_VerifyNode_AddToTree failed),
PKIX_ERRORENTRY(VERIFYNODECREATEFAILED,pkix_VerifyNode_Create failed),
PKIX_ERRORENTRY(VERIFYNODEDUPLICATEHELPERFAILED,pkix_VerifyNode_DuplicateHelper failed),
PKIX_ERRORENTRY(VERIFYNODESETDEPTHFAILED,pkix_VerifyNode_SetDepth failed),
PKIX_ERRORENTRY(VERIFYNODESETERRORFAILED,pkix_VerifyNode_SetError failed),
PKIX_ERRORENTRY(VERSIONVALUEMUSTBEV1ORV2,Version value must be V1(0) or V2(1)),
PKIX_ERRORENTRY(VERSIONVALUEMUSTBEV1V2ORV3,Version value must be v1(0) v2(1) or v3(2)),
PKIX_ERRORENTRY(X500NAMECOMPAREDERBYTESFAILED,pkix_pl_X500Name_CompareDERBytes failed),
PKIX_ERRORENTRY(X500NAMECREATEFAILED,PKIX_PL_X500Name_Create failed),
PKIX_ERRORENTRY(X500NAMECREATEFROMUTF8FAILED,pkix_pl_X500Name_CreateFromUtf8 failed),
PKIX_ERRORENTRY(X500NAMEEQUALSFAILED,PKIX_PL_X500Name_Equals failed),
PKIX_ERRORENTRY(X500NAMEGETCOMMONNAMEFAILED,pkix_pl_X500Name_GetCommonName failed),
PKIX_ERRORENTRY(X500NAMEGETCOUNTRYNAMEFAILED,pkix_pl_X500Name_GetCountryName failed),
PKIX_ERRORENTRY(X500NAMEGETORGNAMEFAILED,pkix_pl_X500Name_GetOrgName failed),
PKIX_ERRORENTRY(X500NAMEGETSECNAMEFAILED,pkix_pl_X500Name_GetSECName failed),
PKIX_ERRORENTRY(X500NAMEHASHCODEFAILED,PKIX_PL_X500Name_Hashcode failed),
PKIX_ERRORENTRY(X500NAMEMATCHFAILED,PKIX_PL_X500Name_Match failed),
PKIX_ERRORENTRY(X500NAMETOSTRINGFAILED,PKIX_PL_X500Name_ToString failed),
PKIX_ERRORENTRY(X500NAMETOSTRINGHELPERFAILED,pkix_pl_X500Name_ToString_Helper failed),
PKIX_ERRORENTRY(ZEROLENGTHBYTEARRAYFORCRLENCODING,Zero-length ByteArray for CRL encoding)

