/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/tinderbox/XR-Trunk/Linux_2.6.18-8.el5_Depend/mozilla/accessible/public/nsIAccessibleDocument.idl
 */

#ifndef __gen_nsIAccessibleDocument_h__
#define __gen_nsIAccessibleDocument_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAccessible; /* forward declaration */

class nsIAccessNode; /* forward declaration */

class nsIDOMDocument; /* forward declaration */

class nsIDOMNode; /* forward declaration */

class nsIDOMWindow; /* forward declaration */


/* starting interface:    nsIAccessibleDocument */
#define NS_IACCESSIBLEDOCUMENT_IID_STR "d118c0e9-b5e7-4671-854a-65b4713d9552"

#define NS_IACCESSIBLEDOCUMENT_IID \
  {0xd118c0e9, 0xb5e7, 0x4671, \
    { 0x85, 0x4a, 0x65, 0xb4, 0x71, 0x3d, 0x95, 0x52 }}

/**
 * An interface for in-process accessibility clients
 * that wish to retrieve information about a document.
 * When accessibility is turned on in Gecko,
 * there is an nsIAccessibleDocument for each document
 * whether it is XUL, HTML or whatever.
 * You can QueryInterface to nsIAccessibleDocument from
 * the nsIAccessible or nsIAccessNode for the root node
 * of a document. You can also get one from 
 * nsIAccessNode::GetAccessibleDocument() or 
 * nsIAccessibleEvent::GetAccessibleDocument()
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIAccessibleDocument : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IACCESSIBLEDOCUMENT_IID)

  /**
   * The URL of the document
   */
  /* readonly attribute AString URL; */
  NS_IMETHOD GetURL(nsAString & aURL) = 0;

  /**
   * The title of the document, as specified in the document.
   */
  /* readonly attribute AString title; */
  NS_IMETHOD GetTitle(nsAString & aTitle) = 0;

  /**
   * The mime type of the document
   */
  /* readonly attribute AString mimeType; */
  NS_IMETHOD GetMimeType(nsAString & aMimeType) = 0;

  /**
   * The doc type of the document, as specified in the document.
   */
  /* readonly attribute AString docType; */
  NS_IMETHOD GetDocType(nsAString & aDocType) = 0;

  /**
   * The nsIDOMDocument interface associated with this document.
   */
  /* readonly attribute nsIDOMDocument document; */
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) = 0;

  /**
   * The nsIDOMWindow that the document resides in.
   */
  /* readonly attribute nsIDOMWindow window; */
  NS_IMETHOD GetWindow(nsIDOMWindow * *aWindow) = 0;

  /**
   * The namespace for each ID that is handed back.
   */
  /* AString getNameSpaceURIForID (in short nameSpaceID); */
  NS_IMETHOD GetNameSpaceURIForID(PRInt16 nameSpaceID, nsAString & _retval) = 0;

  /**
   * The window handle for the OS window the document is being displayed in.
   * For example, in Windows you can static cast it to an HWND.
   */
  /* [noscript] readonly attribute voidPtr windowHandle; */
  NS_IMETHOD GetWindowHandle(void * *aWindowHandle) = 0;

  /**
   * Returns the access node cached by this document
   * @param aUniqueID The unique ID used to cache the node.
   *                  This matches up with the uniqueID attribute on
   *                  nsIAccessNode.
   * @return The nsIAccessNode cached for this particular unique ID.
   */
  /* [noscript] nsIAccessNode getCachedAccessNode (in voidPtr aUniqueID); */
  NS_IMETHOD GetCachedAccessNode(void * aUniqueID, nsIAccessNode **_retval) = 0;

  /**
   * Returns the first accessible parent of a DOM node.
   * Guaranteed not to return nsnull if the DOM node is in a document.
   * @param aDOMNode The DOM node we need an accessible for.
   * @param aCanCreate Can accessibles be created or must it be the first 
   *                   cached accessible in the parent chain?
   * @return An first nsIAccessible found by crawling up the DOM node
   *         to the document root.
   */
  /* nsIAccessible getAccessibleInParentChain (in nsIDOMNode aDOMNode); */
  NS_IMETHOD GetAccessibleInParentChain(nsIDOMNode *aDOMNode, nsIAccessible **_retval) = 0;

  /**
   * A bit flag representing the type of ARIA properties which should be
   * checked in this document:
   * either eUnknownPropType, eCheckNamespaced, eCheckHyphenated or eCheckAny
   */
  /* readonly attribute unsigned long ariaPropTypes; */
  NS_IMETHOD GetAriaPropTypes(PRUint32 *aAriaPropTypes) = 0;

  /**
   * Check attributes in the form of:
   * [someprefix]:[propname]  (e.g. aria:live) where ancestor defines: 
   * xmlns:[someprefix]="http://www.w3.org/2005/07/aaa"
   */
  enum { eCheckNamespaced = 1U };

  /**
   * Check hyphenated attributes in the form of aria-[propname].
   * This is the default in text/html documents.
   * Can be combined with eCheckNamespaced flag. This may
   * change during the life of the document, if setAttributeNS()
   * is used to set an ARIA property.
   */
  enum { eCheckHyphenated = 2U };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAccessibleDocument, NS_IACCESSIBLEDOCUMENT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIACCESSIBLEDOCUMENT \
  NS_IMETHOD GetURL(nsAString & aURL); \
  NS_IMETHOD GetTitle(nsAString & aTitle); \
  NS_IMETHOD GetMimeType(nsAString & aMimeType); \
  NS_IMETHOD GetDocType(nsAString & aDocType); \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument); \
  NS_IMETHOD GetWindow(nsIDOMWindow * *aWindow); \
  NS_IMETHOD GetNameSpaceURIForID(PRInt16 nameSpaceID, nsAString & _retval); \
  NS_IMETHOD GetWindowHandle(void * *aWindowHandle); \
  NS_IMETHOD GetCachedAccessNode(void * aUniqueID, nsIAccessNode **_retval); \
  NS_IMETHOD GetAccessibleInParentChain(nsIDOMNode *aDOMNode, nsIAccessible **_retval); \
  NS_IMETHOD GetAriaPropTypes(PRUint32 *aAriaPropTypes); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIACCESSIBLEDOCUMENT(_to) \
  NS_IMETHOD GetURL(nsAString & aURL) { return _to GetURL(aURL); } \
  NS_IMETHOD GetTitle(nsAString & aTitle) { return _to GetTitle(aTitle); } \
  NS_IMETHOD GetMimeType(nsAString & aMimeType) { return _to GetMimeType(aMimeType); } \
  NS_IMETHOD GetDocType(nsAString & aDocType) { return _to GetDocType(aDocType); } \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) { return _to GetDocument(aDocument); } \
  NS_IMETHOD GetWindow(nsIDOMWindow * *aWindow) { return _to GetWindow(aWindow); } \
  NS_IMETHOD GetNameSpaceURIForID(PRInt16 nameSpaceID, nsAString & _retval) { return _to GetNameSpaceURIForID(nameSpaceID, _retval); } \
  NS_IMETHOD GetWindowHandle(void * *aWindowHandle) { return _to GetWindowHandle(aWindowHandle); } \
  NS_IMETHOD GetCachedAccessNode(void * aUniqueID, nsIAccessNode **_retval) { return _to GetCachedAccessNode(aUniqueID, _retval); } \
  NS_IMETHOD GetAccessibleInParentChain(nsIDOMNode *aDOMNode, nsIAccessible **_retval) { return _to GetAccessibleInParentChain(aDOMNode, _retval); } \
  NS_IMETHOD GetAriaPropTypes(PRUint32 *aAriaPropTypes) { return _to GetAriaPropTypes(aAriaPropTypes); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIACCESSIBLEDOCUMENT(_to) \
  NS_IMETHOD GetURL(nsAString & aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURL(aURL); } \
  NS_IMETHOD GetTitle(nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTitle(aTitle); } \
  NS_IMETHOD GetMimeType(nsAString & aMimeType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMimeType(aMimeType); } \
  NS_IMETHOD GetDocType(nsAString & aDocType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocType(aDocType); } \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocument(aDocument); } \
  NS_IMETHOD GetWindow(nsIDOMWindow * *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindow(aWindow); } \
  NS_IMETHOD GetNameSpaceURIForID(PRInt16 nameSpaceID, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNameSpaceURIForID(nameSpaceID, _retval); } \
  NS_IMETHOD GetWindowHandle(void * *aWindowHandle) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindowHandle(aWindowHandle); } \
  NS_IMETHOD GetCachedAccessNode(void * aUniqueID, nsIAccessNode **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCachedAccessNode(aUniqueID, _retval); } \
  NS_IMETHOD GetAccessibleInParentChain(nsIDOMNode *aDOMNode, nsIAccessible **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleInParentChain(aDOMNode, _retval); } \
  NS_IMETHOD GetAriaPropTypes(PRUint32 *aAriaPropTypes) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAriaPropTypes(aAriaPropTypes); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAccessibleDocument : public nsIAccessibleDocument
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIACCESSIBLEDOCUMENT

  nsAccessibleDocument();

private:
  ~nsAccessibleDocument();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAccessibleDocument, nsIAccessibleDocument)

nsAccessibleDocument::nsAccessibleDocument()
{
  /* member initializers and constructor code */
}

nsAccessibleDocument::~nsAccessibleDocument()
{
  /* destructor code */
}

/* readonly attribute AString URL; */
NS_IMETHODIMP nsAccessibleDocument::GetURL(nsAString & aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString title; */
NS_IMETHODIMP nsAccessibleDocument::GetTitle(nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString mimeType; */
NS_IMETHODIMP nsAccessibleDocument::GetMimeType(nsAString & aMimeType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString docType; */
NS_IMETHODIMP nsAccessibleDocument::GetDocType(nsAString & aDocType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDocument document; */
NS_IMETHODIMP nsAccessibleDocument::GetDocument(nsIDOMDocument * *aDocument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMWindow window; */
NS_IMETHODIMP nsAccessibleDocument::GetWindow(nsIDOMWindow * *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getNameSpaceURIForID (in short nameSpaceID); */
NS_IMETHODIMP nsAccessibleDocument::GetNameSpaceURIForID(PRInt16 nameSpaceID, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute voidPtr windowHandle; */
NS_IMETHODIMP nsAccessibleDocument::GetWindowHandle(void * *aWindowHandle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsIAccessNode getCachedAccessNode (in voidPtr aUniqueID); */
NS_IMETHODIMP nsAccessibleDocument::GetCachedAccessNode(void * aUniqueID, nsIAccessNode **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAccessible getAccessibleInParentChain (in nsIDOMNode aDOMNode); */
NS_IMETHODIMP nsAccessibleDocument::GetAccessibleInParentChain(nsIDOMNode *aDOMNode, nsIAccessible **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long ariaPropTypes; */
NS_IMETHODIMP nsAccessibleDocument::GetAriaPropTypes(PRUint32 *aAriaPropTypes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAccessibleDocument_h__ */
