/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/security/manager/ssl/public/nsIBadCertListener.idl
 */

package org.mozilla.interfaces;

/**
 * Functions that display warnings for problems with web site trust.
 *
 * @status FROZEN
 */
public interface nsIBadCertListener extends nsISupports {

  String NS_IBADCERTLISTENER_IID =
    "{86960956-edb0-11d4-998b-00b0d02354a0}";

  /**
   *  No decision was made by the user, whether to trust a cert.
   */
  short UNINIT_ADD_FLAG = -1;

  /**
   *  The user decided to add trust to a certificate temporarily
   *  for the current application session only.
   */
  short ADD_TRUSTED_FOR_SESSION = 1;

  /**
   *  The user decided to add trust to a certificate permanently.
   */
  short ADD_TRUSTED_PERMANENTLY = 2;

  /**
   *  Inform the user there are problems with the trust of a certificate,
   *  and request a decision from the user.
   *  The UI should offer the user a way to look at the certificate in detail.
   *  The following is a sample UI message to be shown to the user:
   *
   *    Unable to verify the identity of %S as a trusted site.
   *    Possible reasons for this error:
   *    - Your browser does not recognize the Certificate Authority 
   *      that issued the site's certificate.
   *    - The site's certificate is incomplete due to a 
   *      server misconfiguration.
   *    - You are connected to a site pretending to be %S, 
   *      possibly to obtain your confidential information.
   *    Please notify the site's webmaster about this problem.
   *    Before accepting this certificate, you should examine this site's 
   *      certificate carefully. Are you willing to accept this certificate 
   *      for the purpose of identifying the Web site %S?
   *    o Accept this certificate permanently
   *    x Accept this certificate temporarily for this session
   *    o Do not accept this certificate and do not connect to this Web site
   *
   *  @param socketInfo A network communication context that can be used to obtain more information
   *                    about the active connection.
   *  @param cert The certificate that is not trusted and that is having the problem.
   *  @param certAddType The user's trust decision. See constants defined above.
   *
   *  @return true if the user decided to connect anyway, false if the user decided to not connect
   */
  boolean confirmUnknownIssuer(nsIInterfaceRequestor socketInfo, nsIX509Cert cert, short[] certAddType);

  /**
   *  Inform the user there are problems with the trust of a certificate,
   *  and request a decision from the user.
   *  The hostname mentioned in the server's certificate is not the hostname
   *  that was used as a destination address for the current connection.
   *
   *  @param socketInfo A network communication context that can be used to obtain more information
   *                    about the active connection.
   *  @param targetURL The URL that was used to open the current connection.
   *  @param cert The certificate that was presented by the server.
   *
   *  @return true if the user decided to connect anyway, false if the user decided to not connect
   */
  boolean confirmMismatchDomain(nsIInterfaceRequestor socketInfo, String targetURL, nsIX509Cert cert);

  /**
   *  Inform the user there are problems with the trust of a certificate,
   *  and request a decision from the user.
   *  The certificate presented by the server is no longer valid because 
   *  the validity period has expired.
   *
   *  @param socketInfo A network communication context that can be used to obtain more information
   *                    about the active connection.
   *  @param cert The certificate that was presented by the server.
   *
   *  @return true if the user decided to connect anyway, false if the user decided to not connect
   */
  boolean confirmCertExpired(nsIInterfaceRequestor socketInfo, nsIX509Cert cert);

  /**
   *  Inform the user there are problems with the trust of a certificate,
   *  and request a decision from the user.
   *  The Certificate Authority (CA) that issued the server's certificate has issued a 
   *  Certificate Revocation List (CRL). 
   *  However, the application does not have a current version of the CA's CRL.
   *  Due to the application configuration, the application disallows the connection
   *  to the remote site.
   *
   *  @param socketInfo A network communication context that can be used to obtain more information
   *                    about the active connection.
   *  @param targetURL The URL that was used to open the current connection.
   *  @param cert The certificate that was presented by the server.
   */
  void notifyCrlNextupdate(nsIInterfaceRequestor socketInfo, String targetURL, nsIX509Cert cert);

}