/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/tinderbox/XR-Trunk/Darwin_8.8.4_Depend/mozilla/netwerk/dns/public/nsIEffectiveTLDService.idl
 */

#ifndef __gen_nsIEffectiveTLDService_h__
#define __gen_nsIEffectiveTLDService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIEffectiveTLDService */
#define NS_IEFFECTIVETLDSERVICE_IID_STR "4b8cdd85-e186-46e5-9ec0-9488ae7f0b92"

#define NS_IEFFECTIVETLDSERVICE_IID \
  {0x4b8cdd85, 0xe186, 0x46e5, \
    { 0x9e, 0xc0, 0x94, 0x88, 0xae, 0x7f, 0x0b, 0x92 }}

class NS_NO_VTABLE nsIEffectiveTLDService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IEFFECTIVETLDSERVICE_IID)

  /**
     * getEffectiveTLDLength
     *
     * Finds the length of the effective TLD of a hostname.  An effective TLD
     * is the highest-level domain under which individual domains may be
     * registered; it may therefore contain one or more dots.  For example,
     * the effective TLD for "www.bbc.co.uk" is "co.uk", because the .uk TLD
     * does not allow the registration of domains at the second level ("bbc.uk"
     * is forbidden).  Similarly, the effective TLD of "developer.mozilla.com"
     * is "com".
     *
     * The hostname will be normalized using nsIIDNService::normalize, which
     * follows RFC 3454.  getEffectiveTLDLength() will fail, generating an
     * error, if the hostname contains characters that are invalid in URIs.
     *
     * @param   aHostname   The hostname to be analyzed, in UTF-8
     *
     * @returns the number of bytes that the longest identified effective TLD
     *          (TLD or TLD-like higher-level subdomain) occupies, not including
     *          the leading dot:
     *              bugzilla.mozilla.org -> org -> 3
     *              theregister.co.uk -> co.uk -> 5
     *              mysite.us -> us -> 2
     *
     * @throws NS_ERROR_UNEXPECTED 
     *         or other error returned by nsIIDNService::normalize when 
     *         aHostname is not UTF-8 or contains characters disallowed in URIs
     */
  /* PRUint32 getEffectiveTLDLength (in AUTF8String aHostname); */
  NS_IMETHOD GetEffectiveTLDLength(const nsACString & aHostname, PRUint32 *_retval) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIEffectiveTLDService, NS_IEFFECTIVETLDSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEFFECTIVETLDSERVICE \
  NS_IMETHOD GetEffectiveTLDLength(const nsACString & aHostname, PRUint32 *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEFFECTIVETLDSERVICE(_to) \
  NS_IMETHOD GetEffectiveTLDLength(const nsACString & aHostname, PRUint32 *_retval) { return _to GetEffectiveTLDLength(aHostname, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEFFECTIVETLDSERVICE(_to) \
  NS_IMETHOD GetEffectiveTLDLength(const nsACString & aHostname, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEffectiveTLDLength(aHostname, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsEffectiveTLDService : public nsIEffectiveTLDService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIEFFECTIVETLDSERVICE

  nsEffectiveTLDService();

private:
  ~nsEffectiveTLDService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsEffectiveTLDService, nsIEffectiveTLDService)

nsEffectiveTLDService::nsEffectiveTLDService()
{
  /* member initializers and constructor code */
}

nsEffectiveTLDService::~nsEffectiveTLDService()
{
  /* destructor code */
}

/* PRUint32 getEffectiveTLDLength (in AUTF8String aHostname); */
NS_IMETHODIMP nsEffectiveTLDService::GetEffectiveTLDLength(const nsACString & aHostname, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIEffectiveTLDService_h__ */
