/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/components/passwordmgr/public/nsILoginInfo.idl
 */

package org.mozilla.interfaces;

/**
 * An object containing information for a login stored by the
 * password manager.
 */
public interface nsILoginInfo extends nsISupports {

  String NS_ILOGININFO_IID =
    "{a437458b-baca-4a71-a839-13861a2fd538}";

  /**
     * The hostname the login applies to.
     *
     * For logins obtained from HTML forms, the login is formatted like
     * a URL. For example: "http://www.site.com" A port number (":123")
     * may be appended in some cases.
     *
     * For logins obtained from a HTTP or FTP protocol authentication, 
     * the hostname is not a URL format, but does always have the port
     * number appended. For example "www.site.com:80".
     */
  String getHostname();

  /**
     * The hostname the login applies to.
     *
     * For logins obtained from HTML forms, the login is formatted like
     * a URL. For example: "http://www.site.com" A port number (":123")
     * may be appended in some cases.
     *
     * For logins obtained from a HTTP or FTP protocol authentication, 
     * the hostname is not a URL format, but does always have the port
     * number appended. For example "www.site.com:80".
     */
  void setHostname(String aHostname);

  /**
     * The URL a form-based login was submitted to.
     *
     * For logins obtained from HTML forms, this field is the |action|
     * attribute from the |form| element, with the path removed. For
     * example "http://www.site.com". [Forms with no |action| attribute
     * default to submitting to their origin URL, so we store that.]
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  String getFormSubmitURL();

  /**
     * The URL a form-based login was submitted to.
     *
     * For logins obtained from HTML forms, this field is the |action|
     * attribute from the |form| element, with the path removed. For
     * example "http://www.site.com". [Forms with no |action| attribute
     * default to submitting to their origin URL, so we store that.]
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  void setFormSubmitURL(String aFormSubmitURL);

  /**
     * The HTTP Realm a login was requested for.
     *
     * When an HTTP server sends a 401 result, the WWW-Authenticate
     * header includes a realm to identify the "protection space." See
     * RFC2617.
     *
     * For logins obtained from HTML forms, this field is NULL.
     */
  String getHttpRealm();

  /**
     * The HTTP Realm a login was requested for.
     *
     * When an HTTP server sends a 401 result, the WWW-Authenticate
     * header includes a realm to identify the "protection space." See
     * RFC2617.
     *
     * For logins obtained from HTML forms, this field is NULL.
     */
  void setHttpRealm(String aHttpRealm);

  /**
     * The username for the login.
     */
  String getUsername();

  /**
     * The username for the login.
     */
  void setUsername(String aUsername);

  /**
     * The |name| attribute for the username input field.
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  String getUsernameField();

  /**
     * The |name| attribute for the username input field.
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  void setUsernameField(String aUsernameField);

  /**
     * The password for the login.
     */
  String getPassword();

  /**
     * The password for the login.
     */
  void setPassword(String aPassword);

  /**
     * The |name| attribute for the password input field.
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  String getPasswordField();

  /**
     * The |name| attribute for the password input field.
     *
     * For logins obtained from a HTTP or FTP protocol authentication,
     * this field is NULL.
     */
  void setPasswordField(String aPasswordField);

  /**
     * Initialize a newly created nsLoginInfo object.
     *
     * The arguments are the fields for the new object.
     */
  void init(String aHostname, String aFormSubmitURL, String aHttpRealm, String aUsername, String aPassword, String aUsernameField, String aPasswordField);

  /**
     * Test for equality with another nsILoginInfo object.
     *
     * @param aLoginInfo
     *        The other object to test.
     *
     * NOTE: The formSubmitURL field is not strictly checked. A blank (but
     *       not NULL) value will match any value (except null) in the other
     *       object's formSubmitURL field. The blank value indicates the login
     *       was stored before bug 360493 was fixed.
     */
  boolean _equals(nsILoginInfo aLoginInfo);

  /**
     * Test for equality with another nsILoginInfo object, with the
     * password fields ignored.
     *
     * @param aLoginInfo
     *        The other object to test.
     */
  boolean equalsIgnorePassword(nsILoginInfo aLoginInfo);

}