/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Linux_2.6.18-8.el5_Depend/mozilla/netwerk/dns/public/nsIEffectiveTLDService.idl
 */

package org.mozilla.interfaces;

public interface nsIEffectiveTLDService extends nsISupports {

  String NS_IEFFECTIVETLDSERVICE_IID =
    "{b07cb0f0-3394-572e-6260-dbaed0a292ba}";

  /**
     * Returns the public suffix of a URI. A public suffix is the highest-level domain
     * under which individual domains may be registered; it may therefore contain one
     * or more dots. For example, the public suffix for "www.bbc.co.uk" is "co.uk",
     * because the .uk TLD does not allow the registration of domains at the
     * second level ("bbc.uk" is forbidden).
     *
     * The public suffix will be returned encoded in ASCII/ACE and will be normalized
     * according to RFC 3454, i.e. the same encoding returned by nsIURI::GetAsciiHost().
     *
     * @param   aURI               The URI to be analyzed
     *
     * @returns the public suffix
     *
     * @throws NS_ERROR_UNEXPECTED 
     *         or other error returned by nsIIDNService::normalize when 
     *         the hostname contains characters disallowed in URIs
     * @throws NS_ERROR_HOST_IS_IP_ADDRESS
     *         if the host is a numeric IPv4 or IPv6 address (as determined by
     *         the success of a call to PR_StringToNetAddr()).
     */
  String getPublicSuffix(nsIURI aURI);

  /**
     * Returns the base domain of a URI; that is, the public suffix with a given
     * number of additional domain name parts. For example, the result of this method
     * for "www.bbc.co.uk", depending on the value of aAdditionalParts parameter, will
     * be:
     *
     *    0 (default) -> bbc.co.uk
     *    1           -> news.bbc.co.uk
     *
     * Similarly, the public suffix for "developer.mozilla.org" is "org", and the base
     * domain will be:
     *
     *    0 (default) -> mozilla.org
     *    1           -> developer.mozilla.org
     *
     * The base domain will be returned encoded in ASCII/ACE and will be normalized
     * according to RFC 3454, i.e. the same encoding returned by nsIURI::GetAsciiHost().
     *
     * @param   aURI               The URI to be analyzed
     * @param   aAdditionalParts   Number of domain name parts to be
     *                             returned in addition to the public suffix
     *
     * @returns the base domain (public suffix plus the requested number of additional parts)
     *
     * @throws NS_ERROR_UNEXPECTED 
     *         or other error returned by nsIIDNService::normalize when 
     *         the hostname contains characters disallowed in URIs
     * @throws NS_ERROR_INSUFFICIENT_DOMAIN_LEVELS
     *         when there are insufficient subdomain levels in the hostname to satisfy the
     *         requested aAdditionalParts value.
     * @throws NS_ERROR_HOST_IS_IP_ADDRESS
     *         if aHost is a numeric IPv4 or IPv6 address (as determined by
     *         the success of a call to PR_StringToNetAddr()).
     *
     * @see    getPublicSuffix()
     */
  String getBaseDomain(nsIURI aURI, long aAdditionalParts);

  /**
     * Returns the public suffix of a host string. Otherwise identical to getPublicSuffix().
     *
     * @see     getPublicSuffix()
     */
  String getPublicSuffixFromHost(String aHost);

  /**
     * Returns the base domain of a host string. Otherwise identical to getBaseDomain().
     *
     * @see     getBaseDomain()
     */
  String getBaseDomainFromHost(String aHost, long aAdditionalParts);

}