/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/storage/public/mozIStorageService.idl
 */

package org.mozilla.interfaces;

/**
 * The mozIStorageService interface is intended to be implemented by
 * a service that can create storage connections (mozIStorageConnection)
 * to either a well-known profile database or to a specific database file.
 *
 * This is the only way to open a database connection.
 */
public interface mozIStorageService extends nsISupports {

  String MOZISTORAGESERVICE_IID =
    "{336d2741-8438-449d-8746-8c37c62a2ccb}";

  /**
   * Get a connection to a named special database storage.
   *
   * @param aStorageKey a string key identifying the type of storage
   * requested.  Valid values include: "profile", "memory".
   *
   * @see openDatabase for restrictions on how database connections may be
   * used. For the profile database, you should only access it from the main
   * thread since other callers may also have connections.
   *
   * @returns a new mozIStorageConnection for the requested
   * storage database.
   *
   * @throws NS_ERROR_INVALID_ARG if aStorageKey is invalid.
   */
  mozIStorageConnection openSpecialDatabase(String aStorageKey);

  /**
   * Open a connection to the specified file.
   *
   * ==========
   *   DANGER
   * ==========
   *
   * If you have more than one connection to a file, you MUST use the EXACT
   * SAME NAME for the file each time, including case. The sqlite code uses
   * a simple string compare to see if there is already a connection. Opening
   * a connection to "Foo.sqlite" and "foo.sqlite" will CORRUPT YOUR DATABASE.
   *
   * The connection object returned by this function is not threadsafe. You must
   * use it only from the thread you created it from.
   *
   * If your database contains virtual tables (f.e. for full-text indexes), you
   * must open it with openUnsharedDatabase, as those tables are incompatible
   * with a shared cache.  If you attempt to use this method to open a database
   * containing virtual tables, it will think the database is corrupted and
   * throw NS_ERROR_FILE_CORRUPTED.
   *
   * @param aDatabaseFile a nsIFile of the database to open.
   *
   * @returns a mozIStorageConnection for the requested database file.
   *
   * @throws NS_ERROR_FAILURE if any operation fails while opening the database.
   */
  mozIStorageConnection openDatabase(nsIFile aDatabaseFile);

  /**
   * Open a connection to the specified file that doesn't share a sqlite cache.
   *
   * Each connection uses its own sqlite cache, which is inefficient, so you
   * should use openDatabase instead of this method unless you need a feature
   * of SQLite that is incompatible with a shared cache, like virtual table
   * and full text indexing support.
   *
   * ==========
   *   DANGER
   * ==========
   *
   * If you have more than one connection to a file, you MUST use the EXACT
   * SAME NAME for the file each time, including case. The sqlite code uses
   * a simple string compare to see if there is already a connection. Opening
   * a connection to "Foo.sqlite" and "foo.sqlite" will CORRUPT YOUR DATABASE.
   *
   * The connection object returned by this function is not threadsafe. You must
   * use it only from the thread you created it from.
   *
   * @param aDatabaseFile a nsIFile of the database to open.
   *
   * @returns a mozIStorageConnection for the requested database file.
   *
   * @throws NS_ERROR_FAILURE if any operation fails while opening the database.
   */
  mozIStorageConnection openUnsharedDatabase(nsIFile aDatabaseFile);

}