/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIStandardURL.idl
 */

package org.mozilla.interfaces;

/**
 * nsIStandardURL defines the interface to an URL with the standard
 * file path format common to protocols like http, ftp, and file.
 * It supports initialization from a relative path and provides
 * some customization on how URLs are normalized.
 *
 * @status UNDER_REVIEW
 */
public interface nsIStandardURL extends nsISupports {

  String NS_ISTANDARDURL_IID =
    "{8793370a-311f-11d4-9876-00c04fa0cf4a}";

  /**
     * blah:foo/bar    => blah://foo/bar
     * blah:/foo/bar   => blah:///foo/bar
     * blah://foo/bar  => blah://foo/bar
     * blah:///foo/bar => blah:///foo/bar
     */
  long URLTYPE_STANDARD = 1L;

  /**
     * blah:foo/bar    => blah://foo/bar
     * blah:/foo/bar   => blah://foo/bar
     * blah://foo/bar  => blah://foo/bar
     * blah:///foo/bar => blah://foo/bar
     */
  long URLTYPE_AUTHORITY = 2L;

  /**
     * blah:foo/bar    => blah:///foo/bar
     * blah:/foo/bar   => blah:///foo/bar
     * blah://foo/bar  => blah://foo/bar
     * blah:///foo/bar => blah:///foo/bar
     */
  long URLTYPE_NO_AUTHORITY = 3L;

  /**
     * Initialize a standard URL.
     *
     * @param aUrlType       - one of the URLTYPE_ flags listed above.
     * @param aDefaultPort   - if the port parsed from the URL string matches
     *                         this port, then the port will be removed from the
     *                         canonical form of the URL.
     * @param aSpec          - URL string.
     * @param aOriginCharset - the charset from which this URI string
     *                         originated.  this corresponds to the charset
     *                         that should be used when communicating this
     *                         URI to an origin server, for example.  if
     *                         null, then provide aBaseURI implements this
     *                         interface, the origin charset of aBaseURI will
     *                         be assumed, otherwise defaulting to UTF-8 (i.e.,
     *                         no charset transformation from aSpec).
     * @param aBaseURI       - if null, aSpec must specify an absolute URI.
     *                         otherwise, aSpec will be resolved relative
     *                         to aBaseURI.
     */
  void init(long aUrlType, int aDefaultPort, String aSpec, String aOriginCharset, nsIURI aBaseURI);

  /**
     * Control whether or not this URL can be modified.  Protocol handlers
     * can set this flag before handing out an URL to ensure that it is not
     * inadvertently modified.
     */
  boolean getMutable();

  /**
     * Control whether or not this URL can be modified.  Protocol handlers
     * can set this flag before handing out an URL to ensure that it is not
     * inadvertently modified.
     */
  void setMutable(boolean aMutable);

}