/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIWebServiceProxy.idl
 */

package org.mozilla.interfaces;

/**
 * A representation of a method invocation on a web service.
 * An instance of this interface is returned as a result of making
 * an asynchronous call and can be queried for status of the
 * call.
 */
public interface nsIWebServiceCallContext extends nsISupports {

  String NS_IWEBSERVICECALLCONTEXT_IID =
    "{87d87900-f102-4a15-b345-7b77a49d2df2}";

  /** 
   * Possible values of the <code>status</code> attribute. A pending
   * call has a status of PENDING. A completed call has a status of
   * SUCCEEDED or FAILED depending on the result of the call.
   */
  long PENDING = 0L;

  long SUCCEEDED = 1L;

  long FAILED = 2L;

  long ABORTED = 3L;

  /**
   * The proxy object on which the call was made.
   * 
   * @see nsIWebServiceProxy
   */
  nsIWebServiceProxy getProxy();

  /**
   * The name of the method that was invoked.
   */
  String getMethodName();

  /**
   * The status of the call, whether pending, completed successfully
   * or completed with a fault.
   */
  long getStatus();

  /**
   * The exception generated by the call if the status is FAILURE.
   * The exception object can be introspected for more information.
   * The <code>data</code> member can be QIed to a 
   * <code>nsISOAPFault</code> instance for calls that use a
   * SOAP binding.
   */
  nsIException getPendingException();

  /**
   * The WSDL operation that correpsonds to the method being invoked.
   *
   * @see nsIWSDLOperation
   */
  nsIWSDLOperation getOperation();

  /**
   * Called to abort a pending call. If the call is still pending,
   * its callback instance's <code>onError</code> will be invoked,
   * passing in the specified exception.
   *
   * @param error The exception passed to the callback instance's
   *              <code>onError</code> method.
   */
  void abort(nsIException error);

}