/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-central-win32-xulrunner/build/toolkit/components/places/public/nsIFaviconService.idl
 */

package org.mozilla.interfaces;

public interface nsIFaviconService extends nsISupports {

  String NS_IFAVICONSERVICE_IID =
    "{66f6b992-e2d3-43da-ba2a-d966e34a7654}";

  /**
   * Declares that a given page uses a favicon with the given URI.
   *
   * You needn't have specified any data at this point. An entry linking the
   * favicon with the page will be create with no data. You can populate it
   * later with SetFaviconData.  However, any favicons not associated with a
   * visited web page, a bookmark, or a "place:" URI will be expired when
   * history cleanup is done * (typically at app shutdown, but also possibly
   * if the user clears their * cache or history).
   *
   * This will send out history notifications if the new favicon has any data.
   * This means that you should try to set data first if you have it, otherwise
   * the page might not get a notification sent for it since data setting does
   * not send notifications.
   *
   * @param aPageURI
   *        URI of the page whose favicon is being set.
   * @param aFaviconURI
   *        URI of the favicon to associate with the page.
   */
  void setFaviconUrlForPage(nsIURI aPageURI, nsIURI aFaviconURI);

  /**
   * Same as SetFaviconUrlForPage except that this also attempts to set the
   * data by loading the favicon URI. An async request will be created for
   * this URI and if the data is available, it will asynchronously get
   * saved in the database without any further work from the caller.
   *
   * If the icon data already exists, we won't normally try to re-load the
   * icon from the net (or more likely the cache). If the icon is in the
   * failed favicon cache we won't do anything. Use forceReload to force
   * a reload of the data. This will remove the favicon from the failed
   * cache. If it then fails again, it will be re-added to the failed cache.
   *
   * SetFaviconUrlForPage and SetFaviconData will take any URI you provide
   * and save it. This function is intended for automatic usage, and will
   * only save favicons for "good" URIs, as defined by what gets added to
   * history. For "bad" URIs, this function will succeed and do nothing.
   * This function will also ignore the error page favicon URI
   * (chrome://global/skin/icons/warning-16.png). Icons that fail to load
   * will automatically be added to the failed favicon cache.
   *
   * This function will not save favicons for non-bookmarked URIs when
   * history is disabled (expiration time is 0 days). The rest of the functions
   * here will always store favicons even when history is disabled.
   *
   * @param aPageURI
   *        URI of the page whose favicon is being set.
   * @param aFaviconURI
   *        URI of the favicon to associate with the page.
   * @param aForceReload
   *        Unset is normal behavior, we will only try to reload the favicon
   *        if we don't have it or if it has expired from the cache. If set,
   *        it will always try to reload the favicon.
   */
  void setAndLoadFaviconForPage(nsIURI aPageURI, nsIURI aFaviconURI, boolean aForceReload);

  /**
   * Stores the data of a given favicon. You must specify the MIME type
   * unless you're clearing the data.
   *
   * You can set the data even if you haven't called SetFaviconUrlForPage
   * yet. It will be stored but will not be associated with any page.
   * However, any favicons not associated with a visited web page, bookmark,
   * or "place:" URI will be expired when history cleanup is done. This might
   * be done at any time on a timer, so you should not let the message loop
   * run between calls or your icon may get deleted.
   *
   * It is best to set the favicon data, and then associate it with a page.
   * This will make the notifications more efficient since the icon will
   * already have data when the set favicon observer messages goes out.
   *
   * The expiration time is stored. This will be used if you call
   * SetAndLoadFaviconForPage to see whether the data needs reloading.
   *
   * Do not use this function for chrome: icon URIs. You should reference the
   * chrome image yourself. The GetFaviconLinkForIcon/Page will ignore any
   * associated data if the favicon URI is "chrome:" and just return the same
   * chrome URI.
   *
   * This function does NOT send out notifications that the data has changed.
   * Potentially, many pages could be referencing the favicon and they could
   * be visible in a history view or toolbar. But sending out those
   * notifications is very intensive. Those pages will keep the old icon
   * until they have been refreshed by other means.
   *
   * This function tries to optimize the favicon size, if it is bigger
   * than defined limit we will try to convert it to a 16x16 png image. If the
   * conversion fails and favicon is bigger than our max accepted favicon size
   * we will fail and the favicon won't be saved.
   *
   * @param aFaviconURI
   *        URI of the favicon whose data is being set.
   * @param aData
   *        Binary contents of the favicon to save
   * @param aDataLength
   *        Length of binary data
   * @param aMimeType
   *        MIME type of the data to store. This is important so that we know
   *        what to report when the favicon is used.
   * @param aExpiration
   *        Time in microseconds since the epoch when this favicon expires.
   *        Until this time, we won't try to load it again.
   * @throws NS_ERROR_FAILURE
   *         Thrown if the favicon is overbloated and won't be saved to the db.
   */
  void setFaviconData(nsIURI aFaviconURI, byte[] aData, long aDataLen, String aMimeType, double aExpiration);

  /**
   * Stores the data of a given favicon. The data is provided by a string
   * containing a data URL.
   *
   * This function tries to optimize the favicon size, if it is bigger
   * than defined limit we will try to convert it to a 16x16 png image. If the
   * conversion fails and favicon is bigger than our max accepted favicon size
   * we will fail and the favicon won't be saved.
   *
   * @see setFaviconData
   *
   * @param aFaviconURI
   *        URI of the favicon whose data is being set.
   * @param aDataURL
   *        string containing a data URL that represents the contents of
   *        the favicon to save
   * @param aExpiration
   *        Time in microseconds since the epoch when this favicon expires.
   *        Until this time, we won't try to load it again.
   * @throws NS_ERROR_FAILURE
   *         Thrown if the favicon is overbloated and won't be saved to the db.
   */
  void setFaviconDataFromDataURL(nsIURI aFaviconURI, String aDataURL, double aExpiration);

  /**
   * Retrieves the given favicon data. Throws if we don't have data.
   *
   * If there is no data but we have an entry for this favicon, aDataLen will
   * be 0 and aData will be NULL.
   *
   * @param aFaviconURI
   *        URI of the favicon whose data is being read
   * @param aData
   *        Output parameter where the binary favicon data will be placed.
   *        This will be null if we have this URI but have no data associated
   *        with it.
   * @param aDataLen
   *        Output parameter where the size of the binary data will be placed.
   * @param aMimeType
   *        Output parameter where the MIME type will be placed.
   * @throws NS_ERROR_NOT_AVAILABLE
   *         Thrown when we have never heard of this favicon URI.
   */
  byte[] getFaviconData(nsIURI aFaviconURI, String[] aMimeType, long[] aDataLen);

  /**
   * Retrieves the given favicon data as a data URL. Throws if we don't
   * have data.
   *
   * If there is no data but we have an entry for this favicon, the return
   * value will be NULL.
   * 
   * @see getFaviconData
   *
   * @param aFaviconURI
   *        URI of the favicon whose data is being read
   * @returns A data URL containing the data of the favicon. This will be
   *          null if we have this URL but have no data associated with it.
   * @throws NS_ERROR_NOT_AVAILABLE
   *         Thrown when we have never heard of this favicon URL.
   */
  String getFaviconDataAsDataURL(nsIURI aFaviconURI);

  /**
   * Retrieves the URI of the favicon for the given page.
   *
   * @param aPageURI
   *        URI of the page whose favicon is desired
   * @returns The URI of the favicon associated with that page. Returning a
   *          URI here does NOT mean that we have data for this favicon, only
   *          that we know what the favicon should be.
   * @throws NS_ERROR_NOT_AVAILABLE
   *         When the page is not found or it has no favicon.
   */
  nsIURI getFaviconForPage(nsIURI aPageURI);

  /**
   * For a given page, this will give you a URI that, when displayed in chrome,
   * will result in the given page's favicon. Unlike the other get functions,
   * we needn't have heard of the page or its favicon: the default one will
   * be returned in this case.
   *
   * @see getFaviconLinkForIcon
   *      This function only adds the extra level of indirection, looking up
   *      the favicon based on the page URI and using the default if not found.
   *
   * @param aPageURI
   *        URI of the page whose favicon is desired
   * @returns A URI that will give you the icon image. This is NOT the URI of
   *          the icon as set on the page, but a URI that will give you the
   *          data out of the favicon service.  For a normal page with a
   *          favicon we've stored, this will be an annotation URI which will
   *          then cause the corresponding favicon data to be loaded from this
   *          service. For pages where we don't have a favicon, this will be a
   *          chrome URI of the default icon for a web page.
   */
  nsIURI getFaviconImageForPage(nsIURI aPageURI);

  /**
   * For a given icon URI, this will return a URI that will result in the image.
   * In most cases, this is an annotation URI. For chrome, this will do nothing
   * and return the input URI. For NULL input, this will return the URI of
   * the default favicon.
   *
   * @param aFaviconURI
   *        The URI of an icon in the favicon service. Can be NULL.
   * @returns A URI that will load the desired icon. This is NOT the URI of the
   *          icon as set on the page, but a URI that will give you the data
   *          out of the favicon service. For a normal page with a favicon
   *          we've stored, this will be an annotation URI which will then
   *          cause the corresponding favicon data to be loaded from this
   *          service. For pages where we don't have a favicon, this will be a
   *          chrome URI of the default icon for a web page. For chrome, the
   *          output will be the same as the input. For NULL input, this will
   *          be the URI of the default favicon.
   *
   *          No validity checking is done. If you pass an icon URI that we've
   *          never seen, you'll get back a URI that references an invalid
   *          icon. The moz-anno protocol handler's special case for "favicon"
   *          annotations will detect most invalid icons and it will resolve to
   *          the default icon, although without caching. For invalid chrome
   *          URIs, you'll get a broken image.
   */
  nsIURI getFaviconLinkForIcon(nsIURI aFaviconURI);

  /**
   * Expire all known favicons from the database.
   *
   * @note This is an async method.
   *       On successful completion a "places-favicons-expired" notification is
   *       dispatched through observer's service.
   */
  void expireAllFavicons();

  /**
   * Adds a given favicon's URI to the failed favicon cache.
   *
   * The lifespan of the favicon cache is up to the caching system. This cache
   * will also be written to if you use setAndLoadFaviconForPage and it
   * encounters an error.
   *
   * @see isFailedFavicon
   */
  void addFailedFavicon(nsIURI aFaviconURI);

  /**
   * Removes the given favicon from the failed favicon cache. If the icon is
   * not in the cache, this function will silently succeed.
   */
  void removeFailedFavicon(nsIURI aFaviconURI);

  /**
   * Checks to see if this favicon is in the failed favicon cache. Returns true
   * if the favicon is in the failed cache, meaning you probably shouldn't try
   * to load it. A false return value means that it's worth trying to load it.
   * This allows you to avoid trying to load "foo.com/favicon.ico" for every
   * page on a site that doesn't have a favicon.
   */
  boolean isFailedFavicon(nsIURI aFaviconURI);

  /**
   * The default favicon URI
   */
  nsIURI getDefaultFavicon();

}