/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/buildbot/moz2-slave/mozilla-central-macosx-xulrunner/build/modules/libpr0n/public/imgIContainer.idl
 */

package org.mozilla.interfaces;

/**
 * imgIContainer is the interface that represents an image. It allows
 * access to frames as Thebes surfaces, and permits users to extract subregions
 * as other imgIContainers. It also allows drawing of images on to Thebes
 * contexts.
 *
 * Internally, imgIContainer also manages animation of images.
 */
public interface imgIContainer extends nsISupports {

  String IMGICONTAINER_IID =
    "{74c63935-b54f-43a4-9449-2e9c815e3bef}";

  /**
   * The width of the container rectangle.
   */
  int getWidth();

  /**
   * The height of the container rectangle.
   */
  int getHeight();

  /**
   * Whether this image is animated.
   */
  boolean getAnimated();

  /**
   * Whether the current frame is opaque; that is, needs the background painted
   * behind it.
   */
  boolean getCurrentFrameIsOpaque();

  /**
   * Flags for imgIContainer operations.
   *
   * Meanings:
   *
   * FLAG_NONE: Lack of flags
   *
   * FLAG_SYNC_DECODE: Forces synchronous/non-progressive decode of all
   * available data before the call returns.
   */
  int FLAG_NONE = 0;

  int FLAG_SYNC_DECODE = 1;

  /**
    * Constants for specifying various "special" frames.
    *
    * FRAME_FIRST: The first frame
    * FRAME_CURRENT: The current frame
    *
    * FRAME_MAX_VALUE should be set to the value of the maximum constant above,
    * as it is used for ensuring that a valid value was passed in.
    */
  long FRAME_FIRST = 0L;

  long FRAME_CURRENT = 1L;

  long FRAME_MAX_VALUE = 1L;

  void requestDecode();

  /**
    * Increments the lock count on the image. An image will not be discarded
    * as long as the lock count is nonzero. Note that it is still possible for
    * the image to be undecoded if decode-on-draw is enabled and the image
    * was never drawn.
    *
    * Upon instantiation images have a lock count of zero.
    */
  void lockImage();

  /**
    * Decreases the lock count on the image. If the lock count drops to zero,
    * the image is allowed to discard its frame data to save memory.
    *
    * Upon instantiation images have a lock count of zero. It is an error to
    * call this method without first having made a matching lockImage() call.
    * In other words, the lock count is not allowed to be negative.
    */
  void unlockImage();

  /************ Internal libpr0n use only below here. *****************/
/**
   * Flags for imgIContainer initialization.
   *
   * Meanings:
   *
   * INIT_FLAG_NONE: Lack of flags
   *
   * INIT_FLAG_DISCARDABLE: The container should be discardable
   *
   * INIT_FLAG_DECODE_ON_DRAW: The container should decode on draw rather than
   * decoding on load.
   *
   * INIT_FLAG_MULTIPART: The container will be used to display a stream of
   * images in a multipart channel. If this flag is set, INIT_FLAG_DISCARDABLE
   * and INIT_FLAG_DECODE_ON_DRAW must not be set.
   */
  int INIT_FLAG_NONE = 0;

  int INIT_FLAG_DISCARDABLE = 1;

  int INIT_FLAG_DECODE_ON_DRAW = 2;

  int INIT_FLAG_MULTIPART = 4;

  /**
   * Creates a new image container.
   *
   * @param aObserver Observer to send decoder and animation notifications to.
   * @param aMimeType The mimetype of the image.
   * @param aFlags Initialization flags of the INIT_FLAG_* variety.
   */
  void init(imgIDecoderObserver aObserver, String aMimeType, long aFlags);

  /** 
   * "Disposal" method indicates how the image should be handled before the
   *  subsequent image is displayed.
   *  Don't change these without looking at the implementations using them,
   *  struct gif_struct::disposal_method and gif_write() in particular.
   */
  int kDisposeClearAll = -1;

  int kDisposeNotSpecified = 0;

  int kDisposeKeep = 1;

  int kDisposeClear = 2;

  int kDisposeRestorePrevious = 3;

  int kBlendSource = 0;

  int kBlendOver = 1;

  /**
   * Animation mode Constants
   *   0 = normal
   *   1 = don't animate
   *   2 = loop once
   */
  short kNormalAnimMode = 0;

  short kDontAnimMode = 1;

  short kLoopOnceAnimMode = 2;

  int getAnimationMode();

  void setAnimationMode(int aAnimationMode);

  /**
   * The index of the current frame that would be drawn if the image was to be
   * drawn now.
   */
  long getCurrentFrameIndex();

  /**
   * The total number of frames in this image.
   */
  long getNumFrames();

  /**
   * The size, in bytes, occupied by the significant data portions of the image.
   * This includes both compressed source data and decoded frames.
   */
  long getDataSize();

  void setFrameDisposalMethod(long framenumber, int aDisposalMethod);

  void setFrameBlendMethod(long framenumber, int aBlendMethod);

  void setFrameTimeout(long framenumber, int aTimeout);

  void setFrameHasNoAlpha(long framenumber);

  void endFrameDecode(long framenumber);

  void decodingComplete();

  void startAnimation();

  void stopAnimation();

  void resetAnimation();

  /**
   * number of times to loop the image.
   * @note -1 means forever.
   */
  int getLoopCount();

  /**
   * number of times to loop the image.
   * @note -1 means forever.
   */
  void setLoopCount(int aLoopCount);

}