/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/moz2_slave/mozilla-central-macosx-xulrunner/build/modules/libpr0n/public/imgIDecoder.idl
 */

package org.mozilla.interfaces;

/**
 * imgIDecoder interface
 *
 * @author Stuart Parmenter <pavlov@netscape.com>
 * @version 0.2
 * @see imagelib2
 */
public interface imgIDecoder extends nsISupports {

  String IMGIDECODER_IID =
    "{139c6f97-cd2f-4a4f-890d-8d9f4a693682}";

  /**
   * Bits that can be passed to the decoder to affect decoding.
   * @name decodeflags
   *
   * Meanings:
   *
   * DECODER_FLAG_NONE: No flags
   *
   * DECODER_FLAG_HEADERONLY: Read basic data from the image in order to 
   * set up the image container,  but don't read any actual image data.
   */
  int DECODER_FLAG_NONE = 0;

  int DECODER_FLAG_HEADERONLY = 1;

  /**
   * Initialize an image decoder.
   * @param aContainer The image container to decode to.
   * @param aObserver The observer for decode notification events.
   * @param aFlags Flags for the decoder
   *
   * @note The decoder should always pass NULL as the 
   * first two parameters to all of the imgIDecoderObserver APIs.
   */
  void init(imgIContainer aImage, imgIDecoderObserver aObserver, long aFlags);

  /** 
   * Closes the stream.
   * @param aFlags Close flags of the CLOSE_FLAG_* Variety
   *
   * Resources are always freed with this call. If notifications are sent,
   * OnStopDecode is guaranteed to be called if it hasn't been called already.
   *
   * CLOSE_FLAG_DONTNOTIFY - Don't send any observer notifications, and don't
   * call imgIContainer::decodingComplete().
   */
  int CLOSE_FLAG_DONTNOTIFY = 1;

  void close(long aFlags);

  /**
   * Flushes the stream.
   */
  void flush();

  /**
   * Writes data into the stream from an input stream.
   *
   * For Header-Only decodes, OnStartContainer is the only notification
   * fired.
   *
   * If a decoding error occurs, an internal flag is set and an error is
   * returned. Each subsequent call to writeFrom will fail immediately
   * for the lifetime of the decoder. Shutdown notifications of the OnStopX
   * variety, as well as DecodingComplete(), are guaranteed not to be called
   * if a decoding error occurs.
   *
   * Implementer's note: This method is defined by this interface in order
   * to allow the output stream to efficiently copy the data from the input
   * stream into its internal buffer (if any). If this method was provide
   * as an external facility, a separate char* buffer would need to be used
   * in order to call the output stream's other Write method.
   * @param fromStream the stream from which the data is read
   * @param count the maximun number of bytes to write
   */
  void writeFrom(nsIInputStream inStr, long count);

}