/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/Xr-Mozilla1.9-Release/Darwin_8.8.4_Depend/mozilla/modules/libjar/nsIZipReader.idl
 */

package org.mozilla.interfaces;

public interface nsIZipReader extends nsISupports {

  String NS_IZIPREADER_IID =
    "{5cce7f53-23b3-47f8-be05-122c0ba703fd}";

  /**
     * Opens a zip file for reading.
     * It is allowed to open with another file, 
     * but it needs to be closed first with close().
     */
  void open(nsIFile zipFile);

  /**
     * The file that represents the zip with which this zip reader was
     * initialized.
     */
  nsIFile getFile();

  /**
     * Closes a zip reader. Subsequent attempts to extract files or read from
     * its input stream will result in an error.
     */
  void close();

  /**
     * Tests the integrity of the archive by performing a CRC check 
     * on each item expanded into memory.  If an entry is specified
     * the integrity of only that item is tested.  If NULL is passed 
     * in the integrity of all items in the archive are tested.  
     */
  void test(String aEntryName);

  /**
     * Extracts a zip entry into a local file specified by outFile.
     * The entry must be stored in the zip in either uncompressed or
     * DEFLATE-compressed format for the extraction to be successful.
     * If the entry is a directory, the directory will be extracted
     * non-recursively.
     */
  void extract(String zipEntry, nsIFile outFile);

  /**
     * Returns a nsIZipEntry describing a specified zip entry.
     */
  nsIZipEntry getEntry(String zipEntry);

  /**
     * Checks whether the zipfile contains an entry specified by entryName.
     */
  boolean hasEntry(String zipEntry);

  /**
     * Returns a string enumerator containing the matching entry names.
     *
     * @param aPattern
     *   A globbing pattern used to find matching names in the zip file.
     *   Set this parameter to null to get all entries; otherwise, use the
     *   following syntax:
     *
     *   o * matches anything
     *   o ? matches one character
     *   o $ matches the end of the string
     *   o [abc] matches one occurrence of a, b, or c. 
     *   o [^az] matches any character except a or z.  Between brackets,
     *           the only characters that must be escaped are \ and ].  
     *   o [a-z] matches any character between a and z, inclusive.  
     *           The a and z characters must be alphanumeric ASCII characters.
     *           If one is upper case and one is lower case, then the ASCII
     *           non-alphanumeric characters between Z and a will be in range.
     *   o [^a-z] matches any character except those between a and z, inclusive.
     *            These forms cannot be combined, e.g [a-gp-z] does not work.
     *   o yes~no returns matches to the pattern 'yes' that do not also match
     *            the pattern 'no'.  This may be used to filter the results
     *            of one pattern to remove all matches of a second pattern.
     *            Only the outer-most pattern may use this, and at most once.
     *            For example: *~abc will match any string except abc .
     *   o (foo|bar) will match either the pattern foo or the pattern bar.
     *            At least one pipe and two inner patterns are required. 
     *            More are allowed. These inner patterns may NOT use the 
     *            'yes~no' syntax described immediately above, and may not 
     *            contain patterns of this same (foo|bar) form.
     *   o \ will escape a special character.  To treat special characters as
     *            ordinary matching characters, escaping is required for all
     *            special characters, unless otherwise specified above.
     *   o All other characters match case-sensitively.
     *
     *   An aPattern not conforming to this syntax has undefined behavior.
     *
     * @throws NS_ERROR_ILLEGAL_VALUE on many but not all invalid aPattern
     *                                values.
     */
  nsIUTF8StringEnumerator findEntries(String aPattern);

  /**
     * Returns an input stream containing the contents of the specified zip
     * entry.
     * @param zipEntry the name of the entry to open the stream from
     */
  nsIInputStream getInputStream(String zipEntry);

  /**
     * Returns an input stream containing the contents of the specified zip
     * entry. If the entry refers to a directory (ends with '/'), a directory stream 
     * is opened, otherwise the contents of the file entry is returned.
     * @param aJarSpec the Spec of the URI for the JAR (only used for directory streams)
     * @param zipEntry the name of the entry to open the stream from
     */
  nsIInputStream getInputStreamWithSpec(String aJarSpec, String zipEntry);

}