/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/slave/mozilla-central-macosx-xulrunner/build/dom/interfaces/base/nsIContentPrefService.idl
 */

package org.mozilla.interfaces;

public interface nsIContentPrefService extends nsISupports {

  String NS_ICONTENTPREFSERVICE_IID =
    "{b3976fa1-189f-4fcb-9c3b-49d1f6d8073d}";

  /**
   * Get a pref.
   *
   * Besides the regular string, integer, boolean, etc. values, this method
   * may return null (nsIDataType::VTYPE_EMPTY), which means the pref is set
   * to NULL in the database, as well as undefined (nsIDataType::VTYPE_VOID),
   * which means there is no record for this pref in the database.
   *
   * @param    aGroup      the group for which to get the pref, as an nsIURI
   *                       from which the hostname will be used, a string
   *                       (typically in the format of a hostname), or null 
   *                       to get the global pref (applies to all sites)
   * @param    aName       the name of the pref to get
   *
   * @returns  the value of the pref
   * @throws   NS_ERROR_ILLEGAL_VALUE if aGroup is not a string, nsIURI, or null
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  nsIVariant getPref(nsIVariant aGroup, String aName);

  /**
   * Set a pref.
   *
   * @param    aGroup      the group for which to set the pref, as an nsIURI
   *                       from which the hostname will be used, a string
   *                       (typically in the format of a hostname), or null
   *                       to set the global pref (applies to all sites)
   * @param    aName       the name of the pref to set
   * @param    aValue      the new value of the pref
   * @throws   NS_ERROR_ILLEGAL_VALUE if aGroup is not a string, nsIURI, or null
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  void setPref(nsIVariant aGroup, String aName, nsIVariant aValue);

  /**
   * Check whether or not a pref exists.
   *
   * @param    aGroup      the group for which to check for the pref, as an nsIURI
   *                       from which the hostname will be used, a string
   *                       (typically in the format of a hostname), or null
   *                       to check for the global pref (applies to all sites)
   * @param    aName       the name of the pref to check for
   * @throws   NS_ERROR_ILLEGAL_VALUE if aGroup is not a string, nsIURI, or null
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  boolean hasPref(nsIVariant aGroup, String aName);

  /**
   * Remove a pref.
   *
   * @param    aGroup      the group for which to remove the pref, as an nsIURI
   *                       from which the hostname will be used, a string
   *                       (typically in the format of a hostname), or null
   *                       to remove the global pref (applies to all sites) 
   * @param    aName       the name of the pref to remove
   * @throws   NS_ERROR_ILLEGAL_VALUE if aGroup is not a string, nsIURI, or null
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  void removePref(nsIVariant aGroup, String aName);

  /**
   * Remove all grouped prefs.  Useful for removing references to the sites
   * the user has visited when the user clears their private data.
   */
  void removeGroupedPrefs();

  /**
   * Remove all prefs with the given name.
   *
   * @param    aName        the setting name for which to remove prefs
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  void removePrefsByName(String aName);

  /**
   * Get the prefs that apply to the given site.
   *
   * @param    aGroup      the group for which to retrieve prefs, as an nsIURI
   *                       from which the hostname will be used, a string
   *                       (typically in the format of a hostname), or null
   *                       to get the global prefs (apply to all sites) 
   * 
   * @returns  a property bag of prefs
   * @throws   NS_ERROR_ILLEGAL_VALUE if aGroup is not a string, nsIURI, or null
   */
  nsIPropertyBag2 getPrefs(nsIVariant aGroup);

  /**
   * Get the prefs with the given name.
   *
   * @param    aName        the setting name for which to retrieve prefs
   * 
   * @returns  a property bag of prefs
   * @throws   NS_ERROR_ILLEGAL_VALUE if aName is null or an empty string
   */
  nsIPropertyBag2 getPrefsByName(String aName);

  /**
   * Add an observer.
   * 
   * @param    aName       the setting to observe, or null to add
   *                       a generic observer that observes all settings
   * @param    aObserver   the observer to add
   */
  void addObserver(String aName, nsIContentPrefObserver aObserver);

  /**
   * Remove an observer.
   *
   * @param    aName       the setting being observed, or null to remove
   *                       a generic observer that observes all settings
   * @param    aObserver   the observer to remove
   */
  void removeObserver(String aName, nsIContentPrefObserver aObserver);

  /**
   * The component that the service uses to determine the groups to which
   * URIs belong.  By default this is the "hostname grouper", which groups
   * URIs by full hostname (a.k.a. site).
   */
  nsIContentURIGrouper getGrouper();

  /**
   * The database connection to the content preferences database.
   * Useful for accessing and manipulating preferences in ways that are caller-
   * specific or for which there is not yet a generic method, although generic
   * functionality useful to multiple callers should generally be added to this
   * unfrozen interface.  Also useful for testing the database creation
   * and migration code.
   */
  mozIStorageConnection getDBConnection();

}