/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CPanel;
import apple.awt.GraphicsClipper;
import apple.awt.MyCToolkit;
import apple.awt.PeerImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.awt.RepaintArea;
import sun.java2d.SunGraphics2D;

public class MyCPanel
extends CPanel {
    protected static boolean showDebugInfo = false;
    protected AppletFrame ancestor = null;

    public static MyCPanel createNew(Panel panel, AppletFrame appletFrame) {
        MyCPanel myCPanel = new MyCPanel(panel);
        myCPanel.setAncestor(appletFrame);
        myCPanel.initPeer();
        return myCPanel;
    }

    public MyCPanel(Component component) {
        super(component);
        if (showDebugInfo) {
            System.err.println("Called MyCPanel(): Component (" + (component == null ? "null" : component.toString()) + ")");
        }
    }

    public void setAncestor(AppletFrame appletFrame) {
        this.ancestor = appletFrame;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            return;
        }
        if (!(aWTEvent instanceof PaintEvent)) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (this.ancestor == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (!AppletHandlerFactory.isAppletViewDisplayable(this.ancestor.getCocoaParentView())) {
            if (showDebugInfo) {
                System.err.println("MyCPanel handleEvent(): Skipping paint event because applet invisible");
            }
            return;
        }
        if (this.ancestor.updatesOff) {
            if (showDebugInfo) {
                System.err.println("MyCPanel handleEvent(): Skipping paint event because updates off");
            }
            return;
        }
        Rectangle rectangle = this.ancestor.translateCurrentClip(MyCToolkit.getPeerTarget((PeerImpl)this));
        Rectangle rectangle2 = ((PaintEvent)aWTEvent).getUpdateRect();
        if (rectangle2 == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        rectangle = rectangle.intersection(rectangle2);
        if (showDebugInfo) {
            System.err.println("MyCPanel handleEvent(): updateRect clipped from " + rectangle2.toString() + " to " + rectangle.toString());
        }
        if (!rectangle.isEmpty()) {
            if (AppletHandlerFactory.isJava142Update1()) {
                RepaintArea repaintArea = new RepaintArea();
                repaintArea.add(rectangle, aWTEvent.getID());
                this.paintArea = repaintArea;
            }
            ((PaintEvent)aWTEvent).setUpdateRect(rectangle);
            super.handleEvent(aWTEvent);
        }
    }

    public Graphics getGraphics() {
        SunGraphics2D sunGraphics2D = (SunGraphics2D)super.getGraphics();
        GraphicsClipper graphicsClipper = null;
        try {
            Object[] objectArray = new Object[]{sunGraphics2D, this.ancestor, this};
            graphicsClipper = (GraphicsClipper)AppletHandlerFactory.graphicsClipperCreateNew.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            System.err.println("MyCPanel getGraphics(): exception: " + throwable.getMessage());
            throwable.printStackTrace();
            return sunGraphics2D;
        }
        graphicsClipper.validateDevClip();
        return sunGraphics2D;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }
}

