/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/moz2_slave/mozilla-central-linux-xulrunner/build/toolkit/components/places/public/nsIMicrosummaryService.idl
 */

package org.mozilla.interfaces;

public interface nsIMicrosummaryService extends nsISupports {

  String NS_IMICROSUMMARYSERVICE_IID =
    "{d58143a2-74fa-4b13-94ed-113af8936d80}";

  /**
     * Return a microsummary generator for the given URI.
     *
     * @param   generatorURI
     *          the URI of the generator
     *
     * @returns an nsIMicrosummaryGenerator for the given URI.
     *
     */
  nsIMicrosummaryGenerator getGenerator(nsIURI generatorURI);

  /**
     * Install the microsummary generator from the resource at the supplied URI.
     * Callable by content via the addMicrosummaryGenerator() sidebar method.
     *
     * @param   generatorURI
     *          the URI of the resource providing the generator
     *
     */
  void addGenerator(nsIURI generatorURI);

  /**
     * Install the microsummary generator in the given XML definition.
     *
     * @param   xmlDefinition
     *          an nsIDOMDocument XML document defining the generator
     *
     * @returns the newly-installed nsIMicrosummaryGenerator object
     *
     */
  nsIMicrosummaryGenerator installGenerator(nsIDOMDocument xmlDefinition);

  /**
     * Get the set of bookmarks with microsummaries.
     *
     * In the old RDF-based bookmarks datastore, bookmark IDs are nsIRDFResource
     * objects.  In the new Places-based datastore, they are nsIURI objects.
     *
     * @returns an nsISimpleEnumerator enumeration of bookmark IDs
     *
     */
  nsISimpleEnumerator getBookmarks();

  /**
     * Get the set of microsummaries available for a given page.  The set
     * might change after this method returns, since this method will trigger
     * an asynchronous load of the page in question (if it isn't already loaded)
     * to see if it references any page-specific microsummaries.
     *
     * If the caller passes a bookmark ID, and one of the microsummaries
     * is the current one for the bookmark, this method will retrieve content
     * from the datastore for that microsummary, which is useful when callers
     * want to display a list of microsummaries for a page that isn't loaded,
     * and they want to display the actual content of the selected microsummary
     * immediately (rather than after the content is asynchronously loaded).
     *
     * @param   pageURI
     *          the URI of the page for which to retrieve available microsummaries
     *
     * @param   bookmarkID (optional)
     *          the ID of the bookmark for which this method is being called
     *
     * @returns an nsIMicrosummarySet of nsIMicrosummaries for the given page
     *
     */
  nsIMicrosummarySet getMicrosummaries(nsIURI pageURI, long bookmarkID);

  /**
     * Get the current microsummary for the given bookmark.
     *
     * @param   bookmarkID
     *          the bookmark for which to get the current microsummary
     *
     * @returns the current microsummary for the bookmark, or null
     *          if the bookmark does not have a current microsummary
     *
     */
  nsIMicrosummary getMicrosummary(long bookmarkID);

  /**
     * Create a microsummary for a given page URI and generator URI.
     *
     * @param   pageURI
     *          the URI of the page to be summarized
     *
     * @param   generatorURI
     *          the URI of the microsummary generator
     *
     * @returns an nsIMicrosummary for the given page and generator URIs.
     *
     */
  nsIMicrosummary createMicrosummary(nsIURI pageURI, nsIURI generatorURI);

  /**
     * Set the current microsummary for the given bookmark.
     *
     * @param   bookmarkID
     *          the bookmark for which to set the current microsummary
     *
     * @param   microsummary
     *          the microsummary to set as the current one
     *
     */
  void setMicrosummary(long bookmarkID, nsIMicrosummary microsummary);

  /**
     * Remove the current microsummary for the given bookmark.
     *
     * @param   bookmarkID
     *          the bookmark for which to remove the current microsummary
     *
     */
  void removeMicrosummary(long bookmarkID);

  /**
     * Whether or not the given bookmark has a current microsummary.
     *
     * @param   bookmarkID
     *          the bookmark for which to set the current microsummary
     *
     * @returns a boolean representing whether or not the given bookmark
     *          has a current microsummary
     *
     */
  boolean hasMicrosummary(long bookmarkID);

  /**
     * Whether or not the given microsummary is the current microsummary
     * for the given bookmark.
     *
     * @param   bookmarkID
     *          the bookmark to check
     *
     * @param   microsummary
     *          the microsummary to check
     *
     * @returns whether or not the microsummary is the current one
     *          for the bookmark
     *
     */
  boolean isMicrosummary(long bookmarkID, nsIMicrosummary microsummary);

  /**
     * Refresh a microsummary, updating its value in the datastore and UI.
     * If this method can refresh the microsummary instantly, it will.
     * Otherwise, it'll asynchronously download the necessary information
     * (the generator and/or page) before refreshing the microsummary.
     *
     * Callers should check the "content" property of the returned microsummary
     * object to distinguish between sync and async refreshes.  If its value
     * is "null", then it's an async refresh, and the caller should register
     * itself as an nsIMicrosummaryObserver via nsIMicrosummary.addObserver()
     * to find out when the refresh completes.
     *
     * @param   bookmarkID
     *          the bookmark whose microsummary is being refreshed
     *
     * @returns the microsummary being refreshed
     *
     */
  nsIMicrosummary refreshMicrosummary(long bookmarkID);

}