/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-1.9.3-win32-xulrunner/build/accessible/public/nsIAccessibleEvent.idl
 */

package org.mozilla.interfaces;

/**
 * An interface for accessibility events listened to
 * by in-process accessibility clients, which can be used
 * to find out how to get accessibility and DOM interfaces for
 * the event and its target. To listen to in-process accessibility invents,
 * make your object an nsIObserver, and listen for accessible-event by 
 * using code something like this:
 *   nsCOMPtr<nsIObserverService> observerService = 
 *     do_GetService("@mozilla.org/observer-service;1", &rv);
 *   if (NS_SUCCEEDED(rv)) 
 *     rv = observerService->AddObserver(this, "accessible-event", PR_TRUE);
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessibleEvent extends nsISupports {

  String NS_IACCESSIBLEEVENT_IID =
    "{5713f093-1d67-4666-b9e2-516f410976bc}";

  /**
   * An object has been created.
   */
  long EVENT_SHOW = 1L;

  /**
   * An object has been destroyed.
   */
  long EVENT_HIDE = 2L;

  /**
   * An object's children have changed
   */
  long EVENT_REORDER = 3L;

  /**
   * The active descendant of a component has changed. The active descendant
   * is used in objects with transient children.
   */
  long EVENT_ACTIVE_DECENDENT_CHANGED = 4L;

  /**
   * An object has received the keyboard focus.
   */
  long EVENT_FOCUS = 5L;

  /**
   * An object's state has changed.
   */
  long EVENT_STATE_CHANGE = 6L;

  /**
   * An object has changed location, shape, or size.
   */
  long EVENT_LOCATION_CHANGE = 7L;

  /**
   * An object's Name property has changed.
   */
  long EVENT_NAME_CHANGE = 8L;

  /**
   * An object's Description property has changed.
   */
  long EVENT_DESCRIPTION_CHANGE = 9L;

  /**
   * An object's Value property has changed.
   */
  long EVENT_VALUE_CHANGE = 10L;

  /**
   * An object's help has changed.
   */
  long EVENT_HELP_CHANGE = 11L;

  /**
   * An object's default action has changed.
   */
  long EVENT_DEFACTION_CHANGE = 12L;

  /**
   * An object's action has changed.
   */
  long EVENT_ACTION_CHANGE = 13L;

  /**
   * An object's keyboard shortcut has changed.
   */
  long EVENT_ACCELERATOR_CHANGE = 14L;

  /**
   * The selection within a container object has changed.
   */
  long EVENT_SELECTION = 15L;

  /**
   * An item within a container object has been added to the selection.
   */
  long EVENT_SELECTION_ADD = 16L;

  /**
   * An item within a container object has been removed from the selection.
   */
  long EVENT_SELECTION_REMOVE = 17L;

  /**
   * Numerous selection changes have occurred within a container object.
   */
  long EVENT_SELECTION_WITHIN = 18L;

  /**
   * An alert has been generated. Server applications send this event when a
   * user needs to know that a user interface element has changed.
   */
  long EVENT_ALERT = 19L;

  /**
   * The foreground window has changed.
   */
  long EVENT_FOREGROUND = 20L;

  /**
   * A menu item on the menu bar has been selected.
   */
  long EVENT_MENU_START = 21L;

  /**
   * A menu from the menu bar has been closed.
   */
  long EVENT_MENU_END = 22L;

  /**
   * A pop-up menu has been displayed.
   */
  long EVENT_MENUPOPUP_START = 23L;

  /**
   * A pop-up menu has been closed.
   */
  long EVENT_MENUPOPUP_END = 24L;

  /**
   * A window has received mouse capture.
   */
  long EVENT_CAPTURE_START = 25L;

  /**
   * A window has lost mouse capture.
   */
  long EVENT_CAPTURE_END = 26L;

  /**
   * A window is being moved or resized.
   */
  long EVENT_MOVESIZE_START = 27L;

  /**
  * The movement or resizing of a window has finished
  */
  long EVENT_MOVESIZE_END = 28L;

  /**
   * A window has entered context-sensitive Help mode
   */
  long EVENT_CONTEXTHELP_START = 29L;

  /**
   * A window has exited context-sensitive Help mode
   */
  long EVENT_CONTEXTHELP_END = 30L;

  /**
   * An application is about to enter drag-and-drop mode
   */
  long EVENT_DRAGDROP_START = 31L;

  /**
   * An application is about to exit drag-and-drop mode
   */
  long EVENT_DRAGDROP_END = 32L;

  /**
   * A dialog box has been displayed
   */
  long EVENT_DIALOG_START = 33L;

  /**
   * A dialog box has been closed
   */
  long EVENT_DIALOG_END = 34L;

  /**
   * Scrolling has started on a scroll bar
   */
  long EVENT_SCROLLING_START = 35L;

  /**
   * Scrolling has ended on a scroll bar
   */
  long EVENT_SCROLLING_END = 36L;

  /**
   * A window object is about to be minimized or maximized
   */
  long EVENT_MINIMIZE_START = 37L;

  /**
   * A window object has been minimized or maximized
   */
  long EVENT_MINIMIZE_END = 38L;

  /**
   * XXX:
   */
  long EVENT_DOCUMENT_LOAD_START = 39L;

  /**
   * The loading of the document has completed.
   */
  long EVENT_DOCUMENT_LOAD_COMPLETE = 40L;

  /**
   * The document contents are being reloaded.
   */
  long EVENT_DOCUMENT_RELOAD = 41L;

  /**
   * The loading of the document was interrupted.
   */
  long EVENT_DOCUMENT_LOAD_STOPPED = 42L;

  /**
   * The document wide attributes of the document object have changed.
   */
  long EVENT_DOCUMENT_ATTRIBUTES_CHANGED = 43L;

  /**
   * The contents of the document have changed.
   */
  long EVENT_DOCUMENT_CONTENT_CHANGED = 44L;

  long EVENT_PROPERTY_CHANGED = 45L;

  long EVENT_SELECTION_CHANGED = 46L;

  /**
   * A text object's attributes changed.
   * Also see EVENT_OBJECT_ATTRIBUTE_CHANGED.
   */
  long EVENT_TEXT_ATTRIBUTE_CHANGED = 47L;

  /**
   * The caret has moved to a new position.
   */
  long EVENT_TEXT_CARET_MOVED = 48L;

  /**
   * This event indicates general text changes, i.e. changes to text that is
   * exposed through the IAccessibleText and IAccessibleEditableText interfaces.
   */
  long EVENT_TEXT_CHANGED = 49L;

  /**
   * Text was inserted.
   */
  long EVENT_TEXT_INSERTED = 50L;

  /**
   * Text was removed.
   */
  long EVENT_TEXT_REMOVED = 51L;

  /**
   * Text was updated.
   */
  long EVENT_TEXT_UPDATED = 52L;

  /**
   * The text selection changed.
   */
  long EVENT_TEXT_SELECTION_CHANGED = 53L;

  /**
   * A visibile data event indicates the change of the visual appearance
   * of an accessible object.  This includes for example most of the
   * attributes available via the IAccessibleComponent interface.
   */
  long EVENT_VISIBLE_DATA_CHANGED = 54L;

  /**
   * The caret moved from one column to the next.
   */
  long EVENT_TEXT_COLUMN_CHANGED = 55L;

  /**
   * The caret moved from one section to the next.
   */
  long EVENT_SECTION_CHANGED = 56L;

  /**
   * A table caption changed.
   */
  long EVENT_TABLE_CAPTION_CHANGED = 57L;

  /**
   * A table's data changed.
   */
  long EVENT_TABLE_MODEL_CHANGED = 58L;

  /**
   * A table's summary changed.
   */
  long EVENT_TABLE_SUMMARY_CHANGED = 59L;

  /**
   * A table's row description changed.
   */
  long EVENT_TABLE_ROW_DESCRIPTION_CHANGED = 60L;

  /**
   * A table's row header changed.
   */
  long EVENT_TABLE_ROW_HEADER_CHANGED = 61L;

  long EVENT_TABLE_ROW_INSERT = 62L;

  long EVENT_TABLE_ROW_DELETE = 63L;

  long EVENT_TABLE_ROW_REORDER = 64L;

  /**
   * A table's column description changed.
   */
  long EVENT_TABLE_COLUMN_DESCRIPTION_CHANGED = 65L;

  /**
   * A table's column header changed.
   */
  long EVENT_TABLE_COLUMN_HEADER_CHANGED = 66L;

  long EVENT_TABLE_COLUMN_INSERT = 67L;

  long EVENT_TABLE_COLUMN_DELETE = 68L;

  long EVENT_TABLE_COLUMN_REORDER = 69L;

  long EVENT_WINDOW_ACTIVATE = 70L;

  long EVENT_WINDOW_CREATE = 71L;

  long EVENT_WINDOW_DEACTIVATE = 72L;

  long EVENT_WINDOW_DESTROY = 73L;

  long EVENT_WINDOW_MAXIMIZE = 74L;

  long EVENT_WINDOW_MINIMIZE = 75L;

  long EVENT_WINDOW_RESIZE = 76L;

  long EVENT_WINDOW_RESTORE = 77L;

  /**
   * The ending index of this link within the containing string has changed.
   */
  long EVENT_HYPERLINK_END_INDEX_CHANGED = 78L;

  /**
   * The number of anchors assoicated with this hyperlink object has changed.
   */
  long EVENT_HYPERLINK_NUMBER_OF_ANCHORS_CHANGED = 79L;

  /**
   * The hyperlink selected state changed from selected to unselected or
   * from unselected to selected.
   */
  long EVENT_HYPERLINK_SELECTED_LINK_CHANGED = 80L;

  /**
   * One of the links associated with the hypertext object has been activated.
   */
  long EVENT_HYPERTEXT_LINK_ACTIVATED = 81L;

  /**
   * One of the links associated with the hypertext object has been selected.
   */
  long EVENT_HYPERTEXT_LINK_SELECTED = 82L;

  /**
   * The starting index of this link within the containing string has changed.
   */
  long EVENT_HYPERLINK_START_INDEX_CHANGED = 83L;

  /**
   * Focus has changed from one hypertext object to another, or focus moved
   * from a non-hypertext object to a hypertext object, or focus moved from a
   * hypertext object to a non-hypertext object.
   */
  long EVENT_HYPERTEXT_CHANGED = 84L;

  /**
   * The number of hyperlinks associated with a hypertext object changed.
   */
  long EVENT_HYPERTEXT_NLINKS_CHANGED = 85L;

  /**
   * An object's attributes changed. Also see EVENT_TEXT_ATTRIBUTE_CHANGED.
   */
  long EVENT_OBJECT_ATTRIBUTE_CHANGED = 86L;

  /**
   * A slide changed in a presentation document or a page boundary was
   * crossed in a word processing document.
   */
  long EVENT_PAGE_CHANGED = 87L;

  /**
   * Used internally in Gecko.
   */
  long EVENT_INTERNAL_LOAD = 88L;

  /**
   * Help make sure event map does not get out-of-line.
   */
  long EVENT_LAST_ENTRY = 89L;

  /**
   * The type of event, based on the enumerated event values
   * defined in this interface.
   */
  long getEventType();

  /**
   * The nsIAccessible associated with the event.
   * May return null if no accessible is available
   */
  nsIAccessible getAccessible();

  /**
   * The nsIAccessibleDocument that the event target nsIAccessible
   * resides in. This can be used to get the DOM window,
   * the DOM document and the window handler, among other things.
   */
  nsIAccessibleDocument getAccessibleDocument();

  /**
   * The nsIDOMNode associated with the event
   * May return null if accessible for event has been shut down
   */
  nsIDOMNode getDOMNode();

  /**
   * Returns true if the event was caused by explicit user input,
   * as opposed to purely originating from a timer or mouse movement
   */
  boolean getIsFromUserInput();

  /**
   * Returns true if the event was caused by explicit user input,
   * as opposed to purely originating from a timer or mouse movement
   */
  void setIsFromUserInput(boolean aIsFromUserInput);

}