/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-1.9.3-win32-xulrunner/build/accessible/public/nsIAccessibleRetrieval.idl
 */

package org.mozilla.interfaces;

/**
 * An interface for in-process accessibility clients
 * wishing to get an nsIAccessible or nsIAccessNode for
 * a given DOM node.
 * More documentation at:
 *   http://www.mozilla.org/projects/ui/accessibility
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessibleRetrieval extends nsISupports {

  String NS_IACCESSIBLERETRIEVAL_IID =
    "{3e5cbd5c-dbab-4ea3-b82b-4cd6201d6fe0}";

  /**
   * Return application accessible.
   */
  nsIAccessible getApplicationAccessible();

  /**
   * Return an nsIAccessible for a DOM node in pres shell 0.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode The DOM node to get an accessible for.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleFor(nsIDOMNode aNode);

  /**
   * The same like getAccessibleFor method except it returns accessible only if
   * it is attached, i.e. accessible is certified to be a descendent of the root
   * accessible.
   *
   * @param aNode - the DOM node to get an accessible for.
   *
   * @return - the accessible for the given DOM node.
   */
  nsIAccessible getAttachedAccessibleFor(nsIDOMNode aNode);

  /**
   * Return an DOM node that is relevant to attached accesible check. This
   * node is either from bindings chain if given node is anonymous and owner
   * binding denies accessible in anonymous content or given node (it's not
   * important whether it is accessible or not). This method doesn't create
   * accessible object for returned node.
   *
   * @param aNode - the DOM node to get relevant content node.
   *
   * @return - the DOM node for parent attached accessible
   */
  nsIDOMNode getRelevantContentNodeFor(nsIDOMNode aNode);

  /**
    * Returns accessible role as a string.
    *
    * @param aRole - the accessible role constants.
    */
  String getStringRole(long aRole);

  /**
    * Returns list which contains accessible states as a strings.
    *
    * @param aStates - accessible states.
    * @param aExtraStates - accessible extra states.
    */
  nsIDOMDOMStringList getStringStates(long aStates, long aExtraStates);

  /**
   * Get the type of accessible event as a string.
   *
   * @param aEventType - the accessible event type constant
   * @return - accessible event type presented as human readable string
   */
  String getStringEventType(long aEventType);

  /**
   * Get the type of accessible relation as a string.
   *
   * @param aRelationType - the accessible relation type constant
   * @return - accessible relation type presented as human readable string
   */
  String getStringRelationType(long aRelationType);

}