/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-1.9.3-win32-xulrunner/build/widget/public/nsIWinTaskbar.idl
 */

package org.mozilla.interfaces;

public interface nsIWinTaskbar extends nsISupports {

  String NS_IWINTASKBAR_IID =
    "{a25ad3ed-1ded-4473-bb6e-bf8b89d88949}";

  /**
   * Returns true if the operating system supports Win7+ taskbar features.
   * This property acts as a replacement for in-place os version checking.
   */
  boolean getAvailable();

  /**
   * Returns the default application user model identity the application
   * registers with the system. This id is used by the taskbar in grouping
   * windows and in associating pinned shortcuts with running instances and
   * jump lists.
   */
  String getDefaultGroupId();

  /**
   * Taskbar window and tab preview management
   */
/**
   * Creates a taskbar preview. The docshell is used to find the toplevel window.
   * See the documentation for nsITaskbarTabPreview for more information.
   */
  nsITaskbarTabPreview createTaskbarTabPreview(nsIDocShell shell, nsITaskbarPreviewController controller);

  /**
   * Gets the taskbar preview for a window. The docshell is used to find the
   * toplevel window. See the documentation for nsITaskbarTabPreview for more
   * information.
   *
   * Note: to implement custom drawing or buttons, a controller is required.
   */
  nsITaskbarWindowPreview getTaskbarWindowPreview(nsIDocShell shell);

  /**
   * Taskbar icon progress indicator
   */
/**
   * Gets the taskbar progress for a window. The docshell is used to find the
   * toplevel window. See the documentation for nsITaskbarProgress for more
   * information.
   */
  nsITaskbarProgress getTaskbarProgress(nsIDocShell shell);

  /**
   * Taskbar and start menu jump list management
   */
/**
   * Retrieve a taskbar jump list builder
   *
   * Fails if a jump list build operation has already been initiated, developers
   * should make use of a single instance of nsIJumpListBuilder for building lists
   * within an application.
   *
   * @thow NS_ERROR_ALREADY_INITIALIZED if an nsIJumpListBuilder instance is
   * currently building a list.
   */
  nsIJumpListBuilder createJumpListBuilder();

  /**
   * Application window taskbar group settings
   */
/**
   * Set the grouping id for a window.
   *
   * The runtime sets a default, global grouping id for all windows on startup.
   * setGroupIdForWindow allows individual windows to be grouped independently
   * on the taskbar. Ids should be unique to the app and window to insure
   * conflicts with other pinned applications do no arise.
   *
   * The default group id is based on application.ini vendor, application, and
   * version values, with a format of 'vendor.app.version'. The default can be
   * retrieved via defaultGroupId.
   *
   * Note, when a window changes taskbar window stacks, it is placed at the
   * bottom of the new stack.
   *
   * @thow NS_ERROR_INVALID_ARG if the window is not a valid top level window
   * associated with a widget.
   * @thow NS_ERROR_FAILURE if the property on the window could not be set.
   * @thow NS_ERROR_UNEXPECTED for general failures.
   */
  void setGroupIdForWindow(nsIDOMWindow aParent, String aIdentifier);

}