/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/slave/mozilla-2.0-macosx-xulrunner/build/storage/public/mozIStorageStatement.idl
 */

package org.mozilla.interfaces;

/**
 * A SQL statement that can be used for both synchronous and asynchronous
 * purposes.
 */
public interface mozIStorageStatement extends mozIStorageBaseStatement {

  String MOZISTORAGESTATEMENT_IID =
    "{57ec7be1-36cf-4510-b938-7d1c9ee8cec5}";

  /**
   * Create a clone of this statement, by initializing a new statement
   * with the same connection and same SQL statement as this one.  It
   * does not preserve statement state; that is, if a statement is
   * being executed when it is cloned, the new statement will not be
   * executing.
   */
  mozIStorageStatement _clone();

  long getParameterCount();

  /**
   * Name of nth parameter, if given
   */
  String getParameterName(long aParamIndex);

  /**
   * Returns the index of the named parameter.
   *
   * @param aName
   *        The name of the parameter you want the index for.  This does not
   *        include the leading ':'.
   * @return the index of the named parameter.
   */
  long getParameterIndex(String aName);

  /**
   * Number of columns returned
   */
  long getColumnCount();

  /**
   * Name of nth column
   */
  String getColumnName(long aColumnIndex);

  /**
   * Obtains the index of the column with the specified name.
   *
   * @param aName
   *        The name of the column.
   * @return The index of the column with the specified name.
   */
  long getColumnIndex(String aName);

  /**
   * Obtains the declared column type of a prepared statement.
   *
   * @param aParamIndex
   *        The zero-based index of the column who's declared type we are
   *        interested in.
   * @return the declared index type.
   */
  String getColumnDecltype(long aParamIndex);

  /**
   * Reset parameters/statement execution
   */
  void reset();

  /**
   * Execute the query, ignoring any results.  This is accomplished by
   * calling executeStep() once, and then calling reset().
   *
   * Error and last insert info, etc. are available from
   * the mozStorageConnection.
   */
  void execute();

  /**
   * Execute a query, using any currently-bound parameters.  Reset
   * must be called on the statement after the last call of
   * executeStep.
   *
   * @return a boolean indicating whether there are more rows or not;
   *         row data may be accessed using mozIStorageValueArray methods on
   *         the statement.
   */
  boolean executeStep();

  /**
   * Execute a query, using any currently-bound parameters.  Reset is called
   * when no more data is returned.  This method is only available to JavaScript
   * consumers.
   *
   * @deprecated As of Mozilla 1.9.2 in favor of executeStep().
   *
   * @return a boolean indicating whether there are more rows or not.
   *
   * [deprecated] boolean step();
   */
/**
   * Obtains the current list of named parameters, which are settable.  This
   * property is only available to JavaScript consumers.
   *
   * readonly attribute mozIStorageStatementParams params;
   */
/**
   * Obtains the current row, with access to all the data members by name.  This
   * property is only available to JavaScript consumers.
   *
   * readonly attribute mozIStorageStatementRow row;
   */
/**
   * These type values are returned by getTypeOfIndex
   * to indicate what type of value is present at
   * a given column.
   */
  int VALUE_TYPE_NULL = 0;

  int VALUE_TYPE_INTEGER = 1;

  int VALUE_TYPE_FLOAT = 2;

  int VALUE_TYPE_TEXT = 3;

  int VALUE_TYPE_BLOB = 4;

  /**
   * The number of entries in the array (each corresponding to a column in the
   * database row)
   */
  long getNumEntries();

  /**
   * Indicate the data type of the current result row for the the given column.
   * SQLite will perform type conversion if you ask for a value as a different
   * type than it is stored as.
   *
   * @param aIndex
   *        0-based column index.
   * @return The type of the value at the given column index; one of
   *         VALUE_TYPE_NULL, VALUE_TYPE_INTEGER, VALUE_TYPE_FLOAT,
   *         VALUE_TYPE_TEXT, VALUE_TYPE_BLOB.
   */
  int getTypeOfIndex(long aIndex);

  /**
   * Retrieve the contents of a column from the current result row as an
   * integer.
   *
   * @param aIndex
   *        0-based colummn index.
   * @return Column value interpreted as an integer per type conversion rules.
   * @{
   */
  int getInt32(long aIndex);

  long getInt64(long aIndex);

  /** @} */
/**
   * Retrieve the contents of a column from the current result row as a
   * floating point double.
   *
   * @param aIndex
   *        0-based colummn index.
   * @return Column value interpreted as a double per type conversion rules.
   */
  double getDouble(long aIndex);

  /**
   * Retrieve the contents of a column from the current result row as a
   * string.
   *
   * @param aIndex
   *        0-based colummn index.
   * @return The value for the result column interpreted as a string.  If the
   *         stored value was NULL, you will get an empty string with IsVoid set
   *         to distinguish it from an explicitly set empty string.
   * @{
   */
  String getUTF8String(long aIndex);

  String getString(long aIndex);

  /** @} */
/**
   * Retrieve the contents of a column from the current result row as a
   * blob.
   *
   * @param aIndex
   *        0-based colummn index.
   * @param[out] aDataSize
   *             The number of bytes in the blob.
   * @param[out] aData
   *             The contents of the BLOB.  This will be NULL if aDataSize == 0.
   */
  void getBlob(long aIndex, long[] aDataSize, byte[][] aData);

  /**
   * Check whether the given column in the current result row is NULL.
   *
   * @param aIndex
   *        0-based colummn index.
   * @return true if the value for the result column is null.
   */
  boolean getIsNull(long aIndex);

}