/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-2.0-win32-xulrunner/build/content/base/public/nsIContentSecurityPolicy.idl
 */

package org.mozilla.interfaces;

/**
 * nsIContentSecurityPolicy  
 * Describes an XPCOM component used to model an enforce CSPs.
 */
public interface nsIContentSecurityPolicy extends nsISupports {

  String NS_ICONTENTSECURITYPOLICY_IID =
    "{ab36a2bf-cb32-4aa6-ab41-6b4e4444a221}";

  /**
   * Set to true when the CSP has been read in and parsed and is ready to
   * enforce.  This is a barrier for the nsDocument so it doesn't load any
   * sub-content until either it knows that a CSP is ready or will not be used.
   */
  boolean getIsInitialized();

  /**
   * Set to true when the CSP has been read in and parsed and is ready to
   * enforce.  This is a barrier for the nsDocument so it doesn't load any
   * sub-content until either it knows that a CSP is ready or will not be used.
   */
  void setIsInitialized(boolean aIsInitialized);

  /**
   * When set to true, content load-blocking and fail-closed are disabled: CSP
   * will ONLY send reports, and not modify behavior.
   */
  boolean getReportOnlyMode();

  /**
   * When set to true, content load-blocking and fail-closed are disabled: CSP
   * will ONLY send reports, and not modify behavior.
   */
  void setReportOnlyMode(boolean aReportOnlyMode);

  /**
   * A read-only string version of the policy for debugging.
   */
  String getPolicy();

  /**
   * Whether this policy allows in-page script.
   *
   * Calls to this may trigger violation reports when queried, so
   * this value should not be cached.
   */
  boolean getAllowsInlineScript();

  /**
   * whether this policy allows eval and eval-like functions
   * such as setTimeout("code string", time).
   *
   * Calls to this may trigger violation reports when queried, so
   * this value should not be cached.
   */
  boolean getAllowsEval();

  /**
   * Manually triggers violation report sending given a URI and reason.
   * The URI may be null, in which case "self" is sent.
   * @param blockedURI
   *     the URI that violated the policy
   * @param violatedDirective
   *     the directive that was violated.
   * @return 
   *     nothing.
   */
  void sendReports(String blockedURI, String violatedDirective);

  /**
   * Called after the CSP object is created to fill in the appropriate request
   * and request header information needed in case a report needs to be sent.
   */
  void scanRequestData(nsIHttpChannel aChannel);

  /**
   * Updates the policy currently stored in the CSP to be "refined" or
   * tightened by the one specified in the string policyString.
   */
  void refinePolicy(String policyString, nsIURI selfURI);

  /**
   * Verifies ancestry as permitted by the policy.
   *
   * Calls to this may trigger violation reports when queried, so
   * this value should not be cached.
   *
   * @param docShell
   *    containing the protected resource
   * @return
   *    true if the frame's ancestors are all permitted by policy
   */
  boolean permitsAncestry(nsIDocShell docShell);

  /**
   * Delegate method called by the service when sub-elements of the protected
   * document are being loaded.  Given a bit of information about the request,
   * decides whether or not the policy is satisfied.
   *
   * Calls to this may trigger violation reports when queried, so
   * this value should not be cached.
   */
  short shouldLoad(long aContentType, nsIURI aContentLocation, nsIURI aRequestOrigin, nsISupports aContext, String aMimeTypeGuess, nsISupports aExtra);

  /**
   * Delegate method called by the service when sub-elements of the protected
   * document are being processed.  Given a bit of information about the request,
   * decides whether or not the policy is satisfied.
   */
  short shouldProcess(long aContentType, nsIURI aContentLocation, nsIURI aRequestOrigin, nsISupports aContext, String aMimeType, nsISupports aExtra);

}