/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-central-win32-xulrunner/build/accessible/public/nsIAccessibleRetrieval.idl
 */

package org.mozilla.interfaces;

/**
 * An interface for in-process accessibility clients
 * wishing to get an nsIAccessible or nsIAccessNode for
 * a given DOM node.
 * More documentation at:
 *   http://www.mozilla.org/projects/ui/accessibility
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessibleRetrieval extends nsISupports {

  String NS_IACCESSIBLERETRIEVAL_IID =
    "{310ce77d-c92b-4761-82e8-77e1a728e8d4}";

  /**
   * Return application accessible.
   */
  nsIAccessible getApplicationAccessible();

  /**
   * Return an nsIAccessible for a DOM node in pres shell 0.
   * Create a new accessible of the appropriate type if necessary,
   * or use one from the accessibility cache if it already exists.
   * @param aNode The DOM node to get an accessible for.
   * @return The nsIAccessible for the given DOM node.
   */
  nsIAccessible getAccessibleFor(nsIDOMNode aNode);

  /**
    * Returns accessible role as a string.
    *
    * @param aRole - the accessible role constants.
    */
  String getStringRole(long aRole);

  /**
    * Returns list which contains accessible states as a strings.
    *
    * @param aStates - accessible states.
    * @param aExtraStates - accessible extra states.
    */
  nsIDOMDOMStringList getStringStates(long aStates, long aExtraStates);

  /**
   * Get the type of accessible event as a string.
   *
   * @param aEventType - the accessible event type constant
   * @return - accessible event type presented as human readable string
   */
  String getStringEventType(long aEventType);

  /**
   * Get the type of accessible relation as a string.
   *
   * @param aRelationType - the accessible relation type constant
   * @return - accessible relation type presented as human readable string
   */
  String getStringRelationType(long aRelationType);

  /**
   * Return an accessible for the given DOM node from the cache.
   * @note  the method is intended for testing purposes
   *
   * @param aNode  [in] the DOM node to get an accessible for
   *
   * @return       cached accessible for the given DOM node if any
   */
  nsIAccessible getAccessibleFromCache(nsIDOMNode aNode);

}