/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/moz2_slave/shadow-central-linux-xulrunner/build/netwerk/cookie/nsICookieManager2.idl
 */

package org.mozilla.interfaces;

/** 
 * Additions to the frozen nsICookieManager
 */
public interface nsICookieManager2 extends nsICookieManager {

  String NS_ICOOKIEMANAGER2_IID =
    "{94628d1d-8b31-4baa-b474-9c872c440f90}";

  /**
   * Add a cookie. nsICookieService is the normal way to do this. This
   * method is something of a backdoor.
   *
   * @param aHost
   *        the host or domain for which the cookie is set. presence of a
   *        leading dot indicates a domain cookie; otherwise, the cookie
   *        is treated as a non-domain cookie (see RFC2109). The host string
   *        will be normalized to ASCII or ACE; any trailing dot will be
   *        stripped. To be a domain cookie, the host must have at least two
   *        subdomain parts (e.g. '.foo.com', not '.com'), otherwise an
   *        exception will be thrown. An empty string is acceptable
   *        (e.g. file:// URI's).
   * @param aPath
   *        path within the domain for which the cookie is valid
   * @param aName
   *        cookie name
   * @param aValue
   *        cookie data
   * @param aIsSecure
   *        true if the cookie should only be sent over a secure connection.
   * @param aIsHttpOnly
   *        true if the cookie should only be sent to, and can only be
   *        modified by, an http connection.
   * @param aIsSession
   *        true if the cookie should exist for the current session only.
   *        see aExpiry.
   * @param aExpiry
   *        expiration date, in seconds since midnight (00:00:00), January 1,
   *        1970 UTC. note that expiry time will also be honored for session cookies;
   *        in this way, the more restrictive of the two will take effect.
   */
  void add(String aHost, String aPath, String aName, String aValue, boolean aIsSecure, boolean aIsHttpOnly, boolean aIsSession, long aExpiry);

  /**
   * Find whether a given cookie already exists.
   *
   * @param aCookie
   *        the cookie to look for
   *
   * @return true if a cookie was found which matches the host, path, and name
   *         fields of aCookie
   */
  boolean cookieExists(nsICookie2 aCookie);

  /**
   * Count how many cookies exist within the base domain of 'aHost'.
   * Thus, for a host "weather.yahoo.com", the base domain would be "yahoo.com",
   * and any host or domain cookies for "yahoo.com" and its subdomains would be
   * counted.
   *
   * @param aHost
   *        the host string to search for, e.g. "google.com". this should consist
   *        of only the host portion of a URI. see @add for a description of
   *        acceptable host strings.
   *
   * @return the number of cookies found.
   */
  long countCookiesFromHost(String aHost);

  /**
   * Returns an enumerator of cookies that exist within the base domain of
   * 'aHost'. Thus, for a host "weather.yahoo.com", the base domain would be
   * "yahoo.com", and any host or domain cookies for "yahoo.com" and its
   * subdomains would be returned.
   *
   * @param aHost
   *        the host string to search for, e.g. "google.com". this should consist
   *        of only the host portion of a URI. see @add for a description of
   *        acceptable host strings.
   *
   * @return an nsISimpleEnumerator of nsICookie2 objects.
   *
   * @see countCookiesFromHost
   */
  nsISimpleEnumerator getCookiesFromHost(String aHost);

  /**
   * Import an old-style cookie file. Imported cookies will be added to the
   * existing database. If the database contains any cookies the same as those
   * being imported (i.e. domain, name, and path match), they will be replaced.
   *
   * @param aCookieFile the file to import, usually cookies.txt
   */
  void importCookies(nsIFile aCookieFile);

}