/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/moz2_slave/mozilla-central-linux-xulrunner/build/modules/libpr0n/public/imgIContainer.idl
 */

#ifndef __gen_imgIContainer_h__
#define __gen_imgIContainer_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class imgIDecoderObserver; /* forward declaration */

#include "gfxImageSurface.h"
#include "gfxContext.h"
#include "gfxMatrix.h"
#include "gfxRect.h"
#include "gfxPattern.h"
#include "gfxASurface.h"
#include "nsRect.h"

/* starting interface:    imgIContainer */
#define IMGICONTAINER_IID_STR "e6984403-1253-48fa-8a16-a350f76ab6c9"

#define IMGICONTAINER_IID \
  {0xe6984403, 0x1253, 0x48fa, \
    { 0x8a, 0x16, 0xa3, 0x50, 0xf7, 0x6a, 0xb6, 0xc9 }}

/**
 * imgIContainer is the interface that represents an image. It allows
 * access to frames as Thebes surfaces, and permits users to extract subregions
 * as other imgIContainers. It also allows drawing of images on to Thebes
 * contexts.
 *
 * Internally, imgIContainer also manages animation of images.
 */
class NS_NO_VTABLE NS_SCRIPTABLE imgIContainer : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(IMGICONTAINER_IID)

  /**
   * The width of the container rectangle.
   */
  /* readonly attribute PRInt32 width; */
  NS_SCRIPTABLE NS_IMETHOD GetWidth(PRInt32 *aWidth) = 0;

  /**
   * The height of the container rectangle.
   */
  /* readonly attribute PRInt32 height; */
  NS_SCRIPTABLE NS_IMETHOD GetHeight(PRInt32 *aHeight) = 0;

  /**
   * Whether this image is animated. You can only be guaranteed that querying
   * this will not throw if STATUS_DECODE_COMPLETE is set on the imgIRequest.
   *
   * @throws NS_ERROR_NOT_AVAILABLE if the animated state cannot be determined.
   */
  /* readonly attribute boolean animated; */
  NS_SCRIPTABLE NS_IMETHOD GetAnimated(PRBool *aAnimated) = 0;

  /**
   * Whether the current frame is opaque; that is, needs the background painted
   * behind it.
   */
  /* readonly attribute boolean currentFrameIsOpaque; */
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIsOpaque(PRBool *aCurrentFrameIsOpaque) = 0;

  /**
   * Flags for imgIContainer operations.
   *
   * Meanings:
   *
   * FLAG_NONE: Lack of flags
   *
   * FLAG_SYNC_DECODE: Forces synchronous/non-progressive decode of all
   * available data before the call returns. It is an error to pass this flag
   * from a call stack that originates in a decoder (ie, from a decoder
   * observer event).
   */
  enum { FLAG_NONE = 0 };

  enum { FLAG_SYNC_DECODE = 1 };

  /**
    * Constants for specifying various "special" frames.
    *
    * FRAME_FIRST: The first frame
    * FRAME_CURRENT: The current frame
    *
    * FRAME_MAX_VALUE should be set to the value of the maximum constant above,
    * as it is used for ensuring that a valid value was passed in.
    */
  enum { FRAME_FIRST = 0U };

  enum { FRAME_CURRENT = 1U };

  enum { FRAME_MAX_VALUE = 1U };

  /**
   * Get a surface for the given frame. This may be a platform-native,
   * optimized surface, so you cannot inspect its pixel data.
   *
   * @param aWhichFrame Frame specifier of the FRAME_* variety.
   * @param aFlags Flags of the FLAG_* variety
   */
  /* [noscript] gfxASurface getFrame (in PRUint32 aWhichFrame, in PRUint32 aFlags); */
  NS_IMETHOD GetFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxASurface * *_retval NS_OUTPARAM) = 0;

  /**
   * Create and return a new copy of the given frame that you can write to
   * and otherwise inspect the pixels of.
   *
   * @param aWhichFrame Frame specifier of the FRAME_* variety.
   * @param aFlags Flags of the FLAG_* variety
   */
  /* [noscript] gfxImageSurface copyFrame (in PRUint32 aWhichFrame, in PRUint32 aFlags); */
  NS_IMETHOD CopyFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxImageSurface * *_retval NS_OUTPARAM) = 0;

  /**
   * Create a new imgContainer that contains only a single frame, which itself
   * contains a subregion of the given frame.
   *
   * @param aWhichFrame Frame specifier of the FRAME_* variety.
   * @param aRect the area of the current frame to be duplicated in the
   *              returned imgContainer's frame.
   * @param aFlags Flags of the FLAG_* variety
   */
  /* [noscript] imgIContainer extractFrame (in PRUint32 aWhichFrame, [const] in nsIntRect aRect, in PRUint32 aFlags); */
  NS_IMETHOD ExtractFrame(PRUint32 aWhichFrame, const nsIntRect & aRect, PRUint32 aFlags, imgIContainer **_retval NS_OUTPARAM) = 0;

  /**
   * Draw the current frame on to the context specified.
   *
   * @param aContext The Thebes context to draw the image to.
   * @param aFilter The filter to be used if we're scaling the image.
   * @param aUserSpaceToImageSpace The transformation from user space (e.g.,
   *                               appunits) to image space.
   * @param aFill The area in the context to draw pixels to. Image will be
   *              automatically tiled as necessary.
   * @param aSubimage The area of the image, in pixels, that we are allowed to
   *                  sample from.
   * @param aFlags Flags of the FLAG_* variety
   */
  /* [noscript] void draw (in gfxContext aContext, in gfxGraphicsFilter aFilter, [const] in gfxMatrix aUserSpaceToImageSpace, [const] in gfxRect aFill, [const] in nsIntRect aSubimage, in PRUint32 aFlags); */
  NS_IMETHOD Draw(gfxContext * aContext, gfxPattern::GraphicsFilter aFilter, const gfxMatrix & aUserSpaceToImageSpace, const gfxRect & aFill, const nsIntRect & aSubimage, PRUint32 aFlags) = 0;

  /* void requestDecode (); */
  NS_SCRIPTABLE NS_IMETHOD RequestDecode(void) = 0;

  /**
    * Increments the lock count on the image. An image will not be discarded
    * as long as the lock count is nonzero. Note that it is still possible for
    * the image to be undecoded if decode-on-draw is enabled and the image
    * was never drawn.
    *
    * Upon instantiation images have a lock count of zero.
    */
  /* void lockImage (); */
  NS_SCRIPTABLE NS_IMETHOD LockImage(void) = 0;

  /**
    * Decreases the lock count on the image. If the lock count drops to zero,
    * the image is allowed to discard its frame data to save memory.
    *
    * Upon instantiation images have a lock count of zero. It is an error to
    * call this method without first having made a matching lockImage() call.
    * In other words, the lock count is not allowed to be negative.
    */
  /* void unlockImage (); */
  NS_SCRIPTABLE NS_IMETHOD UnlockImage(void) = 0;

  /************ Internal libpr0n use only below here. *****************/
/**
   * Flags for imgIContainer initialization.
   *
   * Meanings:
   *
   * INIT_FLAG_NONE: Lack of flags
   *
   * INIT_FLAG_DISCARDABLE: The container should be discardable
   *
   * INIT_FLAG_DECODE_ON_DRAW: The container should decode on draw rather than
   * decoding on load.
   *
   * INIT_FLAG_MULTIPART: The container will be used to display a stream of
   * images in a multipart channel. If this flag is set, INIT_FLAG_DISCARDABLE
   * and INIT_FLAG_DECODE_ON_DRAW must not be set.
   */
  enum { INIT_FLAG_NONE = 0 };

  enum { INIT_FLAG_DISCARDABLE = 1 };

  enum { INIT_FLAG_DECODE_ON_DRAW = 2 };

  enum { INIT_FLAG_MULTIPART = 4 };

  /**
   * Creates a new image container.
   *
   * @param aObserver Observer to send decoder and animation notifications to.
   * @param aMimeType The mimetype of the image.
   * @param aFlags Initialization flags of the INIT_FLAG_* variety.
   */
  /* void init (in imgIDecoderObserver aObserver, in string aMimeType, in PRUint32 aFlags); */
  NS_SCRIPTABLE NS_IMETHOD Init(imgIDecoderObserver *aObserver, const char *aMimeType, PRUint32 aFlags) = 0;

  /** 
   * "Disposal" method indicates how the image should be handled before the
   *  subsequent image is displayed.
   *  Don't change these without looking at the implementations using them,
   *  struct gif_struct::disposal_method and gif_write() in particular.
   */
  enum { kDisposeClearAll = -1 };

  enum { kDisposeNotSpecified = 0 };

  enum { kDisposeKeep = 1 };

  enum { kDisposeClear = 2 };

  enum { kDisposeRestorePrevious = 3 };

  enum { kBlendSource = 0 };

  enum { kBlendOver = 1 };

  /**
   * Animation mode Constants
   *   0 = normal
   *   1 = don't animate
   *   2 = loop once
   */
  enum { kNormalAnimMode = 0 };

  enum { kDontAnimMode = 1 };

  enum { kLoopOnceAnimMode = 2 };

  /* attribute unsigned short animationMode; */
  NS_SCRIPTABLE NS_IMETHOD GetAnimationMode(PRUint16 *aAnimationMode) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAnimationMode(PRUint16 aAnimationMode) = 0;

  /**
   * The rectangle defining the location and size of the currently displayed frame.
   * Should be an attribute, but can't be because of reference/pointer
   * conflicts with native types in xpidl.
   */
  /* [noscript] void getCurrentFrameRect (in nsIntRect aFrameRect); */
  NS_IMETHOD GetCurrentFrameRect(nsIntRect & aFrameRect) = 0;

  /**
   * The index of the current frame that would be drawn if the image was to be
   * drawn now.
   */
  /* readonly attribute unsigned long currentFrameIndex; */
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIndex(PRUint32 *aCurrentFrameIndex) = 0;

  /**
   * The total number of frames in this image.
   */
  /* readonly attribute unsigned long numFrames; */
  NS_SCRIPTABLE NS_IMETHOD GetNumFrames(PRUint32 *aNumFrames) = 0;

  /**
   * The size, in bytes, occupied by the significant data portions of the image.
   * This includes both compressed source data and decoded frames.
   */
  /* readonly attribute unsigned long dataSize; */
  NS_SCRIPTABLE NS_IMETHOD GetDataSize(PRUint32 *aDataSize) = 0;

  /* void setFrameDisposalMethod (in unsigned long framenumber, in PRInt32 aDisposalMethod); */
  NS_SCRIPTABLE NS_IMETHOD SetFrameDisposalMethod(PRUint32 framenumber, PRInt32 aDisposalMethod) = 0;

  /* void setFrameBlendMethod (in unsigned long framenumber, in PRInt32 aBlendMethod); */
  NS_SCRIPTABLE NS_IMETHOD SetFrameBlendMethod(PRUint32 framenumber, PRInt32 aBlendMethod) = 0;

  /* void setFrameTimeout (in unsigned long framenumber, in PRInt32 aTimeout); */
  NS_SCRIPTABLE NS_IMETHOD SetFrameTimeout(PRUint32 framenumber, PRInt32 aTimeout) = 0;

  /* void setFrameHasNoAlpha (in unsigned long framenumber); */
  NS_SCRIPTABLE NS_IMETHOD SetFrameHasNoAlpha(PRUint32 framenumber) = 0;

  /**
   * Sets the size of the container. This should only be called by the decoder. This function may be called multiple
   * times, but will throw an error if subsequent calls do not match the first.
   */
  /* [noscript] void setSize (in long aWidth, in long aHeight); */
  NS_IMETHOD SetSize(PRInt32 aWidth, PRInt32 aHeight) = 0;

  /**
   * Create or re-use a frame at index aFrameNum. It is an error to call this with aFrameNum not in the range [0, numFrames].
   */
  /* [noscript] void ensureCleanFrame (in unsigned long aFramenum, in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength); */
  NS_IMETHOD EnsureCleanFrame(PRUint32 aFramenum, PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) = 0;

  /**
   * Adds to the end of the list of frames.
   */
  /* [noscript] void appendFrame (in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength); */
  NS_IMETHOD AppendFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) = 0;

  /* [noscript] void appendPalettedFrame (in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, in PRUint8 aPaletteDepth, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength, [array, size_is (paletteLength)] out PRUint32 paletteData, out unsigned long paletteLength); */
  NS_IMETHOD AppendPalettedFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 aPaletteDepth, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM, PRUint32 **paletteData NS_OUTPARAM, PRUint32 *paletteLength NS_OUTPARAM) = 0;

  /* [noscript] void frameUpdated (in unsigned long framenum, in nsIntRect aNewRect); */
  NS_IMETHOD FrameUpdated(PRUint32 framenum, nsIntRect & aNewRect) = 0;

  /* void endFrameDecode (in unsigned long framenumber); */
  NS_SCRIPTABLE NS_IMETHOD EndFrameDecode(PRUint32 framenumber) = 0;

  /* void decodingComplete (); */
  NS_SCRIPTABLE NS_IMETHOD DecodingComplete(void) = 0;

  /* void startAnimation (); */
  NS_SCRIPTABLE NS_IMETHOD StartAnimation(void) = 0;

  /* void stopAnimation (); */
  NS_SCRIPTABLE NS_IMETHOD StopAnimation(void) = 0;

  /* void resetAnimation (); */
  NS_SCRIPTABLE NS_IMETHOD ResetAnimation(void) = 0;

  /**
   * number of times to loop the image.
   * @note -1 means forever.
   */
  /* attribute long loopCount; */
  NS_SCRIPTABLE NS_IMETHOD GetLoopCount(PRInt32 *aLoopCount) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetLoopCount(PRInt32 aLoopCount) = 0;

  /* [noscript] void addSourceData ([array, size_is (aCount), const] in char data, in unsigned long aCount); */
  NS_IMETHOD AddSourceData(const char *data, PRUint32 aCount) = 0;

  /* [noscript] void sourceDataComplete (); */
  NS_IMETHOD SourceDataComplete(void) = 0;

  /* [noscript] void newSourceData (); */
  NS_IMETHOD NewSourceData(void) = 0;

  /**
   * A hint of the number of bytes of source data that the image contains. If
   * called early on, this can help reduce copying and reallocations by
   * appropriately preallocating the source data buffer.
   *
   * We take this approach rather than having the source data management code do
   * something more complicated (like chunklisting) because HTTP is by far the
   * dominant source of images, and the Content-Length header is quite reliable.
   * Thus, pre-allocation simplifies code and reduces the total number of
   * allocations.
   */
  /* void setSourceSizeHint (in unsigned long sizeHint); */
  NS_SCRIPTABLE NS_IMETHOD SetSourceSizeHint(PRUint32 sizeHint) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(imgIContainer, IMGICONTAINER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_IMGICONTAINER \
  NS_SCRIPTABLE NS_IMETHOD GetWidth(PRInt32 *aWidth); \
  NS_SCRIPTABLE NS_IMETHOD GetHeight(PRInt32 *aHeight); \
  NS_SCRIPTABLE NS_IMETHOD GetAnimated(PRBool *aAnimated); \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIsOpaque(PRBool *aCurrentFrameIsOpaque); \
  NS_IMETHOD GetFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxASurface * *_retval NS_OUTPARAM); \
  NS_IMETHOD CopyFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxImageSurface * *_retval NS_OUTPARAM); \
  NS_IMETHOD ExtractFrame(PRUint32 aWhichFrame, const nsIntRect & aRect, PRUint32 aFlags, imgIContainer **_retval NS_OUTPARAM); \
  NS_IMETHOD Draw(gfxContext * aContext, gfxPattern::GraphicsFilter aFilter, const gfxMatrix & aUserSpaceToImageSpace, const gfxRect & aFill, const nsIntRect & aSubimage, PRUint32 aFlags); \
  NS_SCRIPTABLE NS_IMETHOD RequestDecode(void); \
  NS_SCRIPTABLE NS_IMETHOD LockImage(void); \
  NS_SCRIPTABLE NS_IMETHOD UnlockImage(void); \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIDecoderObserver *aObserver, const char *aMimeType, PRUint32 aFlags); \
  NS_SCRIPTABLE NS_IMETHOD GetAnimationMode(PRUint16 *aAnimationMode); \
  NS_SCRIPTABLE NS_IMETHOD SetAnimationMode(PRUint16 aAnimationMode); \
  NS_IMETHOD GetCurrentFrameRect(nsIntRect & aFrameRect); \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIndex(PRUint32 *aCurrentFrameIndex); \
  NS_SCRIPTABLE NS_IMETHOD GetNumFrames(PRUint32 *aNumFrames); \
  NS_SCRIPTABLE NS_IMETHOD GetDataSize(PRUint32 *aDataSize); \
  NS_SCRIPTABLE NS_IMETHOD SetFrameDisposalMethod(PRUint32 framenumber, PRInt32 aDisposalMethod); \
  NS_SCRIPTABLE NS_IMETHOD SetFrameBlendMethod(PRUint32 framenumber, PRInt32 aBlendMethod); \
  NS_SCRIPTABLE NS_IMETHOD SetFrameTimeout(PRUint32 framenumber, PRInt32 aTimeout); \
  NS_SCRIPTABLE NS_IMETHOD SetFrameHasNoAlpha(PRUint32 framenumber); \
  NS_IMETHOD SetSize(PRInt32 aWidth, PRInt32 aHeight); \
  NS_IMETHOD EnsureCleanFrame(PRUint32 aFramenum, PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM); \
  NS_IMETHOD AppendFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM); \
  NS_IMETHOD AppendPalettedFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 aPaletteDepth, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM, PRUint32 **paletteData NS_OUTPARAM, PRUint32 *paletteLength NS_OUTPARAM); \
  NS_IMETHOD FrameUpdated(PRUint32 framenum, nsIntRect & aNewRect); \
  NS_SCRIPTABLE NS_IMETHOD EndFrameDecode(PRUint32 framenumber); \
  NS_SCRIPTABLE NS_IMETHOD DecodingComplete(void); \
  NS_SCRIPTABLE NS_IMETHOD StartAnimation(void); \
  NS_SCRIPTABLE NS_IMETHOD StopAnimation(void); \
  NS_SCRIPTABLE NS_IMETHOD ResetAnimation(void); \
  NS_SCRIPTABLE NS_IMETHOD GetLoopCount(PRInt32 *aLoopCount); \
  NS_SCRIPTABLE NS_IMETHOD SetLoopCount(PRInt32 aLoopCount); \
  NS_IMETHOD AddSourceData(const char *data, PRUint32 aCount); \
  NS_IMETHOD SourceDataComplete(void); \
  NS_IMETHOD NewSourceData(void); \
  NS_SCRIPTABLE NS_IMETHOD SetSourceSizeHint(PRUint32 sizeHint); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_IMGICONTAINER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetWidth(PRInt32 *aWidth) { return _to GetWidth(aWidth); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeight(PRInt32 *aHeight) { return _to GetHeight(aHeight); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnimated(PRBool *aAnimated) { return _to GetAnimated(aAnimated); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIsOpaque(PRBool *aCurrentFrameIsOpaque) { return _to GetCurrentFrameIsOpaque(aCurrentFrameIsOpaque); } \
  NS_IMETHOD GetFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxASurface * *_retval NS_OUTPARAM) { return _to GetFrame(aWhichFrame, aFlags, _retval); } \
  NS_IMETHOD CopyFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxImageSurface * *_retval NS_OUTPARAM) { return _to CopyFrame(aWhichFrame, aFlags, _retval); } \
  NS_IMETHOD ExtractFrame(PRUint32 aWhichFrame, const nsIntRect & aRect, PRUint32 aFlags, imgIContainer **_retval NS_OUTPARAM) { return _to ExtractFrame(aWhichFrame, aRect, aFlags, _retval); } \
  NS_IMETHOD Draw(gfxContext * aContext, gfxPattern::GraphicsFilter aFilter, const gfxMatrix & aUserSpaceToImageSpace, const gfxRect & aFill, const nsIntRect & aSubimage, PRUint32 aFlags) { return _to Draw(aContext, aFilter, aUserSpaceToImageSpace, aFill, aSubimage, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD RequestDecode(void) { return _to RequestDecode(); } \
  NS_SCRIPTABLE NS_IMETHOD LockImage(void) { return _to LockImage(); } \
  NS_SCRIPTABLE NS_IMETHOD UnlockImage(void) { return _to UnlockImage(); } \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIDecoderObserver *aObserver, const char *aMimeType, PRUint32 aFlags) { return _to Init(aObserver, aMimeType, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnimationMode(PRUint16 *aAnimationMode) { return _to GetAnimationMode(aAnimationMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetAnimationMode(PRUint16 aAnimationMode) { return _to SetAnimationMode(aAnimationMode); } \
  NS_IMETHOD GetCurrentFrameRect(nsIntRect & aFrameRect) { return _to GetCurrentFrameRect(aFrameRect); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIndex(PRUint32 *aCurrentFrameIndex) { return _to GetCurrentFrameIndex(aCurrentFrameIndex); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumFrames(PRUint32 *aNumFrames) { return _to GetNumFrames(aNumFrames); } \
  NS_SCRIPTABLE NS_IMETHOD GetDataSize(PRUint32 *aDataSize) { return _to GetDataSize(aDataSize); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameDisposalMethod(PRUint32 framenumber, PRInt32 aDisposalMethod) { return _to SetFrameDisposalMethod(framenumber, aDisposalMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameBlendMethod(PRUint32 framenumber, PRInt32 aBlendMethod) { return _to SetFrameBlendMethod(framenumber, aBlendMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameTimeout(PRUint32 framenumber, PRInt32 aTimeout) { return _to SetFrameTimeout(framenumber, aTimeout); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameHasNoAlpha(PRUint32 framenumber) { return _to SetFrameHasNoAlpha(framenumber); } \
  NS_IMETHOD SetSize(PRInt32 aWidth, PRInt32 aHeight) { return _to SetSize(aWidth, aHeight); } \
  NS_IMETHOD EnsureCleanFrame(PRUint32 aFramenum, PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) { return _to EnsureCleanFrame(aFramenum, aX, aY, aWidth, aHeight, aFormat, imageData, imageLength); } \
  NS_IMETHOD AppendFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) { return _to AppendFrame(aX, aY, aWidth, aHeight, aFormat, imageData, imageLength); } \
  NS_IMETHOD AppendPalettedFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 aPaletteDepth, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM, PRUint32 **paletteData NS_OUTPARAM, PRUint32 *paletteLength NS_OUTPARAM) { return _to AppendPalettedFrame(aX, aY, aWidth, aHeight, aFormat, aPaletteDepth, imageData, imageLength, paletteData, paletteLength); } \
  NS_IMETHOD FrameUpdated(PRUint32 framenum, nsIntRect & aNewRect) { return _to FrameUpdated(framenum, aNewRect); } \
  NS_SCRIPTABLE NS_IMETHOD EndFrameDecode(PRUint32 framenumber) { return _to EndFrameDecode(framenumber); } \
  NS_SCRIPTABLE NS_IMETHOD DecodingComplete(void) { return _to DecodingComplete(); } \
  NS_SCRIPTABLE NS_IMETHOD StartAnimation(void) { return _to StartAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD StopAnimation(void) { return _to StopAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD ResetAnimation(void) { return _to ResetAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD GetLoopCount(PRInt32 *aLoopCount) { return _to GetLoopCount(aLoopCount); } \
  NS_SCRIPTABLE NS_IMETHOD SetLoopCount(PRInt32 aLoopCount) { return _to SetLoopCount(aLoopCount); } \
  NS_IMETHOD AddSourceData(const char *data, PRUint32 aCount) { return _to AddSourceData(data, aCount); } \
  NS_IMETHOD SourceDataComplete(void) { return _to SourceDataComplete(); } \
  NS_IMETHOD NewSourceData(void) { return _to NewSourceData(); } \
  NS_SCRIPTABLE NS_IMETHOD SetSourceSizeHint(PRUint32 sizeHint) { return _to SetSourceSizeHint(sizeHint); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_IMGICONTAINER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetWidth(PRInt32 *aWidth) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWidth(aWidth); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeight(PRInt32 *aHeight) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeight(aHeight); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnimated(PRBool *aAnimated) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAnimated(aAnimated); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIsOpaque(PRBool *aCurrentFrameIsOpaque) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentFrameIsOpaque(aCurrentFrameIsOpaque); } \
  NS_IMETHOD GetFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxASurface * *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFrame(aWhichFrame, aFlags, _retval); } \
  NS_IMETHOD CopyFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxImageSurface * *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFrame(aWhichFrame, aFlags, _retval); } \
  NS_IMETHOD ExtractFrame(PRUint32 aWhichFrame, const nsIntRect & aRect, PRUint32 aFlags, imgIContainer **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtractFrame(aWhichFrame, aRect, aFlags, _retval); } \
  NS_IMETHOD Draw(gfxContext * aContext, gfxPattern::GraphicsFilter aFilter, const gfxMatrix & aUserSpaceToImageSpace, const gfxRect & aFill, const nsIntRect & aSubimage, PRUint32 aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Draw(aContext, aFilter, aUserSpaceToImageSpace, aFill, aSubimage, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD RequestDecode(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RequestDecode(); } \
  NS_SCRIPTABLE NS_IMETHOD LockImage(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->LockImage(); } \
  NS_SCRIPTABLE NS_IMETHOD UnlockImage(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnlockImage(); } \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIDecoderObserver *aObserver, const char *aMimeType, PRUint32 aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aObserver, aMimeType, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnimationMode(PRUint16 *aAnimationMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAnimationMode(aAnimationMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetAnimationMode(PRUint16 aAnimationMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAnimationMode(aAnimationMode); } \
  NS_IMETHOD GetCurrentFrameRect(nsIntRect & aFrameRect) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentFrameRect(aFrameRect); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentFrameIndex(PRUint32 *aCurrentFrameIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentFrameIndex(aCurrentFrameIndex); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumFrames(PRUint32 *aNumFrames) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumFrames(aNumFrames); } \
  NS_SCRIPTABLE NS_IMETHOD GetDataSize(PRUint32 *aDataSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDataSize(aDataSize); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameDisposalMethod(PRUint32 framenumber, PRInt32 aDisposalMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFrameDisposalMethod(framenumber, aDisposalMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameBlendMethod(PRUint32 framenumber, PRInt32 aBlendMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFrameBlendMethod(framenumber, aBlendMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameTimeout(PRUint32 framenumber, PRInt32 aTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFrameTimeout(framenumber, aTimeout); } \
  NS_SCRIPTABLE NS_IMETHOD SetFrameHasNoAlpha(PRUint32 framenumber) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFrameHasNoAlpha(framenumber); } \
  NS_IMETHOD SetSize(PRInt32 aWidth, PRInt32 aHeight) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSize(aWidth, aHeight); } \
  NS_IMETHOD EnsureCleanFrame(PRUint32 aFramenum, PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureCleanFrame(aFramenum, aX, aY, aWidth, aHeight, aFormat, imageData, imageLength); } \
  NS_IMETHOD AppendFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AppendFrame(aX, aY, aWidth, aHeight, aFormat, imageData, imageLength); } \
  NS_IMETHOD AppendPalettedFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 aPaletteDepth, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM, PRUint32 **paletteData NS_OUTPARAM, PRUint32 *paletteLength NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AppendPalettedFrame(aX, aY, aWidth, aHeight, aFormat, aPaletteDepth, imageData, imageLength, paletteData, paletteLength); } \
  NS_IMETHOD FrameUpdated(PRUint32 framenum, nsIntRect & aNewRect) { return !_to ? NS_ERROR_NULL_POINTER : _to->FrameUpdated(framenum, aNewRect); } \
  NS_SCRIPTABLE NS_IMETHOD EndFrameDecode(PRUint32 framenumber) { return !_to ? NS_ERROR_NULL_POINTER : _to->EndFrameDecode(framenumber); } \
  NS_SCRIPTABLE NS_IMETHOD DecodingComplete(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DecodingComplete(); } \
  NS_SCRIPTABLE NS_IMETHOD StartAnimation(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD StopAnimation(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StopAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD ResetAnimation(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResetAnimation(); } \
  NS_SCRIPTABLE NS_IMETHOD GetLoopCount(PRInt32 *aLoopCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoopCount(aLoopCount); } \
  NS_SCRIPTABLE NS_IMETHOD SetLoopCount(PRInt32 aLoopCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLoopCount(aLoopCount); } \
  NS_IMETHOD AddSourceData(const char *data, PRUint32 aCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSourceData(data, aCount); } \
  NS_IMETHOD SourceDataComplete(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SourceDataComplete(); } \
  NS_IMETHOD NewSourceData(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewSourceData(); } \
  NS_SCRIPTABLE NS_IMETHOD SetSourceSizeHint(PRUint32 sizeHint) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSourceSizeHint(sizeHint); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public imgIContainer
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_IMGICONTAINER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, imgIContainer)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute PRInt32 width; */
NS_IMETHODIMP _MYCLASS_::GetWidth(PRInt32 *aWidth)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRInt32 height; */
NS_IMETHODIMP _MYCLASS_::GetHeight(PRInt32 *aHeight)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean animated; */
NS_IMETHODIMP _MYCLASS_::GetAnimated(PRBool *aAnimated)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean currentFrameIsOpaque; */
NS_IMETHODIMP _MYCLASS_::GetCurrentFrameIsOpaque(PRBool *aCurrentFrameIsOpaque)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] gfxASurface getFrame (in PRUint32 aWhichFrame, in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::GetFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxASurface * *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] gfxImageSurface copyFrame (in PRUint32 aWhichFrame, in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::CopyFrame(PRUint32 aWhichFrame, PRUint32 aFlags, gfxImageSurface * *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] imgIContainer extractFrame (in PRUint32 aWhichFrame, [const] in nsIntRect aRect, in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::ExtractFrame(PRUint32 aWhichFrame, const nsIntRect & aRect, PRUint32 aFlags, imgIContainer **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void draw (in gfxContext aContext, in gfxGraphicsFilter aFilter, [const] in gfxMatrix aUserSpaceToImageSpace, [const] in gfxRect aFill, [const] in nsIntRect aSubimage, in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::Draw(gfxContext * aContext, gfxPattern::GraphicsFilter aFilter, const gfxMatrix & aUserSpaceToImageSpace, const gfxRect & aFill, const nsIntRect & aSubimage, PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void requestDecode (); */
NS_IMETHODIMP _MYCLASS_::RequestDecode()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void lockImage (); */
NS_IMETHODIMP _MYCLASS_::LockImage()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void unlockImage (); */
NS_IMETHODIMP _MYCLASS_::UnlockImage()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void init (in imgIDecoderObserver aObserver, in string aMimeType, in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::Init(imgIDecoderObserver *aObserver, const char *aMimeType, PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned short animationMode; */
NS_IMETHODIMP _MYCLASS_::GetAnimationMode(PRUint16 *aAnimationMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetAnimationMode(PRUint16 aAnimationMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void getCurrentFrameRect (in nsIntRect aFrameRect); */
NS_IMETHODIMP _MYCLASS_::GetCurrentFrameRect(nsIntRect & aFrameRect)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long currentFrameIndex; */
NS_IMETHODIMP _MYCLASS_::GetCurrentFrameIndex(PRUint32 *aCurrentFrameIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long numFrames; */
NS_IMETHODIMP _MYCLASS_::GetNumFrames(PRUint32 *aNumFrames)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long dataSize; */
NS_IMETHODIMP _MYCLASS_::GetDataSize(PRUint32 *aDataSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFrameDisposalMethod (in unsigned long framenumber, in PRInt32 aDisposalMethod); */
NS_IMETHODIMP _MYCLASS_::SetFrameDisposalMethod(PRUint32 framenumber, PRInt32 aDisposalMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFrameBlendMethod (in unsigned long framenumber, in PRInt32 aBlendMethod); */
NS_IMETHODIMP _MYCLASS_::SetFrameBlendMethod(PRUint32 framenumber, PRInt32 aBlendMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFrameTimeout (in unsigned long framenumber, in PRInt32 aTimeout); */
NS_IMETHODIMP _MYCLASS_::SetFrameTimeout(PRUint32 framenumber, PRInt32 aTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFrameHasNoAlpha (in unsigned long framenumber); */
NS_IMETHODIMP _MYCLASS_::SetFrameHasNoAlpha(PRUint32 framenumber)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void setSize (in long aWidth, in long aHeight); */
NS_IMETHODIMP _MYCLASS_::SetSize(PRInt32 aWidth, PRInt32 aHeight)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void ensureCleanFrame (in unsigned long aFramenum, in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength); */
NS_IMETHODIMP _MYCLASS_::EnsureCleanFrame(PRUint32 aFramenum, PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void appendFrame (in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength); */
NS_IMETHODIMP _MYCLASS_::AppendFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void appendPalettedFrame (in PRInt32 aX, in PRInt32 aY, in PRInt32 aWidth, in PRInt32 aHeight, in gfxImageFormat aFormat, in PRUint8 aPaletteDepth, [array, size_is (imageLength)] out PRUint8 imageData, out unsigned long imageLength, [array, size_is (paletteLength)] out PRUint32 paletteData, out unsigned long paletteLength); */
NS_IMETHODIMP _MYCLASS_::AppendPalettedFrame(PRInt32 aX, PRInt32 aY, PRInt32 aWidth, PRInt32 aHeight, gfxASurface::gfxImageFormat aFormat, PRUint8 aPaletteDepth, PRUint8 **imageData NS_OUTPARAM, PRUint32 *imageLength NS_OUTPARAM, PRUint32 **paletteData NS_OUTPARAM, PRUint32 *paletteLength NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void frameUpdated (in unsigned long framenum, in nsIntRect aNewRect); */
NS_IMETHODIMP _MYCLASS_::FrameUpdated(PRUint32 framenum, nsIntRect & aNewRect)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void endFrameDecode (in unsigned long framenumber); */
NS_IMETHODIMP _MYCLASS_::EndFrameDecode(PRUint32 framenumber)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void decodingComplete (); */
NS_IMETHODIMP _MYCLASS_::DecodingComplete()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startAnimation (); */
NS_IMETHODIMP _MYCLASS_::StartAnimation()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void stopAnimation (); */
NS_IMETHODIMP _MYCLASS_::StopAnimation()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resetAnimation (); */
NS_IMETHODIMP _MYCLASS_::ResetAnimation()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long loopCount; */
NS_IMETHODIMP _MYCLASS_::GetLoopCount(PRInt32 *aLoopCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetLoopCount(PRInt32 aLoopCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addSourceData ([array, size_is (aCount), const] in char data, in unsigned long aCount); */
NS_IMETHODIMP _MYCLASS_::AddSourceData(const char *data, PRUint32 aCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void sourceDataComplete (); */
NS_IMETHODIMP _MYCLASS_::SourceDataComplete()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void newSourceData (); */
NS_IMETHODIMP _MYCLASS_::NewSourceData()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setSourceSizeHint (in unsigned long sizeHint); */
NS_IMETHODIMP _MYCLASS_::SetSourceSizeHint(PRUint32 sizeHint)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_imgIContainer_h__ */
