/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/slave/shadow-central-linux-xulrunner/build/modules/libpr0n/public/imgIDecoder.idl
 */

#ifndef __gen_imgIDecoder_h__
#define __gen_imgIDecoder_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class imgIContainer; /* forward declaration */

class imgIDecoderObserver; /* forward declaration */


/* starting interface:    imgIDecoder */
#define IMGIDECODER_IID_STR "6fc61088-5443-4539-9e24-629a266a800a"

#define IMGIDECODER_IID \
  {0x6fc61088, 0x5443, 0x4539, \
    { 0x9e, 0x24, 0x62, 0x9a, 0x26, 0x6a, 0x80, 0x0a }}

/**
 * imgIDecoder interface
 *
 * @author Stuart Parmenter <pavlov@netscape.com>
 * @version 0.2
 * @see imagelib2
 */
class NS_NO_VTABLE NS_SCRIPTABLE imgIDecoder : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(IMGIDECODER_IID)

  /**
   * Bits that can be passed to the decoder to affect decoding.
   * @name decodeflags
   *
   * Meanings:
   *
   * DECODER_FLAG_NONE: No flags
   *
   * DECODER_FLAG_HEADERONLY: Read basic data from the image in order to 
   * set up the image container,  but don't read any actual image data.
   */
  enum { DECODER_FLAG_NONE = 0 };

  enum { DECODER_FLAG_HEADERONLY = 1 };

  /**
   * Initialize an image decoder.
   * @param aContainer The image container to decode to.
   * @param aObserver The observer for decode notification events.
   * @param aFlags Flags for the decoder
   *
   * @note The decoder should always pass NULL as the 
   * first two parameters to all of the imgIDecoderObserver APIs.
   */
  /* void init (in imgIContainer aImage, in imgIDecoderObserver aObserver, in unsigned long aFlags); */
  NS_SCRIPTABLE NS_IMETHOD Init(imgIContainer *aImage, imgIDecoderObserver *aObserver, PRUint32 aFlags) = 0;

  /** 
   * Closes the stream.
   * @param aFlags Close flags of the CLOSE_FLAG_* Variety
   *
   * Resources are always freed with this call. If notifications are sent,
   * OnStopDecode is guaranteed to be called if it hasn't been called already.
   *
   * CLOSE_FLAG_DONTNOTIFY - Don't send any observer notifications, and don't
   * call imgIContainer::decodingComplete().
   */
  enum { CLOSE_FLAG_DONTNOTIFY = 1 };

  /* void close (in PRUint32 aFlags); */
  NS_SCRIPTABLE NS_IMETHOD Close(PRUint32 aFlags) = 0;

  /**
   * Flushes the stream.
   */
  /* void flush (); */
  NS_SCRIPTABLE NS_IMETHOD Flush(void) = 0;

  /**
   * Writes data to the decoder.
   *
   * For Header-Only decodes, OnStartContainer is the only notification
   * fired. It is an error to write any more data to the decoder for header-only
   * decodes after SetSize() has been called.
   *
   * If a decoding error occurs, an internal flag is set and an error is
   * returned. Each subsequent call to write will fail immediately
   * for the lifetime of the decoder. Shutdown notifications of the OnStopX
   * variety, as well as DecodingComplete(), are guaranteed not to be called
   * if a decoding error occurs.
   *
   * @param aBuffer buffer containing the data to be written
   * @param aCount the number of bytes to write
   */
  /* void write (in string aBuffer, in unsigned long count); */
  NS_SCRIPTABLE NS_IMETHOD Write(const char *aBuffer, PRUint32 count) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(imgIDecoder, IMGIDECODER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_IMGIDECODER \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIContainer *aImage, imgIDecoderObserver *aObserver, PRUint32 aFlags); \
  NS_SCRIPTABLE NS_IMETHOD Close(PRUint32 aFlags); \
  NS_SCRIPTABLE NS_IMETHOD Flush(void); \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *aBuffer, PRUint32 count); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_IMGIDECODER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIContainer *aImage, imgIDecoderObserver *aObserver, PRUint32 aFlags) { return _to Init(aImage, aObserver, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD Close(PRUint32 aFlags) { return _to Close(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD Flush(void) { return _to Flush(); } \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *aBuffer, PRUint32 count) { return _to Write(aBuffer, count); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_IMGIDECODER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Init(imgIContainer *aImage, imgIDecoderObserver *aObserver, PRUint32 aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aImage, aObserver, aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD Close(PRUint32 aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD Flush(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Flush(); } \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *aBuffer, PRUint32 count) { return !_to ? NS_ERROR_NULL_POINTER : _to->Write(aBuffer, count); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public imgIDecoder
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_IMGIDECODER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, imgIDecoder)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* void init (in imgIContainer aImage, in imgIDecoderObserver aObserver, in unsigned long aFlags); */
NS_IMETHODIMP _MYCLASS_::Init(imgIContainer *aImage, imgIDecoderObserver *aObserver, PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (in PRUint32 aFlags); */
NS_IMETHODIMP _MYCLASS_::Close(PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void flush (); */
NS_IMETHODIMP _MYCLASS_::Flush()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void write (in string aBuffer, in unsigned long count); */
NS_IMETHODIMP _MYCLASS_::Write(const char *aBuffer, PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_imgIDecoder_h__ */
