/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org networking code.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corporation
 * Portions created by the Initial Developer are Copyright (C) 2009
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    Honza Bambas <honzab@firemni.cz>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef nsAsyncRedirectVerifyHelper_h
#define nsAsyncRedirectVerifyHelper_h

#include "nsIRunnable.h"

#include "nsCOMPtr.h"

class nsIChannel;

/**
 * This class simplifies call of OnChannelRedirect of IOService and
 * the sink bound with the channel being redirected while the result of
 * redirect decision is returned through the callback.
 */
class nsAsyncRedirectVerifyHelper : public nsIRunnable
{
    NS_DECL_ISUPPORTS
    NS_DECL_NSIRUNNABLE

public:
    /**
     * Initialize and runs the chain of OnChannelRedirect calls. OldChannel
     * is QI'ed for nsIAsyncVerifyRedirectCallback. The result of the redirect
     * decision is passed through this interface back to the oldChannel.
     *
     * @param oldChan
     *    channel being redirected, MUST implement
     *    nsIAsyncVerifyRedirectCallback
     * @param newChan
     *    target of the redirect channel
     * @param flags
     *    redirect flags
     * @param synchronize
     *    set to TRUE if you want the Init method wait synchronously for
     *    all redirect callbacks
     */
    nsresult Init(nsIChannel* oldChan,
                  nsIChannel* newChan,
                  PRUint32 flags,
                  PRBool synchronize = PR_FALSE);

protected:
    nsCOMPtr<nsIChannel> mOldChan;
    nsCOMPtr<nsIChannel> mNewChan;
    PRUint32 mFlags;
    PRBool mWaitingForRedirectCallback;

    void Callback(nsresult result);
};

#endif
