/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/slave/m-2.0-linuxqt-xr/build/netwerk/base/public/nsITransport.idl
 */

#ifndef __gen_nsITransport_h__
#define __gen_nsITransport_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsITransportEventSink; /* forward declaration */

class nsIEventTarget; /* forward declaration */


/* starting interface:    nsITransport */
#define NS_ITRANSPORT_IID_STR "d8786c64-eb49-4a0b-b42c-0936a745fbe8"

#define NS_ITRANSPORT_IID \
  {0xd8786c64, 0xeb49, 0x4a0b, \
    { 0xb4, 0x2c, 0x09, 0x36, 0xa7, 0x45, 0xfb, 0xe8 }}

/**
 * nsITransport
 *
 * This interface provides a common way of accessing i/o streams connected
 * to some resource.  This interface does not in any way specify the resource.
 * It provides methods to open blocking or non-blocking, buffered or unbuffered
 * streams to the resource.  The name "transport" is meant to connote the 
 * inherent data transfer implied by this interface (i.e., data is being
 * transfered in some fashion via the streams exposed by this interface).
 *
 * A transport can have an event sink associated with it.  The event sink 
 * receives transport-specific events as the transfer is occuring.  For a
 * socket transport, these events can include status about the connection.
 * See nsISocketTransport for more info about socket transport specifics.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsITransport : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ITRANSPORT_IID)

  /**
     * Open flags.
     */
  enum { OPEN_BLOCKING = 1U };

  enum { OPEN_UNBUFFERED = 2U };

  /**
     * Open an input stream on this transport.
     *
     * Flags have the following meaning:
     *
     * OPEN_BLOCKING
     *   If specified, then the resulting stream will have blocking stream
     *   semantics.  This means that if the stream has no data and is not
     *   closed, then reading from it will block the calling thread until
     *   at least one byte is available or until the stream is closed.
     *   If this flag is NOT specified, then the stream has non-blocking
     *   stream semantics.  This means that if the stream has no data and is
     *   not closed, then reading from it returns NS_BASE_STREAM_WOULD_BLOCK.
     *   In addition, in non-blocking mode, the stream is guaranteed to 
     *   support nsIAsyncInputStream.  This interface allows the consumer of
     *   the stream to be notified when the stream can again be read.
     *
     * OPEN_UNBUFFERED
     *   If specified, the resulting stream may not support ReadSegments.
     *   ReadSegments is only gauranteed to be implemented when this flag is
     *   NOT specified.
     *
     * @param aFlags
     *        optional transport specific flags.
     * @param aSegmentSize
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        size of each buffer segment (pass 0 to use default value).
     * @param aSegmentCount
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        maximum number of buffer segments (pass 0 to use default value).
     */
  /* nsIInputStream openInputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
  NS_SCRIPTABLE NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval NS_OUTPARAM) = 0;

  /**
     * Open an output stream on this transport.
     *
     * Flags have the following meaning:
     *
     * OPEN_BLOCKING
     *   If specified, then the resulting stream will have blocking stream
     *   semantics.  This means that if the stream is full and is not closed,
     *   then writing to it will block the calling thread until ALL of the
     *   data can be written or until the stream is closed.  If this flag is
     *   NOT specified, then the stream has non-blocking stream semantics.
     *   This means that if the stream is full and is not closed, then writing
     *   to it returns NS_BASE_STREAM_WOULD_BLOCK.  In addition, in non-
     *   blocking mode, the stream is guaranteed to support
     *   nsIAsyncOutputStream.  This interface allows the consumer of the
     *   stream to be notified when the stream can again accept more data.
     *
     * OPEN_UNBUFFERED
     *   If specified, the resulting stream may not support WriteSegments and
     *   WriteFrom.  WriteSegments and WriteFrom are only gauranteed to be
     *   implemented when this flag is NOT specified.
     *
     * @param aFlags
     *        optional transport specific flags.
     * @param aSegmentSize
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        size of each buffer segment (pass 0 to use default value).
     * @param aSegmentCount
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        maximum number of buffer segments (pass 0 to use default value).
     */
  /* nsIOutputStream openOutputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
  NS_SCRIPTABLE NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval NS_OUTPARAM) = 0;

  /**
     * Close the transport and any open streams.
     *
     * @param aReason
     *        the reason for closing the stream.
     */
  /* void close (in nsresult aReason); */
  NS_SCRIPTABLE NS_IMETHOD Close(nsresult aReason) = 0;

  /**
     * Set the transport event sink.
     *
     * @param aSink
     *        receives transport layer notifications
     * @param aEventTarget
     *        indicates the event target to which the notifications should
     *        be delivered.  if NULL, then the notifications may occur on
     *        any thread.
     */
  /* void setEventSink (in nsITransportEventSink aSink, in nsIEventTarget aEventTarget); */
  NS_SCRIPTABLE NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventTarget *aEventTarget) = 0;

  /**
     * Generic nsITransportEventSink status codes.  nsITransport
     * implementations may override these status codes with their own more
     * specific status codes (e.g., see nsISocketTransport).
     */
  enum { STATUS_READING = 2152398856U };

  enum { STATUS_WRITING = 2152398857U };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsITransport, NS_ITRANSPORT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORT \
  NS_SCRIPTABLE NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Close(nsresult aReason); \
  NS_SCRIPTABLE NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventTarget *aEventTarget); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORT(_to) \
  NS_SCRIPTABLE NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval NS_OUTPARAM) { return _to OpenInputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval NS_OUTPARAM) { return _to OpenOutputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Close(nsresult aReason) { return _to Close(aReason); } \
  NS_SCRIPTABLE NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventTarget *aEventTarget) { return _to SetEventSink(aSink, aEventTarget); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORT(_to) \
  NS_SCRIPTABLE NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenInputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenOutputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Close(nsresult aReason) { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(aReason); } \
  NS_SCRIPTABLE NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventTarget *aEventTarget) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEventSink(aSink, aEventTarget); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransport : public nsITransport
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORT

  nsTransport();

private:
  ~nsTransport();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransport, nsITransport)

nsTransport::nsTransport()
{
  /* member initializers and constructor code */
}

nsTransport::~nsTransport()
{
  /* destructor code */
}

/* nsIInputStream openInputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
NS_IMETHODIMP nsTransport::OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIOutputStream openOutputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
NS_IMETHODIMP nsTransport::OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (in nsresult aReason); */
NS_IMETHODIMP nsTransport::Close(nsresult aReason)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEventSink (in nsITransportEventSink aSink, in nsIEventTarget aEventTarget); */
NS_IMETHODIMP nsTransport::SetEventSink(nsITransportEventSink *aSink, nsIEventTarget *aEventTarget)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsITransportEventSink */
#define NS_ITRANSPORTEVENTSINK_IID_STR "eda4f520-67f7-484b-a691-8c3226a5b0a6"

#define NS_ITRANSPORTEVENTSINK_IID \
  {0xeda4f520, 0x67f7, 0x484b, \
    { 0xa6, 0x91, 0x8c, 0x32, 0x26, 0xa5, 0xb0, 0xa6 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsITransportEventSink : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ITRANSPORTEVENTSINK_IID)

  /**
     * Transport status notification.
     *
     * @param aTransport
     *        the transport sending this status notification.
     * @param aStatus
     *        the transport status (resolvable to a string using
     *        nsIErrorService). See nsISocketTransport for socket specific
     *        status codes and more comments.
     * @param aProgress
     *        the amount of data either read or written depending on the value
     *        of the status code.  this value is relative to aProgressMax.
     * @param aProgressMax
     *        the maximum amount of data that will be read or written.  if
     *        unknown, 0xFFFFFFFF will be passed.
     */
  /* void onTransportStatus (in nsITransport aTransport, in nsresult aStatus, in unsigned long long aProgress, in unsigned long long aProgressMax); */
  NS_SCRIPTABLE NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint64 aProgress, PRUint64 aProgressMax) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsITransportEventSink, NS_ITRANSPORTEVENTSINK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORTEVENTSINK \
  NS_SCRIPTABLE NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint64 aProgress, PRUint64 aProgressMax); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORTEVENTSINK(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint64 aProgress, PRUint64 aProgressMax) { return _to OnTransportStatus(aTransport, aStatus, aProgress, aProgressMax); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORTEVENTSINK(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint64 aProgress, PRUint64 aProgressMax) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnTransportStatus(aTransport, aStatus, aProgress, aProgressMax); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransportEventSink : public nsITransportEventSink
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORTEVENTSINK

  nsTransportEventSink();

private:
  ~nsTransportEventSink();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransportEventSink, nsITransportEventSink)

nsTransportEventSink::nsTransportEventSink()
{
  /* member initializers and constructor code */
}

nsTransportEventSink::~nsTransportEventSink()
{
  /* destructor code */
}

/* void onTransportStatus (in nsITransport aTransport, in nsresult aStatus, in unsigned long long aProgress, in unsigned long long aProgressMax); */
NS_IMETHODIMP nsTransportEventSink::OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint64 aProgress, PRUint64 aProgressMax)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsITransport_h__ */
