/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM e:/builds/moz2_slave/m-cen-w32-xr/build/dom/interfaces/events/nsIDOMEventTarget.idl
 */

#ifndef __gen_nsIDOMEventTarget_h__
#define __gen_nsIDOMEventTarget_h__


#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsEvent.h"
class nsPresContext;
class nsEventChainPreVisitor;
class nsEventChainPostVisitor;
struct JSContext;
class nsEventListenerManager;
class nsIScriptContext; /* forward declaration */

class nsIDOMEventListener; /* forward declaration */

class nsIDOMEvent; /* forward declaration */


/* starting interface:    nsIDOMEventTarget */
#define NS_IDOMEVENTTARGET_IID_STR "1797d5a4-b12a-428d-9eef-a0e13839728c"

#define NS_IDOMEVENTTARGET_IID \
  {0x1797d5a4, 0xb12a, 0x428d, \
    { 0x9e, 0xef, 0xa0, 0xe1, 0x38, 0x39, 0x72, 0x8c }}

class NS_SCRIPTABLE nsIDOMEventTarget : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IDOMEVENTTARGET_IID)

  /**
   * This method allows the registration of event listeners on the event target.
   * If an EventListener is added to an EventTarget while it is processing an
   * event, it will not be triggered by the current actions but may be 
   * triggered during a later stage of event flow, such as the bubbling phase.
   * 
   * If multiple identical EventListeners are registered on the same 
   * EventTarget with the same parameters the duplicate instances are 
   * discarded. They do not cause the EventListener to be called twice 
   * and since they are discarded they do not need to be removed with the 
   * removeEventListener method.
   *
   * @param   type The event type for which the user is registering
   * @param   listener The listener parameter takes an interface 
   *                   implemented by the user which contains the methods 
   *                   to be called when the event occurs.
   * @param   useCapture If true, useCapture indicates that the user 
   *                     wishes to initiate capture. After initiating 
   *                     capture, all events of the specified type will be 
   *                     dispatched to the registered EventListener before 
   *                     being dispatched to any EventTargets beneath them 
   *                     in the tree. Events which are bubbling upward 
   *                     through the tree will not trigger an 
   *                     EventListener designated to use capture.
   * @param   wantsUntrusted If false, the listener will not receive any
   *                         untrusted events (see above), if true, the
   *                         listener will receive events whether or not
   *                         they're trusted
   */
  /* [optional_argc] void addEventListener (in DOMString type, in nsIDOMEventListener listener, [optional] in boolean useCapture, [optional] in boolean wantsUntrusted); */
  NS_SCRIPTABLE NS_IMETHOD AddEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture, PRBool wantsUntrusted, PRUint8 _argc) = 0;

  // non-virtual so it won't affect the vtable
  nsresult AddEventListener(const nsAString& aType,
                            nsIDOMEventListener* aListener,
                            PRBool aUseCapture)
  {
    return AddEventListener(aType, aListener, aUseCapture, PR_FALSE, 1);
  }
  // non-virtual so it won't affect the vtable
  nsresult AddEventListener(const nsAString& aType,
                            nsIDOMEventListener* aListener,
                            PRBool aUseCapture,
                            PRBool aWantsUntrusted)
  {
    return AddEventListener(aType, aListener, aUseCapture, aWantsUntrusted, 2);
  }
  /**
   * This method allows the removal of event listeners from the event 
   * target. If an EventListener is removed from an EventTarget while it 
   * is processing an event, it will not be triggered by the current actions. 
   * EventListeners can never be invoked after being removed.
   * Calling removeEventListener with arguments which do not identify any 
   * currently registered EventListener on the EventTarget has no effect.
   *
   * @param   type Specifies the event type of the EventListener being 
   *               removed.
   * @param   listener The EventListener parameter indicates the 
   *                   EventListener to be removed.
   * @param   useCapture Specifies whether the EventListener being 
   *                     removed was registered as a capturing listener or 
   *                     not. If a listener was registered twice, one with 
   *                     capture and one without, each must be removed 
   *                     separately. Removal of a capturing listener does 
   *                     not affect a non-capturing version of the same 
   *                     listener, and vice versa.
   */
  /* void removeEventListener (in DOMString type, in nsIDOMEventListener listener, [optional] in boolean useCapture); */
  NS_SCRIPTABLE NS_IMETHOD RemoveEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture) = 0;

  /**
   * This method allows the dispatch of events into the implementations 
   * event model. Events dispatched in this manner will have the same 
   * capturing and bubbling behavior as events dispatched directly by the 
   * implementation. The target of the event is the EventTarget on which 
   * dispatchEvent is called.
   *
   * @param   evt Specifies the event type, behavior, and contextual 
   *              information to be used in processing the event.
   * @return  Indicates whether any of the listeners which handled the 
   *          event called preventDefault. If preventDefault was called 
   *          the value is false, else the value is true.
   * @throws  UNSPECIFIED_EVENT_TYPE_ERR: Raised if the Event's type was 
   *              not specified by initializing the event before 
   *              dispatchEvent was called. Specification of the Event's 
   *              type as null or an empty string will also trigger this 
   *              exception.
   */
  /* boolean dispatchEvent (in nsIDOMEvent evt)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD DispatchEvent(nsIDOMEvent *evt, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Returns the nsPIDOMEventTarget object which should be used as the target
   * of DOMEvents.
   * Usually |this| is returned, but for example global object returns
   * the outer object.
   */
  /* [nostdcall, notxpcom] nsIDOMEventTarget GetTargetForDOMEvent (); */
  virtual nsIDOMEventTarget * GetTargetForDOMEvent(void) = 0;

  /**
   * Returns the nsPIDOMEventTarget object which should be used as the target
   * of the event and when constructing event target chain.
   * Usually |this| is returned, but for example global object returns
   * the inner object.
   */
  /* [nostdcall, notxpcom] nsIDOMEventTarget GetTargetForEventTargetChain (); */
  virtual nsIDOMEventTarget * GetTargetForEventTargetChain(void) = 0;

  /**
   * Called before the capture phase of the event flow.
   * This is used to create the event target chain and implementations
   * should set the necessary members of nsEventChainPreVisitor.
   * At least aVisitor.mCanHandle must be set,
   * usually also aVisitor.mParentTarget if mCanHandle is PR_TRUE.
   * First one tells that this object can handle the aVisitor.mEvent event and
   * the latter one is the possible parent object for the event target chain.
   * @see nsEventDispatcher.h for more documentation about aVisitor.
   *
   * @param aVisitor the visitor object which is used to create the
   *                 event target chain for event dispatching.
   *
   * @note Only nsEventDispatcher should call this method.
   */
  /* [noscript, nostdcall] void PreHandleEvent (in nsEventChainPreVisitorRef aVisitor); */
  virtual nsresult PreHandleEvent(nsEventChainPreVisitor & aVisitor) = 0;

  /**
   * If nsEventChainPreVisitor.mWantsWillHandleEvent is set PR_TRUE,
   * called just before possible event handlers on this object will be called.
   */
  /* [noscript, nostdcall] void WillHandleEvent (in nsEventChainPostVisitorRef aVisitor); */
  virtual nsresult WillHandleEvent(nsEventChainPostVisitor & aVisitor) = 0;

  /**
   * Called after the bubble phase of the system event group.
   * The default handling of the event should happen here.
   * @param aVisitor the visitor object which is used during post handling.
   *
   * @see nsEventDispatcher.h for documentation about aVisitor.
   * @note Only nsEventDispatcher should call this method.
   */
  /* [noscript, nostdcall] void PostHandleEvent (in nsEventChainPostVisitorRef aVisitor); */
  virtual nsresult PostHandleEvent(nsEventChainPostVisitor & aVisitor) = 0;

  /**
   * Dispatch an event.
   * @param aEvent the event that is being dispatched.
   * @param aDOMEvent the event that is being dispatched, use if you want to
   *                  dispatch nsIDOMEvent, not only nsEvent.
   * @param aPresContext the current presentation context, can be nsnull.
   * @param aEventStatus the status returned from the function, can be nsnull.
   *
   * @note If both aEvent and aDOMEvent are used, aEvent must be the internal
   *       event of the aDOMEvent.
   *
   * If aDOMEvent is not nsnull (in which case aEvent can be nsnull) it is used
   * for dispatching, otherwise aEvent is used.
   *
   * @deprecated This method is here just until all the callers outside Gecko
   *             have been converted to use nsIDOMEventTarget::dispatchEvent.
   */
  /* [noscript, nostdcall] void DispatchDOMEvent (in nsEventPtr aEvent, in nsIDOMEvent aDOMEvent, in nsPresContextPtr aPresContext, in nsEventStatusPtr aEventStatus); */
  virtual nsresult DispatchDOMEvent(nsEvent *aEvent, nsIDOMEvent *aDOMEvent, nsPresContext *aPresContext, nsEventStatus *aEventStatus) = 0;

  /**
   * Get the event listener manager, the guy you talk to to register for events
   * on this node.
   * @param aMayCreate If PR_FALSE, returns a listener manager only if
   *                   one already exists.
   */
  /* [nostdcall, notxpcom] nsEventListenerManagerPtr GetListenerManager (in boolean aMayCreate); */
  virtual nsEventListenerManager * GetListenerManager(PRBool aMayCreate) = 0;

  /**
   * Add an event listener for nsIID.
   */
  /* [noscript, nostdcall] void AddEventListenerByIID (in nsIDOMEventListener aListener, in nsIIDRef aIID); */
  virtual nsresult AddEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) = 0;

  /**
   * Remove event listener for nsIID.
   */
  /* [noscript, nostdcall] void RemoveEventListenerByIID (in nsIDOMEventListener aListener, in nsIIDRef aIID); */
  virtual nsresult RemoveEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) = 0;

  /**
   * Get the script context in which the event handlers should be run.
   * May return null.
   * @note Caller *must* check the value of aRv.
   */
  /* [nostdcall, notxpcom] nsIScriptContext GetContextForEventHandlers (out nsresult aRv); */
  virtual nsIScriptContext * GetContextForEventHandlers(nsresult *aRv NS_OUTPARAM) = 0;

  /**
   * If the method above returns null, but a success code, this method
   * is called.
   */
  /* [nostdcall, notxpcom] JSContextPtr GetJSContextForEventHandlers (); */
  virtual JSContext * GetJSContextForEventHandlers(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIDOMEventTarget, NS_IDOMEVENTTARGET_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOMEVENTTARGET \
  NS_SCRIPTABLE NS_IMETHOD AddEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture, PRBool wantsUntrusted, PRUint8 _argc); \
  NS_SCRIPTABLE NS_IMETHOD RemoveEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture); \
  NS_SCRIPTABLE NS_IMETHOD DispatchEvent(nsIDOMEvent *evt, PRBool *_retval NS_OUTPARAM); \
  virtual nsIDOMEventTarget * GetTargetForDOMEvent(void); \
  virtual nsIDOMEventTarget * GetTargetForEventTargetChain(void); \
  virtual nsresult PreHandleEvent(nsEventChainPreVisitor & aVisitor); \
  virtual nsresult WillHandleEvent(nsEventChainPostVisitor & aVisitor); \
  virtual nsresult PostHandleEvent(nsEventChainPostVisitor & aVisitor); \
  virtual nsresult DispatchDOMEvent(nsEvent *aEvent, nsIDOMEvent *aDOMEvent, nsPresContext *aPresContext, nsEventStatus *aEventStatus); \
  virtual nsEventListenerManager * GetListenerManager(PRBool aMayCreate); \
  virtual nsresult AddEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID); \
  virtual nsresult RemoveEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID); \
  virtual nsIScriptContext * GetContextForEventHandlers(nsresult *aRv NS_OUTPARAM); \
  virtual JSContext * GetJSContextForEventHandlers(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOMEVENTTARGET(_to) \
  NS_SCRIPTABLE NS_IMETHOD AddEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture, PRBool wantsUntrusted, PRUint8 _argc) { return _to AddEventListener(type, listener, useCapture, wantsUntrusted, _argc); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture) { return _to RemoveEventListener(type, listener, useCapture); } \
  NS_SCRIPTABLE NS_IMETHOD DispatchEvent(nsIDOMEvent *evt, PRBool *_retval NS_OUTPARAM) { return _to DispatchEvent(evt, _retval); } \
  virtual nsIDOMEventTarget * GetTargetForDOMEvent(void) { return _to GetTargetForDOMEvent(); } \
  virtual nsIDOMEventTarget * GetTargetForEventTargetChain(void) { return _to GetTargetForEventTargetChain(); } \
  virtual nsresult PreHandleEvent(nsEventChainPreVisitor & aVisitor) { return _to PreHandleEvent(aVisitor); } \
  virtual nsresult WillHandleEvent(nsEventChainPostVisitor & aVisitor) { return _to WillHandleEvent(aVisitor); } \
  virtual nsresult PostHandleEvent(nsEventChainPostVisitor & aVisitor) { return _to PostHandleEvent(aVisitor); } \
  virtual nsresult DispatchDOMEvent(nsEvent *aEvent, nsIDOMEvent *aDOMEvent, nsPresContext *aPresContext, nsEventStatus *aEventStatus) { return _to DispatchDOMEvent(aEvent, aDOMEvent, aPresContext, aEventStatus); } \
  virtual nsEventListenerManager * GetListenerManager(PRBool aMayCreate) { return _to GetListenerManager(aMayCreate); } \
  virtual nsresult AddEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) { return _to AddEventListenerByIID(aListener, aIID); } \
  virtual nsresult RemoveEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) { return _to RemoveEventListenerByIID(aListener, aIID); } \
  virtual nsIScriptContext * GetContextForEventHandlers(nsresult *aRv NS_OUTPARAM) { return _to GetContextForEventHandlers(aRv); } \
  virtual JSContext * GetJSContextForEventHandlers(void) { return _to GetJSContextForEventHandlers(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOMEVENTTARGET(_to) \
  NS_SCRIPTABLE NS_IMETHOD AddEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture, PRBool wantsUntrusted, PRUint8 _argc) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddEventListener(type, listener, useCapture, wantsUntrusted, _argc); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveEventListener(type, listener, useCapture); } \
  NS_SCRIPTABLE NS_IMETHOD DispatchEvent(nsIDOMEvent *evt, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DispatchEvent(evt, _retval); } \
  virtual nsIDOMEventTarget * GetTargetForDOMEvent(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTargetForDOMEvent(); } \
  virtual nsIDOMEventTarget * GetTargetForEventTargetChain(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTargetForEventTargetChain(); } \
  virtual nsresult PreHandleEvent(nsEventChainPreVisitor & aVisitor) { return !_to ? NS_ERROR_NULL_POINTER : _to->PreHandleEvent(aVisitor); } \
  virtual nsresult WillHandleEvent(nsEventChainPostVisitor & aVisitor) { return !_to ? NS_ERROR_NULL_POINTER : _to->WillHandleEvent(aVisitor); } \
  virtual nsresult PostHandleEvent(nsEventChainPostVisitor & aVisitor) { return !_to ? NS_ERROR_NULL_POINTER : _to->PostHandleEvent(aVisitor); } \
  virtual nsresult DispatchDOMEvent(nsEvent *aEvent, nsIDOMEvent *aDOMEvent, nsPresContext *aPresContext, nsEventStatus *aEventStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->DispatchDOMEvent(aEvent, aDOMEvent, aPresContext, aEventStatus); } \
  virtual nsEventListenerManager * GetListenerManager(PRBool aMayCreate) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListenerManager(aMayCreate); } \
  virtual nsresult AddEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddEventListenerByIID(aListener, aIID); } \
  virtual nsresult RemoveEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveEventListenerByIID(aListener, aIID); } \
  virtual nsIScriptContext * GetContextForEventHandlers(nsresult *aRv NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContextForEventHandlers(aRv); } \
  virtual JSContext * GetJSContextForEventHandlers(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetJSContextForEventHandlers(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDOMEventTarget : public nsIDOMEventTarget
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOMEVENTTARGET

  nsDOMEventTarget();

private:
  ~nsDOMEventTarget();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDOMEventTarget, nsIDOMEventTarget)

nsDOMEventTarget::nsDOMEventTarget()
{
  /* member initializers and constructor code */
}

nsDOMEventTarget::~nsDOMEventTarget()
{
  /* destructor code */
}

/* [optional_argc] void addEventListener (in DOMString type, in nsIDOMEventListener listener, [optional] in boolean useCapture, [optional] in boolean wantsUntrusted); */
NS_IMETHODIMP nsDOMEventTarget::AddEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture, PRBool wantsUntrusted, PRUint8 _argc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeEventListener (in DOMString type, in nsIDOMEventListener listener, [optional] in boolean useCapture); */
NS_IMETHODIMP nsDOMEventTarget::RemoveEventListener(const nsAString & type, nsIDOMEventListener *listener, PRBool useCapture)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean dispatchEvent (in nsIDOMEvent evt)  raises (DOMException); */
NS_IMETHODIMP nsDOMEventTarget::DispatchEvent(nsIDOMEvent *evt, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [nostdcall, notxpcom] nsIDOMEventTarget GetTargetForDOMEvent (); */
nsIDOMEventTarget * nsDOMEventTarget::GetTargetForDOMEvent()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [nostdcall, notxpcom] nsIDOMEventTarget GetTargetForEventTargetChain (); */
nsIDOMEventTarget * nsDOMEventTarget::GetTargetForEventTargetChain()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void PreHandleEvent (in nsEventChainPreVisitorRef aVisitor); */
nsresult nsDOMEventTarget::PreHandleEvent(nsEventChainPreVisitor & aVisitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void WillHandleEvent (in nsEventChainPostVisitorRef aVisitor); */
nsresult nsDOMEventTarget::WillHandleEvent(nsEventChainPostVisitor & aVisitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void PostHandleEvent (in nsEventChainPostVisitorRef aVisitor); */
nsresult nsDOMEventTarget::PostHandleEvent(nsEventChainPostVisitor & aVisitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void DispatchDOMEvent (in nsEventPtr aEvent, in nsIDOMEvent aDOMEvent, in nsPresContextPtr aPresContext, in nsEventStatusPtr aEventStatus); */
nsresult nsDOMEventTarget::DispatchDOMEvent(nsEvent *aEvent, nsIDOMEvent *aDOMEvent, nsPresContext *aPresContext, nsEventStatus *aEventStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [nostdcall, notxpcom] nsEventListenerManagerPtr GetListenerManager (in boolean aMayCreate); */
nsEventListenerManager * nsDOMEventTarget::GetListenerManager(PRBool aMayCreate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void AddEventListenerByIID (in nsIDOMEventListener aListener, in nsIIDRef aIID); */
nsresult nsDOMEventTarget::AddEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript, nostdcall] void RemoveEventListenerByIID (in nsIDOMEventListener aListener, in nsIIDRef aIID); */
nsresult nsDOMEventTarget::RemoveEventListenerByIID(nsIDOMEventListener *aListener, const nsIID & aIID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [nostdcall, notxpcom] nsIScriptContext GetContextForEventHandlers (out nsresult aRv); */
nsIScriptContext * nsDOMEventTarget::GetContextForEventHandlers(nsresult *aRv NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [nostdcall, notxpcom] JSContextPtr GetJSContextForEventHandlers (); */
JSContext * nsDOMEventTarget::GetJSContextForEventHandlers()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

typedef nsIDOMEventTarget nsPIDOMEventTarget;
#define NS_IMPL_DOMTARGET_DEFAULTS(_class) \
nsPIDOMEventTarget* _class::GetTargetForDOMEvent() { return this; } \
nsPIDOMEventTarget* _class::GetTargetForEventTargetChain() { return this; } \
nsresult _class::WillHandleEvent(nsEventChainPostVisitor& aVisitor) { return NS_OK; } \
JSContext* _class::GetJSContextForEventHandlers() { return nsnull; }

#endif /* __gen_nsIDOMEventTarget_h__ */
