/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/slave/m-aurora-lnx64-xr/build/dom/interfaces/core/nsIDOMDocument.idl
 */

#ifndef __gen_nsIDOMDocument_h__
#define __gen_nsIDOMDocument_h__


#ifndef __gen_nsIDOMNode_h__
#include "nsIDOMNode.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMNodeIterator; /* forward declaration */

class nsIDOMNodeFilter; /* forward declaration */

class nsIDOMTreeWalker; /* forward declaration */

class nsIDOMLocation; /* forward declaration */


/* starting interface:    nsIDOMDocument */
#define NS_IDOMDOCUMENT_IID_STR "d53c3d3d-2413-4abc-b54e-11c5c8380776"

#define NS_IDOMDOCUMENT_IID \
  {0xd53c3d3d, 0x2413, 0x4abc, \
    { 0xb5, 0x4e, 0x11, 0xc5, 0xc8, 0x38, 0x07, 0x76 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIDOMDocument : public nsIDOMNode {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IDOMDOCUMENT_IID)

  /**
 * The nsIDOMDocument interface represents the entire HTML or XML document.
 * Conceptually, it is the root of the document tree, and provides the 
 * primary access to the document's data.
 * Since elements, text nodes, comments, processing instructions, etc. 
 * cannot exist outside the context of a Document, the nsIDOMDocument 
 * interface also contains the factory methods needed to create these 
 * objects.
 *
 * For more information on this interface please see 
 * http://dvcs.w3.org/hg/domcore/raw-file/tip/Overview.html
 */
  /* readonly attribute nsIDOMDocumentType doctype; */
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) = 0;

  /* readonly attribute nsIDOMDOMImplementation implementation; */
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) = 0;

  /* readonly attribute nsIDOMElement documentElement; */
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) = 0;

  /* nsIDOMElement createElement (in DOMString tagName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* nsIDOMDocumentFragment createDocumentFragment (); */
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) = 0;

  /* nsIDOMText createTextNode (in DOMString data); */
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) = 0;

  /* nsIDOMComment createComment (in DOMString data); */
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) = 0;

  /* nsIDOMCDATASection createCDATASection (in DOMString data)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) = 0;

  /* nsIDOMProcessingInstruction createProcessingInstruction (in DOMString target, in DOMString data)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) = 0;

  /* nsIDOMAttr createAttribute (in DOMString name)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeList getElementsByTagName (in DOMString tagname); */
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNode importNode (in nsIDOMNode importedNode, in boolean deep)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) = 0;

  /* nsIDOMElement createElementNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* nsIDOMAttr createAttributeNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeList getElementsByTagNameNS (in DOMString namespaceURI, in DOMString localName); */
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) = 0;

  /* nsIDOMElement getElementById (in DOMString elementId); */
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* readonly attribute DOMString inputEncoding; */
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) = 0;

  /* readonly attribute DOMString xmlEncoding; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) = 0;

  /* attribute boolean xmlStandalone; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) = 0;

  /* attribute DOMString xmlVersion; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) = 0;

  /* attribute DOMString documentURI; */
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) = 0;

  /* nsIDOMNode adoptNode (in nsIDOMNode source)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) = 0;

  /**
   * Create a range
   *
   * @see http://html5.org/specs/dom-range.html#dom-document-createrange
   */
  /* nsIDOMRange createRange (); */
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeIterator createNodeIterator (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) = 0;

  /* nsIDOMTreeWalker createTreeWalker (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) = 0;

  /* nsIDOMEvent createEvent (in DOMString eventType)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) = 0;

  /**
   * The window associated with this document.
   *
   * @see <http://www.whatwg.org/html/#dom-document-defaultview>
   */
  /* readonly attribute nsIDOMWindow defaultView; */
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-characterset>
   */
  /* readonly attribute DOMString characterSet; */
  NS_SCRIPTABLE NS_IMETHOD GetCharacterSet(nsAString & aCharacterSet) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-dir>
   */
  /* attribute DOMString dir; */
  NS_SCRIPTABLE NS_IMETHOD GetDir(nsAString & aDir) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDir(const nsAString & aDir) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-location>
   */
  /* readonly attribute nsIDOMLocation location; */
  NS_SCRIPTABLE NS_IMETHOD GetLocation(nsIDOMLocation **aLocation) = 0;

  /**
   * @see <http://www.whatwg.org/html/#document.title>
   */
  /* attribute DOMString title; */
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-readystate>
   */
  /* readonly attribute DOMString readyState; */
  NS_SCRIPTABLE NS_IMETHOD GetReadyState(nsAString & aReadyState) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-lastmodified>
   */
  /* readonly attribute DOMString lastModified; */
  NS_SCRIPTABLE NS_IMETHOD GetLastModified(nsAString & aLastModified) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-referrer>
   */
  /* readonly attribute DOMString referrer; */
  NS_SCRIPTABLE NS_IMETHOD GetReferrer(nsAString & aReferrer) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-hasfocus>
   */
  /* boolean hasFocus (); */
  NS_SCRIPTABLE NS_IMETHOD HasFocus(PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * @see <http://www.whatwg.org/html/#dom-document-activeelement>
   */
  /* readonly attribute nsIDOMElement activeElement; */
  NS_SCRIPTABLE NS_IMETHOD GetActiveElement(nsIDOMElement **aActiveElement) = 0;

  /**
   * Retrieve elements matching all classes listed in a
   * space-separated string.
   *
   * @see <http://www.whatwg.org/html/#dom-document-getelementsbyclassname>
   */
  /* nsIDOMNodeList getElementsByClassName (in DOMString classes); */
  NS_SCRIPTABLE NS_IMETHOD GetElementsByClassName(const nsAString & classes, nsIDOMNodeList **_retval NS_OUTPARAM) = 0;

  /**
   * @see <http://dev.w3.org/csswg/cssom/#dom-document-stylesheets>
   */
  /* readonly attribute nsIDOMStyleSheetList styleSheets; */
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheets(nsIDOMStyleSheetList **aStyleSheets) = 0;

  /**
   * This attribute must return the preferred style sheet set as set by the
   * author. It is determined from the order of style sheet declarations and
   * the Default-Style HTTP headers, as eventually defined elsewhere in the Web
   * Apps 1.0 specification. If there is no preferred style sheet set, this
   * attribute must return the empty string. The case of this attribute must
   * exactly match the case given by the author where the preferred style sheet
   * is specified or implied. This attribute must never return null.
   *
   * @see <http://dev.w3.org/csswg/cssom/#dom-document-preferredStyleSheetSet>
   */
  /* readonly attribute DOMString preferredStyleSheetSet; */
  NS_SCRIPTABLE NS_IMETHOD GetPreferredStyleSheetSet(nsAString & aPreferredStyleSheetSet) = 0;

  /**
   * This attribute indicates which style sheet set is in use. This attribute
   * is live; changing the disabled attribute on style sheets directly will
   * change the value of this attribute.
   *
   * If all the sheets that are enabled and have a title have the same title
   * (by case-sensitive comparisons) then the value of this attribute must be
   * exactly equal to the title of the first enabled style sheet with a title
   * in the styleSheets list. Otherwise, if style sheets from different sets
   * are enabled, then the return value must be null (there is no way to
   * determine what the currently selected style sheet set is in those
   * conditions). Otherwise, either all style sheets that have a title are
   * disabled, or there are no alternate style sheets, and
   * selectedStyleSheetSet must return the empty string.
   *
   * Setting this attribute to the null value must have no effect.
   *
   * Setting this attribute to a non-null value must call
   * enableStyleSheetsForSet() with that value as the function's argument, and
   * set lastStyleSheetSet to that value.
   *
   * From the DOM's perspective, all views have the same
   * selectedStyleSheetSet. If a UA supports multiple views with different
   * selected alternate style sheets, then this attribute (and the StyleSheet
   * interface's disabled attribute) must return and set the value for the
   * default view.
   *
   * @see <http://dev.w3.org/csswg/cssom/#dom-document-selectedStyleSheetSet>
   */
  /* attribute DOMString selectedStyleSheetSet; */
  NS_SCRIPTABLE NS_IMETHOD GetSelectedStyleSheetSet(nsAString & aSelectedStyleSheetSet) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSelectedStyleSheetSet(const nsAString & aSelectedStyleSheetSet) = 0;

  /* readonly attribute DOMString lastStyleSheetSet; */
  NS_SCRIPTABLE NS_IMETHOD GetLastStyleSheetSet(nsAString & aLastStyleSheetSet) = 0;

  /**
   * This must return the live list of the currently available style sheet
   * sets. This list is constructed by enumerating all the style sheets for
   * this document available to the implementation, in the order they are
   * listed in the styleSheets attribute, adding the title of each style sheet
   * with a title to the list, avoiding duplicates by dropping titles that
   * match (case-sensitively) titles that have already been added to the
   * list.
   *
   * @see <http://dev.w3.org/csswg/cssom/#dom-document-styleSheetSets>
   */
  /* readonly attribute nsIDOMDOMStringList styleSheetSets; */
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheetSets(nsIDOMDOMStringList **aStyleSheetSets) = 0;

  /**
   * Calling this method must change the disabled attribute on each StyleSheet
   * object with a title attribute with a length greater than 0 in the
   * styleSheets attribute, so that all those whose title matches the name
   * argument are enabled, and all others are disabled. Title matches must be
   * case-sensitive. Calling this method with the empty string disables all
   * alternate and preferred style sheets (but does not change the state of
   * persistent style sheets, that is those with no title attribute).
   *
   * Calling this method with a null value must have no effect.
   *
   * Style sheets that do not have a title are never affected by this
   * method. This method does not change the values of the lastStyleSheetSet or
   * preferredStyleSheetSet attributes.
   *
   * @see <http://dev.w3.org/csswg/cssom/#dom-document-enableStyleSheetsForSet>
   */
  /* void enableStyleSheetsForSet (in DOMString name); */
  NS_SCRIPTABLE NS_IMETHOD EnableStyleSheetsForSet(const nsAString & name) = 0;

  /**
   * Returns the element from the caller's document at the given point,
   * relative to the upper-left-most point in the (possibly scrolled)
   * window or frame.
   *
   * If the element at the given point belongs to another document (such as
   * an iframe's subdocument), the element in the calling document's DOM
   * (e.g. the iframe) is returned. If the element at the given point is
   * anonymous or XBL generated content, such as a textbox's scrollbars, then
   * the first non-anonymous parent element (that is, the textbox) is returned.
   *
   * This method returns null if either coordinate is negative, or if the
   * specified point lies outside the visible bounds of the document.
   *
   * Callers from XUL documents should wait until the onload event has fired
   * before calling this method.
   *
   * @see <http://dev.w3.org/csswg/cssom-view/#dom-document-elementfrompoint>
   */
  /* nsIDOMElement elementFromPoint (in float x, in float y); */
  NS_SCRIPTABLE NS_IMETHOD ElementFromPoint(float x, float y, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /**
   * @see <https://developer.mozilla.org/en/DOM/document.contentType>
   */
  /* readonly attribute DOMString contentType; */
  NS_SCRIPTABLE NS_IMETHOD GetContentType(nsAString & aContentType) = 0;

  /**
   * Returns the script element whose script is currently being processed.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.currentScript>
   */
  /* readonly attribute nsIDOMElement currentScript; */
  NS_SCRIPTABLE NS_IMETHOD GetCurrentScript(nsIDOMElement **aCurrentScript) = 0;

  /**
   * Release the current mouse capture if it is on an element within this
   * document.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.releaseCapture>
   */
  /* void releaseCapture (); */
  NS_SCRIPTABLE NS_IMETHOD ReleaseCapture(void) = 0;

  /**
   * Use the given DOM element as the source image of target |-moz-element()|.
   *
   * This function introduces a new special ID (called "image element ID"),
   * which is only used by |-moz-element()|, and associates it with the given
   * DOM element.  Image elements ID's have the higher precedence than general
   * HTML id's, so if |document.mozSetImageElement(<id>, <element>)| is called,
   * |-moz-element(#<id>)| uses |<element>| as the source image even if there
   * is another element with id attribute = |<id>|.  To unregister an image
   * element ID |<id>|, call |document.mozSetImageElement(<id>, null)|.
   *
   * Example:
   * <script>
   *   canvas = document.createElement("canvas");
   *   canvas.setAttribute("width", 100);
   *   canvas.setAttribute("height", 100);
   *   // draw to canvas
   *   document.mozSetImageElement("canvasbg", canvas);
   * </script>
   * <div style="background-image: -moz-element(#canvasbg);"></div>
   *
   * @param aImageElementId an image element ID to associate with
   * |aImageElement|
   * @param aImageElement a DOM element to be used as the source image of
   * |-moz-element(#aImageElementId)|. If this is null, the function will
   * unregister the image element ID |aImageElementId|.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.mozSetImageElement>
   */
  /* void mozSetImageElement (in DOMString aImageElementId, in nsIDOMElement aImageElement); */
  NS_SCRIPTABLE NS_IMETHOD MozSetImageElement(const nsAString & aImageElementId, nsIDOMElement *aImageElement) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIDOMDocument, NS_IDOMDOCUMENT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOMDOCUMENT \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype); \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation); \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement); \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone); \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion); \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion); \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI); \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI); \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView); \
  NS_SCRIPTABLE NS_IMETHOD GetCharacterSet(nsAString & aCharacterSet); \
  NS_SCRIPTABLE NS_IMETHOD GetDir(nsAString & aDir); \
  NS_SCRIPTABLE NS_IMETHOD SetDir(const nsAString & aDir); \
  NS_SCRIPTABLE NS_IMETHOD GetLocation(nsIDOMLocation **aLocation); \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD GetReadyState(nsAString & aReadyState); \
  NS_SCRIPTABLE NS_IMETHOD GetLastModified(nsAString & aLastModified); \
  NS_SCRIPTABLE NS_IMETHOD GetReferrer(nsAString & aReferrer); \
  NS_SCRIPTABLE NS_IMETHOD HasFocus(PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetActiveElement(nsIDOMElement **aActiveElement); \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByClassName(const nsAString & classes, nsIDOMNodeList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheets(nsIDOMStyleSheetList **aStyleSheets); \
  NS_SCRIPTABLE NS_IMETHOD GetPreferredStyleSheetSet(nsAString & aPreferredStyleSheetSet); \
  NS_SCRIPTABLE NS_IMETHOD GetSelectedStyleSheetSet(nsAString & aSelectedStyleSheetSet); \
  NS_SCRIPTABLE NS_IMETHOD SetSelectedStyleSheetSet(const nsAString & aSelectedStyleSheetSet); \
  NS_SCRIPTABLE NS_IMETHOD GetLastStyleSheetSet(nsAString & aLastStyleSheetSet); \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheetSets(nsIDOMDOMStringList **aStyleSheetSets); \
  NS_SCRIPTABLE NS_IMETHOD EnableStyleSheetsForSet(const nsAString & name); \
  NS_SCRIPTABLE NS_IMETHOD ElementFromPoint(float x, float y, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetContentType(nsAString & aContentType); \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentScript(nsIDOMElement **aCurrentScript); \
  NS_SCRIPTABLE NS_IMETHOD ReleaseCapture(void); \
  NS_SCRIPTABLE NS_IMETHOD MozSetImageElement(const nsAString & aImageElementId, nsIDOMElement *aImageElement); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOMDOCUMENT(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) { return _to GetDoctype(aDoctype); } \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) { return _to GetImplementation(aImplementation); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) { return _to GetDocumentElement(aDocumentElement); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) { return _to CreateElement(tagName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) { return _to CreateDocumentFragment(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) { return _to CreateTextNode(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) { return _to CreateComment(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) { return _to CreateCDATASection(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) { return _to CreateProcessingInstruction(target, data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) { return _to CreateAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) { return _to GetElementsByTagName(tagname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) { return _to ImportNode(importedNode, deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) { return _to CreateElementNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) { return _to CreateAttributeNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) { return _to GetElementsByTagNameNS(namespaceURI, localName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) { return _to GetElementById(elementId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) { return _to GetInputEncoding(aInputEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) { return _to GetXmlEncoding(aXmlEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) { return _to GetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) { return _to SetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) { return _to GetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) { return _to SetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) { return _to GetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) { return _to SetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) { return _to AdoptNode(source, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) { return _to CreateRange(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) { return _to CreateNodeIterator(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) { return _to CreateTreeWalker(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) { return _to CreateEvent(eventType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) { return _to GetDefaultView(aDefaultView); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharacterSet(nsAString & aCharacterSet) { return _to GetCharacterSet(aCharacterSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetDir(nsAString & aDir) { return _to GetDir(aDir); } \
  NS_SCRIPTABLE NS_IMETHOD SetDir(const nsAString & aDir) { return _to SetDir(aDir); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocation(nsIDOMLocation **aLocation) { return _to GetLocation(aLocation); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return _to GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return _to SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetReadyState(nsAString & aReadyState) { return _to GetReadyState(aReadyState); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastModified(nsAString & aLastModified) { return _to GetLastModified(aLastModified); } \
  NS_SCRIPTABLE NS_IMETHOD GetReferrer(nsAString & aReferrer) { return _to GetReferrer(aReferrer); } \
  NS_SCRIPTABLE NS_IMETHOD HasFocus(PRBool *_retval NS_OUTPARAM) { return _to HasFocus(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveElement(nsIDOMElement **aActiveElement) { return _to GetActiveElement(aActiveElement); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByClassName(const nsAString & classes, nsIDOMNodeList **_retval NS_OUTPARAM) { return _to GetElementsByClassName(classes, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheets(nsIDOMStyleSheetList **aStyleSheets) { return _to GetStyleSheets(aStyleSheets); } \
  NS_SCRIPTABLE NS_IMETHOD GetPreferredStyleSheetSet(nsAString & aPreferredStyleSheetSet) { return _to GetPreferredStyleSheetSet(aPreferredStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetSelectedStyleSheetSet(nsAString & aSelectedStyleSheetSet) { return _to GetSelectedStyleSheetSet(aSelectedStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD SetSelectedStyleSheetSet(const nsAString & aSelectedStyleSheetSet) { return _to SetSelectedStyleSheetSet(aSelectedStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastStyleSheetSet(nsAString & aLastStyleSheetSet) { return _to GetLastStyleSheetSet(aLastStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheetSets(nsIDOMDOMStringList **aStyleSheetSets) { return _to GetStyleSheetSets(aStyleSheetSets); } \
  NS_SCRIPTABLE NS_IMETHOD EnableStyleSheetsForSet(const nsAString & name) { return _to EnableStyleSheetsForSet(name); } \
  NS_SCRIPTABLE NS_IMETHOD ElementFromPoint(float x, float y, nsIDOMElement **_retval NS_OUTPARAM) { return _to ElementFromPoint(x, y, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetContentType(nsAString & aContentType) { return _to GetContentType(aContentType); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentScript(nsIDOMElement **aCurrentScript) { return _to GetCurrentScript(aCurrentScript); } \
  NS_SCRIPTABLE NS_IMETHOD ReleaseCapture(void) { return _to ReleaseCapture(); } \
  NS_SCRIPTABLE NS_IMETHOD MozSetImageElement(const nsAString & aImageElementId, nsIDOMElement *aImageElement) { return _to MozSetImageElement(aImageElementId, aImageElement); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOMDOCUMENT(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoctype(aDoctype); } \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImplementation(aImplementation); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentElement(aDocumentElement); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElement(tagName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateDocumentFragment(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTextNode(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateComment(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateCDATASection(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateProcessingInstruction(target, data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementsByTagName(tagname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ImportNode(importedNode, deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElementNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAttributeNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementsByTagNameNS(namespaceURI, localName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementById(elementId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInputEncoding(aInputEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlEncoding(aXmlEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AdoptNode(source, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateRange(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateNodeIterator(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTreeWalker(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateEvent(eventType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultView(aDefaultView); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharacterSet(nsAString & aCharacterSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharacterSet(aCharacterSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetDir(nsAString & aDir) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDir(aDir); } \
  NS_SCRIPTABLE NS_IMETHOD SetDir(const nsAString & aDir) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDir(aDir); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocation(nsIDOMLocation **aLocation) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocation(aLocation); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetReadyState(nsAString & aReadyState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReadyState(aReadyState); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastModified(nsAString & aLastModified) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastModified(aLastModified); } \
  NS_SCRIPTABLE NS_IMETHOD GetReferrer(nsAString & aReferrer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReferrer(aReferrer); } \
  NS_SCRIPTABLE NS_IMETHOD HasFocus(PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasFocus(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveElement(nsIDOMElement **aActiveElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActiveElement(aActiveElement); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByClassName(const nsAString & classes, nsIDOMNodeList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementsByClassName(classes, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheets(nsIDOMStyleSheetList **aStyleSheets) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStyleSheets(aStyleSheets); } \
  NS_SCRIPTABLE NS_IMETHOD GetPreferredStyleSheetSet(nsAString & aPreferredStyleSheetSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPreferredStyleSheetSet(aPreferredStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetSelectedStyleSheetSet(nsAString & aSelectedStyleSheetSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedStyleSheetSet(aSelectedStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD SetSelectedStyleSheetSet(const nsAString & aSelectedStyleSheetSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSelectedStyleSheetSet(aSelectedStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastStyleSheetSet(nsAString & aLastStyleSheetSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastStyleSheetSet(aLastStyleSheetSet); } \
  NS_SCRIPTABLE NS_IMETHOD GetStyleSheetSets(nsIDOMDOMStringList **aStyleSheetSets) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStyleSheetSets(aStyleSheetSets); } \
  NS_SCRIPTABLE NS_IMETHOD EnableStyleSheetsForSet(const nsAString & name) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnableStyleSheetsForSet(name); } \
  NS_SCRIPTABLE NS_IMETHOD ElementFromPoint(float x, float y, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ElementFromPoint(x, y, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetContentType(nsAString & aContentType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentType(aContentType); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentScript(nsIDOMElement **aCurrentScript) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentScript(aCurrentScript); } \
  NS_SCRIPTABLE NS_IMETHOD ReleaseCapture(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReleaseCapture(); } \
  NS_SCRIPTABLE NS_IMETHOD MozSetImageElement(const nsAString & aImageElementId, nsIDOMElement *aImageElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->MozSetImageElement(aImageElementId, aImageElement); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDOMDocument : public nsIDOMDocument
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOMDOCUMENT

  nsDOMDocument();

private:
  ~nsDOMDocument();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDOMDocument, nsIDOMDocument)

nsDOMDocument::nsDOMDocument()
{
  /* member initializers and constructor code */
}

nsDOMDocument::~nsDOMDocument()
{
  /* destructor code */
}

/* readonly attribute nsIDOMDocumentType doctype; */
NS_IMETHODIMP nsDOMDocument::GetDoctype(nsIDOMDocumentType **aDoctype)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDOMImplementation implementation; */
NS_IMETHODIMP nsDOMDocument::GetImplementation(nsIDOMDOMImplementation **aImplementation)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMElement documentElement; */
NS_IMETHODIMP nsDOMDocument::GetDocumentElement(nsIDOMElement **aDocumentElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement createElement (in DOMString tagName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMDocumentFragment createDocumentFragment (); */
NS_IMETHODIMP nsDOMDocument::CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMText createTextNode (in DOMString data); */
NS_IMETHODIMP nsDOMDocument::CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMComment createComment (in DOMString data); */
NS_IMETHODIMP nsDOMDocument::CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMCDATASection createCDATASection (in DOMString data)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMProcessingInstruction createProcessingInstruction (in DOMString target, in DOMString data)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMAttr createAttribute (in DOMString name)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeList getElementsByTagName (in DOMString tagname); */
NS_IMETHODIMP nsDOMDocument::GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode importNode (in nsIDOMNode importedNode, in boolean deep)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement createElementNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMAttr createAttributeNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeList getElementsByTagNameNS (in DOMString namespaceURI, in DOMString localName); */
NS_IMETHODIMP nsDOMDocument::GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement getElementById (in DOMString elementId); */
NS_IMETHODIMP nsDOMDocument::GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString inputEncoding; */
NS_IMETHODIMP nsDOMDocument::GetInputEncoding(nsAString & aInputEncoding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString xmlEncoding; */
NS_IMETHODIMP nsDOMDocument::GetXmlEncoding(nsAString & aXmlEncoding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean xmlStandalone; */
NS_IMETHODIMP nsDOMDocument::GetXmlStandalone(PRBool *aXmlStandalone)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetXmlStandalone(PRBool aXmlStandalone)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString xmlVersion; */
NS_IMETHODIMP nsDOMDocument::GetXmlVersion(nsAString & aXmlVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetXmlVersion(const nsAString & aXmlVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString documentURI; */
NS_IMETHODIMP nsDOMDocument::GetDocumentURI(nsAString & aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetDocumentURI(const nsAString & aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode adoptNode (in nsIDOMNode source)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMRange createRange (); */
NS_IMETHODIMP nsDOMDocument::CreateRange(nsIDOMRange **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeIterator createNodeIterator (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMTreeWalker createTreeWalker (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMEvent createEvent (in DOMString eventType)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMWindow defaultView; */
NS_IMETHODIMP nsDOMDocument::GetDefaultView(nsIDOMWindow **aDefaultView)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString characterSet; */
NS_IMETHODIMP nsDOMDocument::GetCharacterSet(nsAString & aCharacterSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString dir; */
NS_IMETHODIMP nsDOMDocument::GetDir(nsAString & aDir)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetDir(const nsAString & aDir)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMLocation location; */
NS_IMETHODIMP nsDOMDocument::GetLocation(nsIDOMLocation **aLocation)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString title; */
NS_IMETHODIMP nsDOMDocument::GetTitle(nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetTitle(const nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString readyState; */
NS_IMETHODIMP nsDOMDocument::GetReadyState(nsAString & aReadyState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString lastModified; */
NS_IMETHODIMP nsDOMDocument::GetLastModified(nsAString & aLastModified)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString referrer; */
NS_IMETHODIMP nsDOMDocument::GetReferrer(nsAString & aReferrer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasFocus (); */
NS_IMETHODIMP nsDOMDocument::HasFocus(PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMElement activeElement; */
NS_IMETHODIMP nsDOMDocument::GetActiveElement(nsIDOMElement **aActiveElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeList getElementsByClassName (in DOMString classes); */
NS_IMETHODIMP nsDOMDocument::GetElementsByClassName(const nsAString & classes, nsIDOMNodeList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMStyleSheetList styleSheets; */
NS_IMETHODIMP nsDOMDocument::GetStyleSheets(nsIDOMStyleSheetList **aStyleSheets)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString preferredStyleSheetSet; */
NS_IMETHODIMP nsDOMDocument::GetPreferredStyleSheetSet(nsAString & aPreferredStyleSheetSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString selectedStyleSheetSet; */
NS_IMETHODIMP nsDOMDocument::GetSelectedStyleSheetSet(nsAString & aSelectedStyleSheetSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetSelectedStyleSheetSet(const nsAString & aSelectedStyleSheetSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString lastStyleSheetSet; */
NS_IMETHODIMP nsDOMDocument::GetLastStyleSheetSet(nsAString & aLastStyleSheetSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDOMStringList styleSheetSets; */
NS_IMETHODIMP nsDOMDocument::GetStyleSheetSets(nsIDOMDOMStringList **aStyleSheetSets)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void enableStyleSheetsForSet (in DOMString name); */
NS_IMETHODIMP nsDOMDocument::EnableStyleSheetsForSet(const nsAString & name)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement elementFromPoint (in float x, in float y); */
NS_IMETHODIMP nsDOMDocument::ElementFromPoint(float x, float y, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString contentType; */
NS_IMETHODIMP nsDOMDocument::GetContentType(nsAString & aContentType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMElement currentScript; */
NS_IMETHODIMP nsDOMDocument::GetCurrentScript(nsIDOMElement **aCurrentScript)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void releaseCapture (); */
NS_IMETHODIMP nsDOMDocument::ReleaseCapture()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void mozSetImageElement (in DOMString aImageElementId, in nsIDOMElement aImageElement); */
NS_IMETHODIMP nsDOMDocument::MozSetImageElement(const nsAString & aImageElementId, nsIDOMElement *aImageElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDOMDocument_h__ */
