/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /builds/slave/m-beta-lnx64-xr/build/dom/interfaces/core/nsIDOMDocument.idl
 */

#ifndef __gen_nsIDOMDocument_h__
#define __gen_nsIDOMDocument_h__


#ifndef __gen_nsIDOMNode_h__
#include "nsIDOMNode.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMNodeIterator; /* forward declaration */

class nsIDOMNodeFilter; /* forward declaration */

class nsIDOMTreeWalker; /* forward declaration */


/* starting interface:    nsIDOMDocument */
#define NS_IDOMDOCUMENT_IID_STR "61b2159c-614e-4aff-a626-f34af9bb1759"

#define NS_IDOMDOCUMENT_IID \
  {0x61b2159c, 0x614e, 0x4aff, \
    { 0xa6, 0x26, 0xf3, 0x4a, 0xf9, 0xbb, 0x17, 0x59 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIDOMDocument : public nsIDOMNode {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IDOMDOCUMENT_IID)

  /**
 * The nsIDOMDocument interface represents the entire HTML or XML document.
 * Conceptually, it is the root of the document tree, and provides the 
 * primary access to the document's data.
 * Since elements, text nodes, comments, processing instructions, etc. 
 * cannot exist outside the context of a Document, the nsIDOMDocument 
 * interface also contains the factory methods needed to create these 
 * objects.
 *
 * For more information on this interface please see 
 * http://dvcs.w3.org/hg/domcore/raw-file/tip/Overview.html
 */
  /* readonly attribute nsIDOMDocumentType doctype; */
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) = 0;

  /* readonly attribute nsIDOMDOMImplementation implementation; */
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) = 0;

  /* readonly attribute nsIDOMElement documentElement; */
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) = 0;

  /* nsIDOMElement createElement (in DOMString tagName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* nsIDOMDocumentFragment createDocumentFragment (); */
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) = 0;

  /* nsIDOMText createTextNode (in DOMString data); */
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) = 0;

  /* nsIDOMComment createComment (in DOMString data); */
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) = 0;

  /* nsIDOMCDATASection createCDATASection (in DOMString data)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) = 0;

  /* nsIDOMProcessingInstruction createProcessingInstruction (in DOMString target, in DOMString data)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) = 0;

  /* nsIDOMAttr createAttribute (in DOMString name)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) = 0;

  /* nsIDOMEntityReference createEntityReference (in DOMString name)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateEntityReference(const nsAString & name, nsIDOMEntityReference **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeList getElementsByTagName (in DOMString tagname); */
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNode importNode (in nsIDOMNode importedNode, in boolean deep)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) = 0;

  /* nsIDOMElement createElementNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* nsIDOMAttr createAttributeNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeList getElementsByTagNameNS (in DOMString namespaceURI, in DOMString localName); */
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) = 0;

  /* nsIDOMElement getElementById (in DOMString elementId); */
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) = 0;

  /* readonly attribute DOMString inputEncoding; */
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) = 0;

  /* readonly attribute DOMString xmlEncoding; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) = 0;

  /* attribute boolean xmlStandalone; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) = 0;

  /* attribute DOMString xmlVersion; */
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) = 0;

  /* attribute DOMString documentURI; */
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) = 0;

  /* nsIDOMNode adoptNode (in nsIDOMNode source)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) = 0;

  /* void normalizeDocument (); */
  NS_SCRIPTABLE NS_IMETHOD NormalizeDocument(void) = 0;

  /**
   * The window associated with this document.
   *
   * @see http://www.whatwg.org/html/#dom-document-defaultview
   */
  /* readonly attribute nsIDOMWindow defaultView; */
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) = 0;

  /**
   * Create a range
   *
   * @see http://html5.org/specs/dom-range.html#dom-document-createrange
   */
  /* nsIDOMRange createRange (); */
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) = 0;

  /* nsIDOMNodeIterator createNodeIterator (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) = 0;

  /* nsIDOMTreeWalker createTreeWalker (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) = 0;

  /* nsIDOMEvent createEvent (in DOMString eventType)  raises (DOMException); */
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIDOMDocument, NS_IDOMDOCUMENT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOMDOCUMENT \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype); \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation); \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement); \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateEntityReference(const nsAString & name, nsIDOMEntityReference **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone); \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone); \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion); \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion); \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI); \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI); \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD NormalizeDocument(void); \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView); \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOMDOCUMENT(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) { return _to GetDoctype(aDoctype); } \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) { return _to GetImplementation(aImplementation); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) { return _to GetDocumentElement(aDocumentElement); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) { return _to CreateElement(tagName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) { return _to CreateDocumentFragment(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) { return _to CreateTextNode(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) { return _to CreateComment(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) { return _to CreateCDATASection(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) { return _to CreateProcessingInstruction(target, data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) { return _to CreateAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEntityReference(const nsAString & name, nsIDOMEntityReference **_retval NS_OUTPARAM) { return _to CreateEntityReference(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) { return _to GetElementsByTagName(tagname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) { return _to ImportNode(importedNode, deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) { return _to CreateElementNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) { return _to CreateAttributeNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) { return _to GetElementsByTagNameNS(namespaceURI, localName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) { return _to GetElementById(elementId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) { return _to GetInputEncoding(aInputEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) { return _to GetXmlEncoding(aXmlEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) { return _to GetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) { return _to SetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) { return _to GetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) { return _to SetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) { return _to GetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) { return _to SetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) { return _to AdoptNode(source, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NormalizeDocument(void) { return _to NormalizeDocument(); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) { return _to GetDefaultView(aDefaultView); } \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) { return _to CreateRange(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) { return _to CreateNodeIterator(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) { return _to CreateTreeWalker(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) { return _to CreateEvent(eventType, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOMDOCUMENT(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDoctype(nsIDOMDocumentType **aDoctype) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoctype(aDoctype); } \
  NS_SCRIPTABLE NS_IMETHOD GetImplementation(nsIDOMDOMImplementation **aImplementation) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImplementation(aImplementation); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentElement(nsIDOMElement **aDocumentElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentElement(aDocumentElement); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElement(tagName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateDocumentFragment(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTextNode(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateComment(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateCDATASection(data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateProcessingInstruction(target, data, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEntityReference(const nsAString & name, nsIDOMEntityReference **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateEntityReference(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementsByTagName(tagname, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ImportNode(importedNode, deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElementNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAttributeNS(namespaceURI, qualifiedName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementsByTagNameNS(namespaceURI, localName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementById(elementId, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetInputEncoding(nsAString & aInputEncoding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInputEncoding(aInputEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlEncoding(nsAString & aXmlEncoding) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlEncoding(aXmlEncoding); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlStandalone(PRBool *aXmlStandalone) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlStandalone(PRBool aXmlStandalone) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetXmlStandalone(aXmlStandalone); } \
  NS_SCRIPTABLE NS_IMETHOD GetXmlVersion(nsAString & aXmlVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD SetXmlVersion(const nsAString & aXmlVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetXmlVersion(aXmlVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocumentURI(nsAString & aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD SetDocumentURI(const nsAString & aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentURI(aDocumentURI); } \
  NS_SCRIPTABLE NS_IMETHOD AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AdoptNode(source, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NormalizeDocument(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->NormalizeDocument(); } \
  NS_SCRIPTABLE NS_IMETHOD GetDefaultView(nsIDOMWindow **aDefaultView) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultView(aDefaultView); } \
  NS_SCRIPTABLE NS_IMETHOD CreateRange(nsIDOMRange **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateRange(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateNodeIterator(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTreeWalker(root, whatToShow, filter, entityReferenceExpansion, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateEvent(eventType, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDOMDocument : public nsIDOMDocument
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOMDOCUMENT

  nsDOMDocument();

private:
  ~nsDOMDocument();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDOMDocument, nsIDOMDocument)

nsDOMDocument::nsDOMDocument()
{
  /* member initializers and constructor code */
}

nsDOMDocument::~nsDOMDocument()
{
  /* destructor code */
}

/* readonly attribute nsIDOMDocumentType doctype; */
NS_IMETHODIMP nsDOMDocument::GetDoctype(nsIDOMDocumentType **aDoctype)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDOMImplementation implementation; */
NS_IMETHODIMP nsDOMDocument::GetImplementation(nsIDOMDOMImplementation **aImplementation)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMElement documentElement; */
NS_IMETHODIMP nsDOMDocument::GetDocumentElement(nsIDOMElement **aDocumentElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement createElement (in DOMString tagName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateElement(const nsAString & tagName, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMDocumentFragment createDocumentFragment (); */
NS_IMETHODIMP nsDOMDocument::CreateDocumentFragment(nsIDOMDocumentFragment **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMText createTextNode (in DOMString data); */
NS_IMETHODIMP nsDOMDocument::CreateTextNode(const nsAString & data, nsIDOMText **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMComment createComment (in DOMString data); */
NS_IMETHODIMP nsDOMDocument::CreateComment(const nsAString & data, nsIDOMComment **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMCDATASection createCDATASection (in DOMString data)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateCDATASection(const nsAString & data, nsIDOMCDATASection **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMProcessingInstruction createProcessingInstruction (in DOMString target, in DOMString data)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateProcessingInstruction(const nsAString & target, const nsAString & data, nsIDOMProcessingInstruction **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMAttr createAttribute (in DOMString name)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateAttribute(const nsAString & name, nsIDOMAttr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMEntityReference createEntityReference (in DOMString name)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateEntityReference(const nsAString & name, nsIDOMEntityReference **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeList getElementsByTagName (in DOMString tagname); */
NS_IMETHODIMP nsDOMDocument::GetElementsByTagName(const nsAString & tagname, nsIDOMNodeList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode importNode (in nsIDOMNode importedNode, in boolean deep)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::ImportNode(nsIDOMNode *importedNode, PRBool deep, nsIDOMNode **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement createElementNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateElementNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMAttr createAttributeNS (in DOMString namespaceURI, in DOMString qualifiedName)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateAttributeNS(const nsAString & namespaceURI, const nsAString & qualifiedName, nsIDOMAttr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeList getElementsByTagNameNS (in DOMString namespaceURI, in DOMString localName); */
NS_IMETHODIMP nsDOMDocument::GetElementsByTagNameNS(const nsAString & namespaceURI, const nsAString & localName, nsIDOMNodeList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement getElementById (in DOMString elementId); */
NS_IMETHODIMP nsDOMDocument::GetElementById(const nsAString & elementId, nsIDOMElement **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString inputEncoding; */
NS_IMETHODIMP nsDOMDocument::GetInputEncoding(nsAString & aInputEncoding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute DOMString xmlEncoding; */
NS_IMETHODIMP nsDOMDocument::GetXmlEncoding(nsAString & aXmlEncoding)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean xmlStandalone; */
NS_IMETHODIMP nsDOMDocument::GetXmlStandalone(PRBool *aXmlStandalone)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetXmlStandalone(PRBool aXmlStandalone)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString xmlVersion; */
NS_IMETHODIMP nsDOMDocument::GetXmlVersion(nsAString & aXmlVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetXmlVersion(const nsAString & aXmlVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute DOMString documentURI; */
NS_IMETHODIMP nsDOMDocument::GetDocumentURI(nsAString & aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDOMDocument::SetDocumentURI(const nsAString & aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode adoptNode (in nsIDOMNode source)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::AdoptNode(nsIDOMNode *source, nsIDOMNode **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void normalizeDocument (); */
NS_IMETHODIMP nsDOMDocument::NormalizeDocument()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMWindow defaultView; */
NS_IMETHODIMP nsDOMDocument::GetDefaultView(nsIDOMWindow **aDefaultView)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMRange createRange (); */
NS_IMETHODIMP nsDOMDocument::CreateRange(nsIDOMRange **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNodeIterator createNodeIterator (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateNodeIterator(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMNodeIterator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMTreeWalker createTreeWalker (in nsIDOMNode root, in unsigned long whatToShow, in nsIDOMNodeFilter filter, in boolean entityReferenceExpansion)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateTreeWalker(nsIDOMNode *root, PRUint32 whatToShow, nsIDOMNodeFilter *filter, PRBool entityReferenceExpansion, nsIDOMTreeWalker **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMEvent createEvent (in DOMString eventType)  raises (DOMException); */
NS_IMETHODIMP nsDOMDocument::CreateEvent(const nsAString & eventType, nsIDOMEvent **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDOMDocument_h__ */
