/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/slave/m-192-lnx-xr/build/accessible/public/nsIAccessibleTable.idl
 */

package org.mozilla.interfaces;

public interface nsIAccessibleTable extends nsISupports {

  String NS_IACCESSIBLETABLE_IID =
    "{035c0c0e-41e3-4985-8ad9-d9f14cdc667a}";

  /**
   * Return the caption accessible for the table. For example, html:caption
   * element of html:table element.
   */
  nsIAccessible getCaption();

  /**
   * Return summary description for the table. For example, @summary attribute
   * on html:table element.
   */
  String getSummary();

  /**
   * Return columns count in the table.
   */
  int getColumnCount();

  /**
   * Return rows count in the table.
   */
  int getRowCount();

  /**
   * Return the accessible object at the specified row and column in the table.
   * If both row and column index are valid then the corresponding accessible
   * object is returned that represents the requested cell regardless of whether
   * the cell is currently visible (on the screen).
   *
   * @param  rowIndex     [in] the row index to retrieve the cell at
   * @param  columnIndex  [in] the column index to retrieve the cell at
   */
  nsIAccessible getCellAt(int rowIndex, int columnIndex);

  /**
   * Translate the given row and column indices into the corresponding cell
   * index.
   *
   * @param  rowIndex    [in] the row index to return cell index at
   * @param  columnIndex [in] the column index to return cell index at
   */
  int getCellIndexAt(int rowIndex, int columnIndex);

  /**
   * Translate the given cell index into the corresponding column index.
   *
   * @param  cellIndex  [in] index of the table cell to return column index for
   */
  int getColumnIndexAt(int cellIndex);

  /**
   * Translate the given cell index into the corresponding row index.
   *
   * @param cellIndex  [in] index of the table cell to return row index for
   */
  int getRowIndexAt(int cellIndex);

  /**
   * Return the number of columns occupied by the accessible cell at
   * the specified row and column in the table. The result differs from 1 if
   * the specified cell spans multiple columns.
   *
   * @param  row     [in] row index of the cell to return the column extent for
   * @param  column  [in] column index of the cell to return the column extent
   *                  for
   */
  int getColumnExtentAt(int row, int column);

  /**
   * Return the number of rows occupied by the accessible cell at the specified
   * row and column in the table. The result differs from 1 if the specified
   * cell spans multiple rows.
   *
   * @param  row     [in] row index of the cell to return the column extent for
   * @param  column  [in] column index of the cell to return the column extent
   *                  for
   */
  int getRowExtentAt(int row, int column);

  /**
   * Return the description text of the specified column in the table.
   *
   * @param  columnIndex  [in] the column index to retrieve description for
   */
  String getColumnDescription(int columnIndex);

  /**
   * Return the description text of the specified row in the table.
   *
   * @param  rowIndex  [in] the row index to retrieve description for
   */
  String getRowDescription(int rowIndex);

  /**
   * Return a boolean value indicating whether the specified column is
   * selected, i.e. all cells within the column are selected.
   *
   * @param  columnIndex  [in] the column index to determine if it's selected
   */
  boolean isColumnSelected(int columnIndex);

  /**
   * Return a boolean value indicating whether the specified row is selected,
   * i.e. all cells within the row are selected.
   *
   * @param  rowIndex  [in] the row index to determine whether it's selected
   */
  boolean isRowSelected(int rowIndex);

  /**
   * Return a boolean value indicating whether the specified cell is selected.
   *
   * @param  rowIndex     [in] the row index of the cell
   * @param  columnIndex  [in] the column index of the cell
   */
  boolean isCellSelected(int rowIndex, int columnIndex);

  /**
   * Return the total number of selected cells.
   */
  long getSelectedCellCount();

  /**
   * Return the total number of selected columns.
   */
  long getSelectedColumnCount();

  /**
   * Return the total number of selected rows.
   */
  long getSelectedRowCount();

  /**
   * Return an array of selected cells.
   */
  nsIArray getSelectedCells();

  /**
   * Return an array of cell indices currently selected.
   *
   * @param  cellsArraySize  [in] length of array
   * @param  cellsArray      [in] array of indexes of selected cells
   */
  int[] getSelectedCellIndices(long[] cellsArraySize);

  /**
   * Return an array of column indices currently selected.
   *
   * @param  columnsArraySize  [in] length of array
   * @param  columnsArray      [in] array of indices of selected columns
   */
  int[] getSelectedColumnIndices(long[] columnsArraySize);

  /**
   * Return an array of row indices currently selected.
   *
   * @param  rowsArraySize  [in] Length of array
   * @param  rowsArray      [in] array of indices of selected rows
   */
  int[] getSelectedRowIndices(long[] rowsArraySize);

  /**
   * Select a row and unselects all previously selected rows.
   *
   * @param  rowIndex  [in] the row index to select
   */
  void selectRow(int rowIndex);

  /**
   * Select a column and unselects all previously selected columns.
   *
   * @param  columnIndex  [in] the column index to select
   */
  void selectColumn(int columnIndex);

  /**
   * Unselect the given row, leaving other selected rows selected (if any).
   *
   * @param  rowIndex  [in] the row index to select
  */
  void unselectRow(int rowIndex);

  /**
   * Unselect the given column, leaving other selected columns selected (if any).
   *
   * @param  columnIndex  [in] the column index to select
   */
  void unselectColumn(int columnIndex);

  /**
   * Use heuristics to determine if table is most likely used for layout.
   */
  boolean isProbablyForLayout();

}