/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

var EXPORTED_SYMBOLS = ["PrivateBrowsingUtils"];

Components.utils.import("resource://gre/modules/Services.jsm");

const kAutoStartPref = "browser.components.autostart";

const Cc = Components.classes;
const Ci = Components.interfaces;

var PrivateBrowsingUtils = {
  isWindowPrivate: function pbu_isWindowPrivate(aWindow) {
    return aWindow.QueryInterface(Ci.nsIInterfaceRequestor)
                  .getInterface(Ci.nsIWebNavigation)
                  .QueryInterface(Ci.nsILoadContext)
                  .usePrivateBrowsing;
  },

  get permanentPrivateBrowsing() {
//@line 26 "/builds/slave/m-cen-lnx64-xr/build/toolkit/content/PrivateBrowsingUtils.jsm"
    try {
      return Cc["@mozilla.org/privatebrowsing;1"].
             getService(Ci.nsIPrivateBrowsingService).
             autoStarted;
    } catch (e) {
      return false; // PB not supported
    }
//@line 34 "/builds/slave/m-cen-lnx64-xr/build/toolkit/content/PrivateBrowsingUtils.jsm"
  }
};

//@line 52 "/builds/slave/m-cen-lnx64-xr/build/toolkit/content/PrivateBrowsingUtils.jsm"

