#ifndef mozilla_dom_UnionConversions_h__
#define mozilla_dom_UnionConversions_h__

#include "mozilla/dom/UnionTypes.h"
#include "nsDOMQS.h"
#include "nsDebug.h"

namespace mozilla {
namespace dom {

class HTMLElementOrLongArgument {
public:
  HTMLElementOrLongArgument(const HTMLElementOrLong& aUnion) : mUnion(const_cast<HTMLElementOrLong&>(aUnion))
  {
  }

  bool TrySetToHTMLElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsIDOMHTMLElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsIDOMHTMLElement>(cx, value, &tmp, static_cast<nsIDOMHTMLElement**>(getter_AddRefs(mHTMLElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLElement() = tmp;
    return true;
  }

  bool TrySetToLong(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    if (!ValueToPrimitive<int32_t, eDefault>(cx, value, &SetAsLong())) {
      return false;
    }
    return true;
  }

private:
  nsIDOMHTMLElement*& SetAsHTMLElement()
  {
    mUnion.mType = mUnion.eHTMLElement;
    return mUnion.mValue.mHTMLElement.SetValue();
  }
  int32_t& SetAsLong()
  {
    mUnion.mType = mUnion.eLong;
    return mUnion.mValue.mLong.SetValue();
  }

  nsRefPtr<nsIDOMHTMLElement> mHTMLElementHolder;

  HTMLElementOrLong& mUnion;
};


class HTMLImageElementOrHTMLCanvasElementOrHTMLVideoElementArgument {
public:
  HTMLImageElementOrHTMLCanvasElementOrHTMLVideoElementArgument(const HTMLImageElementOrHTMLCanvasElementOrHTMLVideoElement& aUnion) : mUnion(const_cast<HTMLImageElementOrHTMLCanvasElementOrHTMLVideoElement&>(aUnion))
  {
  }

  bool TrySetToHTMLImageElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsHTMLImageElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsHTMLImageElement>(cx, value, &tmp, static_cast<nsHTMLImageElement**>(getter_AddRefs(mHTMLImageElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLImageElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLImageElement() = tmp;
    return true;
  }

  bool TrySetToHTMLCanvasElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsHTMLCanvasElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsHTMLCanvasElement>(cx, value, &tmp, static_cast<nsHTMLCanvasElement**>(getter_AddRefs(mHTMLCanvasElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLCanvasElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLCanvasElement() = tmp;
    return true;
  }

  bool TrySetToHTMLVideoElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsHTMLVideoElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsHTMLVideoElement>(cx, value, &tmp, static_cast<nsHTMLVideoElement**>(getter_AddRefs(mHTMLVideoElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLVideoElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLVideoElement() = tmp;
    return true;
  }

private:
  nsHTMLImageElement*& SetAsHTMLImageElement()
  {
    mUnion.mType = mUnion.eHTMLImageElement;
    return mUnion.mValue.mHTMLImageElement.SetValue();
  }
  nsHTMLCanvasElement*& SetAsHTMLCanvasElement()
  {
    mUnion.mType = mUnion.eHTMLCanvasElement;
    return mUnion.mValue.mHTMLCanvasElement.SetValue();
  }
  nsHTMLVideoElement*& SetAsHTMLVideoElement()
  {
    mUnion.mType = mUnion.eHTMLVideoElement;
    return mUnion.mValue.mHTMLVideoElement.SetValue();
  }

  nsRefPtr<nsHTMLImageElement> mHTMLImageElementHolder;
  nsRefPtr<nsHTMLCanvasElement> mHTMLCanvasElementHolder;
  nsRefPtr<nsHTMLVideoElement> mHTMLVideoElementHolder;

  HTMLImageElementOrHTMLCanvasElementOrHTMLVideoElement& mUnion;
};


class HTMLOptionElementOrHTMLOptGroupElementArgument {
public:
  HTMLOptionElementOrHTMLOptGroupElementArgument(const HTMLOptionElementOrHTMLOptGroupElement& aUnion) : mUnion(const_cast<HTMLOptionElementOrHTMLOptGroupElement&>(aUnion))
  {
  }

  bool TrySetToHTMLOptionElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsHTMLOptionElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsHTMLOptionElement>(cx, value, &tmp, static_cast<nsHTMLOptionElement**>(getter_AddRefs(mHTMLOptionElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLOptionElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLOptionElement() = tmp;
    return true;
  }

  bool TrySetToHTMLOptGroupElement(JSContext* cx, const JS::Value& value, JS::Value* pvalue, bool& tryNext)
  {
    tryNext = false;
    jsval tmpVal = value;
    nsHTMLOptGroupElement* tmp;
    if (NS_FAILED(xpc_qsUnwrapArg<nsHTMLOptGroupElement>(cx, value, &tmp, static_cast<nsHTMLOptGroupElement**>(getter_AddRefs(mHTMLOptGroupElementHolder)), &tmpVal))) {
      if (mUnion.mType != mUnion.eUninitialized) {
        mUnion.DestroyHTMLOptGroupElement();
      }tryNext = true;
      return true;
    }
    MOZ_ASSERT(tmp);
    SetAsHTMLOptGroupElement() = tmp;
    return true;
  }

private:
  nsHTMLOptionElement*& SetAsHTMLOptionElement()
  {
    mUnion.mType = mUnion.eHTMLOptionElement;
    return mUnion.mValue.mHTMLOptionElement.SetValue();
  }
  nsHTMLOptGroupElement*& SetAsHTMLOptGroupElement()
  {
    mUnion.mType = mUnion.eHTMLOptGroupElement;
    return mUnion.mValue.mHTMLOptGroupElement.SetValue();
  }

  nsRefPtr<nsHTMLOptionElement> mHTMLOptionElementHolder;
  nsRefPtr<nsHTMLOptGroupElement> mHTMLOptGroupElementHolder;

  HTMLOptionElementOrHTMLOptGroupElement& mUnion;
};


} // namespace dom
} // namespace mozilla


#endif // mozilla_dom_UnionConversions_h__
