/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_GeolocationBinding_h__
#define mozilla_dom_GeolocationBinding_h__

#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"

namespace mozilla {
namespace dom {

class Geolocation;
class Position;
class PositionCallback;
class PositionError;
class PositionErrorCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

template <>
struct PrototypeTraits<prototypes::id::Geolocation>
{
  enum
  {
    Depth = 0
  };
  typedef mozilla::dom::Geolocation NativeType;
};
template <>
struct PrototypeIDMap<mozilla::dom::Geolocation>
{
  enum
  {
    PrototypeID = prototypes::id::Geolocation
  };
};
} // namespace dom
} // namespace mozilla


namespace mozilla {
namespace dom {

struct PositionOptions : public MainThreadDictionaryBase {
  PositionOptions() {}
  bool Init(JSContext* cx, const JS::Value& val);
  bool ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::Value *vp) const;

  bool Init(const nsAString& aJSON)
  {
    Maybe<JSAutoRequest> ar;
    Maybe<JSAutoCompartment> ac;
    Maybe< JS::Rooted<JS::Value> > json;
    JSContext* cx = ParseJSON(aJSON, ar, ac, json);
    NS_ENSURE_TRUE(cx, false);
    return Init(cx, json.ref());
  }

  bool mEnableHighAccuracy;
  int32_t mMaximumAge;
  int32_t mTimeout;
private:
  // Disallow copy-construction
  PositionOptions(const PositionOptions&) MOZ_DELETE;
  static bool InitIds(JSContext* cx);
  static bool initedIds;
  static jsid enableHighAccuracy_id;
  static jsid maximumAge_id;
  static jsid timeout_id;
};
struct PositionOptionsInitializer : public PositionOptions {
  PositionOptionsInitializer() {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, JS::NullValue());
  }
};

class PositionCallback : public CallbackFunction
{
public:
  explicit inline PositionCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline PositionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, mozilla::dom::Position& position, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, position, aRv);
  }

  inline void
  Call(mozilla::dom::Position& position, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), position, aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, mozilla::dom::Position& position, ErrorResult& aRv);
};


class PositionErrorCallback : public CallbackFunction
{
public:
  explicit inline PositionErrorCallback(JSObject* aCallback)
    : CallbackFunction(aCallback)
  {
  }

  explicit inline PositionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, mozilla::dom::PositionError& positionError, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JSObject*> thisObjJS(s.GetContext(),
      WrapCallThisObject(s.GetContext(), CallbackPreserveColor(), thisObj));
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, positionError, aRv);
  }

  inline void
  Call(mozilla::dom::PositionError& positionError, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::NullPtr(), positionError, aRv);
  }

private:
  void Call(JSContext* cx, JS::Handle<JSObject*> aThisObj, mozilla::dom::PositionError& positionError, ErrorResult& aRv);
};


namespace GeolocationBinding {

  extern const NativePropertyHooks sNativePropertyHooks;

  void
  CreateInterfaceObjects(JSContext* aCx, JSObject* aGlobal, JSObject** protoAndIfaceArray);

  inline JSObject* GetProtoObject(JSContext* aCx, JSObject* aGlobal)
  {

    /* Get the interface prototype object for this class.  This will create the
       object as needed. */

    /* Make sure our global is sane.  Hopefully we can remove this sometime */
    if (!(js::GetObjectClass(aGlobal)->flags & JSCLASS_DOM_GLOBAL)) {
      return NULL;
    }
    /* Check to see whether the interface objects are already installed */
    JSObject** protoAndIfaceArray = GetProtoAndIfaceArray(aGlobal);
    JSObject* cachedObject = protoAndIfaceArray[prototypes::id::Geolocation];
    if (!cachedObject) {
      CreateInterfaceObjects(aCx, aGlobal, protoAndIfaceArray);
      cachedObject = protoAndIfaceArray[prototypes::id::Geolocation];
    }

    /* cachedObject might _still_ be null, but that's OK */
    return cachedObject;
  }

  extern DOMJSClass Class;

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::Geolocation* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

} // namespace GeolocationBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_GeolocationBinding_h__
