/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_NodeFilterBinding_h__
#define mozilla_dom_NodeFilterBinding_h__

#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"

class XPCWrappedNativeScope;
namespace mozilla {
namespace dom {

class NodeFilter;

} // namespace dom
} // namespace mozilla

class nsINode;


namespace mozilla {
namespace dom {

namespace NodeFilterBinding {

  extern const NativePropertyHooks sNativePropertyHooks;

  void
  CreateInterfaceObjects(JSContext* aCx, JSObject* aGlobal, JSObject** protoAndIfaceArray);

  inline JSObject* GetConstructorObject(JSContext* aCx, JSObject* aGlobal)
  {

    /* Get the interface object for this class.  This will create the object as
       needed. */

    /* Make sure our global is sane.  Hopefully we can remove this sometime */
    if (!(js::GetObjectClass(aGlobal)->flags & JSCLASS_DOM_GLOBAL)) {
      return NULL;
    }
    /* Check to see whether the interface objects are already installed */
    JSObject** protoAndIfaceArray = GetProtoAndIfaceArray(aGlobal);
    JSObject* cachedObject = protoAndIfaceArray[constructors::id::NodeFilter];
    if (!cachedObject) {
      CreateInterfaceObjects(aCx, aGlobal, protoAndIfaceArray);
      cachedObject = protoAndIfaceArray[constructors::id::NodeFilter];
    }

    /* cachedObject might _still_ be null, but that's OK */
    return cachedObject;
  }

  JSObject*
  DefineDOMInterface(JSContext* aCx, JSObject* aGlobal, jsid id, bool* aEnabled);

} // namespace NodeFilterBinding



class NodeFilter : public CallbackInterface
{
public:
  inline NodeFilter(JSContext* cx, JSObject* aOwner, JSObject* aCallback, bool* aInited)
    : CallbackInterface(cx, aOwner, aCallback, aInited)
  {
  }

  template <typename T>
  inline uint16_t
  AcceptNode(const T& thisObj, nsINode& node, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return uint16_t(0);
    }
    JSObject* thisObjJS = WrapCallThisObject(s.GetContext(), mCallback, thisObj);
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return uint16_t(0);
    }
    return AcceptNode(s.GetContext(), thisObjJS, node, aRv);
  }

  inline uint16_t
  AcceptNode(nsINode& node, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return uint16_t(0);
    }
    return AcceptNode(s.GetContext(), nullptr, node, aRv);
  }

private:
  uint16_t AcceptNode(JSContext* cx, JSObject* aThisObj, nsINode& node, ErrorResult& aRv);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_NodeFilterBinding_h__
