/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_RTCSessionDescriptionBinding_h__
#define mozilla_dom_RTCSessionDescriptionBinding_h__

#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"

namespace mozilla {
namespace dom {

struct RTCSessionDescriptionInit;
class mozRTCSessionDescription;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

template <>
struct PrototypeTraits<prototypes::id::mozRTCSessionDescription>
{
  enum
  {
    Depth = 0
  };
  typedef mozilla::dom::mozRTCSessionDescription NativeType;
};
template <>
struct PrototypeIDMap<mozilla::dom::mozRTCSessionDescription>
{
  enum
  {
    PrototypeID = prototypes::id::mozRTCSessionDescription
  };
};
} // namespace dom
} // namespace mozilla


namespace mozilla {
namespace dom {


MOZ_BEGIN_ENUM_CLASS(RTCSdpType, uint32_t)
  Offer,
  Pranswer,
  Answer
MOZ_END_ENUM_CLASS(RTCSdpType)

namespace RTCSdpTypeValues {
extern const EnumEntry strings[4];
} // namespace RTCSdpTypeValues


struct RTCSessionDescriptionInit : public MainThreadDictionaryBase
{
  nsString mSdp;
  Nullable<RTCSdpType > mType;

private:
  static bool initedIds;
  static jsid sdp_id;
  static jsid type_id;

  RTCSessionDescriptionInit(const RTCSessionDescriptionInit&) MOZ_DELETE;

public:
  inline RTCSessionDescriptionInit()
  {
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

private:
  static bool
  InitIds(JSContext* cx);
};
struct RTCSessionDescriptionInitInitializer : public RTCSessionDescriptionInit
{
  inline RTCSessionDescriptionInitInitializer()
  {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, JS::NullHandleValue);
  }
};


namespace mozRTCSessionDescriptionBinding {

  extern const NativePropertyHooks sNativePropertyHooks;

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Heap<JSObject*>* protoAndIfaceArray);

  inline JS::Handle<JSObject*> GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal)
  {

    /* Get the interface prototype object for this class.  This will create the
       object as needed. */

    /* Make sure our global is sane.  Hopefully we can remove this sometime */
    if (!(js::GetObjectClass(aGlobal)->flags & JSCLASS_DOM_GLOBAL)) {
      return JS::NullPtr();
    }
    /* Check to see whether the interface objects are already installed */
    JS::Heap<JSObject*>* protoAndIfaceArray = GetProtoAndIfaceArray(aGlobal);
    if (!protoAndIfaceArray[prototypes::id::mozRTCSessionDescription]) {
      CreateInterfaceObjects(aCx, aGlobal, protoAndIfaceArray);
    }

    /*
     * The object might _still_ be null, but that's OK.
     *
     * Calling fromMarkedLocation() is safe because protoAndIfaceArray is
     * traced by TraceProtoAndIfaceCache() and its contents are never
     * changed after they have been set.
     */
    return JS::Handle<JSObject*>::fromMarkedLocation(protoAndIfaceArray[prototypes::id::mozRTCSessionDescription].address());
  }

  inline JS::Handle<JSObject*> GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal)
  {

    /* Get the interface object for this class.  This will create the object as
       needed. */

    /* Make sure our global is sane.  Hopefully we can remove this sometime */
    if (!(js::GetObjectClass(aGlobal)->flags & JSCLASS_DOM_GLOBAL)) {
      return JS::NullPtr();
    }
    /* Check to see whether the interface objects are already installed */
    JS::Heap<JSObject*>* protoAndIfaceArray = GetProtoAndIfaceArray(aGlobal);
    if (!protoAndIfaceArray[constructors::id::mozRTCSessionDescription]) {
      CreateInterfaceObjects(aCx, aGlobal, protoAndIfaceArray);
    }

    /*
     * The object might _still_ be null, but that's OK.
     *
     * Calling fromMarkedLocation() is safe because protoAndIfaceArray is
     * traced by TraceProtoAndIfaceCache() and its contents are never
     * changed after they have been set.
     */
    return JS::Handle<JSObject*>::fromMarkedLocation(protoAndIfaceArray[constructors::id::mozRTCSessionDescription].address());
  }

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool* aEnabled);

  bool
  ConstructorEnabled(JSContext* /* unused */, JS::Handle<JSObject*> /* unused */);

  extern DOMJSClass Class;

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::mozRTCSessionDescription* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

} // namespace mozRTCSessionDescriptionBinding



class mozRTCSessionDescriptionJSImpl : public CallbackInterface
{
public:
  explicit inline mozRTCSessionDescriptionJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void __Init(const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions);

  Nullable<RTCSdpType > GetType(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions);

  void GetSdp(nsString& retval, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions);

  void SetType(const Nullable<RTCSdpType >& arg, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions);

  void SetSdp(const nsAString& arg, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions);
};


class mozRTCSessionDescription MOZ_FINAL : public nsISupports,
                                           public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(mozRTCSessionDescription)

private:
  nsRefPtr<mozRTCSessionDescriptionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozRTCSessionDescription(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<mozRTCSessionDescription> Constructor(const GlobalObject& global, JSContext* cx, const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv);

  Nullable<RTCSdpType > GetType(ErrorResult& aRv) const;

  void SetType(const Nullable<RTCSdpType >& arg, ErrorResult& aRv);

  void GetSdp(nsString& retval, ErrorResult& aRv) const;

  void SetSdp(const nsAString& arg, ErrorResult& aRv);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCSessionDescriptionBinding_h__
